/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compose.ide.plugin.resources.psi;

import com.intellij.compose.ide.plugin.resources.ComposeResourcesDir;
import com.intellij.compose.ide.plugin.resources.ComposeResourcesGenerationService;
import com.intellij.compose.ide.plugin.resources.ComposeResourcesUtilsKt;
import com.intellij.compose.ide.plugin.resources.psi.ComposeResourcesPsiChangesListenerKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/compose/ide/plugin/resources/psi/ComposeResourcesPsiChangesListener;", "Lcom/intellij/psi/PsiTreeChangeAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "ignoreChildrenChanged", "", "propertyChanged", "", "event", "Lcom/intellij/psi/PsiTreeChangeEvent;", "beforeChildrenChange", "childAdded", "childRemoved", "childReplaced", "childMoved", "childrenChanged", "notice", "intellij.compose.ide.plugin.resources"})
@SourceDebugExtension(value={"SMAP\nComposeResourcesPsiChangesListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeResourcesPsiChangesListener.kt\ncom/intellij/compose/ide/plugin/resources/psi/ComposeResourcesPsiChangesListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,138:1\n30#2,2:139\n*S KotlinDebug\n*F\n+ 1 ComposeResourcesPsiChangesListener.kt\ncom/intellij/compose/ide/plugin/resources/psi/ComposeResourcesPsiChangesListener\n*L\n132#1:139,2\n*E\n"})
public final class ComposeResourcesPsiChangesListener
extends PsiTreeChangeAdapter {
    @NotNull
    private final Project project;
    private boolean ignoreChildrenChanged;

    public ComposeResourcesPsiChangesListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.ignoreChildrenChanged = true;
        if (!Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"fileName") || ComposeResourcesPsiChangesListenerKt.access$isIgnorable(event)) {
            return;
        }
        this.notice(event);
    }

    public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.ignoreChildrenChanged = false;
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.ignoreChildrenChanged = true;
        if (ComposeResourcesPsiChangesListenerKt.access$isIgnorable(event)) {
            return;
        }
        PsiElement psiElement = event.getChild();
        if (psiElement == null) {
            return;
        }
        PsiElement child = psiElement;
        PsiElement psiElement2 = event.getParent();
        if (psiElement2 == null) {
            return;
        }
        PsiElement parent = psiElement2;
        if (child instanceof XmlAttribute && parent instanceof XmlTag) {
            if (((XmlAttribute)child).getValueElement() == null) {
                return;
            }
        } else if (parent instanceof XmlAttribute && child instanceof XmlAttributeValue) {
            String string = ((XmlAttributeValue)child).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            if (((CharSequence)string).length() == 0) {
                return;
            }
        }
        this.notice(event);
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        block6: {
            block7: {
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.ignoreChildrenChanged = true;
                if (ComposeResourcesPsiChangesListenerKt.access$isIgnorable(event) && !Intrinsics.areEqual((Object)((psiElement = event.getParent()) != null && (psiElement = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)psiElement)) != null ? psiElement.getName() : null), (Object)"composeResources")) {
                    return;
                }
                PsiElement psiElement2 = event.getChild();
                if (psiElement2 == null) {
                    return;
                }
                PsiElement child = psiElement2;
                PsiElement psiElement3 = event.getParent();
                if (psiElement3 == null) {
                    return;
                }
                PsiElement parent = psiElement3;
                if (!(parent instanceof XmlAttribute) || !(child instanceof XmlToken)) break block6;
                XmlAttributeValue valueElement = ((XmlAttribute)parent).getValueElement();
                if (valueElement == null) break block7;
                String string = valueElement.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                if (!(((CharSequence)string).length() == 0)) break block6;
            }
            return;
        }
        this.notice(event);
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        block10: {
            PsiElement parent;
            PsiElement child;
            block8: {
                block9: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.ignoreChildrenChanged = true;
                    if (ComposeResourcesPsiChangesListenerKt.access$isIgnorable(event)) {
                        return;
                    }
                    if (event.getParent() instanceof XmlText) {
                        return;
                    }
                    child = event.getChild();
                    if (child instanceof PsiWhiteSpace) {
                        return;
                    }
                    parent = event.getParent();
                    if (!(parent instanceof XmlAttribute) || !(child instanceof XmlToken)) break block8;
                    XmlAttributeValue valueElement = ((XmlAttribute)parent).getValueElement();
                    if (valueElement == null) break block9;
                    String string = valueElement.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                    if (!(((CharSequence)string).length() == 0)) break block10;
                }
                return;
            }
            if (parent instanceof XmlAttributeValue && child instanceof XmlToken && event.getOldChild() != null) {
                String newText = ((XmlToken)child).getText();
                String prevText = event.getOldChild().getText();
                Intrinsics.checkNotNull((Object)newText);
                if (((CharSequence)newText).length() == 0) {
                    Intrinsics.checkNotNull((Object)prevText);
                    if (((CharSequence)prevText).length() == 0) {
                        return;
                    }
                }
            }
        }
        this.notice(event);
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (ComposeResourcesPsiChangesListenerKt.access$isIgnorable(event)) {
            return;
        }
        this.notice(event);
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.ignoreChildrenChanged) {
            return;
        }
        this.notice(event);
    }

    private final void notice(PsiTreeChangeEvent event) {
        if (this.project.isDisposed()) {
            return;
        }
        if (ComposeResourcesPsiChangesListenerKt.access$isIgnorable(event)) {
            return;
        }
        Object object = event.getFile();
        if (object == null || (object = object.getVirtualFile()) == null) {
            PsiElement psiElement = event.getParent();
            PsiDirectory psiDirectory = psiElement instanceof PsiDirectory ? (PsiDirectory)psiElement : null;
            object = psiDirectory != null ? psiDirectory.getVirtualFile() : null;
            if (object == null) {
                return;
            }
        }
        PsiFile virtualFile = object;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ComposeResourcesGenerationService> serviceClass$iv = ComposeResourcesGenerationService.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ComposeResourcesGenerationService composeResourcesGenerationService = (ComposeResourcesGenerationService)object2;
        Path path = VirtualFileUtil.toNioPathOrNull((VirtualFile)virtualFile);
        if (path == null) {
            return;
        }
        Path path2 = path;
        ComposeResourcesDir composeResourcesDir = ComposeResourcesUtilsKt.findComposeResourcesDirFor(this.project, path2);
        if (composeResourcesDir == null) {
            return;
        }
        ComposeResourcesDir composeResourcesDir2 = composeResourcesDir;
        composeResourcesGenerationService.tryEmit(composeResourcesDir2);
    }
}

