/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.SimpleInstructionSequence;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.collectors.CounterContainer;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.util.StartEndPair;
import org.jetbrains.java.decompiler.util.TextBuffer;
import org.jetbrains.java.decompiler.util.TextUtil;

public class BasicBlockStatement
extends Statement {
    private final BasicBlock block;

    public BasicBlockStatement(BasicBlock block) {
        super(Statement.StatementType.BASIC_BLOCK, block.id);
        Instruction instr;
        this.block = block;
        CounterContainer container = DecompilerContext.getCounterContainer();
        if (this.id >= container.getCounter(0)) {
            container.setCounter(0, this.id + 1);
        }
        if ((instr = block.getLastInstruction()) != null) {
            if (instr.group == 2 && instr.opcode != 167) {
                this.lastBasicType = Statement.StatementType.IF;
            } else if (instr.group == 3) {
                this.lastBasicType = Statement.StatementType.SWITCH;
            }
        }
        this.buildMonitorFlags();
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        TextBuffer tb = ExprProcessor.listToJava(this.varDefinitions, indent, tracer);
        tb.append(ExprProcessor.listToJava(this.exprents, indent, tracer));
        return tb;
    }

    @Override
    public Statement getSimpleCopy() {
        int id = DecompilerContext.getCounterContainer().getCounterAndIncrement(0);
        SimpleInstructionSequence seq = new SimpleInstructionSequence();
        for (int i = 0; i < this.block.getSeq().length(); ++i) {
            seq.addInstruction(this.block.getSeq().getInstr(i).clone(), -1);
        }
        return new BasicBlockStatement(new BasicBlock(id, seq));
    }

    public BasicBlock getBlock() {
        return this.block;
    }

    @Override
    public StartEndPair getStartEndRange() {
        if (this.block.size() > 0) {
            return new StartEndPair(this.block.getStartInstruction(), this.block.getEndInstruction());
        }
        return new StartEndPair(0, 0);
    }

    @Override
    protected String toString(int indent) {
        return TextUtil.getIndentString(indent) + String.valueOf((Object)this.type) + ": " + this.id + DecompilerContext.getNewLineSeparator() + this.block.getSeq().toString(indent + 1);
    }
}

