/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dev.psiViewer.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.PlatformColors;
import java.awt.Color;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class BlockTreeNode
extends SimpleNode {
    private final Block myBlock;

    BlockTreeNode(Block block, BlockTreeNode parent) {
        super((SimpleNode)parent);
        this.myBlock = block;
    }

    public Block getBlock() {
        return this.myBlock;
    }

    public BlockTreeNode @NotNull [] getChildren() {
        BlockTreeNode[] blockTreeNodeArray = (BlockTreeNode[])ContainerUtil.map2Array((Collection)this.myBlock.getSubBlocks(), BlockTreeNode.class, block -> new BlockTreeNode((Block)block, this));
        if (blockTreeNodeArray == null) {
            BlockTreeNode.$$$reportNull$$$0(0);
        }
        return blockTreeNodeArray;
    }

    protected void update(@NotNull PresentationData presentation) {
        Block block;
        Object name;
        if (presentation == null) {
            BlockTreeNode.$$$reportNull$$$0(1);
        }
        if ((name = this.myBlock.getDebugName()) == null) {
            name = this.myBlock.getClass().getSimpleName();
        }
        if ((block = this.myBlock) instanceof DataLanguageBlockWrapper) {
            DataLanguageBlockWrapper wrapper = (DataLanguageBlockWrapper)block;
            name = (String)name + " (" + wrapper.getOriginal().getClass().getSimpleName() + ")";
        }
        presentation.addText((String)name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myBlock.getIndent() != null) {
            presentation.addText(" " + String.valueOf(this.myBlock.getIndent()).replaceAll("[<>]", " "), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if (this.myBlock.getAlignment() != null) {
            float d = 1.0f * (float)System.identityHashCode(this.myBlock.getAlignment()) / 2.1474836E9f;
            JBColor color = new JBColor(Color.HSBtoRGB(d, 0.3f, 0.7f), Color.HSBtoRGB(d, 0.3f, 0.8f));
            presentation.addText(" " + String.valueOf(this.myBlock.getAlignment()), new SimpleTextAttributes(1, (Color)color));
        }
        if (this.myBlock.getWrap() != null) {
            presentation.addText(" " + String.valueOf(this.myBlock.getWrap()), new SimpleTextAttributes(2, PlatformColors.BLUE));
        }
    }

    public Object @NotNull [] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myBlock};
        if (objectArray == null) {
            BlockTreeNode.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    public boolean isAlwaysLeaf() {
        return this.myBlock.isLeaf() && this.myBlock.getSubBlocks().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dev/psiViewer/formatter/BlockTreeNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dev/psiViewer/formatter/BlockTreeNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObjects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

