/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import org.assertj.core.api.Abstract2DArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.error.ShouldHaveSameSizeAs;
import org.assertj.core.error.ShouldNotBeNull;
import org.assertj.core.error.SubarraysShouldHaveSameSize;
import org.assertj.core.error.array2d.Array2dElementShouldBeDeepEqual;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Float2DArrays;

public class Float2DArrayAssert
extends Abstract2DArrayAssert<Float2DArrayAssert, float[][], Float> {
    protected Float2DArrays float2dArrays = Float2DArrays.instance();
    private final Failures failures = Failures.instance();

    public Float2DArrayAssert(float[][] actual) {
        super(actual, Float2DArrayAssert.class);
    }

    @Override
    public Float2DArrayAssert isDeepEqualTo(float[][] expected) {
        if (this.actual == expected) {
            return (Float2DArrayAssert)this.myself;
        }
        this.isNotNull();
        if (expected.length != ((float[][])this.actual).length) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldHaveSameSizeAs.shouldHaveSameSizeAs(this.actual, expected, ((float[][])this.actual).length, expected.length));
        }
        for (int i2 = 0; i2 < ((float[][])this.actual).length; ++i2) {
            float[] actualSubArray = ((float[][])this.actual)[i2];
            float[] expectedSubArray = expected[i2];
            if (actualSubArray == expectedSubArray) continue;
            if (actualSubArray == null) {
                throw this.failures.failure((AssertionInfo)this.info, ShouldNotBeNull.shouldNotBeNull("actual[" + i2 + "]"));
            }
            if (expectedSubArray.length != actualSubArray.length) {
                throw this.failures.failure(this.info, SubarraysShouldHaveSameSize.subarraysShouldHaveSameSize(this.actual, expected, actualSubArray, actualSubArray.length, expectedSubArray, expectedSubArray.length, i2), this.info.representation().toStringOf(this.actual), this.info.representation().toStringOf(expected));
            }
            for (int j = 0; j < actualSubArray.length; ++j) {
                if (actualSubArray[j] == expectedSubArray[j]) continue;
                throw this.failures.failure(this.info, Array2dElementShouldBeDeepEqual.elementShouldBeEqual(Float.valueOf(actualSubArray[j]), Float.valueOf(expectedSubArray[j]), i2, j), this.info.representation().toStringOf(this.actual), this.info.representation().toStringOf(expected));
            }
        }
        return (Float2DArrayAssert)this.myself;
    }

    @Override
    public Float2DArrayAssert isEqualTo(Object expected) {
        return (Float2DArrayAssert)super.isEqualTo(expected);
    }

    @Override
    public void isNullOrEmpty() {
        this.float2dArrays.assertNullOrEmpty(this.info, (float[][])this.actual);
    }

    @Override
    public void isEmpty() {
        this.float2dArrays.assertEmpty(this.info, (float[][])this.actual);
    }

    @Override
    public Float2DArrayAssert isNotEmpty() {
        this.float2dArrays.assertNotEmpty(this.info, (float[][])this.actual);
        return (Float2DArrayAssert)this.myself;
    }

    @Override
    public Float2DArrayAssert hasDimensions(int expectedFirstDimension, int expectedSecondDimension) {
        this.float2dArrays.assertHasDimensions(this.info, (float[][])this.actual, expectedFirstDimension, expectedSecondDimension);
        return (Float2DArrayAssert)this.myself;
    }

    @Override
    public Float2DArrayAssert hasNumberOfRows(int expected) {
        this.float2dArrays.assertNumberOfRows(this.info, (float[][])this.actual, expected);
        return (Float2DArrayAssert)this.myself;
    }

    @Override
    public Float2DArrayAssert hasSameDimensionsAs(Object array) {
        this.float2dArrays.assertHasSameDimensionsAs(this.info, (float[][])this.actual, array);
        return (Float2DArrayAssert)this.myself;
    }

    public Float2DArrayAssert contains(float[] value, Index index) {
        this.float2dArrays.assertContains(this.info, (float[][])this.actual, value, index);
        return (Float2DArrayAssert)this.myself;
    }

    public Float2DArrayAssert doesNotContain(float[] value, Index index) {
        this.float2dArrays.assertDoesNotContain(this.info, (float[][])this.actual, value, index);
        return (Float2DArrayAssert)this.myself;
    }
}

