from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

SPANISH_LANG_MODEL = {
    26: {  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        29: SequenceLikelihood.POSITIVE,  # 'C'
        35: SequenceLikelihood.POSITIVE,  # 'D'
        23: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.LIKELY,  # 'F'
        45: SequenceLikelihood.LIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.LIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.POSITIVE,  # 'L'
        34: SequenceLikelihood.LIKELY,  # 'M'
        40: SequenceLikelihood.POSITIVE,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.POSITIVE,  # 'R'
        30: SequenceLikelihood.POSITIVE,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        44: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.LIKELY,  # 'Y'
        58: SequenceLikelihood.LIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        7: SequenceLikelihood.LIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.LIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.LIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.LIKELY,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.LIKELY,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.NEGATIVE,  # 'ü'
    },
    43: {  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        29: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    29: {  # 'C'
        26: SequenceLikelihood.POSITIVE,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        23: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.LIKELY,  # 'H'
        36: SequenceLikelihood.POSITIVE,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.LIKELY,  # 'N'
        42: SequenceLikelihood.POSITIVE,  # 'O'
        31: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        30: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        44: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.LIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ñ'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    35: {  # 'D'
        26: SequenceLikelihood.POSITIVE,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.POSITIVE,  # 'E'
        47: SequenceLikelihood.LIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.LIKELY,  # 'M'
        40: SequenceLikelihood.LIKELY,  # 'N'
        42: SequenceLikelihood.POSITIVE,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        30: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.LIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    23: {  # 'E'
        26: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        29: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        23: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.LIKELY,  # 'F'
        45: SequenceLikelihood.LIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.LIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.POSITIVE,  # 'L'
        34: SequenceLikelihood.LIKELY,  # 'M'
        40: SequenceLikelihood.POSITIVE,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        31: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.POSITIVE,  # 'R'
        30: SequenceLikelihood.POSITIVE,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        44: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.LIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.LIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.UNLIKELY,  # 'i'
        27: SequenceLikelihood.LIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        17: SequenceLikelihood.LIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.POSITIVE,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.NEGATIVE,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    47: {  # 'F'
        26: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    45: {  # 'G'
        26: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        44: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.LIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ñ'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    49: {  # 'H'
        26: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        23: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.LIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    36: {  # 'I'
        26: SequenceLikelihood.POSITIVE,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        29: SequenceLikelihood.POSITIVE,  # 'C'
        35: SequenceLikelihood.POSITIVE,  # 'D'
        23: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.LIKELY,  # 'F'
        45: SequenceLikelihood.LIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        34: SequenceLikelihood.LIKELY,  # 'M'
        40: SequenceLikelihood.POSITIVE,  # 'N'
        42: SequenceLikelihood.POSITIVE,  # 'O'
        31: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        30: SequenceLikelihood.POSITIVE,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.LIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.LIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.UNLIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.LIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.NEGATIVE,  # 'ü'
    },
    51: {  # 'J'
        26: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.LIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    56: {  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.LIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.NEGATIVE,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    32: {  # 'L'
        26: SequenceLikelihood.POSITIVE,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.POSITIVE,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.LIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.POSITIVE,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        44: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ñ'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    34: {  # 'M'
        26: SequenceLikelihood.POSITIVE,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        31: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.LIKELY,  # 'á'
        33: SequenceLikelihood.POSITIVE,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ñ'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        46: SequenceLikelihood.LIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    40: {  # 'N'
        26: SequenceLikelihood.POSITIVE,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        23: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.LIKELY,  # 'F'
        45: SequenceLikelihood.LIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.POSITIVE,  # 'T'
        44: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.LIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    42: {  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        29: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        23: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.LIKELY,  # 'F'
        45: SequenceLikelihood.LIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        34: SequenceLikelihood.LIKELY,  # 'M'
        40: SequenceLikelihood.POSITIVE,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        31: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.POSITIVE,  # 'R'
        30: SequenceLikelihood.POSITIVE,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.UNLIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.NEGATIVE,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.NEGATIVE,  # 'ó'
        46: SequenceLikelihood.NEGATIVE,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    31: {  # 'P'
        26: SequenceLikelihood.POSITIVE,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        23: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        34: SequenceLikelihood.LIKELY,  # 'M'
        40: SequenceLikelihood.LIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        31: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        30: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        44: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.LIKELY,  # 'á'
        33: SequenceLikelihood.LIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.LIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    55: {  # 'Q'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.UNLIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.NEGATIVE,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ñ'
        22: SequenceLikelihood.NEGATIVE,  # 'ó'
        46: SequenceLikelihood.NEGATIVE,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    37: {  # 'R'
        26: SequenceLikelihood.POSITIVE,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        23: SequenceLikelihood.POSITIVE,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.LIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.POSITIVE,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        34: SequenceLikelihood.LIKELY,  # 'M'
        40: SequenceLikelihood.LIKELY,  # 'N'
        42: SequenceLikelihood.POSITIVE,  # 'O'
        31: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        30: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        44: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.LIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    30: {  # 'S'
        26: SequenceLikelihood.POSITIVE,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        29: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        23: SequenceLikelihood.POSITIVE,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        34: SequenceLikelihood.LIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        31: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.POSITIVE,  # 'T'
        44: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.LIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.LIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    38: {  # 'T'
        26: SequenceLikelihood.POSITIVE,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.POSITIVE,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.POSITIVE,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.POSITIVE,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        30: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.LIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.LIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    44: {  # 'U'
        26: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        29: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        23: SequenceLikelihood.POSITIVE,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        34: SequenceLikelihood.LIKELY,  # 'M'
        40: SequenceLikelihood.LIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        30: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        44: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.UNLIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.NEGATIVE,  # 'ú'
        63: SequenceLikelihood.NEGATIVE,  # 'ü'
    },
    48: {  # 'V'
        26: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.POSITIVE,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.LIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    54: {  # 'W'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        7: SequenceLikelihood.LIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    57: {  # 'X'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.LIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.UNLIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    53: {  # 'Y'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.UNLIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.NEGATIVE,  # 'ü'
    },
    58: {  # 'Z'
        26: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.UNLIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    2: {  # 'a'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        15: SequenceLikelihood.POSITIVE,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.POSITIVE,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.POSITIVE,  # 'j'
        50: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.POSITIVE,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.POSITIVE,  # 'v'
        52: SequenceLikelihood.LIKELY,  # 'w'
        39: SequenceLikelihood.LIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        28: SequenceLikelihood.POSITIVE,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.LIKELY,  # 'é'
        24: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.POSITIVE,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.LIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    15: {  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.POSITIVE,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.LIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.LIKELY,  # 'á'
        33: SequenceLikelihood.LIKELY,  # 'é'
        24: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        46: SequenceLikelihood.LIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    11: {  # 'c'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.POSITIVE,  # 'á'
        33: SequenceLikelihood.LIKELY,  # 'é'
        24: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        46: SequenceLikelihood.LIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    9: {  # 'd'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.LIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.LIKELY,  # 'v'
        52: SequenceLikelihood.LIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.LIKELY,  # 'á'
        33: SequenceLikelihood.POSITIVE,  # 'é'
        24: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    1: {  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.POSITIVE,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.POSITIVE,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.POSITIVE,  # 'j'
        50: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.POSITIVE,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.POSITIVE,  # 'v'
        52: SequenceLikelihood.LIKELY,  # 'w'
        39: SequenceLikelihood.POSITIVE,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        28: SequenceLikelihood.POSITIVE,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.LIKELY,  # 'í'
        41: SequenceLikelihood.POSITIVE,  # 'ñ'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    20: {  # 'f'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.POSITIVE,  # 'á'
        33: SequenceLikelihood.LIKELY,  # 'é'
        24: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        46: SequenceLikelihood.LIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    16: {  # 'g'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.LIKELY,  # 'á'
        33: SequenceLikelihood.LIKELY,  # 'é'
        24: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        46: SequenceLikelihood.POSITIVE,  # 'ú'
        63: SequenceLikelihood.LIKELY,  # 'ü'
    },
    21: {  # 'h'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.NEGATIVE,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.LIKELY,  # 'á'
        33: SequenceLikelihood.LIKELY,  # 'é'
        24: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    7: {  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.POSITIVE,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.POSITIVE,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        7: SequenceLikelihood.LIKELY,  # 'i'
        27: SequenceLikelihood.POSITIVE,  # 'j'
        50: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.POSITIVE,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.POSITIVE,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.LIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.POSITIVE,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.LIKELY,  # 'á'
        33: SequenceLikelihood.POSITIVE,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.POSITIVE,  # 'ñ'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    27: {  # 'j'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.LIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.NEGATIVE,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.LIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    50: {  # 'k'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.NEGATIVE,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    8: {  # 'l'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.POSITIVE,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        19: SequenceLikelihood.POSITIVE,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.POSITIVE,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.LIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.POSITIVE,  # 'á'
        33: SequenceLikelihood.POSITIVE,  # 'é'
        24: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        46: SequenceLikelihood.LIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    13: {  # 'm'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.POSITIVE,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.POSITIVE,  # 'á'
        33: SequenceLikelihood.POSITIVE,  # 'é'
        24: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        46: SequenceLikelihood.POSITIVE,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    5: {  # 'n'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.POSITIVE,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.POSITIVE,  # 'j'
        50: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.POSITIVE,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.POSITIVE,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.POSITIVE,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.POSITIVE,  # 'á'
        33: SequenceLikelihood.LIKELY,  # 'é'
        24: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        46: SequenceLikelihood.POSITIVE,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    3: {  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.POSITIVE,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.POSITIVE,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.POSITIVE,  # 'j'
        50: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.POSITIVE,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.POSITIVE,  # 'v'
        52: SequenceLikelihood.POSITIVE,  # 'w'
        39: SequenceLikelihood.POSITIVE,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        28: SequenceLikelihood.POSITIVE,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.UNLIKELY,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.LIKELY,  # 'í'
        41: SequenceLikelihood.LIKELY,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    14: {  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.POSITIVE,  # 'á'
        33: SequenceLikelihood.LIKELY,  # 'é'
        24: SequenceLikelihood.LIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        46: SequenceLikelihood.POSITIVE,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    19: {  # 'q'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.UNLIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.NEGATIVE,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    6: {  # 'r'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.POSITIVE,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.POSITIVE,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.LIKELY,  # 'j'
        50: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.POSITIVE,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.POSITIVE,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        28: SequenceLikelihood.POSITIVE,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.POSITIVE,  # 'á'
        33: SequenceLikelihood.POSITIVE,  # 'é'
        24: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        46: SequenceLikelihood.LIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    4: {  # 's'
        26: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.POSITIVE,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.POSITIVE,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.LIKELY,  # 'v'
        52: SequenceLikelihood.LIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.UNLIKELY,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.LIKELY,  # 'á'
        33: SequenceLikelihood.POSITIVE,  # 'é'
        24: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        46: SequenceLikelihood.LIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    10: {  # 't'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.LIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.LIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.POSITIVE,  # 'á'
        33: SequenceLikelihood.POSITIVE,  # 'é'
        24: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        46: SequenceLikelihood.LIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    12: {  # 'u'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.POSITIVE,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.POSITIVE,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.POSITIVE,  # 'j'
        50: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        17: SequenceLikelihood.POSITIVE,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.LIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        28: SequenceLikelihood.POSITIVE,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.LIKELY,  # 'á'
        33: SequenceLikelihood.POSITIVE,  # 'é'
        24: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.LIKELY,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    17: {  # 'v'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.LIKELY,  # 'á'
        33: SequenceLikelihood.POSITIVE,  # 'é'
        24: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.NEGATIVE,  # 'ü'
    },
    52: {  # 'w'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.POSITIVE,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    39: {  # 'x'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        7: SequenceLikelihood.POSITIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.NEGATIVE,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.NEGATIVE,  # 'ü'
    },
    18: {  # 'y'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.LIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.NEGATIVE,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    28: {  # 'z'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.LIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.LIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.LIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.POSITIVE,  # 'ó'
        46: SequenceLikelihood.LIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    59: {  # 'Á'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.NEGATIVE,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.NEGATIVE,  # 'h'
        7: SequenceLikelihood.NEGATIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.NEGATIVE,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.NEGATIVE,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.NEGATIVE,  # 'á'
        33: SequenceLikelihood.NEGATIVE,  # 'é'
        24: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.NEGATIVE,  # 'ó'
        46: SequenceLikelihood.NEGATIVE,  # 'ú'
        63: SequenceLikelihood.NEGATIVE,  # 'ü'
    },
    62: {  # 'É'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.NEGATIVE,  # 'h'
        7: SequenceLikelihood.UNLIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.NEGATIVE,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.NEGATIVE,  # 'y'
        28: SequenceLikelihood.NEGATIVE,  # 'z'
        59: SequenceLikelihood.NEGATIVE,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.NEGATIVE,  # 'é'
        24: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ñ'
        22: SequenceLikelihood.NEGATIVE,  # 'ó'
        46: SequenceLikelihood.NEGATIVE,  # 'ú'
        63: SequenceLikelihood.NEGATIVE,  # 'ü'
    },
    61: {  # 'Í'
        26: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.NEGATIVE,  # 'h'
        7: SequenceLikelihood.UNLIKELY,  # 'i'
        27: SequenceLikelihood.NEGATIVE,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.NEGATIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.NEGATIVE,  # 'w'
        39: SequenceLikelihood.NEGATIVE,  # 'x'
        18: SequenceLikelihood.NEGATIVE,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.NEGATIVE,  # 'á'
        33: SequenceLikelihood.NEGATIVE,  # 'é'
        24: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.NEGATIVE,  # 'ó'
        46: SequenceLikelihood.NEGATIVE,  # 'ú'
        63: SequenceLikelihood.NEGATIVE,  # 'ü'
    },
    65: {  # 'Ñ'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        45: SequenceLikelihood.NEGATIVE,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        34: SequenceLikelihood.NEGATIVE,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        31: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.NEGATIVE,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.NEGATIVE,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        15: SequenceLikelihood.NEGATIVE,  # 'b'
        11: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.NEGATIVE,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.NEGATIVE,  # 'h'
        7: SequenceLikelihood.UNLIKELY,  # 'i'
        27: SequenceLikelihood.NEGATIVE,  # 'j'
        50: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.NEGATIVE,  # 'm'
        5: SequenceLikelihood.NEGATIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.NEGATIVE,  # 'p'
        19: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        4: SequenceLikelihood.NEGATIVE,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        17: SequenceLikelihood.NEGATIVE,  # 'v'
        52: SequenceLikelihood.NEGATIVE,  # 'w'
        39: SequenceLikelihood.NEGATIVE,  # 'x'
        18: SequenceLikelihood.NEGATIVE,  # 'y'
        28: SequenceLikelihood.NEGATIVE,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.NEGATIVE,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ñ'
        22: SequenceLikelihood.NEGATIVE,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.NEGATIVE,  # 'ü'
    },
    60: {  # 'Ó'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.LIKELY,  # 'N'
        42: SequenceLikelihood.NEGATIVE,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        20: SequenceLikelihood.NEGATIVE,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.NEGATIVE,  # 'h'
        7: SequenceLikelihood.UNLIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.NEGATIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.NEGATIVE,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.NEGATIVE,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.NEGATIVE,  # 'z'
        59: SequenceLikelihood.NEGATIVE,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.NEGATIVE,  # 'á'
        33: SequenceLikelihood.NEGATIVE,  # 'é'
        24: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.NEGATIVE,  # 'ó'
        46: SequenceLikelihood.NEGATIVE,  # 'ú'
        63: SequenceLikelihood.NEGATIVE,  # 'ü'
    },
    64: {  # 'Ú'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        45: SequenceLikelihood.NEGATIVE,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.NEGATIVE,  # 'U'
        48: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        20: SequenceLikelihood.NEGATIVE,  # 'f'
        16: SequenceLikelihood.NEGATIVE,  # 'g'
        21: SequenceLikelihood.NEGATIVE,  # 'h'
        7: SequenceLikelihood.NEGATIVE,  # 'i'
        27: SequenceLikelihood.NEGATIVE,  # 'j'
        50: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.NEGATIVE,  # 'o'
        14: SequenceLikelihood.NEGATIVE,  # 'p'
        19: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.NEGATIVE,  # 'u'
        17: SequenceLikelihood.NEGATIVE,  # 'v'
        52: SequenceLikelihood.NEGATIVE,  # 'w'
        39: SequenceLikelihood.NEGATIVE,  # 'x'
        18: SequenceLikelihood.NEGATIVE,  # 'y'
        28: SequenceLikelihood.NEGATIVE,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.NEGATIVE,  # 'á'
        33: SequenceLikelihood.NEGATIVE,  # 'é'
        24: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ñ'
        22: SequenceLikelihood.NEGATIVE,  # 'ó'
        46: SequenceLikelihood.NEGATIVE,  # 'ú'
        63: SequenceLikelihood.NEGATIVE,  # 'ü'
    },
    66: {  # 'Ü'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.NEGATIVE,  # 'G'
        49: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.NEGATIVE,  # 'f'
        16: SequenceLikelihood.NEGATIVE,  # 'g'
        21: SequenceLikelihood.NEGATIVE,  # 'h'
        7: SequenceLikelihood.NEGATIVE,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.NEGATIVE,  # 'o'
        14: SequenceLikelihood.NEGATIVE,  # 'p'
        19: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.NEGATIVE,  # 't'
        12: SequenceLikelihood.NEGATIVE,  # 'u'
        17: SequenceLikelihood.NEGATIVE,  # 'v'
        52: SequenceLikelihood.NEGATIVE,  # 'w'
        39: SequenceLikelihood.NEGATIVE,  # 'x'
        18: SequenceLikelihood.NEGATIVE,  # 'y'
        28: SequenceLikelihood.NEGATIVE,  # 'z'
        59: SequenceLikelihood.UNLIKELY,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.NEGATIVE,  # 'á'
        33: SequenceLikelihood.NEGATIVE,  # 'é'
        24: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ñ'
        22: SequenceLikelihood.NEGATIVE,  # 'ó'
        46: SequenceLikelihood.NEGATIVE,  # 'ú'
        63: SequenceLikelihood.NEGATIVE,  # 'ü'
    },
    25: {  # 'á'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.LIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        19: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        17: SequenceLikelihood.LIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.LIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.LIKELY,  # 'z'
        59: SequenceLikelihood.NEGATIVE,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    33: {  # 'é'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.LIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.NEGATIVE,  # 'w'
        39: SequenceLikelihood.POSITIVE,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.NEGATIVE,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.NEGATIVE,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.NEGATIVE,  # 'ú'
        63: SequenceLikelihood.NEGATIVE,  # 'ü'
    },
    24: {  # 'í'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        20: SequenceLikelihood.POSITIVE,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.UNLIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        19: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        17: SequenceLikelihood.LIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.LIKELY,  # 'z'
        59: SequenceLikelihood.NEGATIVE,  # 'Á'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        61: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.NEGATIVE,  # 'ú'
        63: SequenceLikelihood.UNLIKELY,  # 'ü'
    },
    41: {  # 'ñ'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.NEGATIVE,  # 'M'
        40: SequenceLikelihood.NEGATIVE,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        31: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.NEGATIVE,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        20: SequenceLikelihood.NEGATIVE,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.LIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.NEGATIVE,  # 'z'
        59: SequenceLikelihood.NEGATIVE,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.LIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.LIKELY,  # 'ó'
        46: SequenceLikelihood.UNLIKELY,  # 'ú'
        63: SequenceLikelihood.NEGATIVE,  # 'ü'
    },
    22: {  # 'ó'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.NEGATIVE,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.UNLIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        17: SequenceLikelihood.LIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.LIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.NEGATIVE,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.NEGATIVE,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.UNLIKELY,  # 'ó'
        46: SequenceLikelihood.NEGATIVE,  # 'ú'
        63: SequenceLikelihood.NEGATIVE,  # 'ü'
    },
    46: {  # 'ú'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        49: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.UNLIKELY,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.NEGATIVE,  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        44: SequenceLikelihood.NEGATIVE,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        15: SequenceLikelihood.POSITIVE,  # 'b'
        11: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.UNLIKELY,  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.NEGATIVE,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.NEGATIVE,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.NEGATIVE,  # 'ó'
        46: SequenceLikelihood.NEGATIVE,  # 'ú'
        63: SequenceLikelihood.NEGATIVE,  # 'ü'
    },
    63: {  # 'ü'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        29: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        23: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        45: SequenceLikelihood.NEGATIVE,  # 'G'
        49: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        34: SequenceLikelihood.NEGATIVE,  # 'M'
        40: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.NEGATIVE,  # 'O'
        31: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.NEGATIVE,  # 'S'
        38: SequenceLikelihood.NEGATIVE,  # 'T'
        44: SequenceLikelihood.NEGATIVE,  # 'U'
        48: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        15: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        20: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        7: SequenceLikelihood.UNLIKELY,  # 'i'
        27: SequenceLikelihood.NEGATIVE,  # 'j'
        50: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        17: SequenceLikelihood.UNLIKELY,  # 'v'
        52: SequenceLikelihood.UNLIKELY,  # 'w'
        39: SequenceLikelihood.NEGATIVE,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        59: SequenceLikelihood.NEGATIVE,  # 'Á'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        61: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ó'
        64: SequenceLikelihood.NEGATIVE,  # 'Ú'
        66: SequenceLikelihood.NEGATIVE,  # 'Ü'
        25: SequenceLikelihood.UNLIKELY,  # 'á'
        33: SequenceLikelihood.UNLIKELY,  # 'é'
        24: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ñ'
        22: SequenceLikelihood.NEGATIVE,  # 'ó'
        46: SequenceLikelihood.NEGATIVE,  # 'ú'
        63: SequenceLikelihood.NEGATIVE,  # 'ü'
    },
}

# Character Mapping Table(s):
CP037_SPANISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 0,  # 'â'
    67: 0,  # 'ä'
    68: 0,  # 'à'
    69: 25,  # 'á'
    70: 0,  # 'ã'
    71: 0,  # 'å'
    72: 0,  # 'ç'
    73: 41,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '¢'
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '|'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 33,  # 'é'
    82: 0,  # 'ê'
    83: 0,  # 'ë'
    84: 0,  # 'è'
    85: 24,  # 'í'
    86: 0,  # 'î'
    87: 0,  # 'ï'
    88: 0,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # '!'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '¬'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 0,  # 'Â'
    99: 0,  # 'Ä'
    100: 0,  # 'À'
    101: 59,  # 'Á'
    102: 0,  # 'Ã'
    103: 0,  # 'Å'
    104: 0,  # 'Ç'
    105: 65,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 62,  # 'É'
    114: 0,  # 'Ê'
    115: 0,  # 'Ë'
    116: 0,  # 'È'
    117: 61,  # 'Í'
    118: 0,  # 'Î'
    119: 0,  # 'Ï'
    120: 0,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 2,  # 'a'
    130: 15,  # 'b'
    131: 11,  # 'c'
    132: 9,  # 'd'
    133: 1,  # 'e'
    134: 20,  # 'f'
    135: 16,  # 'g'
    136: 21,  # 'h'
    137: 7,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 0,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 27,  # 'j'
    146: 50,  # 'k'
    147: 8,  # 'l'
    148: 13,  # 'm'
    149: 5,  # 'n'
    150: 3,  # 'o'
    151: 14,  # 'p'
    152: 19,  # 'q'
    153: 6,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 0,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 0,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 4,  # 's'
    163: 10,  # 't'
    164: 12,  # 'u'
    165: 17,  # 'v'
    166: 52,  # 'w'
    167: 39,  # 'x'
    168: 18,  # 'y'
    169: 28,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 0,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '^'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '['
    187: CharacterCategory.SYMBOL,  # ']'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 26,  # 'A'
    194: 43,  # 'B'
    195: 29,  # 'C'
    196: 35,  # 'D'
    197: 23,  # 'E'
    198: 47,  # 'F'
    199: 45,  # 'G'
    200: 49,  # 'H'
    201: 36,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 0,  # 'ô'
    204: 0,  # 'ö'
    205: 0,  # 'ò'
    206: 22,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 51,  # 'J'
    210: 56,  # 'K'
    211: 32,  # 'L'
    212: 34,  # 'M'
    213: 40,  # 'N'
    214: 42,  # 'O'
    215: 31,  # 'P'
    216: 55,  # 'Q'
    217: 37,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 0,  # 'û'
    220: 63,  # 'ü'
    221: 0,  # 'ù'
    222: 46,  # 'ú'
    223: 0,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 30,  # 'S'
    227: 38,  # 'T'
    228: 44,  # 'U'
    229: 48,  # 'V'
    230: 54,  # 'W'
    231: 57,  # 'X'
    232: 53,  # 'Y'
    233: 58,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 0,  # 'Ô'
    236: 0,  # 'Ö'
    237: 0,  # 'Ò'
    238: 60,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 0,  # 'Û'
    252: 66,  # 'Ü'
    253: 0,  # 'Ù'
    254: 64,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP037_SPANISH_MODEL = SingleByteCharSetModel(
    charset_name="CP037",
    language="Spanish",
    char_to_order_map=CP037_SPANISH_CHAR_TO_ORDER,
    language_model=SPANISH_LANG_MODEL,
    typical_positive_ratio=0.9766692321051526,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÑÓÚÜáéíñóúü",
)

CP437_SPANISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 43,  # 'B'
    67: 29,  # 'C'
    68: 35,  # 'D'
    69: 23,  # 'E'
    70: 47,  # 'F'
    71: 45,  # 'G'
    72: 49,  # 'H'
    73: 36,  # 'I'
    74: 51,  # 'J'
    75: 56,  # 'K'
    76: 32,  # 'L'
    77: 34,  # 'M'
    78: 40,  # 'N'
    79: 42,  # 'O'
    80: 31,  # 'P'
    81: 55,  # 'Q'
    82: 37,  # 'R'
    83: 30,  # 'S'
    84: 38,  # 'T'
    85: 44,  # 'U'
    86: 48,  # 'V'
    87: 54,  # 'W'
    88: 57,  # 'X'
    89: 53,  # 'Y'
    90: 58,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 15,  # 'b'
    99: 11,  # 'c'
    100: 9,  # 'd'
    101: 1,  # 'e'
    102: 20,  # 'f'
    103: 16,  # 'g'
    104: 21,  # 'h'
    105: 7,  # 'i'
    106: 27,  # 'j'
    107: 50,  # 'k'
    108: 8,  # 'l'
    109: 13,  # 'm'
    110: 5,  # 'n'
    111: 3,  # 'o'
    112: 14,  # 'p'
    113: 19,  # 'q'
    114: 6,  # 'r'
    115: 4,  # 's'
    116: 10,  # 't'
    117: 12,  # 'u'
    118: 17,  # 'v'
    119: 52,  # 'w'
    120: 39,  # 'x'
    121: 18,  # 'y'
    122: 28,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 63,  # 'ü'
    130: 33,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 62,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 0,  # 'û'
    151: 0,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 66,  # 'Ü'
    155: CharacterCategory.SYMBOL,  # '¢'
    156: CharacterCategory.SYMBOL,  # '£'
    157: CharacterCategory.SYMBOL,  # '¥'
    158: CharacterCategory.SYMBOL,  # '₧'
    159: 0,  # 'ƒ'
    160: 25,  # 'á'
    161: 24,  # 'í'
    162: 22,  # 'ó'
    163: 46,  # 'ú'
    164: 41,  # 'ñ'
    165: 65,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '⌐'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'α'
    225: 0,  # 'ß'
    226: 0,  # 'Γ'
    227: 0,  # 'π'
    228: 0,  # 'Σ'
    229: 0,  # 'σ'
    230: 0,  # 'µ'
    231: 0,  # 'τ'
    232: 0,  # 'Φ'
    233: 0,  # 'Θ'
    234: 0,  # 'Ω'
    235: 0,  # 'δ'
    236: CharacterCategory.SYMBOL,  # '∞'
    237: 0,  # 'φ'
    238: 0,  # 'ε'
    239: CharacterCategory.SYMBOL,  # '∩'
    240: CharacterCategory.SYMBOL,  # '≡'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '≥'
    243: CharacterCategory.SYMBOL,  # '≤'
    244: CharacterCategory.SYMBOL,  # '⌠'
    245: CharacterCategory.SYMBOL,  # '⌡'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '≈'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: 0,  # 'ⁿ'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP437_SPANISH_MODEL = SingleByteCharSetModel(
    charset_name="CP437",
    language="Spanish",
    char_to_order_map=CP437_SPANISH_CHAR_TO_ORDER,
    language_model=SPANISH_LANG_MODEL,
    typical_positive_ratio=0.9770760101775388,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÑÓÚÜáéíñóúü",
)

CP500_SPANISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 0,  # 'â'
    67: 0,  # 'ä'
    68: 0,  # 'à'
    69: 25,  # 'á'
    70: 0,  # 'ã'
    71: 0,  # 'å'
    72: 0,  # 'ç'
    73: 41,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '['
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '!'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 33,  # 'é'
    82: 0,  # 'ê'
    83: 0,  # 'ë'
    84: 0,  # 'è'
    85: 24,  # 'í'
    86: 0,  # 'î'
    87: 0,  # 'ï'
    88: 0,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # ']'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '^'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 0,  # 'Â'
    99: 0,  # 'Ä'
    100: 0,  # 'À'
    101: 59,  # 'Á'
    102: 0,  # 'Ã'
    103: 0,  # 'Å'
    104: 0,  # 'Ç'
    105: 65,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 62,  # 'É'
    114: 0,  # 'Ê'
    115: 0,  # 'Ë'
    116: 0,  # 'È'
    117: 61,  # 'Í'
    118: 0,  # 'Î'
    119: 0,  # 'Ï'
    120: 0,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 2,  # 'a'
    130: 15,  # 'b'
    131: 11,  # 'c'
    132: 9,  # 'd'
    133: 1,  # 'e'
    134: 20,  # 'f'
    135: 16,  # 'g'
    136: 21,  # 'h'
    137: 7,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 0,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 27,  # 'j'
    146: 50,  # 'k'
    147: 8,  # 'l'
    148: 13,  # 'm'
    149: 5,  # 'n'
    150: 3,  # 'o'
    151: 14,  # 'p'
    152: 19,  # 'q'
    153: 6,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 0,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 0,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 4,  # 's'
    163: 10,  # 't'
    164: 12,  # 'u'
    165: 17,  # 'v'
    166: 52,  # 'w'
    167: 39,  # 'x'
    168: 18,  # 'y'
    169: 28,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 0,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '¢'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '¬'
    187: CharacterCategory.SYMBOL,  # '|'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 26,  # 'A'
    194: 43,  # 'B'
    195: 29,  # 'C'
    196: 35,  # 'D'
    197: 23,  # 'E'
    198: 47,  # 'F'
    199: 45,  # 'G'
    200: 49,  # 'H'
    201: 36,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 0,  # 'ô'
    204: 0,  # 'ö'
    205: 0,  # 'ò'
    206: 22,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 51,  # 'J'
    210: 56,  # 'K'
    211: 32,  # 'L'
    212: 34,  # 'M'
    213: 40,  # 'N'
    214: 42,  # 'O'
    215: 31,  # 'P'
    216: 55,  # 'Q'
    217: 37,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 0,  # 'û'
    220: 63,  # 'ü'
    221: 0,  # 'ù'
    222: 46,  # 'ú'
    223: 0,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 30,  # 'S'
    227: 38,  # 'T'
    228: 44,  # 'U'
    229: 48,  # 'V'
    230: 54,  # 'W'
    231: 57,  # 'X'
    232: 53,  # 'Y'
    233: 58,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 0,  # 'Ô'
    236: 0,  # 'Ö'
    237: 0,  # 'Ò'
    238: 60,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 0,  # 'Û'
    252: 66,  # 'Ü'
    253: 0,  # 'Ù'
    254: 64,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP500_SPANISH_MODEL = SingleByteCharSetModel(
    charset_name="CP500",
    language="Spanish",
    char_to_order_map=CP500_SPANISH_CHAR_TO_ORDER,
    language_model=SPANISH_LANG_MODEL,
    typical_positive_ratio=0.9766692321051526,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÑÓÚÜáéíñóúü",
)

CP850_SPANISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 43,  # 'B'
    67: 29,  # 'C'
    68: 35,  # 'D'
    69: 23,  # 'E'
    70: 47,  # 'F'
    71: 45,  # 'G'
    72: 49,  # 'H'
    73: 36,  # 'I'
    74: 51,  # 'J'
    75: 56,  # 'K'
    76: 32,  # 'L'
    77: 34,  # 'M'
    78: 40,  # 'N'
    79: 42,  # 'O'
    80: 31,  # 'P'
    81: 55,  # 'Q'
    82: 37,  # 'R'
    83: 30,  # 'S'
    84: 38,  # 'T'
    85: 44,  # 'U'
    86: 48,  # 'V'
    87: 54,  # 'W'
    88: 57,  # 'X'
    89: 53,  # 'Y'
    90: 58,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 15,  # 'b'
    99: 11,  # 'c'
    100: 9,  # 'd'
    101: 1,  # 'e'
    102: 20,  # 'f'
    103: 16,  # 'g'
    104: 21,  # 'h'
    105: 7,  # 'i'
    106: 27,  # 'j'
    107: 50,  # 'k'
    108: 8,  # 'l'
    109: 13,  # 'm'
    110: 5,  # 'n'
    111: 3,  # 'o'
    112: 14,  # 'p'
    113: 19,  # 'q'
    114: 6,  # 'r'
    115: 4,  # 's'
    116: 10,  # 't'
    117: 12,  # 'u'
    118: 17,  # 'v'
    119: 52,  # 'w'
    120: 39,  # 'x'
    121: 18,  # 'y'
    122: 28,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 63,  # 'ü'
    130: 33,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 62,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 0,  # 'û'
    151: 0,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 66,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 25,  # 'á'
    161: 24,  # 'í'
    162: 22,  # 'ó'
    163: 46,  # 'ú'
    164: 41,  # 'ñ'
    165: 65,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 59,  # 'Á'
    182: 0,  # 'Â'
    183: 0,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 0,  # 'Ê'
    211: 0,  # 'Ë'
    212: 0,  # 'È'
    213: 0,  # 'ı'
    214: 61,  # 'Í'
    215: 0,  # 'Î'
    216: 0,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 0,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 60,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ô'
    227: 0,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 64,  # 'Ú'
    234: 0,  # 'Û'
    235: 0,  # 'Ù'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP850_SPANISH_MODEL = SingleByteCharSetModel(
    charset_name="CP850",
    language="Spanish",
    char_to_order_map=CP850_SPANISH_CHAR_TO_ORDER,
    language_model=SPANISH_LANG_MODEL,
    typical_positive_ratio=0.9766692321051526,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÑÓÚÜáéíñóúü",
)

CP858_SPANISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 43,  # 'B'
    67: 29,  # 'C'
    68: 35,  # 'D'
    69: 23,  # 'E'
    70: 47,  # 'F'
    71: 45,  # 'G'
    72: 49,  # 'H'
    73: 36,  # 'I'
    74: 51,  # 'J'
    75: 56,  # 'K'
    76: 32,  # 'L'
    77: 34,  # 'M'
    78: 40,  # 'N'
    79: 42,  # 'O'
    80: 31,  # 'P'
    81: 55,  # 'Q'
    82: 37,  # 'R'
    83: 30,  # 'S'
    84: 38,  # 'T'
    85: 44,  # 'U'
    86: 48,  # 'V'
    87: 54,  # 'W'
    88: 57,  # 'X'
    89: 53,  # 'Y'
    90: 58,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 15,  # 'b'
    99: 11,  # 'c'
    100: 9,  # 'd'
    101: 1,  # 'e'
    102: 20,  # 'f'
    103: 16,  # 'g'
    104: 21,  # 'h'
    105: 7,  # 'i'
    106: 27,  # 'j'
    107: 50,  # 'k'
    108: 8,  # 'l'
    109: 13,  # 'm'
    110: 5,  # 'n'
    111: 3,  # 'o'
    112: 14,  # 'p'
    113: 19,  # 'q'
    114: 6,  # 'r'
    115: 4,  # 's'
    116: 10,  # 't'
    117: 12,  # 'u'
    118: 17,  # 'v'
    119: 52,  # 'w'
    120: 39,  # 'x'
    121: 18,  # 'y'
    122: 28,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 63,  # 'ü'
    130: 33,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 62,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 0,  # 'û'
    151: 0,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 66,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 25,  # 'á'
    161: 24,  # 'í'
    162: 22,  # 'ó'
    163: 46,  # 'ú'
    164: 41,  # 'ñ'
    165: 65,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 59,  # 'Á'
    182: 0,  # 'Â'
    183: 0,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 0,  # 'Ê'
    211: 0,  # 'Ë'
    212: 0,  # 'È'
    213: CharacterCategory.SYMBOL,  # '€'
    214: 61,  # 'Í'
    215: 0,  # 'Î'
    216: 0,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 0,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 60,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ô'
    227: 0,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 64,  # 'Ú'
    234: 0,  # 'Û'
    235: 0,  # 'Ù'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP858_SPANISH_MODEL = SingleByteCharSetModel(
    charset_name="CP858",
    language="Spanish",
    char_to_order_map=CP858_SPANISH_CHAR_TO_ORDER,
    language_model=SPANISH_LANG_MODEL,
    typical_positive_ratio=0.9766692321051526,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÑÓÚÜáéíñóúü",
)

ISO_8859_1_SPANISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 43,  # 'B'
    67: 29,  # 'C'
    68: 35,  # 'D'
    69: 23,  # 'E'
    70: 47,  # 'F'
    71: 45,  # 'G'
    72: 49,  # 'H'
    73: 36,  # 'I'
    74: 51,  # 'J'
    75: 56,  # 'K'
    76: 32,  # 'L'
    77: 34,  # 'M'
    78: 40,  # 'N'
    79: 42,  # 'O'
    80: 31,  # 'P'
    81: 55,  # 'Q'
    82: 37,  # 'R'
    83: 30,  # 'S'
    84: 38,  # 'T'
    85: 44,  # 'U'
    86: 48,  # 'V'
    87: 54,  # 'W'
    88: 57,  # 'X'
    89: 53,  # 'Y'
    90: 58,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 15,  # 'b'
    99: 11,  # 'c'
    100: 9,  # 'd'
    101: 1,  # 'e'
    102: 20,  # 'f'
    103: 16,  # 'g'
    104: 21,  # 'h'
    105: 7,  # 'i'
    106: 27,  # 'j'
    107: 50,  # 'k'
    108: 8,  # 'l'
    109: 13,  # 'm'
    110: 5,  # 'n'
    111: 3,  # 'o'
    112: 14,  # 'p'
    113: 19,  # 'q'
    114: 6,  # 'r'
    115: 4,  # 's'
    116: 10,  # 't'
    117: 12,  # 'u'
    118: 17,  # 'v'
    119: 52,  # 'w'
    120: 39,  # 'x'
    121: 18,  # 'y'
    122: 28,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 0,  # 'À'
    193: 59,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 62,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 61,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 65,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 60,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 64,  # 'Ú'
    219: 0,  # 'Û'
    220: 66,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 25,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 33,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 24,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 41,  # 'ñ'
    242: 0,  # 'ò'
    243: 22,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 46,  # 'ú'
    251: 0,  # 'û'
    252: 63,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

ISO_8859_1_SPANISH_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-1",
    language="Spanish",
    char_to_order_map=ISO_8859_1_SPANISH_CHAR_TO_ORDER,
    language_model=SPANISH_LANG_MODEL,
    typical_positive_ratio=0.9766692321051526,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÑÓÚÜáéíñóúü",
)

ISO_8859_15_SPANISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 43,  # 'B'
    67: 29,  # 'C'
    68: 35,  # 'D'
    69: 23,  # 'E'
    70: 47,  # 'F'
    71: 45,  # 'G'
    72: 49,  # 'H'
    73: 36,  # 'I'
    74: 51,  # 'J'
    75: 56,  # 'K'
    76: 32,  # 'L'
    77: 34,  # 'M'
    78: 40,  # 'N'
    79: 42,  # 'O'
    80: 31,  # 'P'
    81: 55,  # 'Q'
    82: 37,  # 'R'
    83: 30,  # 'S'
    84: 38,  # 'T'
    85: 44,  # 'U'
    86: 48,  # 'V'
    87: 54,  # 'W'
    88: 57,  # 'X'
    89: 53,  # 'Y'
    90: 58,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 15,  # 'b'
    99: 11,  # 'c'
    100: 9,  # 'd'
    101: 1,  # 'e'
    102: 20,  # 'f'
    103: 16,  # 'g'
    104: 21,  # 'h'
    105: 7,  # 'i'
    106: 27,  # 'j'
    107: 50,  # 'k'
    108: 8,  # 'l'
    109: 13,  # 'm'
    110: 5,  # 'n'
    111: 3,  # 'o'
    112: 14,  # 'p'
    113: 19,  # 'q'
    114: 6,  # 'r'
    115: 4,  # 's'
    116: 10,  # 't'
    117: 12,  # 'u'
    118: 17,  # 'v'
    119: 52,  # 'w'
    120: 39,  # 'x'
    121: 18,  # 'y'
    122: 28,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '€'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: 0,  # 'Š'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'š'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: 0,  # 'Ž'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ž'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'Œ'
    189: 0,  # 'œ'
    190: 0,  # 'Ÿ'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 0,  # 'À'
    193: 59,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 62,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 61,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 65,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 60,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 64,  # 'Ú'
    219: 0,  # 'Û'
    220: 66,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 25,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 33,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 24,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 41,  # 'ñ'
    242: 0,  # 'ò'
    243: 22,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 46,  # 'ú'
    251: 0,  # 'û'
    252: 63,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

ISO_8859_15_SPANISH_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-15",
    language="Spanish",
    char_to_order_map=ISO_8859_15_SPANISH_CHAR_TO_ORDER,
    language_model=SPANISH_LANG_MODEL,
    typical_positive_ratio=0.9766692321051526,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÑÓÚÜáéíñóúü",
)

MACROMAN_SPANISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 43,  # 'B'
    67: 29,  # 'C'
    68: 35,  # 'D'
    69: 23,  # 'E'
    70: 47,  # 'F'
    71: 45,  # 'G'
    72: 49,  # 'H'
    73: 36,  # 'I'
    74: 51,  # 'J'
    75: 56,  # 'K'
    76: 32,  # 'L'
    77: 34,  # 'M'
    78: 40,  # 'N'
    79: 42,  # 'O'
    80: 31,  # 'P'
    81: 55,  # 'Q'
    82: 37,  # 'R'
    83: 30,  # 'S'
    84: 38,  # 'T'
    85: 44,  # 'U'
    86: 48,  # 'V'
    87: 54,  # 'W'
    88: 57,  # 'X'
    89: 53,  # 'Y'
    90: 58,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 15,  # 'b'
    99: 11,  # 'c'
    100: 9,  # 'd'
    101: 1,  # 'e'
    102: 20,  # 'f'
    103: 16,  # 'g'
    104: 21,  # 'h'
    105: 7,  # 'i'
    106: 27,  # 'j'
    107: 50,  # 'k'
    108: 8,  # 'l'
    109: 13,  # 'm'
    110: 5,  # 'n'
    111: 3,  # 'o'
    112: 14,  # 'p'
    113: 19,  # 'q'
    114: 6,  # 'r'
    115: 4,  # 's'
    116: 10,  # 't'
    117: 12,  # 'u'
    118: 17,  # 'v'
    119: 52,  # 'w'
    120: 39,  # 'x'
    121: 18,  # 'y'
    122: 28,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ä'
    129: 0,  # 'Å'
    130: 0,  # 'Ç'
    131: 62,  # 'É'
    132: 65,  # 'Ñ'
    133: 0,  # 'Ö'
    134: 66,  # 'Ü'
    135: 25,  # 'á'
    136: 0,  # 'à'
    137: 0,  # 'â'
    138: 0,  # 'ä'
    139: 0,  # 'ã'
    140: 0,  # 'å'
    141: 0,  # 'ç'
    142: 33,  # 'é'
    143: 0,  # 'è'
    144: 0,  # 'ê'
    145: 0,  # 'ë'
    146: 24,  # 'í'
    147: 0,  # 'ì'
    148: 0,  # 'î'
    149: 0,  # 'ï'
    150: 41,  # 'ñ'
    151: 22,  # 'ó'
    152: 0,  # 'ò'
    153: 0,  # 'ô'
    154: 0,  # 'ö'
    155: 0,  # 'õ'
    156: 46,  # 'ú'
    157: 0,  # 'ù'
    158: 0,  # 'û'
    159: 63,  # 'ü'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'ß'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: CharacterCategory.SYMBOL,  # '´'
    172: CharacterCategory.SYMBOL,  # '¨'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 0,  # 'Æ'
    175: 0,  # 'Ø'
    176: CharacterCategory.SYMBOL,  # '∞'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: CharacterCategory.SYMBOL,  # '¥'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '∂'
    183: CharacterCategory.SYMBOL,  # '∑'
    184: CharacterCategory.SYMBOL,  # '∏'
    185: 0,  # 'π'
    186: CharacterCategory.SYMBOL,  # '∫'
    187: 0,  # 'ª'
    188: 0,  # 'º'
    189: 0,  # 'Ω'
    190: 0,  # 'æ'
    191: 0,  # 'ø'
    192: CharacterCategory.SYMBOL,  # '¿'
    193: CharacterCategory.SYMBOL,  # '¡'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ƒ'
    197: CharacterCategory.SYMBOL,  # '≈'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 0,  # 'À'
    204: 0,  # 'Ã'
    205: 0,  # 'Õ'
    206: 0,  # 'Œ'
    207: 0,  # 'œ'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '◊'
    216: 0,  # 'ÿ'
    217: 0,  # 'Ÿ'
    218: CharacterCategory.SYMBOL,  # '⁄'
    219: CharacterCategory.SYMBOL,  # '€'
    220: CharacterCategory.SYMBOL,  # '‹'
    221: CharacterCategory.SYMBOL,  # '›'
    222: 0,  # 'ﬁ'
    223: 0,  # 'ﬂ'
    224: CharacterCategory.SYMBOL,  # '‡'
    225: CharacterCategory.SYMBOL,  # '·'
    226: CharacterCategory.SYMBOL,  # '‚'
    227: CharacterCategory.SYMBOL,  # '„'
    228: CharacterCategory.SYMBOL,  # '‰'
    229: 0,  # 'Â'
    230: 0,  # 'Ê'
    231: 59,  # 'Á'
    232: 0,  # 'Ë'
    233: 0,  # 'È'
    234: 61,  # 'Í'
    235: 0,  # 'Î'
    236: 0,  # 'Ï'
    237: 0,  # 'Ì'
    238: 60,  # 'Ó'
    239: 0,  # 'Ô'
    240: CharacterCategory.CONTROL,  # '\uf8ff'
    241: 0,  # 'Ò'
    242: 64,  # 'Ú'
    243: 0,  # 'Û'
    244: 0,  # 'Ù'
    245: 0,  # 'ı'
    246: 0,  # 'ˆ'
    247: CharacterCategory.SYMBOL,  # '˜'
    248: CharacterCategory.SYMBOL,  # '¯'
    249: CharacterCategory.SYMBOL,  # '˘'
    250: CharacterCategory.SYMBOL,  # '˙'
    251: CharacterCategory.SYMBOL,  # '˚'
    252: CharacterCategory.SYMBOL,  # '¸'
    253: CharacterCategory.SYMBOL,  # '˝'
    254: CharacterCategory.SYMBOL,  # '˛'
    255: 0,  # 'ˇ'
}

MACROMAN_SPANISH_MODEL = SingleByteCharSetModel(
    charset_name="MacRoman",
    language="Spanish",
    char_to_order_map=MACROMAN_SPANISH_CHAR_TO_ORDER,
    language_model=SPANISH_LANG_MODEL,
    typical_positive_ratio=0.9766692321051526,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÑÓÚÜáéíñóúü",
)

WINDOWS_1252_SPANISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 43,  # 'B'
    67: 29,  # 'C'
    68: 35,  # 'D'
    69: 23,  # 'E'
    70: 47,  # 'F'
    71: 45,  # 'G'
    72: 49,  # 'H'
    73: 36,  # 'I'
    74: 51,  # 'J'
    75: 56,  # 'K'
    76: 32,  # 'L'
    77: 34,  # 'M'
    78: 40,  # 'N'
    79: 42,  # 'O'
    80: 31,  # 'P'
    81: 55,  # 'Q'
    82: 37,  # 'R'
    83: 30,  # 'S'
    84: 38,  # 'T'
    85: 44,  # 'U'
    86: 48,  # 'V'
    87: 54,  # 'W'
    88: 57,  # 'X'
    89: 53,  # 'Y'
    90: 58,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 15,  # 'b'
    99: 11,  # 'c'
    100: 9,  # 'd'
    101: 1,  # 'e'
    102: 20,  # 'f'
    103: 16,  # 'g'
    104: 21,  # 'h'
    105: 7,  # 'i'
    106: 27,  # 'j'
    107: 50,  # 'k'
    108: 8,  # 'l'
    109: 13,  # 'm'
    110: 5,  # 'n'
    111: 3,  # 'o'
    112: 14,  # 'p'
    113: 19,  # 'q'
    114: 6,  # 'r'
    115: 4,  # 's'
    116: 10,  # 't'
    117: 12,  # 'u'
    118: 17,  # 'v'
    119: 52,  # 'w'
    120: 39,  # 'x'
    121: 18,  # 'y'
    122: 28,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ƒ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: 0,  # 'ˆ'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'Š'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Œ'
    141: CharacterCategory.UNDEFINED,  # None
    142: 0,  # 'Ž'
    143: CharacterCategory.UNDEFINED,  # None
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.SYMBOL,  # '˜'
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'š'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'œ'
    157: CharacterCategory.UNDEFINED,  # None
    158: 0,  # 'ž'
    159: 0,  # 'Ÿ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 0,  # 'À'
    193: 59,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 62,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 61,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 65,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 60,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 64,  # 'Ú'
    219: 0,  # 'Û'
    220: 66,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 25,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 33,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 24,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 41,  # 'ñ'
    242: 0,  # 'ò'
    243: 22,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 46,  # 'ú'
    251: 0,  # 'û'
    252: 63,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

WINDOWS_1252_SPANISH_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1252",
    language="Spanish",
    char_to_order_map=WINDOWS_1252_SPANISH_CHAR_TO_ORDER,
    language_model=SPANISH_LANG_MODEL,
    typical_positive_ratio=0.9766692321051526,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÑÓÚÜáéíñóúü",
)
