/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Stack;
import org.apache.fop.apps.FOPException;
import org.apache.fop.complexscripts.bidi.DelimitedTextRange;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.InlineLevel;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.xml.sax.Locator;

public class Leader
extends InlineLevel {
    private Length alignmentAdjust;
    private int alignmentBaseline;
    private Length baselineShift;
    private int dominantBaseline;
    private int leaderAlignment;
    private LengthRangeProperty leaderLength;
    private int leaderPattern;
    private Length leaderPatternWidth;
    private int ruleStyle;
    private Length ruleThickness;

    public Leader(FONode parent) {
        super(parent);
    }

    @Override
    public void bind(PropertyList pList) throws FOPException {
        super.bind(pList);
        this.alignmentAdjust = pList.get(3).getLength();
        this.alignmentBaseline = pList.get(4).getEnum();
        this.baselineShift = pList.get(15).getLength();
        this.dominantBaseline = pList.get(88).getEnum();
        this.leaderAlignment = pList.get(136).getEnum();
        this.leaderLength = pList.get(137).getLengthRange();
        this.leaderPattern = pList.get(138).getEnum();
        this.leaderPatternWidth = pList.get(139).getLength();
        this.ruleThickness = Leader.getPropertyMakerFor(214).make(pList).getLength();
        switch (this.leaderPattern) {
            case 134: {
                break;
            }
            case 123: {
                this.ruleStyle = pList.get(213).getEnum();
                this.ruleThickness = pList.get(214).getLength();
                break;
            }
            case 35: {
                break;
            }
            case 158: {
                break;
            }
            default: {
                throw new RuntimeException("Invalid leader pattern: " + this.leaderPattern);
            }
        }
    }

    @Override
    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI) && (localName.equals("leader") || localName.equals("inline-container") || localName.equals("block-container") || localName.equals("float") || localName.equals("marker") || !this.isInlineItem(nsURI, localName))) {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    public int getRuleStyle() {
        return this.ruleStyle;
    }

    public Length getRuleThickness() {
        return this.ruleThickness;
    }

    public int getLeaderAlignment() {
        return this.leaderAlignment;
    }

    public LengthRangeProperty getLeaderLength() {
        return this.leaderLength;
    }

    public int getLeaderPattern() {
        return this.leaderPattern;
    }

    public Length getLeaderPatternWidth() {
        return this.leaderPatternWidth;
    }

    public Length getAlignmentAdjust() {
        return this.alignmentAdjust;
    }

    public int getAlignmentBaseline() {
        return this.alignmentBaseline;
    }

    public Length getBaselineShift() {
        return this.baselineShift;
    }

    public int getDominantBaseline() {
        return this.dominantBaseline;
    }

    @Override
    public String getLocalName() {
        return "leader";
    }

    @Override
    public int getNameId() {
        return 39;
    }

    @Override
    public void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startLeader(this);
    }

    @Override
    public void endOfNode() throws FOPException {
        super.endOfNode();
        this.getFOEventHandler().endLeader(this);
    }

    @Override
    protected Stack<DelimitedTextRange> collectDelimitedTextRanges(Stack<DelimitedTextRange> ranges, DelimitedTextRange currentRange) {
        if (currentRange != null) {
            if (this.leaderPattern == 158) {
                ranges = super.collectDelimitedTextRanges(ranges, currentRange);
            } else {
                currentRange.append('\ufffc', (FONode)this);
            }
        }
        return ranges;
    }
}

