/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Stroke;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.ShapedPainter;

class ForkPainter
extends ShapedPainter {
    private static final int SINGLE_CHILD_SHIFT = -2;

    ForkPainter(MainView mainView) {
        super(mainView, NodeGeometryModel.FORK);
    }

    @Override
    public Point getLeftPoint() {
        int borderWidth = this.mainView.getPaintedBorderWidth();
        Point in = new Point(0, this.mainView.getHeight() - 1 - borderWidth / 2);
        return in;
    }

    @Override
    int getMainViewHeightWithFoldingMark(boolean onlyFolded) {
        NodeView nodeView = this.mainView.getNodeView();
        if (nodeView.usesHorizontalLayout()) {
            return super.getMainViewHeightWithFoldingMark(onlyFolded);
        }
        int height = this.mainView.getHeight();
        if (!onlyFolded || nodeView.isFolded()) {
            height += this.mainView.getZoomedFoldingMarkHalfSize();
        }
        return height;
    }

    @Override
    public Point getRightPoint() {
        int borderWidth = this.mainView.getPaintedBorderWidth();
        Point in = new Point(this.mainView.getWidth() - 1, this.mainView.getHeight() - 1 - borderWidth / 2);
        return in;
    }

    @Override
    void paintBackground(Graphics2D graphics, Color color) {
        graphics.setColor(color);
        graphics.fillRect(0, 0, this.mainView.getWidth(), this.mainView.getHeight() - this.mainView.getPaintedBorderWidth());
    }

    @Override
    void paintNodeShape(Graphics2D g) {
        Stroke oldStroke = g.getStroke();
        g.setStroke(UITools.createStroke(this.mainView.getPaintedBorderWidth(), this.mainView.getDash().pattern, 0));
        Color oldColor = g.getColor();
        Color borderColor = this.mainView.getBorderColor();
        g.setColor(borderColor);
        Point leftLinePoint = this.getLeftPoint();
        g.drawLine(leftLinePoint.x, leftLinePoint.y, leftLinePoint.x + this.mainView.getWidth(), leftLinePoint.y);
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    @Override
    Insets getInsets() {
        return this.getInsets(null);
    }

    @Override
    Insets getInsets(Insets insets) {
        int borderWidth = Math.round(this.mainView.getUnzoomedBorderWidth());
        if (insets == null) {
            insets = new Insets(0, 2, borderWidth, 2);
        } else {
            insets.set(0, 2, borderWidth, 2);
        }
        return insets;
    }

    @Override
    int getSingleChildShift() {
        return -2;
    }
}

