/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;
import org.freeplane.core.ui.components.html.ScaledHTML;
import org.freeplane.core.util.TextUtils;
import org.freeplane.view.swing.map.ZoomableLabel;

public class ZoomableLabelUI
extends BasicLabelUI {
    private static final char RLM = '\u200f';
    private static final char LRM = '\u200e';
    private boolean isPainting = false;
    static ZoomableLabelUI labelUI = new ZoomableLabelUI();
    private Rectangle iconR = new Rectangle();
    private Rectangle textR = new Rectangle();
    private Rectangle viewR = new Rectangle();
    static final float EXTRA_SCALING_FACTOR = 0.97f;

    private static String bidiSafe(JLabel lbl, String s) {
        int cp;
        if (s == null || s.isEmpty() || BasicHTML.isHTMLString(s)) {
            return s;
        }
        boolean compLTR = lbl.getComponentOrientation().isLeftToRight();
        for (int i = 0; i < s.length(); i += Character.charCount(cp)) {
            cp = s.codePointAt(i);
            byte dir = Character.getDirectionality(cp);
            if (dir == 0) {
                return compLTR ? s : '\u200f' + s;
            }
            if (dir != 1 && dir != 2) continue;
            return compLTR ? '\u200e' + s : s;
        }
        return s;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int minimumWidth;
        float zoom;
        Dimension preferredSize = super.getPreferredSize(c);
        ZoomableLabel zoomableLabel = (ZoomableLabel)c;
        if (zoomableLabel.getIcon() == null) {
            int fontHeight = zoomableLabel.getFontMetrics().getHeight();
            Insets insets = c.getInsets();
            preferredSize.width = Math.max(preferredSize.width, fontHeight / 2 + insets.left + insets.right);
            preferredSize.height = Math.max(preferredSize.height, fontHeight + insets.top + insets.bottom);
        }
        if ((zoom = zoomableLabel.getZoom()) != 1.0f) {
            preferredSize.width = (int)Math.ceil(zoom * (float)preferredSize.width);
            preferredSize.height = (int)Math.ceil(zoom * (float)preferredSize.height);
        }
        if ((minimumWidth = zoomableLabel.getMinimumWidth()) != 0) {
            preferredSize.width = Math.max(minimumWidth, preferredSize.width);
        }
        return preferredSize;
    }

    public static ComponentUI createUI(JComponent c) {
        return labelUI;
    }

    @Override
    protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        ScaledHTML.Renderer v;
        float zoom;
        LayoutData preferredLayoutData = (LayoutData)label.getClientProperty("preferredLayoutData");
        String bidiSafeText = ZoomableLabelUI.bidiSafe(label, text);
        if (preferredLayoutData != null) {
            viewR.x = preferredLayoutData.viewR.x;
            viewR.y = preferredLayoutData.viewR.y;
            viewR.width = preferredLayoutData.viewR.width;
            viewR.height = preferredLayoutData.viewR.height;
            textR.x = preferredLayoutData.textR.x;
            textR.y = preferredLayoutData.textR.y;
            textR.width = preferredLayoutData.textR.width;
            textR.height = preferredLayoutData.textR.height;
            iconR.x = preferredLayoutData.iconR.x;
            iconR.y = preferredLayoutData.iconR.y;
            iconR.width = preferredLayoutData.iconR.width;
            iconR.height = preferredLayoutData.iconR.height;
            return bidiSafeText;
        }
        ZoomableLabel zLabel = (ZoomableLabel)label;
        float scale = zoom = zLabel.getZoom();
        if (this.isPainting) {
            Insets insets = zLabel.getInsets();
            int width = zLabel.getWidth();
            int height = zLabel.getHeight();
            viewR.x = insets.left;
            viewR.y = insets.top;
            viewR.width = (int)((float)width / scale) - (insets.left + insets.right);
            viewR.height = (int)((float)height / scale) - (insets.top + insets.bottom);
            if (viewR.width < 0) {
                viewR.width = 0;
            }
        } else if (zLabel.getMaximumWidth() != Integer.MAX_VALUE) {
            ScaledHTML.Renderer v2;
            int maximumWidth = (int)((float)zLabel.getMaximumWidth() / scale);
            Insets insets = label.getInsets();
            viewR.width = maximumWidth - insets.left - insets.right;
            if (viewR.width < 0) {
                viewR.width = 0;
            }
            if ((v2 = (ScaledHTML.Renderer)label.getClientProperty("html")) != null) {
                int currentWidth;
                float minimumWidth;
                int availableTextWidth = viewR.width;
                if (icon != null && label.getVerticalTextPosition() != 3) {
                    availableTextWidth -= icon.getIconWidth() + label.getIconTextGap();
                }
                if ((minimumWidth = v2.getMinimumSpan(0)) > (float)availableTextWidth) {
                    viewR.width = (int)((float)viewR.width + (minimumWidth - (float)availableTextWidth));
                    availableTextWidth = (int)minimumWidth;
                }
                if ((currentWidth = v2.getWidth()) != availableTextWidth) {
                    float viewPreferredWidth = v2.getPreferredWidth();
                    if (viewPreferredWidth > (float)availableTextWidth) {
                        v2.setWidth(availableTextWidth);
                        this.layoutCompoundLabel(bidiSafeText, icon, viewR, iconR, textR, zLabel);
                        return bidiSafeText;
                    }
                    if ((float)currentWidth != viewPreferredWidth) {
                        v2.resetWidth();
                    }
                }
            }
        }
        Icon textRenderingIcon = zLabel.getTextRenderingIcon();
        if (textRenderingIcon != null) {
            ZoomableLabelUI.layoutLabelWithTextIcon(textRenderingIcon, icon, viewR, iconR, textR, zLabel);
        } else {
            this.layoutCompoundLabel(bidiSafeText, icon, viewR, iconR, textR, zLabel);
        }
        if (!this.isPainting) {
            return bidiSafeText;
        }
        int reservedIconWidth = iconR.width == 0 ? 0 : iconR.width + label.getIconTextGap();
        int availableTextWidth = viewR.width;
        if (iconR.width > 0 && label.getVerticalTextPosition() != 3) {
            availableTextWidth -= reservedIconWidth;
        }
        if ((v = (ScaledHTML.Renderer)label.getClientProperty("html")) != null && textR.width < availableTextWidth) {
            textR.width = availableTextWidth;
            v.setWidth(availableTextWidth);
        }
        switch (label.getVerticalTextPosition()) {
            case 3: {
                iconR.x = viewR.x;
                iconR.y = viewR.y;
                textR.x = viewR.x;
                textR.y = iconR.height == 0 ? viewR.y : viewR.y + iconR.height + label.getIconTextGap();
                int extraTopMargin = (viewR.height - (textR.y + textR.height - viewR.y)) / 2;
                iconR.y += extraTopMargin;
                textR.y += extraTopMargin;
                int horizontalAlignment = zLabel.getEffectiveHorizontalAlignment();
                switch (horizontalAlignment) {
                    case 0: {
                        iconR.x += (viewR.width - iconR.width) / 2;
                        textR.x += (viewR.width - textR.width) / 2;
                        break;
                    }
                    case 4: {
                        iconR.x += viewR.width - iconR.width;
                        textR.x += viewR.width - textR.width;
                    }
                }
                break;
            }
            default: {
                switch (label.getVerticalTextPosition()) {
                    case 1: {
                        iconR.y = textR.y = viewR.y + (viewR.height - Math.max(textR.height, iconR.height)) / 2;
                        break;
                    }
                    case 0: {
                        iconR.y = viewR.y + (viewR.height - iconR.height) / 2;
                        textR.y = viewR.y + (viewR.height - textR.height) / 2;
                    }
                }
                int effectiveHorizontalTextPosition = zLabel.getEffectiveHorizontalTextPosition();
                iconR.x = effectiveHorizontalTextPosition == 4 ? viewR.x : viewR.x + viewR.width - iconR.width;
                textR.x = effectiveHorizontalTextPosition == 2 || iconR.width == 0 ? viewR.x : iconR.x + iconR.width + label.getIconTextGap();
                int horizontalAlignment = zLabel.getEffectiveHorizontalAlignment();
                switch (horizontalAlignment) {
                    case 0: {
                        textR.x += (availableTextWidth - textR.width) / 2;
                        break;
                    }
                    case 4: {
                        textR.x += availableTextWidth - textR.width;
                    }
                }
            }
        }
        if (zLabel.useFractionalMetrics()) {
            int alignment = zLabel.getEffectiveHorizontalAlignment();
            int shift = (int)((float)textR.width * 0.029999971f);
            if (alignment == 4) {
                textR.x += shift;
            } else if (alignment == 0) {
                textR.x += shift / 2;
            }
            if (iconR.x != viewR.x) {
                iconR.x += shift;
            }
        }
        return bidiSafeText;
    }

    private void layoutCompoundLabel(String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR, ZoomableLabel zLabel) {
        int verticalTextPosition = zLabel.getVerticalTextPosition();
        SwingUtilities.layoutCompoundLabel(zLabel, zLabel.getFontMetrics(), text, icon, zLabel.getVerticalAlignment(), zLabel.getHorizontalAlignment(), verticalTextPosition, verticalTextPosition != 3 ? 2 : 0, viewR, iconR, textR, zLabel.getIconTextGap());
    }

    private static void layoutLabelWithTextIcon(Icon textRenderingIcon, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR, ZoomableLabel zLabel) {
        int verticalTextPosition = zLabel.getVerticalTextPosition();
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
            textR.x = viewR.x;
            textR.y = viewR.y;
        }
        int gap = iconR.width == 0 ? 0 : zLabel.getIconTextGap();
        int availTextWidth = verticalTextPosition == 3 ? viewR.width : viewR.width - (iconR.width + gap);
        textR.width = Math.min(availTextWidth, textRenderingIcon.getIconWidth());
        textR.height = textRenderingIcon.getIconHeight();
        if (iconR.width != 0) {
            if (verticalTextPosition == 3) {
                iconR.x = textR.x = viewR.x;
                iconR.y = viewR.y;
                textR.y = iconR.y + iconR.height + gap;
            } else {
                iconR.y = textR.y = viewR.y;
                iconR.x = viewR.x;
                textR.x = iconR.x + iconR.width + gap;
            }
        }
    }

    @Override
    public void paint(Graphics g, JComponent label) {
        this.paint(g, (ZoomableLabel)label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paint(Graphics g, ZoomableLabel label) {
        Object newRenderingHintFM;
        if (!label.useFractionalMetrics()) {
            try {
                this.isPainting = true;
                this.superPaintSafe(g, label);
            }
            finally {
                this.isPainting = false;
            }
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Object oldRenderingHintFM = g2.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS);
        if (oldRenderingHintFM != (newRenderingHintFM = RenderingHints.VALUE_FRACTIONALMETRICS_ON)) {
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, newRenderingHintFM);
        }
        AffineTransform transform = g2.getTransform();
        float zoom = label.getZoom() * 0.97f;
        if (label.getVerticalAlignment() == 0) {
            float translationFactorY = 0.5f;
            g2.translate(0.0, (float)label.getHeight() * 0.029999971f * 0.5f);
        }
        g2.scale(zoom, zoom);
        boolean htmlViewSet = null != label.getClientProperty("html");
        try {
            this.isPainting = true;
            if (htmlViewSet) {
                ScaledHTML.resetPainter();
            }
            this.superPaintSafe(g, label);
        }
        finally {
            this.isPainting = false;
            if (htmlViewSet) {
                ScaledHTML.resetPainter();
            }
        }
        g2.setTransform(transform);
        if (oldRenderingHintFM != newRenderingHintFM) {
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, oldRenderingHintFM != null ? oldRenderingHintFM : RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT);
        }
    }

    private void superPaintSafe(Graphics g, final ZoomableLabel label) {
        try {
            boolean isTextTransparent = label.getForeground().getAlpha() == 0;
            Icon textRenderingIcon = label.getTextRenderingIcon();
            if (isTextTransparent) {
                this.paintIcon(g, label);
            } else if (textRenderingIcon != null) {
                this.paintIcons(g, label, textRenderingIcon);
            } else {
                super.paint(g, label);
            }
        }
        catch (ClassCastException e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    label.setText(TextUtils.format("html_problem", label.getText()));
                }
            });
        }
    }

    private void paintIcon(Graphics g, ZoomableLabel label) {
        Icon icon;
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null) {
            return;
        }
        FontMetrics fm = label.getFontMetrics(g.getFont());
        String text = label.getText();
        Rectangle paintViewR = new Rectangle();
        Rectangle paintIconR = new Rectangle();
        Rectangle paintTextR = new Rectangle();
        this.layoutCL(label, fm, text, icon, paintViewR, paintIconR, paintTextR);
        if (icon != null) {
            icon.paintIcon(label, g, paintIconR.x, paintIconR.y);
        }
    }

    private void paintIcons(Graphics g, ZoomableLabel label, Icon textRenderingIcon) {
        Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        Rectangle paintViewR = new Rectangle();
        Rectangle paintIconR = new Rectangle();
        Rectangle paintTextR = new Rectangle();
        this.layoutCL(label, null, null, icon, paintViewR, paintIconR, paintTextR);
        if (icon != null) {
            icon.paintIcon(label, g, paintIconR.x, paintIconR.y);
        }
        textRenderingIcon.paintIcon(label, g, paintTextR.x, paintTextR.y);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        ZoomableLabel lbl = (ZoomableLabel)e.getSource();
        String propertyName = e.getPropertyName();
        if (propertyName == "text" || "font" == propertyName || "foreground" == propertyName || "horizontalAlignment" == propertyName || "componentOrientation" == propertyName || ("ancestor" == propertyName || "graphicsConfiguration" == propertyName) && e.getNewValue() != null || "customCss" == propertyName) {
            this.updateRendererOnPropertyChange(lbl, propertyName);
        } else {
            super.propertyChange(e);
            View view = (View)lbl.getClientProperty("html");
            if (view != null && !(view instanceof ScaledHTML.Renderer)) {
                this.updateRendererOnPropertyChange(lbl, propertyName);
            }
        }
    }

    private void updateRendererOnPropertyChange(ZoomableLabel lbl, String propertyName) {
        if (lbl.getTextRenderingIcon() != null) {
            ScaledHTML.updateRenderer(lbl, "");
        } else {
            ScaledHTML.updateRendererOnPropertyChange(lbl, propertyName);
        }
    }

    @Override
    protected void installComponents(JLabel c) {
        ScaledHTML.updateRenderer(c, c.getText());
        c.setInheritsPopupMenu(true);
    }

    public Rectangle getIconR(ZoomableLabel label) {
        this.layoutZoomed(label);
        return this.iconR;
    }

    public Rectangle getTextR(ZoomableLabel label) {
        this.layoutZoomed(label);
        return this.textR;
    }

    public Rectangle getAvailableTextR(ZoomableLabel label) {
        this.layoutZoomed(label);
        int availableTextWidth = this.viewR.width;
        if (this.iconR.width > 0 && label.getVerticalTextPosition() != 3) {
            availableTextWidth -= this.iconR.width + label.getIconTextGap();
        }
        if (availableTextWidth == this.textR.width) {
            return this.textR;
        }
        Rectangle availableTextR = new Rectangle(this.textR);
        int horizontalAlignment = label.getEffectiveHorizontalAlignment();
        switch (horizontalAlignment) {
            case 0: {
                availableTextR.x -= (availableTextWidth - this.textR.width) / 2;
                break;
            }
            case 4: {
                availableTextR.x -= availableTextWidth - this.textR.width;
            }
        }
        availableTextR.width = availableTextWidth;
        return availableTextR;
    }

    private void layoutZoomed(ZoomableLabel label) {
        this.layoutIgnoringZoom(label);
        float zoom = label.getZoom();
        if (zoom != 1.0f) {
            this.viewR.x = (int)((float)this.iconR.x * zoom);
            this.viewR.y = (int)((float)this.iconR.y * zoom);
            this.viewR.width = (int)((float)this.viewR.width * zoom);
            this.viewR.height = (int)((float)this.viewR.height * zoom);
            this.iconR.x = (int)((float)this.iconR.x * zoom);
            this.iconR.y = (int)((float)this.iconR.y * zoom);
            this.iconR.width = (int)((float)this.iconR.width * zoom);
            this.iconR.height = (int)((float)this.iconR.height * zoom);
            this.textR.x = (int)((float)this.textR.x * zoom);
            this.textR.y = (int)((float)this.textR.y * zoom);
            this.textR.width = (int)((float)this.textR.width * zoom);
            this.textR.height = (int)((float)this.textR.height * zoom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void layoutIgnoringZoom(ZoomableLabel label) {
        boolean wasPainting = this.isPainting;
        try {
            this.isPainting = true;
            this.iconR.height = 0;
            this.iconR.width = 0;
            this.iconR.y = 0;
            this.iconR.x = 0;
            this.textR.height = 0;
            this.textR.width = 0;
            this.textR.y = 0;
            this.textR.x = 0;
            String text = label.getText();
            Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
            this.layoutCL(label, label.getFontMetrics(), text, icon, this.viewR, this.iconR, this.textR);
        }
        finally {
            this.isPainting = wasPainting;
        }
    }

    public void preserveLayout(ZoomableLabel zoomableLabel) {
        this.layoutIgnoringZoom(zoomableLabel);
        zoomableLabel.putClientProperty("preferredLayoutData", new LayoutData(new Rectangle(this.viewR), new Rectangle(this.textR), new Rectangle(this.iconR)));
    }

    public void releaseLayout(ZoomableLabel zoomableLabel) {
        zoomableLabel.putClientProperty("preferredLayoutData", null);
    }

    public static class LayoutData {
        public final Rectangle viewR;
        public final Rectangle iconR;
        public final Rectangle textR;

        public LayoutData(Rectangle viewR, Rectangle textR, Rectangle iconR) {
            this.viewR = viewR;
            this.textR = textR;
            this.iconR = iconR;
        }
    }
}

