/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.echosvg.anim.dom.ResourceLoader;
import io.sf.carte.echosvg.util.ParsedURL;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.w3c.dom.DOMException;

class SMResourceLoader
extends ResourceLoader {
    SMResourceLoader() {
    }

    @Override
    URL getResource(final Class<?> cl, final String resourceName) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return cl.getResource(resourceName);
            }
        });
    }

    @Override
    InputStream openStream(final ParsedURL purl) throws IOException, DOMException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    return purl.openStream();
                }
            });
        }
        catch (PrivilegedActionException e) {
            DOMException ex = new DOMException(11, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }
}

