/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class FolderChooser
extends JFileChooser {
    private static final String uiClassID = "FolderChooserUI";
    private List<String> _recentList;
    public static final String PROPERTY_RECENTLIST = "recentList";
    public static final String PROPERTY_RECENTLIST_VISIBLE = "recentListVisible";
    public static final int BUTTON_ALL = -1;
    public static final int BUTTON_DELETE = 1;
    public static final int BUTTON_NEW = 2;
    public static final int BUTTON_REFRESH = 4;
    public static final int BUTTON_DESKTOP = 8;
    public static final int BUTTON_MY_DOCUMENTS = 16;
    private Comparator<File> _fileComparator = null;
    public static final String PROPERTY_AVAILABLE_BUTTONS = "availableButtons";
    private int _availableButtons;
    private boolean _recentListVisible;
    private File _selectedFolder;
    public static final String PROPERTY_NAVIGATION_FIELD_VISIBLE = "navigationFieldVisible";
    private boolean _navigationFieldVisible;

    public FolderChooser() {
        this.configurationDefaultFlags();
    }

    public FolderChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
        this.configurationDefaultFlags();
    }

    public FolderChooser(File currentDirectory) {
        super(currentDirectory);
        this.configurationDefaultFlags();
    }

    public FolderChooser(FileSystemView fsv) {
        super(fsv);
        this.configurationDefaultFlags();
    }

    public FolderChooser(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
        this.configurationDefaultFlags();
    }

    public FolderChooser(String currentDirectoryPath, FileSystemView fsv) {
        super(currentDirectoryPath, fsv);
        this.configurationDefaultFlags();
    }

    private void configurationDefaultFlags() {
        this.setAvailableButtons(-1);
        this.setRecentListVisible(true);
        this.setNavigationFieldVisible(false);
    }

    public List<String> getRecentList() {
        return this._recentList;
    }

    public void setRecentList(List<String> recentList) {
        List<String> old = this._recentList;
        this._recentList = new ArrayList<String>();
        this._recentList.addAll(recentList);
        this.firePropertyChange(PROPERTY_RECENTLIST, old, this._recentList);
    }

    @Override
    public void updateUI() {
        JComponent c;
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        if ((c = this.getAccessory()) != null) {
            this.setAccessory(null);
        }
        this.setUI(UIManager.getUI(this));
        if (c != null) {
            this.setAccessory(c);
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public File getSelectedFolder() {
        return this._selectedFolder;
    }

    public void setSelectedFolder(File selectedFolder) {
        File old = this._selectedFolder;
        if (!JideSwingUtilities.equals(old, selectedFolder)) {
            this._selectedFolder = selectedFolder;
            this.firePropertyChange("SelectedFileChangedProperty", old, this._selectedFolder);
        }
    }

    public void setNavigationFieldVisible(boolean navigationFieldVisible) {
        boolean oldValue = this._navigationFieldVisible;
        if (!JideSwingUtilities.equals(oldValue, navigationFieldVisible)) {
            this._navigationFieldVisible = navigationFieldVisible;
            this.firePropertyChange(PROPERTY_NAVIGATION_FIELD_VISIBLE, oldValue, this._navigationFieldVisible);
        }
    }

    public boolean isNavigationFieldVisible() {
        return this._navigationFieldVisible;
    }

    public int getAvailableButtons() {
        return this._availableButtons;
    }

    public void setAvailableButtons(int availableButtons) {
        if (this.getAvailableButtons() == availableButtons) {
            return;
        }
        int oldValue = this.getAvailableButtons();
        this._availableButtons = availableButtons;
        this.firePropertyChange(PROPERTY_AVAILABLE_BUTTONS, oldValue, availableButtons);
    }

    public boolean isRecentListVisible() {
        return this._recentListVisible;
    }

    public void setRecentListVisible(boolean recentListVisible) {
        if (this._recentListVisible == recentListVisible) {
            return;
        }
        boolean oldValue = this.isRecentListVisible();
        this._recentListVisible = recentListVisible;
        this.firePropertyChange(PROPERTY_RECENTLIST_VISIBLE, oldValue, recentListVisible);
    }

    @Override
    public void setFileFilter(FileFilter filter) {
        super.setFileFilter(filter);
        this.updateUI();
    }

    public Comparator<File> getFileComparator() {
        return this._fileComparator;
    }

    public void setFileComparator(Comparator<File> fileComparator) {
        this._fileComparator = fileComparator;
    }
}

