/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.net.jdbc.TNSAddress.Description;
import oracle.net.jdbc.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.nt.ConnectDescription;
import oracle.net.resolver.NavAddress;
import oracle.net.resolver.NavAddressList;
import oracle.net.resolver.NavDescriptionList;
import oracle.net.resolver.NavSchemaObject;
import oracle.net.resolver.TimeUnitSuffixUtility;

public class NavDescription
extends Description
implements NavSchemaObject {
    private Vector activeChildren = new Vector(1, 10);
    private int descProcessed;
    private NetException stashedException = null;

    public NavDescription(SchemaObjectFactoryInterface fac) {
        super(fac);
    }

    @Override
    public void navigate(ConnStrategy cs, StringBuffer sBuf) throws NetException {
        sBuf.setLength(0);
        sBuf.append("(DESCRIPTION=");
        ConnectDescription desc = cs.newConnectDescription();
        desc.setDescriptionString(this.descriptionString);
        if (this.SDU != null) {
            desc.setSdu(this.getIntValue(this.SDU, desc.getSdu()));
        }
        if (this.TDU != null) {
            desc.setTdu(this.getIntValue(this.TDU, desc.getTdu()));
        }
        if (this.connectTimeout != null) {
            desc.setConnectTimeout(TimeUnitSuffixUtility.getTimeInMilliseconds(this.connectTimeout, true, desc.getConnectTimeout()));
        }
        if (this.transportTimeout != null) {
            desc.setTransportConnectTimeout(TimeUnitSuffixUtility.getTimeInMilliseconds(this.transportTimeout, true, desc.getTransportConnectTimeout()));
        }
        if (this.retryCount != null) {
            cs.retryCount = this.getIntValue(this.retryCount, cs.retryCount);
            desc.setRetryCount(cs.retryCount);
        }
        if (this.delayInMillis != -1) {
            desc.setDelayInMillis(this.delayInMillis);
        }
        if (!this.failover) {
            sBuf.append("(FAILOVER=false)");
        }
        if (this.netConnectionIdPrefix != null) {
            desc.setConnectionIdPrefix(this.netConnectionIdPrefix);
        }
        if (this.checksumClient != null) {
            desc.setChecksumClient(this.checksumClient);
        }
        if (this.checksumClientTypes != null) {
            desc.setChecksumClientTypes(this.checksumClientTypes);
        }
        if (this.encryptionClient != null) {
            desc.setEncryptionClient(this.encryptionClient);
        }
        if (this.encryptionClientTypes != null) {
            desc.setEncryptionClientTypes(this.encryptionClientTypes);
        }
        if (this.allowWeakCrypto != null) {
            desc.setAllowWeakCrypto(this.allowWeakCrypto);
        }
        if (this.useSNI != null) {
            desc.useSNI(this.useSNI);
        }
        if (this.httpsProxy != null) {
            desc.setHttpsProxy(this.httpsProxy);
        }
        if (this.httpsProxyPort != null) {
            try {
                desc.setHttpsProxyPort(Integer.parseInt(this.httpsProxyPort));
            }
            catch (NumberFormatException e) {
                throw new NetException(17866, "Invalid https proxy port number format");
            }
        }
        cs.addSocketOptions(this.keepAlive);
        if (this.sourceRoute) {
            if (!this.backwardCompatibilityCase(this.children, cs)) {
                this.activeChildren = this.children;
                try {
                    ((NavSchemaObject)this.activeChildren.elementAt(0)).navigate(cs, sBuf);
                }
                catch (NetException e) {
                    this.stashedException = e;
                    throw e;
                }
                for (int i = 1; i < this.activeChildren.size(); ++i) {
                    ((NavSchemaObject)this.activeChildren.elementAt(i)).addToString(cs);
                }
            } else {
                this.setConnectionOption(cs, sBuf);
            }
            this.closeNVPair(cs);
        } else {
            this.activeChildren = NavDescriptionList.setActiveChildren(this.children, this.failover, this.loadBalance);
            for (int i = 0; i < this.activeChildren.size(); ++i) {
                try {
                    ((NavSchemaObject)this.activeChildren.elementAt(i)).navigate(cs, sBuf);
                    continue;
                }
                catch (NetException e) {
                    this.stashedException = e;
                }
            }
            this.closeNVPair(cs);
        }
        if (cs.currentDescription().getConnectOptions().size() == 0) {
            sBuf.replace(sBuf.length() - "(DESCRIPTION=".length(), sBuf.length(), "");
            throw this.stashedException;
        }
        if (this.expireTime != null) {
            desc.setExpireTime(this.getIntValue(this.expireTime, -1));
        }
        if (this.loadBalance) {
            cs.addSocketOptions_FORCE_DNS_LOAD_BALANCING_OFF();
        }
        desc.setTokenAuthentication(this.tokenAuthentication);
        desc.setTokenLocation(this.tokenLocation);
        desc.setPasswordAuthentication(this.passwordAuthentication);
        desc.setOciIamUrl(this.ociIamUrl);
        desc.setOciTenancy(this.ociTenancy);
        desc.setOciCompartment(this.ociCompartment);
        desc.setOciDatabase(this.ociDatabase);
        desc.setOciConfigFile(this.ociConfigFile);
        desc.setOciProfile(this.ociProfile);
        desc.setAzureDbAppIdUri(this.azureDbAppIdUri);
        desc.setTenantId(this.tenantId);
        desc.setClientId(this.clientId);
        desc.setClientCertificate(this.clientCertificate);
        desc.setRedirectUri(this.redirectUri);
        desc.setAzureCredentials(this.azureCredentials);
        desc.setWalletLocation(this.myWalletDirectory);
        if (this.BEQServerProcessEnvironmentVars != null) {
            assert (desc.getConnectOptions() != null && desc.getConnectOptions().size() >= 1) : "ConnOption not properly set for BEQ";
            desc.getConnectOptions().get((int)0).serverProcessEnvironmentVars = this.getKeyValueCommaListValue(this.BEQServerProcessEnvironmentVars);
        }
        if (this.BEQServerProcessArguments != null) {
            assert (desc.getConnectOptions() != null && desc.getConnectOptions().size() >= 1) : "ConnOption not properly set for BEQ";
            desc.getConnectOptions().get((int)0).serverProcessArguments = this.BEQServerProcessArguments;
        }
        cs.closeDescription();
    }

    private Map<String, String> getKeyValueCommaListValue(String environmentVars) {
        HashMap<String, String> result = new HashMap<String, String>();
        assert (environmentVars != null) : "env vars string cannot be null";
        String[] commaSplitted = environmentVars.split(",");
        for (int i = 0; i < commaSplitted.length; ++i) {
            String[] equalSplitted = commaSplitted[i].split("=");
            if (equalSplitted.length != 2) {
                throw new IllegalArgumentException(String.format("unexpected format %s", commaSplitted[i]));
            }
            result.put(equalSplitted[0], equalSplitted[1]);
        }
        return result;
    }

    public void closeNVPair(ConnStrategy cs) {
        if (cs.currentDescription() == null) {
            return;
        }
        ArrayList<ConnOption> cOpts = cs.currentDescription().getConnectOptions();
        for (ConnOption connOpt : cOpts) {
            if (this.sourceRoute) {
                connOpt.conn_data.append("(SOURCE_ROUTE=yes)");
            }
            if (this.connectData == null) {
                this.connectData = "(SERVICE_NAME=)";
            }
            connOpt.conn_data.append("(CONNECT_DATA=");
            connOpt.conn_data.append("(CID=(PROGRAM=");
            connOpt.conn_data.append(cs.getProgramName());
            connOpt.conn_data.append(")(HOST=");
            connOpt.conn_data.append(cs.getHostname());
            connOpt.conn_data.append(")(USER=");
            connOpt.conn_data.append(cs.getOSUsername());
            connOpt.conn_data.append("))");
            connOpt.conn_data.append(this.connectData);
            connOpt.conn_data.append(")");
            connOpt.sourceRoute = this.sourceRoute;
            if (this.SID != null) {
                connOpt.sid = this.SID;
            }
            if (this.serviceName != null) {
                connOpt.service_name = this.serviceName;
            }
            if (this.instanceName != null) {
                connOpt.instance_name = this.instanceName;
            }
            if (this.sslServerCertDN != null) {
                connOpt.sslServerCertDN = this.sslServerCertDN;
            }
            if (this.myWalletDirectory != null) {
                connOpt.walletDirectory = this.myWalletDirectory;
            }
            if (this.sslServerDNMatch != null) {
                connOpt.sslServerDNMatch = this.sslServerDNMatch;
            }
            if (this.sslAllowWeakDNMatch != null) {
                connOpt.sslAllowWeakDNMatch = this.sslAllowWeakDNMatch;
            }
            if (this.sslVersion != null) {
                connOpt.sslVersion = this.sslVersion;
            }
            if (this.sslCiphers != null) {
                connOpt.sslCiphers = this.sslCiphers;
            }
            if (this.sslCertAlias != null) {
                connOpt.sslCertAlias = this.sslCertAlias;
            }
            if (this.sslCertThumbprint != null) {
                connOpt.sslCertThumbprint = this.sslCertThumbprint;
            }
            if (this.useTcpFastOpen != null) {
                connOpt.useTcpFastOpen = this.useTcpFastOpen;
            }
            if (this.colocationTag != null) {
                connOpt.colocationTag = this.colocationTag;
            }
            if (this.server != null) {
                connOpt.serverMode = this.server;
            }
            connOpt.conn_data.append(")");
            connOpt.done = true;
        }
    }

    @Override
    public void addToString(ConnStrategy cs) {
    }

    private int getIntValue(String stringInt, int defaultValue) {
        try {
            return Integer.parseInt(stringInt);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private boolean backwardCompatibilityCase(Vector children, ConnStrategy cs) {
        if (children.size() == 1 && ((NavSchemaObject)children.elementAt(0)).isA() == 1 && !((NavAddressList)children.elementAt((int)0)).sourceRoute) {
            NavAddressList addrl = (NavAddressList)children.elementAt(0);
            int numChildren = addrl.getChildrenSize();
            if (numChildren == 0) {
                return false;
            }
            for (int i = 0; i < numChildren; ++i) {
                if (addrl.getChildrenType(i) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void setConnectionOption(ConnStrategy cs, StringBuffer sBuf) throws NetException {
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, this.getClass().getName(), "setConnectionOption", "Dealing with a Back.Compat. Case", null, null);
        sBuf.append("(ADDRESS_LIST=");
        NavAddressList addrl = (NavAddressList)this.children.elementAt(0);
        NavAddress first = addrl.getChild(0);
        int numChildren = addrl.getChildrenSize();
        first.navigate(cs, sBuf);
        for (int i = 1; i < numChildren; ++i) {
            addrl.getChild(i).addToString(cs);
        }
        cs.currentDescription().getConnectOptions().get((int)0).conn_data.append(")");
    }
}

