/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.common.FailoverEvent;
import oracle.ucp.common.FailoverEventHandlerTaskBase;
import oracle.ucp.common.Failoverable;
import oracle.ucp.jdbc.oracle.ONSDatabaseFailoverEvent;
import oracle.ucp.jdbc.oracle.ONSOracleFailoverEventSubscriber;
import oracle.ucp.jdbc.oracle.OracleFailoverEvent;
import oracle.ucp.jdbc.oracle.OracleFailoverEventSubscriber;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.util.TaskManager;

class ONSDatabaseEventHandlerTask
extends FailoverEventHandlerTaskBase {
    static final String CLASS_NAME = ONSDatabaseEventHandlerTask.class.getName();
    private final OracleFailoverEventSubscriber m_onsSubscriber;
    private final boolean m_subscriberFailed;
    private final TaskManager m_taskManager;
    private final LinkedList<OracleFailoverEvent> m_recentEvents;
    private static final int EVENT_AGE_OUT_PERIOD = 120000;
    private long m_timestampOfLastEvent;
    private static final String FAN_STATUS_FIELD = "status";

    @Debug(level=Debug.Level.FINEST)
    ONSDatabaseEventHandlerTask(String serviceName, Failoverable failoverableObject, TaskManager taskManager) throws UniversalConnectionPoolException {
        this(serviceName, failoverableObject, null, taskManager);
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "<init>", "entering args ({0}, {1}, {2})", null, null, serviceName, failoverableObject, taskManager);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "<init>", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "<init>", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    protected ONSDatabaseEventHandlerTask(String serviceName, Failoverable failoverableObject, OracleFailoverEventSubscriber subscriber, TaskManager taskManager) throws UniversalConnectionPoolException {
        super(failoverableObject);
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "<init>", "entering args ({0}, {1}, {2}, {3})", null, null, serviceName, failoverableObject, subscriber, taskManager);
            this.m_recentEvents = new LinkedList();
            ONS currentONS = ((RACManagerImpl)failoverableObject).getONS();
            if (null == subscriber) {
                ONSOracleFailoverEventSubscriber s = new ONSOracleFailoverEventSubscriber(serviceName, currentONS);
                this.m_subscriberFailed = s.isFailed();
                this.m_onsSubscriber = s;
            } else {
                this.m_subscriberFailed = false;
                this.m_onsSubscriber = subscriber;
            }
            this.m_taskManager = taskManager;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "<init>", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "<init>", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    ONSDatabaseEventHandlerTask(Failoverable failoverableObject, TaskManager taskManager) throws UniversalConnectionPoolException {
        this("", failoverableObject, null, taskManager);
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "<init>", "entering args ({0}, {1})", null, null, failoverableObject, taskManager);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "<init>", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "<init>", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    protected ONSDatabaseEventHandlerTask(Failoverable failoverableObject, OracleFailoverEventSubscriber subscriber, TaskManager taskManager) throws UniversalConnectionPoolException {
        this("", failoverableObject, subscriber, taskManager);
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "<init>", "entering args ({0}, {1}, {2})", null, null, failoverableObject, subscriber, taskManager);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "<init>", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "<init>", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void run() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "run", "entering args ()", null, null, new Object[0]);
            Notification event = null;
            boolean retrySubscription = false;
            if (!this.m_subscriberFailed) {
                while (!this.isTerminate()) {
                    this.trace(Level.FINEST, CLASS_NAME, "run", "check for events", null, null, new Object[0]);
                    try {
                        event = this.m_onsSubscriber.receive();
                        if (event != null) {
                            ONSDatabaseFailoverEvent oracleFailoverEvent = event.get(FAN_STATUS_FIELD) != null ? new ONSDatabaseFailoverEvent(event) : new ONSDatabaseFailoverEvent(event.type(), event.body());
                            this.handleEvent(oracleFailoverEvent);
                            this.trace(Level.FINEST, CLASS_NAME, "run", "event triggered: {0}", null, null, ((Object)oracleFailoverEvent).toString());
                        } else {
                            this.trace(Level.FINEST, CLASS_NAME, "run", "received null event", null, null, new Object[0]);
                        }
                    }
                    catch (UniversalConnectionPoolException ucpEx) {
                        this.trace(Level.WARNING, CLASS_NAME, "run", "", null, ucpEx, new Object[0]);
                        retrySubscription = true;
                    }
                    if (!retrySubscription) continue;
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        this.trace(Level.FINEST, CLASS_NAME, "run", "sleep interrupted", null, null, new Object[0]);
                    }
                    retrySubscription = false;
                }
            } else {
                this.trace(Level.FINEST, CLASS_NAME, "run", "ONS subscriber failed", null, null, new Object[0]);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "run", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "run", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void handleEvent(FailoverEvent failoverEvent) throws UniversalConnectionPoolException {
        try {
            void event;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "handleEvent", "entering args ({0})", null, null, failoverEvent);
            OracleFailoverEvent oevent = (OracleFailoverEvent)event;
            if (!oevent.isValid()) {
                this.trace(Level.FINEST, CLASS_NAME, "handleEvent", "Invalid HA event received: {0}", null, null, event);
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "handleEvent", "returning void", null, null, new Object[0]);
                return;
            }
            long ts = oevent.getTimestamp();
            if (ts >= 0L && ts < this.m_timestampOfLastEvent) {
                this.trace(Level.FINEST, CLASS_NAME, "handleEvent", "Out-of-order HA event received: {0}", null, null, event);
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "handleEvent", "returning void", null, null, new Object[0]);
                return;
            }
            Iterator<OracleFailoverEvent> iterator = this.m_recentEvents.descendingIterator();
            boolean foundRedundant = false;
            String newType = oevent.getEventType();
            String newSvc = oevent.getServiceName();
            String newInst = oevent.getInstanceName();
            String newDb = oevent.getDbUniqueName();
            String newHst = oevent.getHostName();
            String newStat = oevent.getStatus();
            if (null != newSvc && newSvc.contains("%")) {
                OracleFailoverEvent nextEvent;
                this.trace(Level.FINEST, CLASS_NAME, "handleEvent", "GDS service name: {0}, processing GDS-based filtering", null, null, newSvc);
                if (newType.equals("database/event/service")) {
                    String nextInstName = null;
                    while (iterator.hasNext()) {
                        nextEvent = iterator.next();
                        nextInstName = nextEvent.getInstanceName();
                        if (newStat == null || !newStat.equals(nextEvent.getStatus()) || newSvc == null || !newSvc.equals(nextEvent.getServiceName()) || newDb == null || !newDb.equals(nextEvent.getDbUniqueName()) || newHst == null || !newHst.equals(nextEvent.getHostName()) || (newInst != null || nextInstName != null) && (newInst == null || nextInstName != null && !newInst.equals(nextInstName))) continue;
                        foundRedundant = true;
                        this.trace(Level.FINEST, CLASS_NAME, "handleEvent", "Redundant HA service event received and ignored: {0}", null, null, oevent);
                        break;
                    }
                } else if (newType.equals("database/event/host")) {
                    while (iterator.hasNext()) {
                        nextEvent = iterator.next();
                        if (newHst == null || !newHst.equals(nextEvent.getHostName())) continue;
                        foundRedundant = true;
                        this.trace(Level.FINEST, CLASS_NAME, "handleEvent", "Redundant HA host event received and ignored: {0}", null, null, oevent);
                        break;
                    }
                }
                if (!foundRedundant) {
                    this.m_recentEvents.addLast(oevent);
                    this.m_timestampOfLastEvent = oevent.getTimestamp();
                    super.handleEvent((FailoverEvent)event);
                    while ((nextEvent = this.m_recentEvents.peekFirst()) != null && this.m_timestampOfLastEvent > nextEvent.getTimestamp() + 120000L) {
                        this.trace(Level.FINEST, CLASS_NAME, "handleEvent", "about to remove {0}", null, null, nextEvent.toString());
                        this.m_recentEvents.removeFirst();
                    }
                }
            } else {
                this.trace(Level.FINEST, CLASS_NAME, "handleEvent", "non-GDS service name: {0}, skipping GDS-based filtering", null, null, newSvc);
                super.handleEvent((FailoverEvent)event);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "handleEvent", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "handleEvent", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setTerminate(boolean bl) {
        try {
            void terminate;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "setTerminate", "entering args ({0})", null, null, bl);
            super.setTerminate((boolean)terminate);
            if (terminate != false) {
                this.m_onsSubscriber.close();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "setTerminate", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask", "setTerminate", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    protected TaskManager getTaskManager() {
        return this.m_taskManager;
    }
}

