/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import org.opensearch.knn.common.KNNValidationUtil;
import org.opensearch.knn.index.VectorDataType;

public interface PerDimensionValidator {
    public static final PerDimensionValidator DEFAULT_FLOAT_VALIDATOR = new PerDimensionValidator(){

        @Override
        public void validate(float value) {
            KNNValidationUtil.validateFloatVectorValue(value);
        }

        @Override
        public void validateByte(float value) {
            throw new IllegalStateException("DEFAULT_FLOAT_VALIDATOR should only be used for float vectors");
        }
    };
    public static final PerDimensionValidator DEFAULT_BYTE_VALIDATOR = new PerDimensionValidator(){

        @Override
        public void validate(float value) {
            throw new IllegalStateException("DEFAULT_BYTE_VALIDATOR should only be used for byte values");
        }

        @Override
        public void validateByte(float value) {
            KNNValidationUtil.validateByteVectorValue(value, VectorDataType.BYTE);
        }
    };
    public static final PerDimensionValidator DEFAULT_BIT_VALIDATOR = new PerDimensionValidator(){

        @Override
        public void validate(float value) {
            throw new IllegalStateException("DEFAULT_BIT_VALIDATOR should only be used for byte values");
        }

        @Override
        public void validateByte(float value) {
            KNNValidationUtil.validateByteVectorValue(value, VectorDataType.BINARY);
        }
    };

    default public void validate(float value) {
    }

    default public void validateByte(float value) {
    }
}

