\name{ScalarImageKmeansImageFilter}
\alias{ScalarImageKmeansImageFilter}
\title{ScalarImageKmeansImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Classifies the intensity values of a scalar image using the K-Means
algorithm.
ScalarImageKmeansImageFilter}
\details{
Given an input image with scalar values, it uses the K-Means
statistical classifier in order to define labels for every pixel in
the image. The filter is templated over the type of the input image.
The output image is predefined as having the same dimension of the
input image and pixel type unsigned char, under the assumption that
the classifier will generate less than 256 classes.
You may want to look also at the RelabelImageFilter that may be used
as a postprocessing stage, in particular if you are interested in
ordering the labels by their relative size in number of pixels.
See:
Image
ImageKmeansModelEstimator
KdTreeBasedKmeansEstimator, WeightedCentroidKdTreeGenerator, KdTree
RelabelImageFilter
ScalarImageKmeans for the procedural interface
itk::ScalarImageKmeansImageFilter for the Doxygen on the original ITK class.
ScalarImageKmeansImageFilter}
%C++ includes: sitkScalarImageKmeansImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::vector< double > GetClassWithInitialMean() const:}{}
\item{std::vector< double > GetFinalMeans() const:}{
Return the array of Means found after the classification.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetUseNonContiguousLabels() const:}{
Set/Get the UseNonContiguousLabels flag. When this is set to false the
labels are numbered contiguously, like in {0,1,3..N}. When the flag is
set to true, the labels are selected in order to span the dynamic
range of the output image. This last option is useful when the output
image is intended only for display. The default value is false.
}
\item{ ScalarImageKmeansImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetClassWithInitialMean(std::vector< double > ClassWithInitialMean):}{}
\item{Self SetUseNonContiguousLabels(bool UseNonContiguousLabels):}{
Set/Get the UseNonContiguousLabels flag. When this is set to false the
labels are numbered contiguously, like in {0,1,3..N}. When the flag is
set to true, the labels are selected in order to span the dynamic
range of the output image. This last option is useful when the output
image is intended only for display. The default value is false.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self UseNonContiguousLabelsOff():}{}
\item{Self UseNonContiguousLabelsOn():}{
Set the value of UseNonContiguousLabels to true or false respectfully.
}
\item{ ~ScalarImageKmeansImageFilter():}{
Destructor
}
}
}
