/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnection;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.pool2.ObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.GenericObjectPool;

public class PoolingDataSource<C extends Connection>
implements DataSource,
AutoCloseable {
    private static final Log log = LogFactory.getLog(PoolingDataSource.class);
    private boolean accessToUnderlyingConnectionAllowed;
    private PrintWriter logWriter;
    private final ObjectPool<C> pool;

    public PoolingDataSource(ObjectPool<C> objectPool) {
        Objects.requireNonNull(objectPool, "pool");
        this.pool = objectPool;
        if (this.pool instanceof GenericObjectPool) {
            PoolableConnectionFactory poolableConnectionFactory = (PoolableConnectionFactory)((GenericObjectPool)this.pool).getFactory();
            Objects.requireNonNull(poolableConnectionFactory, "this.pool.getFactory()");
            if (poolableConnectionFactory.getPool() != this.pool) {
                log.warn((Object)Utils.getMessage("poolingDataSource.factoryConfig"));
                ObjectPool<PoolableConnection> objectPool2 = this.pool;
                poolableConnectionFactory.setPool(objectPool2);
            }
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.pool.close();
        }
        catch (Exception exception) {
            throw new SQLException(Utils.getMessage("pool.close.fail"), exception);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            Connection connection = (Connection)this.pool.borrowObject();
            if (connection == null) {
                return null;
            }
            return new PoolGuardConnectionWrapper(this, connection);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException("Cannot get a connection, pool error " + noSuchElementException.getMessage(), noSuchElementException);
        }
        catch (RuntimeException | SQLException exception) {
            throw exception;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new SQLException("Cannot get a connection, general error", interruptedException);
        }
        catch (Exception exception) {
            throw new SQLException("Cannot get a connection, general error", exception);
        }
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLoginTimeout() {
        throw new UnsupportedOperationException("Login timeout is not supported.");
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    protected ObjectPool<C> getPool() {
        return this.pool;
    }

    public boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isInstance(this);
    }

    public void setAccessToUnderlyingConnectionAllowed(boolean bl) {
        this.accessToUnderlyingConnectionAllowed = bl;
    }

    @Override
    public void setLoginTimeout(int n) {
        throw new UnsupportedOperationException("Login timeout is not supported.");
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return clazz.cast(this);
        }
        throw new SQLException(this + " is not a wrapper for " + clazz);
    }

    private static final class PoolGuardConnectionWrapper<D extends Connection>
    extends DelegatingConnection<D> {
        final /* synthetic */ PoolingDataSource this$0;

        PoolGuardConnectionWrapper(D d) {
            this.this$0 = var1_1;
            super(d);
        }

        @Override
        public void close() throws SQLException {
            if (this.getDelegateInternal() != null) {
                super.close();
                super.setDelegate(null);
            }
        }

        @Override
        public D getDelegate() {
            return this.this$0.isAccessToUnderlyingConnectionAllowed() ? (D)super.getDelegate() : null;
        }

        @Override
        public Connection getInnermostDelegate() {
            return this.this$0.isAccessToUnderlyingConnectionAllowed() ? super.getInnermostDelegate() : null;
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.getDelegateInternal() == null || super.isClosed();
        }
    }
}

