/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.model.data.wkb;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.MessageFormat;
import org.jkiss.dbeaver.ext.hana.model.data.wkb.GeometryType;
import org.jkiss.dbeaver.ext.hana.model.data.wkb.HANAWKBWriterException;
import org.jkiss.dbeaver.ext.hana.model.data.wkb.XyzmMode;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class HANAWKBWriter {
    private static final int HEADER_SIZE = 5;
    private static final int COUNT_SIZE = 4;
    private static final int COORD_SIZE = 8;
    private static final byte NDR = 1;
    private static final int Z_OFFSET = 1000;
    private static final int M_OFFSET = 2000;

    public static byte[] write(Geometry geometry, XyzmMode xyzmMode) throws HANAWKBWriterException {
        if (geometry == null) {
            return null;
        }
        int size = HANAWKBWriter.computeGeometrySize(geometry, xyzmMode);
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        HANAWKBWriter.writeGeometry(geometry, xyzmMode, buffer);
        return buffer.array();
    }

    private static int computeGeometrySize(Geometry geometry, XyzmMode xyzmMode) throws HANAWKBWriterException {
        if (geometry instanceof Point) {
            return HANAWKBWriter.computePointSize(xyzmMode);
        }
        if (geometry instanceof LineString) {
            return HANAWKBWriter.computeLineStringSize((LineString)geometry, xyzmMode);
        }
        if (geometry instanceof Polygon) {
            return HANAWKBWriter.computePolygonSize((Polygon)geometry, xyzmMode);
        }
        if (geometry instanceof MultiPoint) {
            return HANAWKBWriter.computeMultiPointSize((MultiPoint)geometry, xyzmMode);
        }
        if (geometry instanceof MultiLineString) {
            return HANAWKBWriter.computeMultiLineStringSize((MultiLineString)geometry, xyzmMode);
        }
        if (geometry instanceof MultiPolygon) {
            return HANAWKBWriter.computeMultiPolygonSize((MultiPolygon)geometry, xyzmMode);
        }
        if (geometry instanceof GeometryCollection) {
            return HANAWKBWriter.computeGeometryCollectionSize((GeometryCollection)geometry, xyzmMode);
        }
        throw new HANAWKBWriterException(MessageFormat.format("Unsupported geometry type {0}", geometry.getGeometryType()));
    }

    private static int computePointSize(XyzmMode xyzmMode) {
        return 5 + xyzmMode.getCoordinatesPerPoint() * 8;
    }

    private static int computeLineStringSize(LineString lineString, XyzmMode xyzmMode) {
        return 9 + lineString.getNumPoints() * xyzmMode.getCoordinatesPerPoint() * 8;
    }

    private static int computePolygonSize(Polygon polygon, XyzmMode xyzmMode) {
        int size = 9;
        LinearRing shell = polygon.getExteriorRing();
        if (shell == null || shell.getNumPoints() == 0) {
            return size;
        }
        int pointSize = xyzmMode.getCoordinatesPerPoint() * 8;
        size += 4 + shell.getNumPoints() * pointSize;
        int numHoles = polygon.getNumInteriorRing();
        for (int i = 0; i < numHoles; ++i) {
            size += 4 + polygon.getInteriorRingN(i).getNumPoints() * pointSize;
        }
        return size;
    }

    private static int computeMultiPointSize(MultiPoint multiPoint, XyzmMode xyzmMode) {
        int pointSize = xyzmMode.getCoordinatesPerPoint() * 8;
        return 9 + multiPoint.getNumPoints() * (5 + pointSize);
    }

    private static int computeMultiLineStringSize(MultiLineString multiLineString, XyzmMode xyzmMode) {
        int size = 9;
        for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
            size += HANAWKBWriter.computeLineStringSize((LineString)multiLineString.getGeometryN(i), xyzmMode);
        }
        return size;
    }

    private static int computeMultiPolygonSize(MultiPolygon multiPolygon, XyzmMode xyzmMode) {
        int size = 9;
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            size += HANAWKBWriter.computePolygonSize((Polygon)multiPolygon.getGeometryN(i), xyzmMode);
        }
        return size;
    }

    private static int computeGeometryCollectionSize(GeometryCollection geometryCollection, XyzmMode xyzmMode) throws HANAWKBWriterException {
        int size = 9;
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            size += HANAWKBWriter.computeGeometrySize(geometryCollection.getGeometryN(i), xyzmMode);
        }
        return size;
    }

    private static void writeGeometry(Geometry geometry, XyzmMode xyzmMode, ByteBuffer buffer) throws HANAWKBWriterException {
        if (geometry instanceof Point) {
            HANAWKBWriter.writePoint((Point)geometry, xyzmMode, buffer);
        } else if (geometry instanceof LineString) {
            HANAWKBWriter.writeLineString((LineString)geometry, xyzmMode, buffer);
        } else if (geometry instanceof Polygon) {
            HANAWKBWriter.writePolygon((Polygon)geometry, xyzmMode, buffer);
        } else if (geometry instanceof MultiPoint) {
            HANAWKBWriter.writeMultiPoint((MultiPoint)geometry, xyzmMode, buffer);
        } else if (geometry instanceof MultiLineString) {
            HANAWKBWriter.writeMultiLineString((MultiLineString)geometry, xyzmMode, buffer);
        } else if (geometry instanceof MultiPolygon) {
            HANAWKBWriter.writeMultiPolygon((MultiPolygon)geometry, xyzmMode, buffer);
        } else if (geometry instanceof GeometryCollection) {
            HANAWKBWriter.writeGeometryCollection((GeometryCollection)geometry, xyzmMode, buffer);
        } else {
            throw new HANAWKBWriterException(MessageFormat.format("Unsupported geometry type {0}", geometry.getGeometryType()));
        }
    }

    private static void writePoint(Point point, XyzmMode xyzmMode, ByteBuffer buffer) {
        HANAWKBWriter.writeHeader(GeometryType.POINT, xyzmMode, buffer);
        CoordinateSequence cs = point.getCoordinateSequence();
        if (cs.size() == 0) {
            for (int i = 0; i < xyzmMode.getCoordinatesPerPoint(); ++i) {
                buffer.putDouble(Double.NaN);
            }
        } else {
            buffer.putDouble(cs.getX(0));
            buffer.putDouble(cs.getY(0));
            if (xyzmMode.hasZ()) {
                buffer.putDouble(cs.getZ(0));
            }
            if (xyzmMode.hasM()) {
                buffer.putDouble(cs.getM(0));
            }
        }
    }

    private static void writeLineString(LineString lineString, XyzmMode xyzmMode, ByteBuffer buffer) {
        HANAWKBWriter.writeHeader(GeometryType.LINESTRING, xyzmMode, buffer);
        HANAWKBWriter.writeCoordinateSequence(lineString.getCoordinateSequence(), xyzmMode, buffer);
    }

    private static void writePolygon(Polygon polygon, XyzmMode xyzmMode, ByteBuffer buffer) {
        HANAWKBWriter.writeHeader(GeometryType.POLYGON, xyzmMode, buffer);
        LinearRing shell = polygon.getExteriorRing();
        if (shell == null || shell.getNumPoints() == 0) {
            buffer.putInt(0);
            return;
        }
        int numHoles = polygon.getNumInteriorRing();
        buffer.putInt(1 + numHoles);
        HANAWKBWriter.writeCoordinateSequence(shell.getCoordinateSequence(), xyzmMode, buffer);
        for (int i = 0; i < numHoles; ++i) {
            LinearRing hole = polygon.getInteriorRingN(i);
            HANAWKBWriter.writeCoordinateSequence(hole.getCoordinateSequence(), xyzmMode, buffer);
        }
    }

    private static void writeMultiPoint(MultiPoint multiPoint, XyzmMode xyzmMode, ByteBuffer buffer) {
        HANAWKBWriter.writeHeader(GeometryType.MULTIPOINT, xyzmMode, buffer);
        int numPoints = multiPoint.getNumPoints();
        buffer.putInt(numPoints);
        for (int i = 0; i < numPoints; ++i) {
            HANAWKBWriter.writePoint((Point)multiPoint.getGeometryN(i), xyzmMode, buffer);
        }
    }

    private static void writeMultiLineString(MultiLineString multiLineString, XyzmMode xyzmMode, ByteBuffer buffer) {
        HANAWKBWriter.writeHeader(GeometryType.MULTILINESTRING, xyzmMode, buffer);
        int numLineStrings = multiLineString.getNumGeometries();
        buffer.putInt(numLineStrings);
        for (int i = 0; i < numLineStrings; ++i) {
            HANAWKBWriter.writeLineString((LineString)multiLineString.getGeometryN(i), xyzmMode, buffer);
        }
    }

    private static void writeMultiPolygon(MultiPolygon multiPolygon, XyzmMode xyzmMode, ByteBuffer buffer) {
        HANAWKBWriter.writeHeader(GeometryType.MULTIPOLYGON, xyzmMode, buffer);
        int numPolygons = multiPolygon.getNumGeometries();
        buffer.putInt(numPolygons);
        for (int i = 0; i < numPolygons; ++i) {
            HANAWKBWriter.writePolygon((Polygon)multiPolygon.getGeometryN(i), xyzmMode, buffer);
        }
    }

    private static void writeGeometryCollection(GeometryCollection geometryCollection, XyzmMode xyzmMode, ByteBuffer buffer) throws HANAWKBWriterException {
        HANAWKBWriter.writeHeader(GeometryType.GEOMETRYCOLLECTION, xyzmMode, buffer);
        int numGeometries = geometryCollection.getNumGeometries();
        buffer.putInt(numGeometries);
        for (int i = 0; i < numGeometries; ++i) {
            HANAWKBWriter.writeGeometry(geometryCollection.getGeometryN(i), xyzmMode, buffer);
        }
    }

    private static void writeCoordinateSequence(CoordinateSequence cs, XyzmMode xyzmMode, ByteBuffer buffer) {
        int numPoints = cs.size();
        buffer.putInt(numPoints);
        for (int i = 0; i < numPoints; ++i) {
            buffer.putDouble(cs.getX(i));
            buffer.putDouble(cs.getY(i));
            if (xyzmMode.hasZ()) {
                buffer.putDouble(cs.getZ(i));
            }
            if (!xyzmMode.hasM()) continue;
            buffer.putDouble(cs.getM(i));
        }
    }

    private static void writeHeader(GeometryType geometryType, XyzmMode xyzmMode, ByteBuffer buffer) {
        buffer.put((byte)1);
        int typeCode = geometryType.getTypeCode();
        if (xyzmMode.hasZ()) {
            typeCode += 1000;
        }
        if (xyzmMode.hasM()) {
            typeCode += 2000;
        }
        buffer.putInt(typeCode);
    }
}

