/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.parser;

import io.sf.carte.echosvg.parser.DefaultLengthHandler;
import io.sf.carte.echosvg.parser.LengthParser;
import io.sf.carte.echosvg.parser.ParseException;
import org.w3c.dom.Element;

public abstract class UnitProcessor {
    public static final short HORIZONTAL_LENGTH = 2;
    public static final short VERTICAL_LENGTH = 1;
    public static final short OTHER_LENGTH = 0;
    static final double SQRT2 = Math.sqrt(2.0);

    protected UnitProcessor() {
    }

    public static float cssToObjectBoundingBox(String s, String attr, final short d, final Context ctx) throws ParseException {
        UnitResolver ur = new UnitResolver(){

            @Override
            protected float unitToPixels(short unitType, float floatValue, short percentageInterpretation) {
                return UnitProcessor.cssToObjectBoundingBox(floatValue, unitType, d, ctx);
            }
        };
        LengthParser lengthParser = new LengthParser(ur);
        lengthParser.parse(s);
        return UnitProcessor.cssToObjectBoundingBox(ur.value, ur.unit, d, ctx);
    }

    public static float cssToObjectBoundingBox(float value, short type, short d, Context ctx) {
        switch (type) {
            case 0: {
                return value;
            }
            case 2: {
                return value / 100.0f;
            }
        }
        return UnitProcessor.cssToUserSpace(value, type, d, ctx);
    }

    public static float cssToUserSpace(String s, String attr, final short d, final Context ctx) throws ParseException {
        UnitResolver ur = new UnitResolver(){

            @Override
            protected float unitToPixels(short unitType, float floatValue, short percentageInterpretation) {
                return UnitProcessor.cssToUserSpace(floatValue, unitType, d, ctx);
            }
        };
        LengthParser lengthParser = new LengthParser(ur);
        lengthParser.parse(s);
        return UnitProcessor.cssToUserSpace(ur.value, ur.unit, d, ctx);
    }

    public static float cssToUserSpace(float v, short type, short d, Context ctx) throws IllegalArgumentException {
        switch (type) {
            case 0: 
            case 3: {
                return v;
            }
            case 2: {
                return UnitProcessor.percentagesToPixels(v, d, ctx);
            }
            case 20: {
                return UnitProcessor.emsToPixels(v, d, ctx);
            }
            case 21: {
                return UnitProcessor.exsToPixels(v, d, ctx);
            }
            case 25: {
                return UnitProcessor.lhToPixels(v, d, ctx);
            }
            case 26: {
                return UnitProcessor.remToPixels(v, d, ctx);
            }
            case 28: {
                return UnitProcessor.rexToPixels(v, d, ctx);
            }
            case 27: {
                return UnitProcessor.rlhToPixels(v, d, ctx);
            }
            case 45: {
                return UnitProcessor.vwToPixels(v, d, ctx);
            }
            case 41: {
                return UnitProcessor.vhToPixels(v, d, ctx);
            }
            case 44: {
                return UnitProcessor.vminToPixels(v, d, ctx);
            }
            case 43: {
                return UnitProcessor.vmaxToPixels(v, d, ctx);
            }
            case 8: {
                return v * 3.7795277f;
            }
            case 7: {
                return v * 37.795277f;
            }
            case 4: {
                return v * 96.0f;
            }
            case 6: {
                return v / 0.75f;
            }
            case 5: {
                return v * 16.0f;
            }
            case 9: {
                return v * 0.9448819f;
            }
        }
        throw new IllegalArgumentException("Length has unknown type");
    }

    public static float userSpaceToCSS(float v, short type, short d, Context ctx) {
        switch (type) {
            case 0: 
            case 3: {
                return v;
            }
            case 8: {
                return v * 0.26458332f;
            }
            case 7: {
                return v * 0.026458334f;
            }
            case 4: {
                return v / 96.0f;
            }
            case 6: {
                return v * 0.75f;
            }
            case 5: {
                return v / 16.0f;
            }
            case 9: {
                return v * 1.0583333f;
            }
            case 20: {
                return UnitProcessor.pixelsToEms(v, d, ctx);
            }
            case 21: {
                return UnitProcessor.pixelsToExs(v, d, ctx);
            }
            case 25: {
                return UnitProcessor.pixelsToLh(v, d, ctx);
            }
            case 26: {
                return UnitProcessor.pixelsToRem(v, d, ctx);
            }
            case 28: {
                return UnitProcessor.pixelsToRex(v, d, ctx);
            }
            case 27: {
                return UnitProcessor.pixelsToRlh(v, d, ctx);
            }
            case 45: {
                return UnitProcessor.pixelsToVw(v, d, ctx);
            }
            case 41: {
                return UnitProcessor.pixelsToVh(v, d, ctx);
            }
            case 44: {
                return UnitProcessor.pixelsToVmin(v, d, ctx);
            }
            case 43: {
                return UnitProcessor.pixelsToVmax(v, d, ctx);
            }
            case 2: {
                return UnitProcessor.pixelsToPercentages(v, d, ctx);
            }
        }
        throw new IllegalArgumentException("Length has unknown type");
    }

    protected static float percentagesToPixels(float v, short d, Context ctx) {
        if (d == 2) {
            float w = ctx.getViewportWidth();
            return w * v / 100.0f;
        }
        if (d == 1) {
            float h = ctx.getViewportHeight();
            return h * v / 100.0f;
        }
        double w = ctx.getViewportWidth();
        double h = ctx.getViewportHeight();
        double vpp = Math.sqrt(w * w + h * h) / SQRT2;
        return (float)(vpp * (double)v / 100.0);
    }

    protected static float pixelsToPercentages(float v, short d, Context ctx) {
        if (d == 2) {
            float w = ctx.getViewportWidth();
            return v * 100.0f / w;
        }
        if (d == 1) {
            float h = ctx.getViewportHeight();
            return v * 100.0f / h;
        }
        double w = ctx.getViewportWidth();
        double h = ctx.getViewportHeight();
        double vpp = Math.sqrt(w * w + h * h) / SQRT2;
        return (float)((double)v * 100.0 / vpp);
    }

    protected static float pixelsToEms(float v, short d, Context ctx) {
        return v / ctx.getFontSize();
    }

    protected static float emsToPixels(float v, short d, Context ctx) {
        return v * ctx.getFontSize();
    }

    protected static float pixelsToExs(float v, short d, Context ctx) {
        float xh = ctx.getXHeight();
        return v / xh / ctx.getFontSize();
    }

    protected static float exsToPixels(float v, short d, Context ctx) {
        float xh = ctx.getXHeight();
        return v * xh * ctx.getFontSize();
    }

    protected static float pixelsToLh(float v, short d, Context ctx) {
        return v / ctx.getLineHeight();
    }

    protected static float lhToPixels(float v, short d, Context ctx) {
        return v * ctx.getLineHeight();
    }

    protected static float pixelsToRem(float v, short d, Context ctx) {
        return v / ctx.getRootFontSize();
    }

    protected static float remToPixels(float v, short d, Context ctx) {
        return v * ctx.getRootFontSize();
    }

    protected static float pixelsToRex(float v, short d, Context ctx) {
        float xh = ctx.getRootXHeight();
        return v / xh / ctx.getRootFontSize();
    }

    protected static float rexToPixels(float v, short d, Context ctx) {
        float xh = ctx.getRootXHeight();
        return v * xh * ctx.getRootFontSize();
    }

    protected static float pixelsToRlh(float v, short d, Context ctx) {
        return v / ctx.getRootLineHeight();
    }

    protected static float rlhToPixels(float v, short d, Context ctx) {
        return v * ctx.getRootLineHeight();
    }

    private static float pixelsToVw(float v, short d, Context ctx) {
        return v / ctx.getViewportWidth() * 100.0f;
    }

    private static float pixelsToVh(float v, short d, Context ctx) {
        return v / ctx.getViewportHeight() * 100.0f;
    }

    private static float pixelsToVmax(float v, short d, Context ctx) {
        float w = ctx.getViewportWidth();
        float h = ctx.getViewportHeight();
        return v / Math.max(w, h) * 100.0f;
    }

    private static float pixelsToVmin(float v, short d, Context ctx) {
        float w = ctx.getViewportWidth();
        float h = ctx.getViewportHeight();
        return v / Math.min(w, h) * 100.0f;
    }

    private static float vwToPixels(float v, short d, Context ctx) {
        return v * ctx.getViewportWidth() / 100.0f;
    }

    private static float vhToPixels(float v, short d, Context ctx) {
        return v * ctx.getViewportHeight() / 100.0f;
    }

    private static float vmaxToPixels(float v, short d, Context ctx) {
        float w = ctx.getViewportWidth();
        float h = ctx.getViewportHeight();
        return v * Math.max(w, h) / 100.0f;
    }

    private static float vminToPixels(float v, short d, Context ctx) {
        float w = ctx.getViewportWidth();
        float h = ctx.getViewportHeight();
        return v * Math.min(w, h) / 100.0f;
    }

    public static interface Context {
        public Element getElement();

        public float getResolution();

        public float getFontSize();

        public float getXHeight();

        public float getLineHeight();

        public float getRootFontSize();

        public float getRootXHeight();

        public float getRootLineHeight();

        public float getViewportWidth();

        public float getViewportHeight();
    }

    public static class UnitResolver
    extends DefaultLengthHandler {
        public float value;
        public short unit = 0;

        @Override
        public void startLength() throws ParseException {
        }

        @Override
        public void lengthValue(float v) throws ParseException {
            this.value = v;
        }

        @Override
        protected void setUnit(short unit) {
            this.unit = unit;
        }

        @Override
        public void endLength() throws ParseException {
        }
    }
}

