/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import org.gradle.api.Plugin;
import org.gradle.api.internal.plugins.PluginTarget;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.configuration.ConfigurationTargetIdentifier;
import org.gradle.model.internal.inspect.ExtractedRuleSource;
import org.gradle.model.internal.inspect.ModelRuleExtractor;
import org.gradle.model.internal.inspect.ModelRuleSourceDetector;
import org.gradle.model.internal.registry.ModelRegistry;
import org.jspecify.annotations.Nullable;

public class RuleBasedPluginTarget
implements PluginTarget {
    private final ProjectInternal target;
    private final PluginTarget imperativeTarget;
    private final ModelRuleExtractor ruleInspector;
    private final ModelRuleSourceDetector ruleDetector;

    public RuleBasedPluginTarget(ProjectInternal target, PluginTarget imperativeTarget, ModelRuleExtractor ruleInspector, ModelRuleSourceDetector ruleDetector) {
        this.target = target;
        this.ruleInspector = ruleInspector;
        this.ruleDetector = ruleDetector;
        this.imperativeTarget = imperativeTarget;
    }

    @Override
    public ConfigurationTargetIdentifier getConfigurationTargetIdentifier() {
        return this.imperativeTarget.getConfigurationTargetIdentifier();
    }

    @Override
    public void applyImperative(@Nullable String pluginId, Plugin<?> plugin) {
        this.imperativeTarget.applyImperative(pluginId, plugin);
    }

    @Override
    public void applyRules(@Nullable String pluginId, Class<?> clazz) {
        this.target.prepareForRuleBasedPlugins();
        ModelRegistry modelRegistry = this.target.getModelRegistry();
        Iterable declaredSources = this.ruleDetector.getDeclaredSources(clazz);
        for (Class ruleSource : declaredSources) {
            ExtractedRuleSource rules = this.ruleInspector.extract(ruleSource);
            for (Class dependency : rules.getRequiredPlugins()) {
                this.target.getPluginManager().apply(dependency);
            }
            modelRegistry.getRoot().applyToSelf(rules);
        }
    }

    @Override
    public void applyImperativeRulesHybrid(@Nullable String pluginId, Plugin<?> plugin, Class<?> declaringClass) {
        this.applyImperative(pluginId, plugin);
        this.applyRules(pluginId, declaringClass);
    }

    public String toString() {
        return this.target.toString();
    }
}

