/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.plugins.antlr.internal.AntlrResult;
import org.gradle.api.plugins.antlr.internal.AntlrSpec;
import org.gradle.api.plugins.antlr.internal.antlr2.GenerationPlan;
import org.gradle.api.plugins.antlr.internal.antlr2.GenerationPlanBuilder;
import org.gradle.api.plugins.antlr.internal.antlr2.MetadataExtracter;
import org.gradle.api.plugins.antlr.internal.antlr2.XRef;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.process.internal.worker.RequestHandler;
import org.gradle.util.internal.RelativePathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntlrExecuter
implements RequestHandler<AntlrSpec, AntlrResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AntlrExecuter.class);

    public AntlrResult run(AntlrSpec spec) {
        AntlrTool antlrTool = new Antlr4Tool();
        if (antlrTool.available()) {
            LOGGER.info("Processing with ANTLR 4");
            return antlrTool.process(spec);
        }
        antlrTool = new Antlr3Tool();
        if (antlrTool.available()) {
            LOGGER.info("Processing with ANTLR 3");
            return antlrTool.process(spec);
        }
        antlrTool = new Antlr2Tool();
        if (antlrTool.available()) {
            LOGGER.info("Processing with ANTLR 2");
            return antlrTool.process(spec);
        }
        throw new IllegalStateException("No Antlr implementation available");
    }

    private static void errorIfPackageArgumentSet(List<String> arguments, String antlrVersion) {
        if (arguments.contains("-package")) {
            throw new IllegalArgumentException("The -package argument is not supported by ANTLR " + antlrVersion + ".");
        }
    }

    static class Antlr4Tool
    extends AntlrTool {
        Antlr4Tool() {
        }

        @Override
        int invoke(List<String> arguments, File inputDirectory) throws ClassNotFoundException {
            Object backedObject = Antlr4Tool.loadTool("org.antlr.v4.Tool", Antlr4Tool.toArray(arguments));
            if (inputDirectory != null) {
                Antlr4Tool.setField(backedObject, "inputDirectory", inputDirectory);
            }
            JavaMethod.of((Object)backedObject, Void.class, (String)"processGrammarsOnCommandLine", (Class[])new Class[0]).invoke(backedObject, new Object[0]);
            return (Integer)JavaMethod.of((Object)backedObject, Integer.class, (String)"getNumErrors", (Class[])new Class[0]).invoke(backedObject, new Object[0]);
        }

        private static void setField(Object object, String fieldName, File value) {
            try {
                Field field = object.getClass().getField(fieldName);
                field.set(object, value);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        @Override
        public boolean available() {
            try {
                Antlr4Tool.loadTool("org.antlr.v4.Tool", null);
            }
            catch (ClassNotFoundException cnf) {
                return false;
            }
            return true;
        }
    }

    private static abstract class AntlrTool {
        private AntlrTool() {
        }

        static Object loadTool(String className, String[] args) throws ClassNotFoundException {
            try {
                Class<?> toolClass = Class.forName(className);
                if (args == null) {
                    return JavaReflectionUtil.newInstance(toolClass);
                }
                Constructor<?> constructor = toolClass.getConstructor(String[].class);
                return constructor.newInstance(new Object[]{args});
            }
            catch (ClassNotFoundException cnf) {
                throw cnf;
            }
            catch (InvocationTargetException e) {
                throw new GradleException("Failed to load ANTLR", e.getCause());
            }
            catch (Exception e) {
                throw new GradleException("Failed to load ANTLR", (Throwable)e);
            }
        }

        public final AntlrResult process(AntlrSpec spec) {
            try {
                return this.doProcess(spec);
            }
            catch (ClassNotFoundException e) {
                throw new GradleException("Cannot process antlr sources", (Throwable)e);
            }
        }

        public AntlrResult doProcess(AntlrSpec spec) throws ClassNotFoundException {
            int numErrors = 0;
            if (spec.getInputDirectories().size() == 0) {
                numErrors += this.invoke(spec.asArgumentsWithFiles(), null);
            } else {
                boolean onWindows = OperatingSystem.current().isWindows();
                for (File inputDirectory : spec.getInputDirectories()) {
                    List<String> arguments = spec.getArguments();
                    arguments.add("-o");
                    arguments.add(spec.getOutputDirectory().getAbsolutePath());
                    for (File grammarFile : spec.getGrammarFiles()) {
                        String relativeGrammarFilePath = RelativePathUtil.relativePath((File)inputDirectory, (File)grammarFile);
                        if (onWindows) {
                            relativeGrammarFilePath = relativeGrammarFilePath.replace('/', File.separatorChar);
                        }
                        arguments.add(relativeGrammarFilePath);
                    }
                    numErrors += this.invoke(arguments, inputDirectory);
                }
            }
            return new AntlrResult(numErrors);
        }

        abstract int invoke(List<String> var1, File var2) throws ClassNotFoundException;

        public abstract boolean available();

        protected static String[] toArray(List<String> strings) {
            return strings.toArray(new String[0]);
        }
    }

    private static class Antlr3Tool
    extends AntlrTool {
        private Antlr3Tool() {
        }

        @Override
        int invoke(List<String> arguments, File inputDirectory) throws ClassNotFoundException {
            AntlrExecuter.errorIfPackageArgumentSet(arguments, "3");
            Object backedObject = Antlr3Tool.loadTool("org.antlr.Tool", null);
            String[] argArray = arguments.toArray(new String[0]);
            if (inputDirectory != null) {
                JavaMethod.of((Object)backedObject, Void.class, (String)"setInputDirectory", (Class[])new Class[]{String.class}).invoke(backedObject, new Object[]{inputDirectory.getAbsolutePath()});
                JavaMethod.of((Object)backedObject, Void.class, (String)"setForceRelativeOutput", (Class[])new Class[]{Boolean.TYPE}).invoke(backedObject, new Object[]{true});
            }
            JavaMethod.of((Object)backedObject, Void.class, (String)"processArgs", (Class[])new Class[]{String[].class}).invoke(backedObject, new Object[]{argArray});
            JavaMethod.of((Object)backedObject, Void.class, (String)"process", (Class[])new Class[0]).invoke(backedObject, new Object[0]);
            return (Integer)JavaMethod.of((Object)backedObject, Integer.class, (String)"getNumErrors", (Class[])new Class[0]).invoke(backedObject, new Object[0]);
        }

        @Override
        public boolean available() {
            try {
                Antlr3Tool.loadTool("org.antlr.Tool", null);
            }
            catch (ClassNotFoundException cnf) {
                return false;
            }
            return true;
        }
    }

    private static class Antlr2Tool
    extends AntlrTool {
        private Antlr2Tool() {
        }

        @Override
        public AntlrResult doProcess(AntlrSpec spec) throws ClassNotFoundException {
            XRef xref = new MetadataExtracter().extractMetadata(spec.getGrammarFiles());
            List<GenerationPlan> generationPlans = new GenerationPlanBuilder(spec.getOutputDirectory()).buildGenerationPlans(xref);
            for (GenerationPlan generationPlan : generationPlans) {
                ArrayList generationPlanArguments = Lists.newArrayList(spec.getArguments());
                generationPlanArguments.add("-o");
                generationPlanArguments.add(generationPlan.getGenerationDirectory().getAbsolutePath());
                generationPlanArguments.add(generationPlan.getSource().getAbsolutePath());
                try {
                    this.invoke(generationPlanArguments, null);
                }
                catch (RuntimeException e) {
                    if (e.getMessage().equals("ANTLR Panic: Exiting due to errors.")) {
                        return new AntlrResult(-1, e);
                    }
                    throw e;
                }
            }
            return new AntlrResult(0);
        }

        @Override
        int invoke(List<String> arguments, File inputDirectory) throws ClassNotFoundException {
            AntlrExecuter.errorIfPackageArgumentSet(arguments, "2");
            Object backedAntlrTool = Antlr2Tool.loadTool("antlr.Tool", null);
            JavaMethod.of((Object)backedAntlrTool, Integer.class, (String)"doEverything", (Class[])new Class[]{String[].class}).invoke(backedAntlrTool, new Object[]{Antlr2Tool.toArray(arguments)});
            return 0;
        }

        @Override
        public boolean available() {
            try {
                Antlr2Tool.loadTool("antlr.Tool", null);
            }
            catch (ClassNotFoundException cnf) {
                return false;
            }
            return true;
        }
    }
}

