/*
 * Decompiled with CFR 0.152.
 */
package io.github.dan2097.jnarinchi;

import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import io.github.dan2097.jnarinchi.FileTextOutput;
import io.github.dan2097.jnarinchi.ReactionComponentRole;
import io.github.dan2097.jnarinchi.ReactionDirection;
import io.github.dan2097.jnarinchi.ReactionFileFormat;
import io.github.dan2097.jnarinchi.RinchiDecompositionOutput;
import io.github.dan2097.jnarinchi.RinchiFlag;
import io.github.dan2097.jnarinchi.RinchiInput;
import io.github.dan2097.jnarinchi.RinchiInputFromRinchiOutput;
import io.github.dan2097.jnarinchi.RinchiKeyOutput;
import io.github.dan2097.jnarinchi.RinchiKeyType;
import io.github.dan2097.jnarinchi.RinchiLibrary;
import io.github.dan2097.jnarinchi.RinchiOptions;
import io.github.dan2097.jnarinchi.RinchiOutput;
import io.github.dan2097.jnarinchi.Status;
import io.github.dan2097.jnarinchi.cheminfo.MdlReactionReader;
import io.github.dan2097.jnarinchi.cheminfo.MdlReactionReaderException;
import io.github.dan2097.jnarinchi.cheminfo.MdlReactionWriter;
import java.io.InputStream;
import java.util.Properties;

public class JnaRinchi {
    private static final Object lock = new Object();
    private static final String PROPERTY_KEY_RINCHI_VERSION = "rinchi_version";
    private static final String PROPERTY_KEY_JNARINCHI_VERSION = "jnarinchi_version";
    private static final String PROPERTY_FILE_NAME = "jnarinchi_build.props";
    private static final String platform;
    private static final Throwable libraryLoadingError;
    private static final String RINCHI_DECOMPOSE_LINE_SEPARATOR = "\n";
    private static final String RINCHI_DECOMPOSE_DIRECTION_SHORT_DESIGNATION = "D";
    private static final int ERROR_CODE_DECOMPOSE_FROM_LINES = -1;

    public static RinchiOutput toRinchi(RinchiInput rinchiInput) {
        return JnaRinchi.toRinchi(rinchiInput, RinchiOptions.DEFAULT_OPTIONS);
    }

    public static RinchiOutput toRinchi(RinchiInput rinchiInput, RinchiOptions options) {
        MdlReactionWriter mdlWriter = new MdlReactionWriter(ReactionFileFormat.RD);
        String fileText = mdlWriter.rinchiInputToFileText(rinchiInput);
        return JnaRinchi.fileTextToRinchi(fileText, options);
    }

    public static RinchiInputFromRinchiOutput getRinchiInputFromRinchi(String rinchi, String auxInfo) {
        return JnaRinchi.getRinchiInputFromRinchi(rinchi, auxInfo, false);
    }

    public static RinchiInputFromRinchiOutput getRinchiInputFromRinchi(String rinchi, String auxInfo, boolean guessTetrahedralChiralityFromBondsInfo) {
        FileTextOutput ftOut = JnaRinchi.rinchiToFileText(rinchi, auxInfo, ReactionFileFormat.RD);
        if (ftOut.getStatus() != Status.SUCCESS) {
            return new RinchiInputFromRinchiOutput(null, Status.ERROR, -1, ftOut.getErrorMessage());
        }
        MdlReactionReader mdlReader = new MdlReactionReader(ReactionFileFormat.RD, guessTetrahedralChiralityFromBondsInfo);
        try {
            RinchiInput rInp = mdlReader.fileTextToRinchiInput(ftOut.getReactionFileText());
            return new RinchiInputFromRinchiOutput(rInp, Status.SUCCESS, 0, "");
        }
        catch (MdlReactionReaderException exception) {
            return new RinchiInputFromRinchiOutput(null, Status.ERROR, -1, exception.getAllErrors());
        }
    }

    public static RinchiOutput fileTextToRinchi(String reactionTextFile) {
        return JnaRinchi.fileTextToRinchi(reactionTextFile, RinchiOptions.DEFAULT_OPTIONS, ReactionFileFormat.AUTO);
    }

    public static RinchiOutput fileTextToRinchi(String reactionTextFile, RinchiOptions options) {
        return JnaRinchi.fileTextToRinchi(reactionTextFile, options, ReactionFileFormat.AUTO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RinchiOutput fileTextToRinchi(String reactionFileText, RinchiOptions options, ReactionFileFormat fileFormat) {
        Object object = lock;
        synchronized (object) {
            JnaRinchi.checkLibrary();
            JnaRinchi.requireNonNull(reactionFileText, "reactionFileText");
            JnaRinchi.requireNonNull(options, "options");
            JnaRinchi.requireNonNull((Object)fileFormat, "fileFormat");
            PointerByReference out_rinchi_string_p = new PointerByReference();
            PointerByReference out_rinchi_auxinfo_p = new PointerByReference();
            boolean forceEq = options.getFlags().contains((Object)RinchiFlag.ForceEquilibrium);
            int errCode = RinchiLibrary.rinchilib_rinchi_from_file_text(fileFormat.toString(), reactionFileText, forceEq, out_rinchi_string_p, out_rinchi_auxinfo_p);
            if (errCode != 0) {
                String errMsg = RinchiLibrary.rinchilib_latest_err_msg();
                return new RinchiOutput("", "", Status.ERROR, errCode, errMsg);
            }
            Pointer p = out_rinchi_string_p.getValue();
            String rinchi = p.getString(0L);
            p = out_rinchi_auxinfo_p.getValue();
            String auxInfo = p.getString(0L);
            return new RinchiOutput(rinchi, auxInfo, Status.SUCCESS, 0, "");
        }
    }

    public static RinchiKeyOutput fileTextToRinchiKey(String reactionTextFile, RinchiKeyType keyType) {
        return JnaRinchi.fileTextToRinchiKey(reactionTextFile, keyType, RinchiOptions.DEFAULT_OPTIONS, ReactionFileFormat.AUTO);
    }

    public static RinchiKeyOutput fileTextToRinchiKey(String reactionFileText, RinchiKeyType keyType, RinchiOptions options) {
        return JnaRinchi.fileTextToRinchiKey(reactionFileText, keyType, options, ReactionFileFormat.AUTO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RinchiKeyOutput fileTextToRinchiKey(String reactionFileText, RinchiKeyType keyType, RinchiOptions options, ReactionFileFormat fileFormat) {
        Object object = lock;
        synchronized (object) {
            JnaRinchi.checkLibrary();
            JnaRinchi.requireNonNull(reactionFileText, "reactionFileText");
            JnaRinchi.requireNonNull((Object)keyType, "keyType");
            JnaRinchi.requireNonNull(options, "options");
            JnaRinchi.requireNonNull((Object)fileFormat, "fileFormat");
            PointerByReference out_rinchi_key = new PointerByReference();
            boolean forceEq = options.getFlags().contains((Object)RinchiFlag.ForceEquilibrium);
            int errCode = RinchiLibrary.rinchilib_rinchikey_from_file_text(fileFormat.toString(), reactionFileText, keyType.getShortDesignation(), forceEq, out_rinchi_key);
            if (errCode != 0) {
                String err = RinchiLibrary.rinchilib_latest_err_msg();
                return new RinchiKeyOutput("", keyType, Status.ERROR, errCode, err);
            }
            Pointer p = out_rinchi_key.getValue();
            String rinchi_key = p.getString(0L);
            return new RinchiKeyOutput(rinchi_key, keyType, Status.SUCCESS, 0, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileTextOutput rinchiToFileText(String rinchi, String auxInfo, ReactionFileFormat fileFormat) {
        Object object = lock;
        synchronized (object) {
            JnaRinchi.checkLibrary();
            JnaRinchi.requireNonNull(rinchi, "rinchi");
            JnaRinchi.requireNonNull(auxInfo, "auxInfo");
            JnaRinchi.requireNonNull((Object)fileFormat, "fileFormat");
            PointerByReference out_file_text_p = new PointerByReference();
            int errCode = RinchiLibrary.rinchilib_file_text_from_rinchi(rinchi, auxInfo, fileFormat.toString(), out_file_text_p);
            if (errCode != 0) {
                String err = RinchiLibrary.rinchilib_latest_err_msg();
                return new FileTextOutput("", fileFormat, Status.ERROR, errCode, err);
            }
            Pointer p = out_file_text_p.getValue();
            String reactFileText = p.getString(0L);
            return new FileTextOutput(reactFileText, fileFormat, Status.SUCCESS, 0, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RinchiKeyOutput rinchiToRinchiKey(RinchiKeyType keyType, String rinchi) {
        Object object = lock;
        synchronized (object) {
            JnaRinchi.checkLibrary();
            JnaRinchi.requireNonNull((Object)keyType, "keyType");
            JnaRinchi.requireNonNull(rinchi, "rinchi");
            PointerByReference out_rinchi_key = new PointerByReference();
            int errCode = RinchiLibrary.rinchilib_rinchikey_from_rinchi(rinchi, keyType.getShortDesignation(), out_rinchi_key);
            if (errCode != 0) {
                String err = RinchiLibrary.rinchilib_latest_err_msg();
                return new RinchiKeyOutput("", keyType, Status.ERROR, errCode, err);
            }
            Pointer p = out_rinchi_key.getValue();
            String rinchi_key = p.getString(0L);
            return new RinchiKeyOutput(rinchi_key, keyType, Status.SUCCESS, 0, "");
        }
    }

    public static RinchiDecompositionOutput decomposeRinchi(String rinchi) {
        return JnaRinchi.decomposeRinchi(rinchi, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RinchiDecompositionOutput decomposeRinchi(String rinchi, String auxInfo) {
        Object object = lock;
        synchronized (object) {
            JnaRinchi.checkLibrary();
            JnaRinchi.requireNonNull(rinchi, "rinchi");
            JnaRinchi.requireNonNull(auxInfo, "auxInfo");
            PointerByReference out_inchis_text_p = new PointerByReference();
            int errCode = RinchiLibrary.rinchilib_inchis_from_rinchi(rinchi, auxInfo, out_inchis_text_p);
            if (errCode != 0) {
                String err = RinchiLibrary.rinchilib_latest_err_msg();
                return new RinchiDecompositionOutput(ReactionDirection.FORWARD, null, null, null, Status.ERROR, errCode, err);
            }
            Pointer p = out_inchis_text_p.getValue();
            String s = p.getString(0L);
            return JnaRinchi.parseNativeOutInchisText(s);
        }
    }

    public static String getRinchiLibraryVersion() {
        return JnaRinchi.getVersion(PROPERTY_KEY_RINCHI_VERSION);
    }

    public static String getJnaRinchiVersion() {
        return JnaRinchi.getVersion(PROPERTY_KEY_JNARINCHI_VERSION);
    }

    private static String getVersion(String propertyKey) {
        String string;
        block8: {
            InputStream is = JnaRinchi.class.getResourceAsStream(PROPERTY_FILE_NAME);
            try {
                Properties props = new Properties();
                props.load(is);
                string = props.getProperty(propertyKey);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            is.close();
        }
        return string;
    }

    private static RinchiDecompositionOutput parseNativeOutInchisText(String outText) {
        String err;
        String[] lines = outText.split(RINCHI_DECOMPOSE_LINE_SEPARATOR);
        StringBuilder errorBuffer = new StringBuilder();
        int nLines = lines.length;
        int nComponents = -1;
        if (nLines < 2 || nLines % 2 != 0) {
            errorBuffer.append("Incorrect number of lines. Expected even number\n");
        } else {
            nComponents = (nLines - 2) / 2;
        }
        String[] inchis = new String[nComponents];
        String[] auxInfos = new String[nComponents];
        ReactionComponentRole[] roles = new ReactionComponentRole[nComponents];
        ReactionDirection direction = null;
        if (nLines > 0) {
            if (lines[0].startsWith("D:") || lines[0].length() < 3) {
                String dirStr = lines[0].substring(2);
                direction = ReactionDirection.getDirectionFromShortDesignation(dirStr);
                if (direction == null) {
                    errorBuffer.append("Incorrect direction definition in the first line: ").append(lines[0]).append(RINCHI_DECOMPOSE_LINE_SEPARATOR);
                }
            } else {
                errorBuffer.append("Incorrect first line: has to start with ").append(RINCHI_DECOMPOSE_DIRECTION_SHORT_DESIGNATION).append(":").append(RINCHI_DECOMPOSE_LINE_SEPARATOR);
            }
        } else {
            errorBuffer.append("No lines available!\n");
        }
        if (nComponents > 0) {
            for (int i = 0; i < nComponents; ++i) {
                String rinchiLine = lines[2 + 2 * i];
                String auxInfoLine = lines[2 + 2 * i + 1];
                boolean flagRinchiLineOK = false;
                ReactionComponentRole role = null;
                if (rinchiLine.length() < 2) {
                    errorBuffer.append("Incorrect RInChI component line: ").append(rinchiLine).append(RINCHI_DECOMPOSE_LINE_SEPARATOR);
                } else {
                    role = ReactionComponentRole.getRoleFromShortDesignation(rinchiLine.substring(0, 1));
                    if (role == null) {
                        errorBuffer.append("Incorrect RInChI component line: incorrect role: ").append(rinchiLine).append(RINCHI_DECOMPOSE_LINE_SEPARATOR);
                    } else {
                        inchis[i] = rinchiLine.substring(2);
                        flagRinchiLineOK = true;
                    }
                }
                if (!flagRinchiLineOK) continue;
                if (auxInfoLine.length() < 2) {
                    errorBuffer.append("Incorrect AuxInfo component line: ").append(auxInfoLine).append(RINCHI_DECOMPOSE_LINE_SEPARATOR);
                    continue;
                }
                ReactionComponentRole role2 = ReactionComponentRole.getRoleFromShortDesignation(auxInfoLine.substring(0, 1));
                if (role2 == null || role != role2) {
                    errorBuffer.append("Incorrect AuxInfo component line: incorrect role: ").append(auxInfoLine).append(RINCHI_DECOMPOSE_LINE_SEPARATOR);
                    continue;
                }
                auxInfos[i] = auxInfoLine.substring(2);
                roles[i] = role;
            }
        }
        if ((err = errorBuffer.toString()).isEmpty()) {
            try {
                return new RinchiDecompositionOutput(direction, inchis, auxInfos, roles, Status.SUCCESS, 0, "");
            }
            catch (IllegalArgumentException exception) {
                return new RinchiDecompositionOutput(direction, null, null, null, Status.ERROR, -1, exception.getMessage());
            }
        }
        return new RinchiDecompositionOutput(direction, null, null, null, Status.ERROR, -1, err);
    }

    private static void requireNonNull(Object object, String argumentName) {
        if (object == null) {
            throw new IllegalArgumentException("The argument '" + argumentName + "' must not be null.");
        }
    }

    static void checkLibrary() {
        if (libraryLoadingError != null) {
            throw new RuntimeException("Error loading RInChI native code. Please check that the binaries for your platform (" + platform + ") have been included on the classpath.", libraryLoadingError);
        }
    }

    static {
        Throwable t = null;
        String p = null;
        try {
            p = Platform.RESOURCE_PREFIX;
            RinchiLibrary.JNA_NATIVE_LIB.getName();
        }
        catch (Throwable e) {
            t = e;
        }
        platform = p;
        libraryLoadingError = t;
    }
}

