/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.kafka.clients.consumer.AcknowledgeType;
import org.apache.kafka.common.MessageFormatter;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.consumer.DefaultMessageFormatter;

public final class ConsoleShareConsumerOptions
extends CommandDefaultOptions {
    private final OptionSpec<String> messageFormatterOpt;
    private final OptionSpec<String> messageFormatterConfigOpt;
    private final OptionSpec<String> messageFormatterArgOpt;
    private final OptionSpec<String> keyDeserializerOpt;
    private final OptionSpec<String> valueDeserializerOpt;
    private final OptionSpec<Integer> maxMessagesOpt;
    private final OptionSpec<?> rejectMessageOnErrorOpt;
    private final OptionSpec<?> rejectOpt;
    private final OptionSpec<?> releaseOpt;
    private final OptionSpec<String> topicOpt;
    private final OptionSpec<Integer> timeoutMsOpt;
    private final OptionSpec<String> bootstrapServerOpt;
    private final OptionSpec<String> groupIdOpt;
    private final Properties consumerProps;
    private final MessageFormatter formatter;
    private final OptionSpec<?> enableSystestEventsLoggingOpt;

    public ConsoleShareConsumerOptions(String[] args) throws IOException {
        super(args);
        this.topicOpt = this.parser.accepts("topic", "The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec consumerPropertyOpt = this.parser.accepts("consumer-property", "A mechanism to pass user-defined properties in the form key=value to the consumer.").withRequiredArg().describedAs("consumer_prop").ofType(String.class);
        ArgumentAcceptingOptionSpec consumerConfigOpt = this.parser.accepts("consumer-config", "Consumer config properties file. Note that " + String.valueOf(consumerPropertyOpt) + " takes precedence over this config.").withRequiredArg().describedAs("config file").ofType(String.class);
        this.messageFormatterOpt = this.parser.accepts("formatter", "The name of a class to use for formatting Kafka messages for display.").withRequiredArg().describedAs("class").ofType(String.class).defaultsTo((Object)DefaultMessageFormatter.class.getName(), (Object[])new String[0]);
        this.messageFormatterArgOpt = this.parser.accepts("property", "The properties to initialize the message formatter. Default properties include: \n print.timestamp=true|false\n print.key=true|false\n print.offset=true|false\n print.delivery=true|false\n print.epoch=true|false\n print.partition=true|false\n print.headers=true|false\n print.value=true|false\n key.separator=<key.separator>\n line.separator=<line.separator>\n headers.separator=<line.separator>\n null.literal=<null.literal>\n key.deserializer=<key.deserializer>\n value.deserializer=<value.deserializer>\n header.deserializer=<header.deserializer>\n\nUsers can also pass in customized properties for their formatter; more specifically, users can pass in properties keyed with 'key.deserializer.', 'value.deserializer.' and 'headers.deserializer.' prefixes to configure their deserializers.").withRequiredArg().describedAs("prop").ofType(String.class);
        this.messageFormatterConfigOpt = this.parser.accepts("formatter-config", "Config properties file to initialize the message formatter. Note that " + String.valueOf(this.messageFormatterArgOpt) + " takes precedence over this config.").withRequiredArg().describedAs("config file").ofType(String.class);
        this.maxMessagesOpt = this.parser.accepts("max-messages", "The maximum number of messages to consume before exiting. If not set, consumption is continual.").withRequiredArg().describedAs("num_messages").ofType(Integer.class);
        this.timeoutMsOpt = this.parser.accepts("timeout-ms", "If specified, exit if no message is available for consumption for the specified interval.").withRequiredArg().describedAs("timeout_ms").ofType(Integer.class);
        this.rejectOpt = this.parser.accepts("reject", "If specified, messages are rejected as they are consumed.");
        this.releaseOpt = this.parser.accepts("release", "If specified, messages are released as they are consumed.");
        this.rejectMessageOnErrorOpt = this.parser.accepts("reject-message-on-error", "If there is an error when processing a message, reject it instead of halting.");
        this.bootstrapServerOpt = this.parser.accepts("bootstrap-server", "REQUIRED: The server(s) to connect to.").withRequiredArg().describedAs("server to connect to").ofType(String.class);
        this.keyDeserializerOpt = this.parser.accepts("key-deserializer", "The name of the class to use for deserializing keys.").withRequiredArg().describedAs("deserializer for key").ofType(String.class);
        this.valueDeserializerOpt = this.parser.accepts("value-deserializer", "The name of the class to use for deserializing values.").withRequiredArg().describedAs("deserializer for values").ofType(String.class);
        this.groupIdOpt = this.parser.accepts("group", "The share group id of the consumer.").withRequiredArg().describedAs("share group id").ofType(String.class);
        this.enableSystestEventsLoggingOpt = this.parser.accepts("enable-systest-events", "Log lifecycle events of the share consumer in addition to logging consumed messages. (This is specific for system tests.)");
        try {
            this.options = this.parser.parse(args);
        }
        catch (OptionException oe) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)oe.getMessage());
        }
        CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)this, (String)"This tool helps to read data from Kafka topics using share groups and outputs it to standard output.");
        this.checkRequiredArgs();
        if (this.options.has(this.rejectOpt) && this.options.has(this.releaseOpt)) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"At most one of --reject and --release may be specified.");
        }
        Properties consumerPropsFromFile = this.options.has((OptionSpec)consumerConfigOpt) ? Utils.loadProps((String)((String)this.options.valueOf((OptionSpec)consumerConfigOpt))) : new Properties();
        Properties extraConsumerProps = CommandLineUtils.parseKeyValueArgs((List)this.options.valuesOf((OptionSpec)consumerPropertyOpt));
        Set<String> groupIdsProvided = this.checkShareGroup(consumerPropsFromFile, extraConsumerProps);
        this.consumerProps = this.buildConsumerProps(consumerPropsFromFile, extraConsumerProps, groupIdsProvided);
        this.formatter = this.buildFormatter();
    }

    private void checkRequiredArgs() {
        if (!this.options.has(this.topicOpt)) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"--topic is a required argument");
        }
        CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.bootstrapServerOpt});
    }

    private Set<String> checkShareGroup(Properties consumerPropsFromFile, Properties extraConsumerProps) {
        HashSet<String> groupIdsProvided = new HashSet<String>();
        if (this.options.has(this.groupIdOpt)) {
            groupIdsProvided.add((String)this.options.valueOf(this.groupIdOpt));
        }
        if (consumerPropsFromFile.containsKey("group.id")) {
            groupIdsProvided.add((String)consumerPropsFromFile.get("group.id"));
        }
        if (extraConsumerProps.containsKey("group.id")) {
            groupIdsProvided.add(extraConsumerProps.getProperty("group.id"));
        }
        if (groupIdsProvided.isEmpty()) {
            groupIdsProvided.add("console-share-consumer");
        } else if (groupIdsProvided.size() > 1) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("The group ids provided in different places (directly using '--group', via '--consumer-property', or via '--consumer-config') do not match. Detected group ids: " + groupIdsProvided.stream().map(group -> "'" + group + "'").collect(Collectors.joining(", "))));
        }
        return groupIdsProvided;
    }

    private Properties buildConsumerProps(Properties consumerPropsFromFile, Properties extraConsumerProps, Set<String> groupIdsProvided) {
        Properties consumerProps = new Properties();
        consumerProps.putAll((Map<?, ?>)consumerPropsFromFile);
        consumerProps.putAll((Map<?, ?>)extraConsumerProps);
        consumerProps.put("bootstrap.servers", this.bootstrapServer());
        if (consumerProps.getProperty("client.id") == null) {
            consumerProps.put("client.id", "console-share-consumer");
        }
        consumerProps.put("group.id", groupIdsProvided.iterator().next());
        return consumerProps;
    }

    private MessageFormatter buildFormatter() {
        MessageFormatter formatter = null;
        try {
            Class<?> messageFormatterClass = Class.forName((String)this.options.valueOf(this.messageFormatterOpt));
            formatter = (MessageFormatter)messageFormatterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Properties formatterArgs = this.formatterArgs();
            HashMap<String, String> formatterConfigs = new HashMap<String, String>();
            for (String name : formatterArgs.stringPropertyNames()) {
                formatterConfigs.put(name, formatterArgs.getProperty(name));
            }
            formatter.configure(formatterConfigs);
        }
        catch (Exception e) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)e.getMessage());
        }
        return formatter;
    }

    Properties consumerProps() {
        return this.consumerProps;
    }

    boolean rejectMessageOnError() {
        return this.options.has(this.rejectMessageOnErrorOpt);
    }

    AcknowledgeType acknowledgeType() {
        if (this.options.has(this.rejectOpt)) {
            return AcknowledgeType.REJECT;
        }
        if (this.options.has(this.releaseOpt)) {
            return AcknowledgeType.RELEASE;
        }
        return AcknowledgeType.ACCEPT;
    }

    String topicArg() {
        return (String)this.options.valueOf(this.topicOpt);
    }

    int maxMessages() {
        return this.options.has(this.maxMessagesOpt) ? (Integer)this.options.valueOf(this.maxMessagesOpt) : -1;
    }

    int timeoutMs() {
        return this.options.has(this.timeoutMsOpt) ? (Integer)this.options.valueOf(this.timeoutMsOpt) : -1;
    }

    String bootstrapServer() {
        return (String)this.options.valueOf(this.bootstrapServerOpt);
    }

    Properties formatterArgs() throws IOException {
        String valueDeserializer;
        Properties formatterArgs = this.options.has(this.messageFormatterConfigOpt) ? Utils.loadProps((String)((String)this.options.valueOf(this.messageFormatterConfigOpt))) : new Properties();
        String keyDeserializer = (String)this.options.valueOf(this.keyDeserializerOpt);
        if (keyDeserializer != null && !keyDeserializer.isEmpty()) {
            formatterArgs.setProperty("key.deserializer", keyDeserializer);
        }
        if ((valueDeserializer = (String)this.options.valueOf(this.valueDeserializerOpt)) != null && !valueDeserializer.isEmpty()) {
            formatterArgs.setProperty("value.deserializer", valueDeserializer);
        }
        formatterArgs.putAll((Map<?, ?>)CommandLineUtils.parseKeyValueArgs((List)this.options.valuesOf(this.messageFormatterArgOpt)));
        return formatterArgs;
    }

    MessageFormatter formatter() {
        return this.formatter;
    }

    boolean enableSystestEventsLogging() {
        return this.options.has(this.enableSystestEventsLoggingOpt);
    }
}

