/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.diagnostics.LibrarySpecialCompatibilityChecker;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/checkers/WasmLibrarySpecialCompatibilityChecker;", "Lorg/jetbrains/kotlin/backend/common/diagnostics/LibrarySpecialCompatibilityChecker;", "<init>", "()V", "shouldCheckLibrary", "", "library", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "getMessageToReport", "", "compilerVersion", "Lorg/jetbrains/kotlin/backend/common/diagnostics/LibrarySpecialCompatibilityChecker$Version;", "libraryVersion", "ir.serialization.js"})
@SourceDebugExtension(value={"SMAP\nWasmLibrarySpecialCompatibilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmLibrarySpecialCompatibilityChecker.kt\norg/jetbrains/kotlin/ir/backend/js/checkers/WasmLibrarySpecialCompatibilityChecker\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,30:1\n234#2:31\n*S KotlinDebug\n*F\n+ 1 WasmLibrarySpecialCompatibilityChecker.kt\norg/jetbrains/kotlin/ir/backend/js/checkers/WasmLibrarySpecialCompatibilityChecker\n*L\n23#1:31\n*E\n"})
public final class WasmLibrarySpecialCompatibilityChecker
extends LibrarySpecialCompatibilityChecker {
    @NotNull
    public static final WasmLibrarySpecialCompatibilityChecker INSTANCE = new WasmLibrarySpecialCompatibilityChecker();

    private WasmLibrarySpecialCompatibilityChecker() {
    }

    @Override
    protected boolean shouldCheckLibrary(@NotNull KotlinLibrary library) {
        Intrinsics.checkNotNullParameter(library, "library");
        return KotlinLibraryKt.isWasmStdlib(library) || KotlinLibraryKt.isWasmKotlinTest(library);
    }

    @Override
    @Nullable
    protected String getMessageToReport(@NotNull LibrarySpecialCompatibilityChecker.Version compilerVersion2, @NotNull LibrarySpecialCompatibilityChecker.Version libraryVersion, @NotNull KotlinLibrary library) {
        String string;
        Intrinsics.checkNotNullParameter(compilerVersion2, "compilerVersion");
        Intrinsics.checkNotNullParameter(libraryVersion, "libraryVersion");
        Intrinsics.checkNotNullParameter(library, "library");
        String libraryDisplayName = KotlinLibraryKt.isWasmStdlib(library) ? "standard" : (KotlinLibraryKt.isWasmKotlinTest(library) ? "kotlin-test" : null);
        boolean condition$iv = Intrinsics.areEqual(libraryVersion, compilerVersion2);
        boolean $i$f$runUnless = false;
        if (condition$iv) {
            string = null;
        } else {
            boolean bl = false;
            string = "The version of the Kotlin/Wasm " + libraryDisplayName + " library (" + libraryVersion + ") differs from the version of the compiler (" + compilerVersion2 + ").\nPlease, make sure that the " + libraryDisplayName + " library has the same version as the compiler. Adjust your project's settings if necessary.";
        }
        return string;
    }
}

