/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated plain C Header file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

#ifndef __LIB3MF_HEADER
#define __LIB3MF_HEADER

#ifdef __LIB3MF_EXPORTS
#ifdef _WIN32
#define LIB3MF_DECLSPEC __declspec (dllexport)
#else // _WIN32
#define LIB3MF_DECLSPEC __attribute__((visibility("default")))
#endif // _WIN32
#else // __LIB3MF_EXPORTS
#define LIB3MF_DECLSPEC
#endif // __LIB3MF_EXPORTS

#include "lib3mf_types.h"


#ifdef __cplusplus
extern "C" {
#endif

/*************************************************************************************************************************
 Class definition for Base
**************************************************************************************************************************/

/**
* Get Class Type Id
*
* @param[in] pBase - Base instance.
* @param[out] pClassTypeId - Class type as a 64 bits integer
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_base_classtypeid(Lib3MF_Base pBase, Lib3MF_uint64 * pClassTypeId);

/*************************************************************************************************************************
 Class definition for Writer
**************************************************************************************************************************/

/**
* Writes out the model as file. The file type is specified by the Model Writer class.
*
* @param[in] pWriter - Writer instance.
* @param[in] pFilename - Filename to write into
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_writer_writetofile(Lib3MF_Writer pWriter, const char * pFilename);

/**
* Retrieves the size of the full 3MF file stream.
*
* @param[in] pWriter - Writer instance.
* @param[out] pStreamSize - the stream size
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_writer_getstreamsize(Lib3MF_Writer pWriter, Lib3MF_uint64 * pStreamSize);

/**
* Writes out the 3MF file into a memory buffer
*
* @param[in] pWriter - Writer instance.
* @param[in] nBufferBufferSize - Number of elements in buffer
* @param[out] pBufferNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pBufferBuffer - uint8  buffer of buffer to write into
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_writer_writetobuffer(Lib3MF_Writer pWriter, const Lib3MF_uint64 nBufferBufferSize, Lib3MF_uint64* pBufferNeededCount, Lib3MF_uint8 * pBufferBuffer);

/**
* Writes out the model and passes the data to a provided callback function. The file type is specified by the Model Writer class.
*
* @param[in] pWriter - Writer instance.
* @param[in] pTheWriteCallback - Callback to call for writing a data chunk
* @param[in] pTheSeekCallback - Callback to call for seeking in the stream
* @param[in] pUserData - Userdata that is passed to the callback function
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_writer_writetocallback(Lib3MF_Writer pWriter, Lib3MFWriteCallback pTheWriteCallback, Lib3MFSeekCallback pTheSeekCallback, Lib3MF_pvoid pUserData);

/**
* Set the progress callback for calls to this writer
*
* @param[in] pWriter - Writer instance.
* @param[in] pProgressCallback - pointer to the callback function.
* @param[in] pUserData - pointer to arbitrary user data that is passed without modification to the callback.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_writer_setprogresscallback(Lib3MF_Writer pWriter, Lib3MFProgressCallback pProgressCallback, Lib3MF_pvoid pUserData);

/**
* Returns the number of digits after the decimal point to be written in each vertex coordinate-value.
*
* @param[in] pWriter - Writer instance.
* @param[out] pDecimalPrecision - The number of digits to be written in each vertex coordinate-value after the decimal point.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_writer_getdecimalprecision(Lib3MF_Writer pWriter, Lib3MF_uint32 * pDecimalPrecision);

/**
* Sets the number of digits after the decimal point to be written in each vertex coordinate-value.
*
* @param[in] pWriter - Writer instance.
* @param[in] nDecimalPrecision - The number of digits to be written in each vertex coordinate-value after the decimal point.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_writer_setdecimalprecision(Lib3MF_Writer pWriter, Lib3MF_uint32 nDecimalPrecision);

/**
* Activates (deactivates) the strict mode of the reader.
*
* @param[in] pWriter - Writer instance.
* @param[in] bStrictModeActive - flag whether strict mode is active or not.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_writer_setstrictmodeactive(Lib3MF_Writer pWriter, bool bStrictModeActive);

/**
* Queries whether the strict mode of the reader is active or not
*
* @param[in] pWriter - Writer instance.
* @param[out] pStrictModeActive - returns flag whether strict mode is active or not.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_writer_getstrictmodeactive(Lib3MF_Writer pWriter, bool * pStrictModeActive);

/**
* Returns Warning and Error Information of the read process
*
* @param[in] pWriter - Writer instance.
* @param[in] nIndex - Index of the Warning. Valid values are 0 to WarningCount - 1
* @param[out] pErrorCode - filled with the error code of the warning
* @param[in] nWarningBufferSize - size of the buffer (including trailing 0)
* @param[out] pWarningNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pWarningBuffer -  buffer of the message of the warning, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_writer_getwarning(Lib3MF_Writer pWriter, Lib3MF_uint32 nIndex, Lib3MF_uint32 * pErrorCode, const Lib3MF_uint32 nWarningBufferSize, Lib3MF_uint32* pWarningNeededChars, char * pWarningBuffer);

/**
* Returns Warning and Error Count of the read process
*
* @param[in] pWriter - Writer instance.
* @param[out] pCount - filled with the count of the occurred warnings.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_writer_getwarningcount(Lib3MF_Writer pWriter, Lib3MF_uint32 * pCount);

/**
* Registers a callback to deal with data key encryption/decryption from keystore
*
* @param[in] pWriter - Writer instance.
* @param[in] pConsumerID - The ConsumerID to register for
* @param[in] pTheCallback - The callback to be callede for wrapping and encryption key
* @param[in] pUserData - Userdata that is passed to the callback function
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_writer_addkeywrappingcallback(Lib3MF_Writer pWriter, const char * pConsumerID, Lib3MFKeyWrappingCallback pTheCallback, Lib3MF_pvoid pUserData);

/**
* Registers a callback to deal with encryption of content
*
* @param[in] pWriter - Writer instance.
* @param[in] pTheCallback - The callback used to encrypt content
* @param[in] pUserData - Userdata that is passed to the callback function
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_writer_setcontentencryptioncallback(Lib3MF_Writer pWriter, Lib3MFContentEncryptionCallback pTheCallback, Lib3MF_pvoid pUserData);

/*************************************************************************************************************************
 Class definition for Reader
**************************************************************************************************************************/

/**
* Reads a model from a file. The file type is specified by the Model Reader class
*
* @param[in] pReader - Reader instance.
* @param[in] pFilename - Filename to read from
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_reader_readfromfile(Lib3MF_Reader pReader, const char * pFilename);

/**
* Reads a model from a memory buffer.
*
* @param[in] pReader - Reader instance.
* @param[in] nBufferBufferSize - Number of elements in buffer
* @param[in] pBufferBuffer - uint8 buffer of Buffer to read from
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_reader_readfrombuffer(Lib3MF_Reader pReader, Lib3MF_uint64 nBufferBufferSize, const Lib3MF_uint8 * pBufferBuffer);

/**
* Reads a model and from the data provided by a callback function
*
* @param[in] pReader - Reader instance.
* @param[in] pTheReadCallback - Callback to call for reading a data chunk
* @param[in] nStreamSize - number of bytes the callback returns
* @param[in] pTheSeekCallback - Callback to call for seeking in the stream.
* @param[in] pUserData - Userdata that is passed to the callback function
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_reader_readfromcallback(Lib3MF_Reader pReader, Lib3MFReadCallback pTheReadCallback, Lib3MF_uint64 nStreamSize, Lib3MFSeekCallback pTheSeekCallback, Lib3MF_pvoid pUserData);

/**
* Set the progress callback for calls to this writer
*
* @param[in] pReader - Reader instance.
* @param[in] pProgressCallback - pointer to the callback function.
* @param[in] pUserData - pointer to arbitrary user data that is passed without modification to the callback.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_reader_setprogresscallback(Lib3MF_Reader pReader, Lib3MFProgressCallback pProgressCallback, Lib3MF_pvoid pUserData);

/**
* Adds a relationship type which shall be read as attachment in memory while loading
*
* @param[in] pReader - Reader instance.
* @param[in] pRelationShipType - String of the relationship type
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_reader_addrelationtoread(Lib3MF_Reader pReader, const char * pRelationShipType);

/**
* Removes a relationship type which shall be read as attachment in memory while loading
*
* @param[in] pReader - Reader instance.
* @param[in] pRelationShipType - String of the relationship type
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_reader_removerelationtoread(Lib3MF_Reader pReader, const char * pRelationShipType);

/**
* Activates (deactivates) the strict mode of the reader.
*
* @param[in] pReader - Reader instance.
* @param[in] bStrictModeActive - flag whether strict mode is active or not.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_reader_setstrictmodeactive(Lib3MF_Reader pReader, bool bStrictModeActive);

/**
* Queries whether the strict mode of the reader is active or not
*
* @param[in] pReader - Reader instance.
* @param[out] pStrictModeActive - returns flag whether strict mode is active or not.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_reader_getstrictmodeactive(Lib3MF_Reader pReader, bool * pStrictModeActive);

/**
* Returns Warning and Error Information of the read process
*
* @param[in] pReader - Reader instance.
* @param[in] nIndex - Index of the Warning. Valid values are 0 to WarningCount - 1
* @param[out] pErrorCode - filled with the error code of the warning
* @param[in] nWarningBufferSize - size of the buffer (including trailing 0)
* @param[out] pWarningNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pWarningBuffer -  buffer of the message of the warning, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_reader_getwarning(Lib3MF_Reader pReader, Lib3MF_uint32 nIndex, Lib3MF_uint32 * pErrorCode, const Lib3MF_uint32 nWarningBufferSize, Lib3MF_uint32* pWarningNeededChars, char * pWarningBuffer);

/**
* Returns Warning and Error Count of the read process
*
* @param[in] pReader - Reader instance.
* @param[out] pCount - filled with the count of the occurred warnings.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_reader_getwarningcount(Lib3MF_Reader pReader, Lib3MF_uint32 * pCount);

/**
* Registers a callback to deal with key wrapping mechanism from keystore
*
* @param[in] pReader - Reader instance.
* @param[in] pConsumerID - The ConsumerID to register for
* @param[in] pTheCallback - The callback used to decrypt data key
* @param[in] pUserData - Userdata that is passed to the callback function
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_reader_addkeywrappingcallback(Lib3MF_Reader pReader, const char * pConsumerID, Lib3MFKeyWrappingCallback pTheCallback, Lib3MF_pvoid pUserData);

/**
* Registers a callback to deal with encryption of content
*
* @param[in] pReader - Reader instance.
* @param[in] pTheCallback - The callback used to encrypt content
* @param[in] pUserData - Userdata that is passed to the callback function
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_reader_setcontentencryptioncallback(Lib3MF_Reader pReader, Lib3MFContentEncryptionCallback pTheCallback, Lib3MF_pvoid pUserData);

/*************************************************************************************************************************
 Class definition for PackagePart
**************************************************************************************************************************/

/**
* Returns the absolute path of this PackagePart.
*
* @param[in] pPackagePart - PackagePart instance.
* @param[in] nPathBufferSize - size of the buffer (including trailing 0)
* @param[out] pPathNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pPathBuffer -  buffer of Returns the absolute path of this PackagePart, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_packagepart_getpath(Lib3MF_PackagePart pPackagePart, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer);

/**
* Sets the absolute path of this PackagePart.
*
* @param[in] pPackagePart - PackagePart instance.
* @param[in] pPath - Sets the absolute path of this PackagePart.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_packagepart_setpath(Lib3MF_PackagePart pPackagePart, const char * pPath);

/*************************************************************************************************************************
 Class definition for Resource
**************************************************************************************************************************/

/**
* Retrieves the unique id of this resource within a package. This function will be removed in a later release in favor of GetUniqueResourceID
*
* @param[in] pResource - Resource instance.
* @param[out] pUniqueResourceID - Retrieves the unique id of this resource within a package.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_resource_getresourceid(Lib3MF_Resource pResource, Lib3MF_uint32 * pUniqueResourceID);

/**
* Retrieves the unique id of this resource within a package.
*
* @param[in] pResource - Resource instance.
* @param[out] pUniqueResourceID - Retrieves the unique id of this resource within a package.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_resource_getuniqueresourceid(Lib3MF_Resource pResource, Lib3MF_uint32 * pUniqueResourceID);

/**
* Returns the PackagePart within which this resource resides
*
* @param[in] pResource - Resource instance.
* @param[out] pPackagePart - the PackagePart within which this resource resides.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_resource_packagepart(Lib3MF_Resource pResource, Lib3MF_PackagePart * pPackagePart);

/**
* Sets the new PackagePart within which this resource resides
*
* @param[in] pResource - Resource instance.
* @param[in] pPackagePart - the new PackagePart within which this resource resides.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_resource_setpackagepart(Lib3MF_Resource pResource, Lib3MF_PackagePart pPackagePart);

/**
* Retrieves the id of this resource within a model.
*
* @param[in] pResource - Resource instance.
* @param[out] pModelResourceId - Retrieves the id of this resource within a model.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_resource_getmodelresourceid(Lib3MF_Resource pResource, Lib3MF_uint32 * pModelResourceId);

/*************************************************************************************************************************
 Class definition for ResourceIterator
**************************************************************************************************************************/

/**
* Iterates to the next resource in the list.
*
* @param[in] pResourceIterator - ResourceIterator instance.
* @param[out] pHasNext - Iterates to the next resource in the list.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_resourceiterator_movenext(Lib3MF_ResourceIterator pResourceIterator, bool * pHasNext);

/**
* Iterates to the previous resource in the list.
*
* @param[in] pResourceIterator - ResourceIterator instance.
* @param[out] pHasPrevious - Iterates to the previous resource in the list.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_resourceiterator_moveprevious(Lib3MF_ResourceIterator pResourceIterator, bool * pHasPrevious);

/**
* Returns the resource the iterator points at.
*
* @param[in] pResourceIterator - ResourceIterator instance.
* @param[out] pResource - returns the resource instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_resourceiterator_getcurrent(Lib3MF_ResourceIterator pResourceIterator, Lib3MF_Resource * pResource);

/**
* Creates a new resource iterator with the same resource list.
*
* @param[in] pResourceIterator - ResourceIterator instance.
* @param[out] pOutResourceIterator - returns the cloned Iterator instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_resourceiterator_clone(Lib3MF_ResourceIterator pResourceIterator, Lib3MF_ResourceIterator * pOutResourceIterator);

/**
* Returns the number of resoucres the iterator captures.
*
* @param[in] pResourceIterator - ResourceIterator instance.
* @param[out] pCount - returns the number of resoucres the iterator captures.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_resourceiterator_count(Lib3MF_ResourceIterator pResourceIterator, Lib3MF_uint64 * pCount);

/*************************************************************************************************************************
 Class definition for SliceStackIterator
**************************************************************************************************************************/

/**
* Returns the SliceStack the iterator points at.
*
* @param[in] pSliceStackIterator - SliceStackIterator instance.
* @param[out] pResource - returns the SliceStack instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_slicestackiterator_getcurrentslicestack(Lib3MF_SliceStackIterator pSliceStackIterator, Lib3MF_SliceStack * pResource);

/*************************************************************************************************************************
 Class definition for ObjectIterator
**************************************************************************************************************************/

/**
* Returns the Object the iterator points at.
*
* @param[in] pObjectIterator - ObjectIterator instance.
* @param[out] pResource - returns the Object instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_objectiterator_getcurrentobject(Lib3MF_ObjectIterator pObjectIterator, Lib3MF_Object * pResource);

/*************************************************************************************************************************
 Class definition for MeshObjectIterator
**************************************************************************************************************************/

/**
* Returns the MeshObject the iterator points at.
*
* @param[in] pMeshObjectIterator - MeshObjectIterator instance.
* @param[out] pResource - returns the MeshObject instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobjectiterator_getcurrentmeshobject(Lib3MF_MeshObjectIterator pMeshObjectIterator, Lib3MF_MeshObject * pResource);

/*************************************************************************************************************************
 Class definition for ComponentsObjectIterator
**************************************************************************************************************************/

/**
* Returns the ComponentsObject the iterator points at.
*
* @param[in] pComponentsObjectIterator - ComponentsObjectIterator instance.
* @param[out] pResource - returns the ComponentsObject instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_componentsobjectiterator_getcurrentcomponentsobject(Lib3MF_ComponentsObjectIterator pComponentsObjectIterator, Lib3MF_ComponentsObject * pResource);

/*************************************************************************************************************************
 Class definition for Texture2DIterator
**************************************************************************************************************************/

/**
* Returns the Texture2D the iterator points at.
*
* @param[in] pTexture2DIterator - Texture2DIterator instance.
* @param[out] pResource - returns the Texture2D instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_texture2diterator_getcurrenttexture2d(Lib3MF_Texture2DIterator pTexture2DIterator, Lib3MF_Texture2D * pResource);

/*************************************************************************************************************************
 Class definition for BaseMaterialGroupIterator
**************************************************************************************************************************/

/**
* Returns the MaterialGroup the iterator points at.
*
* @param[in] pBaseMaterialGroupIterator - BaseMaterialGroupIterator instance.
* @param[out] pResource - returns the BaseMaterialGroup instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup(Lib3MF_BaseMaterialGroupIterator pBaseMaterialGroupIterator, Lib3MF_BaseMaterialGroup * pResource);

/*************************************************************************************************************************
 Class definition for ColorGroupIterator
**************************************************************************************************************************/

/**
* Returns the ColorGroup the iterator points at.
*
* @param[in] pColorGroupIterator - ColorGroupIterator instance.
* @param[out] pResource - returns the ColorGroup instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_colorgroupiterator_getcurrentcolorgroup(Lib3MF_ColorGroupIterator pColorGroupIterator, Lib3MF_ColorGroup * pResource);

/*************************************************************************************************************************
 Class definition for Texture2DGroupIterator
**************************************************************************************************************************/

/**
* Returns the Texture2DGroup the iterator points at.
*
* @param[in] pTexture2DGroupIterator - Texture2DGroupIterator instance.
* @param[out] pResource - returns the Texture2DGroup instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup(Lib3MF_Texture2DGroupIterator pTexture2DGroupIterator, Lib3MF_Texture2DGroup * pResource);

/*************************************************************************************************************************
 Class definition for CompositeMaterialsIterator
**************************************************************************************************************************/

/**
* Returns the CompositeMaterials the iterator points at.
*
* @param[in] pCompositeMaterialsIterator - CompositeMaterialsIterator instance.
* @param[out] pResource - returns the CompositeMaterials instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_compositematerialsiterator_getcurrentcompositematerials(Lib3MF_CompositeMaterialsIterator pCompositeMaterialsIterator, Lib3MF_CompositeMaterials * pResource);

/*************************************************************************************************************************
 Class definition for MultiPropertyGroupIterator
**************************************************************************************************************************/

/**
* Returns the MultiPropertyGroup the iterator points at.
*
* @param[in] pMultiPropertyGroupIterator - MultiPropertyGroupIterator instance.
* @param[out] pResource - returns the MultiPropertyGroup instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup(Lib3MF_MultiPropertyGroupIterator pMultiPropertyGroupIterator, Lib3MF_MultiPropertyGroup * pResource);

/*************************************************************************************************************************
 Class definition for Image3DIterator
**************************************************************************************************************************/

/**
* Returns the Image3D the iterator points at.
*
* @param[in] pImage3DIterator - Image3DIterator instance.
* @param[out] pResource - returns the Image3D instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_image3diterator_getcurrentimage3d(Lib3MF_Image3DIterator pImage3DIterator, Lib3MF_Image3D * pResource);

/*************************************************************************************************************************
 Class definition for FunctionIterator
**************************************************************************************************************************/

/**
* Returns the Function the iterator points at.
*
* @param[in] pFunctionIterator - FunctionIterator instance.
* @param[out] pResource - returns the Function instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functioniterator_getcurrentfunction(Lib3MF_FunctionIterator pFunctionIterator, Lib3MF_Function * pResource);

/*************************************************************************************************************************
 Class definition for LevelSetIterator
**************************************************************************************************************************/

/**
* Returns the LevelSet the iterator points at.
*
* @param[in] pLevelSetIterator - LevelSetIterator instance.
* @param[out] pResource - returns the MeshObject instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_levelsetiterator_getcurrentlevelset(Lib3MF_LevelSetIterator pLevelSetIterator, Lib3MF_LevelSet * pResource);

/*************************************************************************************************************************
 Class definition for MetaData
**************************************************************************************************************************/

/**
* returns the namespace URL of the metadata
*
* @param[in] pMetaData - MetaData instance.
* @param[in] nNameSpaceBufferSize - size of the buffer (including trailing 0)
* @param[out] pNameSpaceNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pNameSpaceBuffer -  buffer of the namespace URL of the metadata, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_metadata_getnamespace(Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nNameSpaceBufferSize, Lib3MF_uint32* pNameSpaceNeededChars, char * pNameSpaceBuffer);

/**
* sets a new namespace URL of the metadata
*
* @param[in] pMetaData - MetaData instance.
* @param[in] pNameSpace - the new namespace URL of the metadata
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_metadata_setnamespace(Lib3MF_MetaData pMetaData, const char * pNameSpace);

/**
* returns the name of a metadata
*
* @param[in] pMetaData - MetaData instance.
* @param[in] nNameBufferSize - size of the buffer (including trailing 0)
* @param[out] pNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pNameBuffer -  buffer of the name of the metadata, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_metadata_getname(Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer);

/**
* sets a new name of a metadata
*
* @param[in] pMetaData - MetaData instance.
* @param[in] pName - the new name of the metadata
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_metadata_setname(Lib3MF_MetaData pMetaData, const char * pName);

/**
* returns the (namespace+name) of a metadata
*
* @param[in] pMetaData - MetaData instance.
* @param[in] nKeyBufferSize - size of the buffer (including trailing 0)
* @param[out] pKeyNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pKeyBuffer -  buffer of the key (namespace+name) of the metadata, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_metadata_getkey(Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nKeyBufferSize, Lib3MF_uint32* pKeyNeededChars, char * pKeyBuffer);

/**
* returns, whether a metadata must be preserved
*
* @param[in] pMetaData - MetaData instance.
* @param[out] pMustPreserve - returns, whether a metadata must be preserved
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_metadata_getmustpreserve(Lib3MF_MetaData pMetaData, bool * pMustPreserve);

/**
* sets whether a metadata must be preserved
*
* @param[in] pMetaData - MetaData instance.
* @param[in] bMustPreserve - a new value whether a metadata must be preserved
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_metadata_setmustpreserve(Lib3MF_MetaData pMetaData, bool bMustPreserve);

/**
* returns the type of a metadata
*
* @param[in] pMetaData - MetaData instance.
* @param[in] nTypeBufferSize - size of the buffer (including trailing 0)
* @param[out] pTypeNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pTypeBuffer -  buffer of the type of the metadata, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_metadata_gettype(Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nTypeBufferSize, Lib3MF_uint32* pTypeNeededChars, char * pTypeBuffer);

/**
* sets a new type of a metadata. This must be a simple XML type
*
* @param[in] pMetaData - MetaData instance.
* @param[in] pType - a new type of the metadata
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_metadata_settype(Lib3MF_MetaData pMetaData, const char * pType);

/**
* returns the value of the metadata
*
* @param[in] pMetaData - MetaData instance.
* @param[in] nValueBufferSize - size of the buffer (including trailing 0)
* @param[out] pValueNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pValueBuffer -  buffer of the value of the metadata, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_metadata_getvalue(Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nValueBufferSize, Lib3MF_uint32* pValueNeededChars, char * pValueBuffer);

/**
* sets a new value of the metadata
*
* @param[in] pMetaData - MetaData instance.
* @param[in] pValue - a new value of the metadata
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_metadata_setvalue(Lib3MF_MetaData pMetaData, const char * pValue);

/*************************************************************************************************************************
 Class definition for MetaDataGroup
**************************************************************************************************************************/

/**
* returns the number of metadata in this metadatagroup
*
* @param[in] pMetaDataGroup - MetaDataGroup instance.
* @param[out] pCount - returns the number metadata
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_metadatagroup_getmetadatacount(Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_uint32 * pCount);

/**
* returns a metadata value within this metadatagroup
*
* @param[in] pMetaDataGroup - MetaDataGroup instance.
* @param[in] nIndex - Index of the Metadata.
* @param[out] pMetaData - an instance of the metadata
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_metadatagroup_getmetadata(Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_uint32 nIndex, Lib3MF_MetaData * pMetaData);

/**
* returns a metadata value within this metadatagroup
*
* @param[in] pMetaDataGroup - MetaDataGroup instance.
* @param[in] pNameSpace - the namespace of the metadata
* @param[in] pName - the name of the Metadata
* @param[out] pMetaData - an instance of the metadata
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_metadatagroup_getmetadatabykey(Lib3MF_MetaDataGroup pMetaDataGroup, const char * pNameSpace, const char * pName, Lib3MF_MetaData * pMetaData);

/**
* removes metadata by index from the model.
*
* @param[in] pMetaDataGroup - MetaDataGroup instance.
* @param[in] nIndex -  Index of the metadata to remove
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_metadatagroup_removemetadatabyindex(Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_uint32 nIndex);

/**
* removes metadata from the model.
*
* @param[in] pMetaDataGroup - MetaDataGroup instance.
* @param[in] pTheMetaData - The metadata to remove
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_metadatagroup_removemetadata(Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_MetaData pTheMetaData);

/**
* adds a new metadata to this metadatagroup
*
* @param[in] pMetaDataGroup - MetaDataGroup instance.
* @param[in] pNameSpace - the namespace of the metadata
* @param[in] pName - the name of the metadata
* @param[in] pValue - the value of the metadata
* @param[in] pType - the type of the metadata
* @param[in] bMustPreserve - should the metadata be preserved
* @param[out] pMetaData - a new instance of the metadata
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_metadatagroup_addmetadata(Lib3MF_MetaDataGroup pMetaDataGroup, const char * pNameSpace, const char * pName, const char * pValue, const char * pType, bool bMustPreserve, Lib3MF_MetaData * pMetaData);

/*************************************************************************************************************************
 Class definition for TriangleSet
**************************************************************************************************************************/

/**
* sets the name of the triangle set
*
* @param[in] pTriangleSet - TriangleSet instance.
* @param[in] pName - the new name
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_triangleset_setname(Lib3MF_TriangleSet pTriangleSet, const char * pName);

/**
* returns the name of the triangle set
*
* @param[in] pTriangleSet - TriangleSet instance.
* @param[in] nNameBufferSize - size of the buffer (including trailing 0)
* @param[out] pNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pNameBuffer -  buffer of returns the name, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_triangleset_getname(Lib3MF_TriangleSet pTriangleSet, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer);

/**
* sets the identifier of the triangle set.
*
* @param[in] pTriangleSet - TriangleSet instance.
* @param[in] pIdentifier - the new identifier. MUST be unique within the mesh. MUST NOT be an empty string
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_triangleset_setidentifier(Lib3MF_TriangleSet pTriangleSet, const char * pIdentifier);

/**
* returns the identifier of the triangle set
*
* @param[in] pTriangleSet - TriangleSet instance.
* @param[in] nIdentifierBufferSize - size of the buffer (including trailing 0)
* @param[out] pIdentifierNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pIdentifierBuffer -  buffer of returns the identifier, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_triangleset_getidentifier(Lib3MF_TriangleSet pTriangleSet, const Lib3MF_uint32 nIdentifierBufferSize, Lib3MF_uint32* pIdentifierNeededChars, char * pIdentifierBuffer);

/**
* adds a triangle to the set. Does nothing if triangle is already in the set.
*
* @param[in] pTriangleSet - TriangleSet instance.
* @param[in] nTriangleIndex - Triangle index to add. MUST be between 0 and TriangleCount - 1.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_triangleset_addtriangle(Lib3MF_TriangleSet pTriangleSet, Lib3MF_uint32 nTriangleIndex);

/**
* removes a triangle from the set
*
* @param[in] pTriangleSet - TriangleSet instance.
* @param[in] nTriangleIndex - Triangle index to remove. MUST be between 0 and TriangleCount - 1.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_triangleset_removetriangle(Lib3MF_TriangleSet pTriangleSet, Lib3MF_uint32 nTriangleIndex);

/**
* clears all triangles from the list
*
* @param[in] pTriangleSet - TriangleSet instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_triangleset_clear(Lib3MF_TriangleSet pTriangleSet);

/**
* Sets all triangles in the list, while clearing old values. Duplicates will be merged.
*
* @param[in] pTriangleSet - TriangleSet instance.
* @param[in] nTriangleIndicesBufferSize - Number of elements in buffer
* @param[in] pTriangleIndicesBuffer - uint32 buffer of Triangle indices to add. Every element MUST be between 0 and TriangleCount - 1.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_triangleset_settrianglelist(Lib3MF_TriangleSet pTriangleSet, Lib3MF_uint64 nTriangleIndicesBufferSize, const Lib3MF_uint32 * pTriangleIndicesBuffer);

/**
* Retrieves all the triangles in the TriangleSet
*
* @param[in] pTriangleSet - TriangleSet instance.
* @param[in] nTriangleIndicesBufferSize - Number of elements in buffer
* @param[out] pTriangleIndicesNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pTriangleIndicesBuffer - uint32  buffer of retrieves the indices of the triangles in this TriangleSet
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_triangleset_gettrianglelist(Lib3MF_TriangleSet pTriangleSet, const Lib3MF_uint64 nTriangleIndicesBufferSize, Lib3MF_uint64* pTriangleIndicesNeededCount, Lib3MF_uint32 * pTriangleIndicesBuffer);

/**
* Adds multiple triangles in the list. Duplicates will be merged.
*
* @param[in] pTriangleSet - TriangleSet instance.
* @param[in] nTriangleIndicesBufferSize - Number of elements in buffer
* @param[in] pTriangleIndicesBuffer - uint32 buffer of Triangle indices to add. Every element MUST be between 0 and TriangleCount - 1.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_triangleset_addtrianglelist(Lib3MF_TriangleSet pTriangleSet, Lib3MF_uint64 nTriangleIndicesBufferSize, const Lib3MF_uint32 * pTriangleIndicesBuffer);

/**
* Merges another Triangle set.
*
* @param[in] pTriangleSet - TriangleSet instance.
* @param[in] pOtherTriangleSet - Other triangle set to merge.
* @param[in] bDeleteOther - Flag if other triangle set is getting removed.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_triangleset_merge(Lib3MF_TriangleSet pTriangleSet, Lib3MF_TriangleSet pOtherTriangleSet, bool bDeleteOther);

/**
* Deletes the whole set from the mesh.
*
* @param[in] pTriangleSet - TriangleSet instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_triangleset_deleteset(Lib3MF_TriangleSet pTriangleSet);

/**
* Duplicates the set in the mesh.
*
* @param[in] pTriangleSet - TriangleSet instance.
* @param[in] pIdentifier - the new identifier. MUST be unique within the mesh. MUST NOT be an empty string
* @param[out] pNewSet - Copy of the triangle set.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_triangleset_duplicate(Lib3MF_TriangleSet pTriangleSet, const char * pIdentifier, Lib3MF_TriangleSet * pNewSet);

/*************************************************************************************************************************
 Class definition for Object
**************************************************************************************************************************/

/**
* Retrieves an object's type
*
* @param[in] pObject - Object instance.
* @param[out] pObjectType - returns object type enum.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_gettype(Lib3MF_Object pObject, eLib3MFObjectType * pObjectType);

/**
* Sets an object's type
*
* @param[in] pObject - Object instance.
* @param[in] eObjectType - object type enum.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_settype(Lib3MF_Object pObject, eLib3MFObjectType eObjectType);

/**
* Retrieves an object's name
*
* @param[in] pObject - Object instance.
* @param[in] nNameBufferSize - size of the buffer (including trailing 0)
* @param[out] pNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pNameBuffer -  buffer of returns object name., may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_getname(Lib3MF_Object pObject, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer);

/**
* Sets an object's name string
*
* @param[in] pObject - Object instance.
* @param[in] pName - new object name.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_setname(Lib3MF_Object pObject, const char * pName);

/**
* Retrieves an object's part number
*
* @param[in] pObject - Object instance.
* @param[in] nPartNumberBufferSize - size of the buffer (including trailing 0)
* @param[out] pPartNumberNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pPartNumberBuffer -  buffer of returns object part number., may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_getpartnumber(Lib3MF_Object pObject, const Lib3MF_uint32 nPartNumberBufferSize, Lib3MF_uint32* pPartNumberNeededChars, char * pPartNumberBuffer);

/**
* Sets an objects partnumber string
*
* @param[in] pObject - Object instance.
* @param[in] pPartNumber - new object part number.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_setpartnumber(Lib3MF_Object pObject, const char * pPartNumber);

/**
* Retrieves, if an object is a mesh object
*
* @param[in] pObject - Object instance.
* @param[out] pIsMeshObject - returns, whether the object is a mesh object
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_ismeshobject(Lib3MF_Object pObject, bool * pIsMeshObject);

/**
* Retrieves, if an object is a components object
*
* @param[in] pObject - Object instance.
* @param[out] pIsComponentsObject - returns, whether the object is a components object
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_iscomponentsobject(Lib3MF_Object pObject, bool * pIsComponentsObject);

/**
* Retrieves, if an object is a level set object
*
* @param[in] pObject - Object instance.
* @param[out] pIsLevelSetObject - returns, whether the object is a level set object
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_islevelsetobject(Lib3MF_Object pObject, bool * pIsLevelSetObject);

/**
* Retrieves, if the object is valid according to the core spec. For mesh objects, we distinguish between the type attribute of the object:In case of object type other, this always means false.In case of object type model or solidsupport, this means, if the mesh suffices all requirements of the core spec chapter 4.1.In case of object type support or surface, this always means true.A component objects is valid if and only if it contains at least one component and all child components are valid objects.
*
* @param[in] pObject - Object instance.
* @param[out] pIsValid - returns whether the object is a valid object description
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_isvalid(Lib3MF_Object pObject, bool * pIsValid);

/**
* Use an existing attachment as thumbnail for this object
*
* @param[in] pObject - Object instance.
* @param[in] pAttachment - Instance of a new or the existing thumbnailattachment object.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_setattachmentasthumbnail(Lib3MF_Object pObject, Lib3MF_Attachment pAttachment);

/**
* Get the attachment containing the object thumbnail.
*
* @param[in] pObject - Object instance.
* @param[out] pAttachment - Instance of the thumbnailattachment object or NULL.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_getthumbnailattachment(Lib3MF_Object pObject, Lib3MF_Attachment * pAttachment);

/**
* Clears the attachment. The attachment instance is not removed from the package.
*
* @param[in] pObject - Object instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_clearthumbnailattachment(Lib3MF_Object pObject);

/**
* Returns the outbox of a build item
*
* @param[in] pObject - Object instance.
* @param[out] pOutbox - Outbox of this build item
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_getoutbox(Lib3MF_Object pObject, sLib3MFBox * pOutbox);

/**
* Retrieves an object's uuid string (see production extension specification)
*
* @param[in] pObject - Object instance.
* @param[out] pHasUUID - flag whether the build item has a UUID
* @param[in] nUUIDBufferSize - size of the buffer (including trailing 0)
* @param[out] pUUIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pUUIDBuffer -  buffer of returns object uuid., may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_getuuid(Lib3MF_Object pObject, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer);

/**
* Sets a build object's uuid string (see production extension specification)
*
* @param[in] pObject - Object instance.
* @param[in] pUUID - new object uuid string.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_setuuid(Lib3MF_Object pObject, const char * pUUID);

/**
* Returns the metadatagroup of this object
*
* @param[in] pObject - Object instance.
* @param[out] pMetaDataGroup - returns an Instance of the metadatagroup of this object
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_getmetadatagroup(Lib3MF_Object pObject, Lib3MF_MetaDataGroup * pMetaDataGroup);

/**
* set the meshresolution of the mesh object
*
* @param[in] pObject - Object instance.
* @param[in] eMeshResolution - meshresolution of this object
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_setslicesmeshresolution(Lib3MF_Object pObject, eLib3MFSlicesMeshResolution eMeshResolution);

/**
* get the meshresolution of the mesh object
*
* @param[in] pObject - Object instance.
* @param[out] pMeshResolution - meshresolution of this object
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_getslicesmeshresolution(Lib3MF_Object pObject, eLib3MFSlicesMeshResolution * pMeshResolution);

/**
* returns whether the Object has a slice stack. If Recursive is true, also checks whether any references object has a slice stack
*
* @param[in] pObject - Object instance.
* @param[in] bRecursive - check also all referenced objects?
* @param[out] pHasSlices - does the object have a slice stack?
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_hasslices(Lib3MF_Object pObject, bool bRecursive, bool * pHasSlices);

/**
* unlinks the attached slicestack from this object. If no slice stack is attached, do noting.
*
* @param[in] pObject - Object instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_clearslicestack(Lib3MF_Object pObject);

/**
* get the Slicestack attached to the object
*
* @param[in] pObject - Object instance.
* @param[out] pSliceStackInstance - returns the slicestack instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_getslicestack(Lib3MF_Object pObject, Lib3MF_SliceStack * pSliceStackInstance);

/**
* assigns a slicestack to the object
*
* @param[in] pObject - Object instance.
* @param[in] pSliceStackInstance - the new slice stack of this Object
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_object_assignslicestack(Lib3MF_Object pObject, Lib3MF_SliceStack pSliceStackInstance);

/*************************************************************************************************************************
 Class definition for MeshObject
**************************************************************************************************************************/

/**
* Returns the vertex count of a mesh object.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[out] pVertexCount - filled with the vertex count.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_getvertexcount(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 * pVertexCount);

/**
* Returns the triangle count of a mesh object.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[out] pVertexCount - filled with the triangle count.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_gettrianglecount(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 * pVertexCount);

/**
* Returns the vertex count of a mesh object.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nIndex - Index of the vertex (0 to vertexcount - 1)
* @param[out] pCoordinates - filled with the vertex coordinates.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_getvertex(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, sLib3MFPosition * pCoordinates);

/**
* Sets the coordinates of a single vertex of a mesh object
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nIndex - Index of the vertex (0 to vertexcount - 1)
* @param[in] pCoordinates - contains the vertex coordinates.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_setvertex(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, const sLib3MFPosition * pCoordinates);

/**
* Adds a single vertex to a mesh object
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] pCoordinates - contains the vertex coordinates.
* @param[out] pNewIndex - Index of the new vertex
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_addvertex(Lib3MF_MeshObject pMeshObject, const sLib3MFPosition * pCoordinates, Lib3MF_uint32 * pNewIndex);

/**
* Obtains all vertex positions of a mesh object
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nVerticesBufferSize - Number of elements in buffer
* @param[out] pVerticesNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pVerticesBuffer - Position  buffer of contains the vertex coordinates.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_getvertices(Lib3MF_MeshObject pMeshObject, const Lib3MF_uint64 nVerticesBufferSize, Lib3MF_uint64* pVerticesNeededCount, sLib3MFPosition * pVerticesBuffer);

/**
* Returns indices of a single triangle of a mesh object.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
* @param[out] pIndices - filled with the triangle indices.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_gettriangle(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, sLib3MFTriangle * pIndices);

/**
* Sets the indices of a single triangle of a mesh object.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
* @param[in] pIndices - contains the triangle indices.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_settriangle(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, const sLib3MFTriangle * pIndices);

/**
* Adds a single triangle to a mesh object
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] pIndices - contains the triangle indices.
* @param[out] pNewIndex - Index of the new triangle
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_addtriangle(Lib3MF_MeshObject pMeshObject, const sLib3MFTriangle * pIndices, Lib3MF_uint32 * pNewIndex);

/**
* Get all triangles of a mesh object
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nIndicesBufferSize - Number of elements in buffer
* @param[out] pIndicesNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pIndicesBuffer - Triangle  buffer of contains the triangle indices.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_gettriangleindices(Lib3MF_MeshObject pMeshObject, const Lib3MF_uint64 nIndicesBufferSize, Lib3MF_uint64* pIndicesNeededCount, sLib3MFTriangle * pIndicesBuffer);

/**
* Sets the property at the object-level of the mesh object.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nUniqueResourceID - the object-level Property UniqueResourceID.
* @param[in] nPropertyID - the object-level PropertyID.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_setobjectlevelproperty(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nUniqueResourceID, Lib3MF_uint32 nPropertyID);

/**
* Gets the property at the object-level of the mesh object.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[out] pUniqueResourceID - the object-level Property UniqueResourceID.
* @param[out] pPropertyID - the object-level PropertyID.
* @param[out] pHasObjectLevelProperty - Has an object-level property been specified?
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_getobjectlevelproperty(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 * pUniqueResourceID, Lib3MF_uint32 * pPropertyID, bool * pHasObjectLevelProperty);

/**
* Sets the properties of a single triangle of a mesh object.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
* @param[in] pProperties - contains the triangle properties.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_settriangleproperties(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, const sLib3MFTriangleProperties * pProperties);

/**
* Gets the properties of a single triangle of a mesh object.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
* @param[out] pProperty - returns the triangle properties.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_gettriangleproperties(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, sLib3MFTriangleProperties * pProperty);

/**
* Sets the properties of all triangles of a mesh object. Sets the object level property to the first entry of the passed triangle properties, if not yet specified.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nPropertiesArrayBufferSize - Number of elements in buffer
* @param[in] pPropertiesArrayBuffer - TriangleProperties buffer of contains the triangle properties array. Must have trianglecount elements.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_setalltriangleproperties(Lib3MF_MeshObject pMeshObject, Lib3MF_uint64 nPropertiesArrayBufferSize, const sLib3MFTriangleProperties * pPropertiesArrayBuffer);

/**
* Gets the properties of all triangles of a mesh object.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nPropertiesArrayBufferSize - Number of elements in buffer
* @param[out] pPropertiesArrayNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pPropertiesArrayBuffer - TriangleProperties  buffer of returns the triangle properties array. Must have trianglecount elements.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_getalltriangleproperties(Lib3MF_MeshObject pMeshObject, const Lib3MF_uint64 nPropertiesArrayBufferSize, Lib3MF_uint64* pPropertiesArrayNeededCount, sLib3MFTriangleProperties * pPropertiesArrayBuffer);

/**
* Clears all properties of this mesh object (triangle and object-level).
*
* @param[in] pMeshObject - MeshObject instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_clearallproperties(Lib3MF_MeshObject pMeshObject);

/**
* Set all triangles of a mesh object
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nVerticesBufferSize - Number of elements in buffer
* @param[in] pVerticesBuffer - Position buffer of contains the positions.
* @param[in] nIndicesBufferSize - Number of elements in buffer
* @param[in] pIndicesBuffer - Triangle buffer of contains the triangle indices.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_setgeometry(Lib3MF_MeshObject pMeshObject, Lib3MF_uint64 nVerticesBufferSize, const sLib3MFPosition * pVerticesBuffer, Lib3MF_uint64 nIndicesBufferSize, const sLib3MFTriangle * pIndicesBuffer);

/**
* Retrieves, if an object describes a topologically oriented and manifold mesh, according to the core spec.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[out] pIsManifoldAndOriented - returns, if the object is oriented and manifold.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_ismanifoldandoriented(Lib3MF_MeshObject pMeshObject, bool * pIsManifoldAndOriented);

/**
* Retrieves the BeamLattice within this MeshObject.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[out] pTheBeamLattice - the BeamLattice within this MeshObject
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_beamlattice(Lib3MF_MeshObject pMeshObject, Lib3MF_BeamLattice * pTheBeamLattice);

/**
* Retrieves the VolumeData of this MeshObject.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[out] pTheVolumeData - the VolumeData of this MeshObject
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_getvolumedata(Lib3MF_MeshObject pMeshObject, Lib3MF_VolumeData * pTheVolumeData);

/**
* Sets the VolumeData of this MeshObject.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] pTheVolumeData - the VolumeData of this MeshObject
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_setvolumedata(Lib3MF_MeshObject pMeshObject, Lib3MF_VolumeData pTheVolumeData);

/**
* Adds a new triangle set.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] pIdentifier - the new identifier. MUST be unique within the mesh. MUST NOT be an empty string
* @param[in] pName - the human readable name. MUST NOT be an empty string
* @param[out] pTheTriangleSet - the new Triangle Set Instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_addtriangleset(Lib3MF_MeshObject pMeshObject, const char * pIdentifier, const char * pName, Lib3MF_TriangleSet * pTheTriangleSet);

/**
* Checks if a triangle set exists.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] pIdentifier - the identifier to be found.
* @param[out] pTriangleSetExists - flag if the triangles set exists.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_hastriangleset(Lib3MF_MeshObject pMeshObject, const char * pIdentifier, bool * pTriangleSetExists);

/**
* Finds a new triangle set by identifier. Fails if not existing.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] pIdentifier - the identifier to be found.
* @param[out] pTheTriangleSet - the triangle Set Instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_findtriangleset(Lib3MF_MeshObject pMeshObject, const char * pIdentifier, Lib3MF_TriangleSet * pTheTriangleSet);

/**
* Returns number of triangle sets.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[out] pCount - the number of triangle sets of this mesh.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_gettrianglesetcount(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 * pCount);

/**
* Returns a specific triangle set by index.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nIndex - the index of the triangle set.
* @param[out] pTheTriangleSet - the triangle Set Instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshobject_gettriangleset(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, Lib3MF_TriangleSet * pTheTriangleSet);

/*************************************************************************************************************************
 Class definition for LevelSet
**************************************************************************************************************************/

/**
* Returns the function that is used as boundary shape.
*
* @param[in] pLevelSet - LevelSet instance.
* @param[out] pTheFunction - the function to use as boundary shape
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_levelset_getfunction(Lib3MF_LevelSet pLevelSet, Lib3MF_Function * pTheFunction);

/**
* Sets the function to use as boundary shape.
*
* @param[in] pLevelSet - LevelSet instance.
* @param[in] pTheFunction - the function to use as boundary shape
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_levelset_setfunction(Lib3MF_LevelSet pLevelSet, Lib3MF_Function pTheFunction);

/**
* Returns the transformation matrix into the coordinate system of the referenced Function.
*
* @param[in] pLevelSet - LevelSet instance.
* @param[out] pTransform - the transformation matrix
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_levelset_gettransform(Lib3MF_LevelSet pLevelSet, sLib3MFTransform * pTransform);

/**
* Sets the transformation matrix into the coordinate system of the referenced Function.
*
* @param[in] pLevelSet - LevelSet instance.
* @param[in] pTransform - new transformation matrix
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_levelset_settransform(Lib3MF_LevelSet pLevelSet, const sLib3MFTransform * pTransform);

/**
* Returns the name of the function output channel to use.
*
* @param[in] pLevelSet - LevelSet instance.
* @param[in] nChannelNameBufferSize - size of the buffer (including trailing 0)
* @param[out] pChannelNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pChannelNameBuffer -  buffer of the name of the function output channel, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_levelset_getchannelname(Lib3MF_LevelSet pLevelSet, const Lib3MF_uint32 nChannelNameBufferSize, Lib3MF_uint32* pChannelNameNeededChars, char * pChannelNameBuffer);

/**
* Sets the name of the function output channel to use.
*
* @param[in] pLevelSet - LevelSet instance.
* @param[in] pChannelName - new name of the function output channel
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_levelset_setchannelname(Lib3MF_LevelSet pLevelSet, const char * pChannelName);

/**
* Sets the minimal feature size as a hint for the function evaluator
*
* @param[in] pLevelSet - LevelSet instance.
* @param[in] dMinFeatureSize - minimal feature size
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_levelset_setminfeaturesize(Lib3MF_LevelSet pLevelSet, Lib3MF_double dMinFeatureSize);

/**
* Returns the minimal feature size as a hint for the function evaluator
*
* @param[in] pLevelSet - LevelSet instance.
* @param[out] pMinFeatureSize - minimal feature size
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_levelset_getminfeaturesize(Lib3MF_LevelSet pLevelSet, Lib3MF_double * pMinFeatureSize);

/**
* Sets the fallback value to use if the function evaluation fails (e.g. evaluates to NaN or Inf).
*
* @param[in] pLevelSet - LevelSet instance.
* @param[in] dFallBackValue - fallback value
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_levelset_setfallbackvalue(Lib3MF_LevelSet pLevelSet, Lib3MF_double dFallBackValue);

/**
* Returns the fallback value to use if the function evaluation fails (e.g. evaluates to NaN or Inf).
*
* @param[in] pLevelSet - LevelSet instance.
* @param[out] pFallBackValue - fallback value
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_levelset_getfallbackvalue(Lib3MF_LevelSet pLevelSet, Lib3MF_double * pFallBackValue);

/**
* If set only the bounding box of the mesh is intersected with the boundary
*
* @param[in] pLevelSet - LevelSet instance.
* @param[in] bMeshBBoxOnly - If set only the bounding box of the mesh is intersected with the boundary
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_levelset_setmeshbboxonly(Lib3MF_LevelSet pLevelSet, bool bMeshBBoxOnly);

/**
* If set only the bounding box of the mesh is intersected with the boundary
*
* @param[in] pLevelSet - LevelSet instance.
* @param[out] pMeshBBoxOnly - If set only the bounding box of the mesh is intersected with the boundary
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_levelset_getmeshbboxonly(Lib3MF_LevelSet pLevelSet, bool * pMeshBBoxOnly);

/**
* Sets the mesh to use as evaluation domain
*
* @param[in] pLevelSet - LevelSet instance.
* @param[in] pTheMesh - The mesh
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_levelset_setmesh(Lib3MF_LevelSet pLevelSet, Lib3MF_MeshObject pTheMesh);

/**
* Returns the mesh that is used as evaluation domain
*
* @param[in] pLevelSet - LevelSet instance.
* @param[out] pTheMesh - The mesh
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_levelset_getmesh(Lib3MF_LevelSet pLevelSet, Lib3MF_MeshObject * pTheMesh);

/**
* Retrieves the VolumeData this Object.
*
* @param[in] pLevelSet - LevelSet instance.
* @param[out] pTheVolumeData - the VolumeData of this Object
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_levelset_getvolumedata(Lib3MF_LevelSet pLevelSet, Lib3MF_VolumeData * pTheVolumeData);

/**
* Sets the VolumeData of this LevelSet.
*
* @param[in] pLevelSet - LevelSet instance.
* @param[in] pTheVolumeData - the VolumeData of this MeshObject
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_levelset_setvolumedata(Lib3MF_LevelSet pLevelSet, Lib3MF_VolumeData pTheVolumeData);

/*************************************************************************************************************************
 Class definition for BeamLattice
**************************************************************************************************************************/

/**
* Returns the minimal length of beams for the beamlattice.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[out] pMinLength - minimal length of beams for the beamlattice
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_getminlength(Lib3MF_BeamLattice pBeamLattice, Lib3MF_double * pMinLength);

/**
* Sets the minimal length of beams for the beamlattice.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] dMinLength - minimal length of beams for the beamlattice
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_setminlength(Lib3MF_BeamLattice pBeamLattice, Lib3MF_double dMinLength);

/**
* Returns the clipping mode and the clipping-mesh for the beamlattice of this mesh.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[out] pClipMode - contains the clip mode of this mesh
* @param[out] pUniqueResourceID - filled with the UniqueResourceID of the clipping mesh-object or an undefined value if pClipMode is MODELBEAMLATTICECLIPMODE_NONE
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_getclipping(Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeClipMode * pClipMode, Lib3MF_uint32 * pUniqueResourceID);

/**
* Sets the clipping mode and the clipping-mesh for the beamlattice of this mesh.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] eClipMode - contains the clip mode of this mesh
* @param[in] nUniqueResourceID - the UniqueResourceID of the clipping mesh-object. This mesh-object has to be defined before setting the Clipping.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_setclipping(Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeClipMode eClipMode, Lib3MF_uint32 nUniqueResourceID);

/**
* Returns the representation-mesh for the beamlattice of this mesh.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[out] pHasRepresentation - flag whether the beamlattice has a representation mesh.
* @param[out] pUniqueResourceID - filled with the UniqueResourceID of the clipping mesh-object.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_getrepresentation(Lib3MF_BeamLattice pBeamLattice, bool * pHasRepresentation, Lib3MF_uint32 * pUniqueResourceID);

/**
* Sets the representation-mesh for the beamlattice of this mesh.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] nUniqueResourceID - the UniqueResourceID of the representation mesh-object. This mesh-object has to be defined before setting the representation.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_setrepresentation(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nUniqueResourceID);

/**
* Returns the ball mode and the default ball radius for the beamlattice of this mesh.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[out] pBallMode - contains the ball mode of this mesh
* @param[out] pBallRadius - default ball radius of balls for the beamlattice
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_getballoptions(Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeBallMode * pBallMode, Lib3MF_double * pBallRadius);

/**
* Sets the ball mode and thedefault ball radius for the beamlattice.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] eBallMode - contains the ball mode of this mesh
* @param[in] dBallRadius - default ball radius of balls for the beamlattice
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_setballoptions(Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeBallMode eBallMode, Lib3MF_double dBallRadius);

/**
* Returns the beam count of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[out] pCount - filled with the beam count.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_getbeamcount(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 * pCount);

/**
* Returns indices, radii and capmodes of a single beam of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] nIndex - Index of the beam (0 to beamcount - 1).
* @param[out] pBeamInfo - filled with the beam indices, radii and capmodes.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_getbeam(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, sLib3MFBeam * pBeamInfo);

/**
* Adds a single beam to a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] pBeamInfo - contains the node indices, radii and capmodes.
* @param[out] pIndex - filled with the new Index of the beam.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_addbeam(Lib3MF_BeamLattice pBeamLattice, const sLib3MFBeam * pBeamInfo, Lib3MF_uint32 * pIndex);

/**
* Sets the indices, radii and capmodes of a single beam of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] nIndex - Index of the beam (0 to beamcount - 1).
* @param[in] pBeamInfo - filled with the beam indices, radii and capmodes.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_setbeam(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, const sLib3MFBeam * pBeamInfo);

/**
* Sets all beam indices, radii and capmodes of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] nBeamInfoBufferSize - Number of elements in buffer
* @param[in] pBeamInfoBuffer - Beam buffer of contains information of a number of  beams
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_setbeams(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint64 nBeamInfoBufferSize, const sLib3MFBeam * pBeamInfoBuffer);

/**
* obtains all beam indices, radii and capmodes of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] nBeamInfoBufferSize - Number of elements in buffer
* @param[out] pBeamInfoNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pBeamInfoBuffer - Beam  buffer of contains information of all beams
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_getbeams(Lib3MF_BeamLattice pBeamLattice, const Lib3MF_uint64 nBeamInfoBufferSize, Lib3MF_uint64* pBeamInfoNeededCount, sLib3MFBeam * pBeamInfoBuffer);

/**
* Returns the ball count of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[out] pCount - filled with the ball count.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_getballcount(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 * pCount);

/**
* Returns index and radius of a single ball of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] nIndex - Index of the ball (0 to ballcount - 1).
* @param[out] pBallInfo - filled with the ball node index and radius.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_getball(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, sLib3MFBall * pBallInfo);

/**
* Adds a single ball to a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] pBallInfo - contains the node index and radius.
* @param[out] pIndex - filled with the new Index of the ball.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_addball(Lib3MF_BeamLattice pBeamLattice, const sLib3MFBall * pBallInfo, Lib3MF_uint32 * pIndex);

/**
* Sets the index and radius of a single ball of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] nIndex - Index of the ball (0 to ballcount - 1).
* @param[in] pBallInfo - filled with the ball node index and radius.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_setball(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, const sLib3MFBall * pBallInfo);

/**
* Sets all ball indices and radii of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] nBallInfoBufferSize - Number of elements in buffer
* @param[in] pBallInfoBuffer - Ball buffer of contains information of a number of  balls
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_setballs(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint64 nBallInfoBufferSize, const sLib3MFBall * pBallInfoBuffer);

/**
* obtains all ball indices and radii of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] nBallInfoBufferSize - Number of elements in buffer
* @param[out] pBallInfoNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pBallInfoBuffer - Ball  buffer of contains information of all balls
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_getballs(Lib3MF_BeamLattice pBeamLattice, const Lib3MF_uint64 nBallInfoBufferSize, Lib3MF_uint64* pBallInfoNeededCount, sLib3MFBall * pBallInfoBuffer);

/**
* Returns the number of beamsets of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[out] pCount - filled with the beamset count.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_getbeamsetcount(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 * pCount);

/**
* Adds an empty beamset to a mesh object
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[out] pBeamSet - the new beamset
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_addbeamset(Lib3MF_BeamLattice pBeamLattice, Lib3MF_BeamSet * pBeamSet);

/**
* Returns a beamset of a mesh object
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] nIndex - index of the requested beamset (0 ... beamsetcount-1).
* @param[out] pBeamSet - the requested beamset
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlattice_getbeamset(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, Lib3MF_BeamSet * pBeamSet);

/*************************************************************************************************************************
 Class definition for FunctionReference
**************************************************************************************************************************/

/**
* Returns the UniqueResourceID of the Function. Only functions with a 'pos'-input are allowed.
*
* @param[in] pFunctionReference - FunctionReference instance.
* @param[out] pUniqueResourceID - returns the UniqueResourceID.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functionreference_getfunctionresourceid(Lib3MF_FunctionReference pFunctionReference, Lib3MF_uint32 * pUniqueResourceID);

/**
* Sets the UniqueResourceID to refer to.
*
* @param[in] pFunctionReference - FunctionReference instance.
* @param[in] nUniqueResourceID - UniqueResourceID of the function
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functionreference_setfunctionresourceid(Lib3MF_FunctionReference pFunctionReference, Lib3MF_uint32 nUniqueResourceID);

/**
* Returns the transformation matrix into the coordinate system of the referenced Function.
*
* @param[in] pFunctionReference - FunctionReference instance.
* @param[out] pTransform - the transformation matrix
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functionreference_gettransform(Lib3MF_FunctionReference pFunctionReference, sLib3MFTransform * pTransform);

/**
* Sets the transformation matrix into the coordinate system of the referenced Function.
*
* @param[in] pFunctionReference - FunctionReference instance.
* @param[in] pTransform - new transformation matrix
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functionreference_settransform(Lib3MF_FunctionReference pFunctionReference, const sLib3MFTransform * pTransform);

/**
* Returns the name of the function output channel to use.
*
* @param[in] pFunctionReference - FunctionReference instance.
* @param[in] nChannelNameBufferSize - size of the buffer (including trailing 0)
* @param[out] pChannelNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pChannelNameBuffer -  buffer of the name of the function output channel, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functionreference_getchannelname(Lib3MF_FunctionReference pFunctionReference, const Lib3MF_uint32 nChannelNameBufferSize, Lib3MF_uint32* pChannelNameNeededChars, char * pChannelNameBuffer);

/**
* Sets the name of the function output channel to use.
*
* @param[in] pFunctionReference - FunctionReference instance.
* @param[in] pChannelName - new name of the function output channel
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functionreference_setchannelname(Lib3MF_FunctionReference pFunctionReference, const char * pChannelName);

/**
* Sets the minimal feature size as a hint for the function evaluator
*
* @param[in] pFunctionReference - FunctionReference instance.
* @param[in] dMinFeatureSize - minimal feature size
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functionreference_setminfeaturesize(Lib3MF_FunctionReference pFunctionReference, Lib3MF_double dMinFeatureSize);

/**
* Returns the minimal feature size as a hint for the function evaluator
*
* @param[in] pFunctionReference - FunctionReference instance.
* @param[out] pMinFeatureSize - minimal feature size
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functionreference_getminfeaturesize(Lib3MF_FunctionReference pFunctionReference, Lib3MF_double * pMinFeatureSize);

/**
* Sets the fallback value to use if the function evaluation fails (e.g. evaluates to NaN or Inf).
*
* @param[in] pFunctionReference - FunctionReference instance.
* @param[in] dFallBackValue - fallback value
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functionreference_setfallbackvalue(Lib3MF_FunctionReference pFunctionReference, Lib3MF_double dFallBackValue);

/**
* Returns the fallback value to use if the function evaluation fails (e.g. evaluates to NaN or Inf).
*
* @param[in] pFunctionReference - FunctionReference instance.
* @param[out] pFallBackValue - fallback value
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functionreference_getfallbackvalue(Lib3MF_FunctionReference pFunctionReference, Lib3MF_double * pFallBackValue);

/*************************************************************************************************************************
 Class definition for VolumeDataColor
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for MaterialMapping
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for VolumeDataComposite
**************************************************************************************************************************/

/**
* Returns the BaseMaterialGroup used within this volume data item
*
* @param[in] pVolumeDataComposite - VolumeDataComposite instance.
* @param[out] pBaseMaterialGroupInstance - The BaseMaterialGroup instance of this VolumeDataComposite element
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_volumedatacomposite_getbasematerialgroup(Lib3MF_VolumeDataComposite pVolumeDataComposite, Lib3MF_BaseMaterialGroup * pBaseMaterialGroupInstance);

/**
* Sets the BaseMaterialGroup to use within this volume data item.
*
* @param[in] pVolumeDataComposite - VolumeDataComposite instance.
* @param[in] pBaseMaterialGroupInstance - The new BaseMaterialGroup instance of this VolumeDataComposite element
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_volumedatacomposite_setbasematerialgroup(Lib3MF_VolumeDataComposite pVolumeDataComposite, Lib3MF_BaseMaterialGroup pBaseMaterialGroupInstance);

/**
* Returns the number of material mappings of this VolumeDataComposite element
*
* @param[in] pVolumeDataComposite - VolumeDataComposite instance.
* @param[out] pCount - the number of material mappings.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_volumedatacomposite_getmaterialmappingcount(Lib3MF_VolumeDataComposite pVolumeDataComposite, Lib3MF_uint32 * pCount);

/**
* Returns MaterialMapping with given index
*
* @param[in] pVolumeDataComposite - VolumeDataComposite instance.
* @param[in] nIndex - Index of the MaterialMapping in question.
* @param[out] pTheMaterialMapping - MaterialMapping used in this element
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_volumedatacomposite_getmaterialmapping(Lib3MF_VolumeDataComposite pVolumeDataComposite, Lib3MF_uint32 nIndex, Lib3MF_MaterialMapping * pTheMaterialMapping);

/**
* Adds a MaterialMapping
*
* @param[in] pVolumeDataComposite - VolumeDataComposite instance.
* @param[in] pTransform - new transformation matrix
* @param[out] pTheMaterialMapping - The new MaterialMapping
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_volumedatacomposite_addmaterialmapping(Lib3MF_VolumeDataComposite pVolumeDataComposite, const sLib3MFTransform * pTransform, Lib3MF_MaterialMapping * pTheMaterialMapping);

/**
* Removes the MaterialMapping with given index
*
* @param[in] pVolumeDataComposite - VolumeDataComposite instance.
* @param[in] nIndex - The index of the MaterialMapping to be removed.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_volumedatacomposite_removematerialmapping(Lib3MF_VolumeDataComposite pVolumeDataComposite, Lib3MF_uint32 nIndex);

/*************************************************************************************************************************
 Class definition for VolumeDataProperty
**************************************************************************************************************************/

/**
* Gets the qualified name of this property.
*
* @param[in] pVolumeDataProperty - VolumeDataProperty instance.
* @param[in] nPropertyNameBufferSize - size of the buffer (including trailing 0)
* @param[out] pPropertyNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pPropertyNameBuffer -  buffer of The qualified name of this property., may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_volumedataproperty_getname(Lib3MF_VolumeDataProperty pVolumeDataProperty, const Lib3MF_uint32 nPropertyNameBufferSize, Lib3MF_uint32* pPropertyNameNeededChars, char * pPropertyNameBuffer);

/**
* Sets whether this property is required to process this 3MF document instance.
*
* @param[in] pVolumeDataProperty - VolumeDataProperty instance.
* @param[in] bIsRequired - New value for whether this property is required to process this 3MF document instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_volumedataproperty_setisrequired(Lib3MF_VolumeDataProperty pVolumeDataProperty, bool bIsRequired);

/**
* Returns whether this property is required to process this 3MF document instance.
*
* @param[in] pVolumeDataProperty - VolumeDataProperty instance.
* @param[out] pIsRequired - Is this property required to process this 3MF document instance?
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_volumedataproperty_isrequired(Lib3MF_VolumeDataProperty pVolumeDataProperty, bool * pIsRequired);

/*************************************************************************************************************************
 Class definition for VolumeData
**************************************************************************************************************************/

/**
* Returns the VolumeDataComposite of this VolumeData instance
*
* @param[in] pVolumeData - VolumeData instance.
* @param[out] pTheCompositeData - filled with the VolumeDataComposite of this VolumeData instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_volumedata_getcomposite(Lib3MF_VolumeData pVolumeData, Lib3MF_VolumeDataComposite * pTheCompositeData);

/**
* Creates a new VolumeDataComposite for this VolumeData instance
*
* @param[in] pVolumeData - VolumeData instance.
* @param[out] pTheCompositeData - The new VolumeDataComposite of this VolumeData instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_volumedata_createnewcomposite(Lib3MF_VolumeData pVolumeData, Lib3MF_VolumeDataComposite * pTheCompositeData);

/**
* Removes the VolumeDataComposite of this VolumeData instance
*
* @param[in] pVolumeData - VolumeData instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_volumedata_removecomposite(Lib3MF_VolumeData pVolumeData);

/**
* Returns the VolumeDataColor of this VolumeData instance
*
* @param[in] pVolumeData - VolumeData instance.
* @param[out] pTheColorData - filled with the VolumeDataColor of this VolumeData instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_volumedata_getcolor(Lib3MF_VolumeData pVolumeData, Lib3MF_VolumeDataColor * pTheColorData);

/**
* Creates a new VolumeDataColor for this VolumeData instance
*
* @param[in] pVolumeData - VolumeData instance.
* @param[in] pTheFunction - Function used in this element
* @param[out] pTheColorData - The new VolumeDataColor of this VolumeData instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_volumedata_createnewcolor(Lib3MF_VolumeData pVolumeData, Lib3MF_Function pTheFunction, Lib3MF_VolumeDataColor * pTheColorData);

/**
* Removes the VolumeDataColor of this VolumeData instance
*
* @param[in] pVolumeData - VolumeData instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_volumedata_removecolor(Lib3MF_VolumeData pVolumeData);

/**
* Returns the number of VolumeDataProperty
*
* @param[in] pVolumeData - VolumeData instance.
* @param[out] pCount - the number of VolumeDataProperty-elements within this VolumeData
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_volumedata_getpropertycount(Lib3MF_VolumeData pVolumeData, Lib3MF_uint32 * pCount);

/**
* Returns the VolumeDataProperty at a given Index
*
* @param[in] pVolumeData - VolumeData instance.
* @param[in] nIndex - the index of the VolumeDataProperty to be returned.
* @param[out] pTheVolumeDataProperty - the VolumeDataProperty at the given index.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_volumedata_getproperty(Lib3MF_VolumeData pVolumeData, Lib3MF_uint32 nIndex, Lib3MF_VolumeDataProperty * pTheVolumeDataProperty);

/**
* Adds a new VolumeDataProperty from a Function
*
* @param[in] pVolumeData - VolumeData instance.
* @param[in] pName - the qualified name (namespace+name) of the Property
* @param[in] pTheFunction - Function used in this element
* @param[out] pTheVolumeDataProperty - the newly created VolumeDataProperty.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_volumedata_addpropertyfromfunction(Lib3MF_VolumeData pVolumeData, const char * pName, Lib3MF_Function pTheFunction, Lib3MF_VolumeDataProperty * pTheVolumeDataProperty);

/**
* Removes the VolumeDataProperty with a given index
*
* @param[in] pVolumeData - VolumeData instance.
* @param[in] nIndex - the index of the VolumeDataProperty to be removed.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_volumedata_removeproperty(Lib3MF_VolumeData pVolumeData, Lib3MF_uint32 nIndex);

/*************************************************************************************************************************
 Class definition for Component
**************************************************************************************************************************/

/**
* Returns the Resource Instance of the component.
*
* @param[in] pComponent - Component instance.
* @param[out] pObjectResource - filled with the Resource Instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_component_getobjectresource(Lib3MF_Component pComponent, Lib3MF_Object * pObjectResource);

/**
* Returns the UniqueResourceID of the component.
*
* @param[in] pComponent - Component instance.
* @param[out] pUniqueResourceID - returns the UniqueResourceID.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_component_getobjectresourceid(Lib3MF_Component pComponent, Lib3MF_uint32 * pUniqueResourceID);

/**
* returns, whether a component has a UUID and, if true, the component's UUID
*
* @param[in] pComponent - Component instance.
* @param[out] pHasUUID - flag whether the component has a UUID
* @param[in] nUUIDBufferSize - size of the buffer (including trailing 0)
* @param[out] pUUIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pUUIDBuffer -  buffer of the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx', may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_component_getuuid(Lib3MF_Component pComponent, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer);

/**
* sets the component's UUID
*
* @param[in] pComponent - Component instance.
* @param[in] pUUID - the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_component_setuuid(Lib3MF_Component pComponent, const char * pUUID);

/**
* Returns, if the component has a different transformation than the identity matrix
*
* @param[in] pComponent - Component instance.
* @param[out] pHasTransform - if true is returned, the transformation is not equal than the identity
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_component_hastransform(Lib3MF_Component pComponent, bool * pHasTransform);

/**
* Returns the transformation matrix of the component.
*
* @param[in] pComponent - Component instance.
* @param[out] pTransform - filled with the component transformation matrix
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_component_gettransform(Lib3MF_Component pComponent, sLib3MFTransform * pTransform);

/**
* Sets the transformation matrix of the component.
*
* @param[in] pComponent - Component instance.
* @param[in] pTransform - new transformation matrix
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_component_settransform(Lib3MF_Component pComponent, const sLib3MFTransform * pTransform);

/*************************************************************************************************************************
 Class definition for ComponentsObject
**************************************************************************************************************************/

/**
* Adds a new component to a components object.
*
* @param[in] pComponentsObject - ComponentsObject instance.
* @param[in] pObjectResource - object to add as component. Must not lead to circular references!
* @param[in] pTransform - optional transform matrix for the component.
* @param[out] pComponentInstance - new component instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_componentsobject_addcomponent(Lib3MF_ComponentsObject pComponentsObject, Lib3MF_Object pObjectResource, const sLib3MFTransform * pTransform, Lib3MF_Component * pComponentInstance);

/**
* Retrieves a component from a component object.
*
* @param[in] pComponentsObject - ComponentsObject instance.
* @param[in] nIndex - index of the component to retrieve (0 to componentcount - 1)
* @param[out] pComponentInstance - component instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_componentsobject_getcomponent(Lib3MF_ComponentsObject pComponentsObject, Lib3MF_uint32 nIndex, Lib3MF_Component * pComponentInstance);

/**
* Retrieves a component count of a component object.
*
* @param[in] pComponentsObject - ComponentsObject instance.
* @param[out] pCount - returns the component count
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_componentsobject_getcomponentcount(Lib3MF_ComponentsObject pComponentsObject, Lib3MF_uint32 * pCount);

/*************************************************************************************************************************
 Class definition for BeamSet
**************************************************************************************************************************/

/**
* Sets a beamset's name string
*
* @param[in] pBeamSet - BeamSet instance.
* @param[in] pName - new name of the beamset.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamset_setname(Lib3MF_BeamSet pBeamSet, const char * pName);

/**
* Retrieves a beamset's name string
*
* @param[in] pBeamSet - BeamSet instance.
* @param[in] nNameBufferSize - size of the buffer (including trailing 0)
* @param[out] pNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pNameBuffer -  buffer of returns the name of the beamset., may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamset_getname(Lib3MF_BeamSet pBeamSet, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer);

/**
* Sets a beamset's identifier string
*
* @param[in] pBeamSet - BeamSet instance.
* @param[in] pIdentifier - new name of the beamset.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamset_setidentifier(Lib3MF_BeamSet pBeamSet, const char * pIdentifier);

/**
* Retrieves a beamset's identifier string
*
* @param[in] pBeamSet - BeamSet instance.
* @param[in] nIdentifierBufferSize - size of the buffer (including trailing 0)
* @param[out] pIdentifierNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pIdentifierBuffer -  buffer of returns the identifier of the beamset., may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamset_getidentifier(Lib3MF_BeamSet pBeamSet, const Lib3MF_uint32 nIdentifierBufferSize, Lib3MF_uint32* pIdentifierNeededChars, char * pIdentifierBuffer);

/**
* Retrieves the reference count of a beamset
*
* @param[in] pBeamSet - BeamSet instance.
* @param[out] pCount - returns the reference count
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamset_getreferencecount(Lib3MF_BeamSet pBeamSet, Lib3MF_uint32 * pCount);

/**
* Sets the references of a beamset
*
* @param[in] pBeamSet - BeamSet instance.
* @param[in] nReferencesBufferSize - Number of elements in buffer
* @param[in] pReferencesBuffer - uint32 buffer of the new indices of all beams in this beamset
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamset_setreferences(Lib3MF_BeamSet pBeamSet, Lib3MF_uint64 nReferencesBufferSize, const Lib3MF_uint32 * pReferencesBuffer);

/**
* Retrieves the references of a beamset
*
* @param[in] pBeamSet - BeamSet instance.
* @param[in] nReferencesBufferSize - Number of elements in buffer
* @param[out] pReferencesNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pReferencesBuffer - uint32  buffer of retrieves the indices of all beams in this beamset
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamset_getreferences(Lib3MF_BeamSet pBeamSet, const Lib3MF_uint64 nReferencesBufferSize, Lib3MF_uint64* pReferencesNeededCount, Lib3MF_uint32 * pReferencesBuffer);

/**
* Retrieves the ball reference count of a beamset
*
* @param[in] pBeamSet - BeamSet instance.
* @param[out] pCount - returns the ball reference count
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamset_getballreferencecount(Lib3MF_BeamSet pBeamSet, Lib3MF_uint32 * pCount);

/**
* Sets the ball references of a beamset
*
* @param[in] pBeamSet - BeamSet instance.
* @param[in] nBallReferencesBufferSize - Number of elements in buffer
* @param[in] pBallReferencesBuffer - uint32 buffer of the new indices of all balls in this beamset
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamset_setballreferences(Lib3MF_BeamSet pBeamSet, Lib3MF_uint64 nBallReferencesBufferSize, const Lib3MF_uint32 * pBallReferencesBuffer);

/**
* Retrieves the ball references of a beamset
*
* @param[in] pBeamSet - BeamSet instance.
* @param[in] nBallReferencesBufferSize - Number of elements in buffer
* @param[out] pBallReferencesNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pBallReferencesBuffer - uint32  buffer of retrieves the indices of all balls in this beamset
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamset_getballreferences(Lib3MF_BeamSet pBeamSet, const Lib3MF_uint64 nBallReferencesBufferSize, Lib3MF_uint64* pBallReferencesNeededCount, Lib3MF_uint32 * pBallReferencesBuffer);

/*************************************************************************************************************************
 Class definition for BaseMaterialGroup
**************************************************************************************************************************/

/**
* Retrieves the count of base materials in the material group.
*
* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
* @param[out] pCount - returns the count of base materials.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_basematerialgroup_getcount(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 * pCount);

/**
* returns all the PropertyIDs of all materials in this group
*
* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pPropertyIDsBuffer - uint32  buffer of PropertyID of the material in the material group.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_basematerialgroup_getallpropertyids(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer);

/**
* Adds a new material to the material group
*
* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
* @param[in] pName - new name of the base material.
* @param[in] pDisplayColor - Display color of the material
* @param[out] pPropertyID - returns new PropertyID of the new material in the material group.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_basematerialgroup_addmaterial(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, const char * pName, const sLib3MFColor * pDisplayColor, Lib3MF_uint32 * pPropertyID);

/**
* Removes a material from the material group.
*
* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
* @param[in] nPropertyID - PropertyID of the material in the material group.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_basematerialgroup_removematerial(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID);

/**
* Returns the base material's name
*
* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
* @param[in] nPropertyID - PropertyID of the material in the material group.
* @param[in] nNameBufferSize - size of the buffer (including trailing 0)
* @param[out] pNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pNameBuffer -  buffer of returns the name of the base material., may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_basematerialgroup_getname(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer);

/**
* Sets a base material's name
*
* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
* @param[in] nPropertyID - PropertyID of the material in the material group.
* @param[in] pName - new name of the base material.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_basematerialgroup_setname(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, const char * pName);

/**
* Sets a base material's display color.
*
* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
* @param[in] nPropertyID - PropertyID of the material in the material group.
* @param[in] pTheColor - The base material's display color
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_basematerialgroup_setdisplaycolor(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, const sLib3MFColor * pTheColor);

/**
* Returns a base material's display color.
*
* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
* @param[in] nPropertyID - PropertyID of the material in the material group.
* @param[out] pTheColor - The base material's display color
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_basematerialgroup_getdisplaycolor(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, sLib3MFColor * pTheColor);

/*************************************************************************************************************************
 Class definition for ColorGroup
**************************************************************************************************************************/

/**
* Retrieves the count of base materials in this Color Group.
*
* @param[in] pColorGroup - ColorGroup instance.
* @param[out] pCount - returns the count of colors within this color group.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_colorgroup_getcount(Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 * pCount);

/**
* returns all the PropertyIDs of all colors within this group
*
* @param[in] pColorGroup - ColorGroup instance.
* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pPropertyIDsBuffer - uint32  buffer of PropertyID of the color in the color group.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_colorgroup_getallpropertyids(Lib3MF_ColorGroup pColorGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer);

/**
* Adds a new value.
*
* @param[in] pColorGroup - ColorGroup instance.
* @param[in] pTheColor - The new color
* @param[out] pPropertyID - PropertyID of the new color within this color group.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_colorgroup_addcolor(Lib3MF_ColorGroup pColorGroup, const sLib3MFColor * pTheColor, Lib3MF_uint32 * pPropertyID);

/**
* Removes a color from the color group.
*
* @param[in] pColorGroup - ColorGroup instance.
* @param[in] nPropertyID - PropertyID of the color to be removed from the color group.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_colorgroup_removecolor(Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 nPropertyID);

/**
* Sets a color value.
*
* @param[in] pColorGroup - ColorGroup instance.
* @param[in] nPropertyID - PropertyID of a color within this color group.
* @param[in] pTheColor - The color
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_colorgroup_setcolor(Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 nPropertyID, const sLib3MFColor * pTheColor);

/**
* Sets a color value.
*
* @param[in] pColorGroup - ColorGroup instance.
* @param[in] nPropertyID - PropertyID of a color within this color group.
* @param[out] pTheColor - The color
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_colorgroup_getcolor(Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 nPropertyID, sLib3MFColor * pTheColor);

/*************************************************************************************************************************
 Class definition for Texture2DGroup
**************************************************************************************************************************/

/**
* Retrieves the count of tex2coords in the Texture2DGroup.
*
* @param[in] pTexture2DGroup - Texture2DGroup instance.
* @param[out] pCount - returns the count of tex2coords.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_texture2dgroup_getcount(Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_uint32 * pCount);

/**
* returns all the PropertyIDs of all tex2coords in this Texture2DGroup
*
* @param[in] pTexture2DGroup - Texture2DGroup instance.
* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pPropertyIDsBuffer - uint32  buffer of PropertyID of the tex2coords in the Texture2DGroup.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_texture2dgroup_getallpropertyids(Lib3MF_Texture2DGroup pTexture2DGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer);

/**
* Adds a new tex2coord to the Texture2DGroup
*
* @param[in] pTexture2DGroup - Texture2DGroup instance.
* @param[in] pUVCoordinate - The u/v-coordinate within the texture, horizontally right/vertically up from the origin in the lower left of the texture.
* @param[out] pPropertyID - returns new PropertyID of the new tex2coord in the Texture2DGroup.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_texture2dgroup_addtex2coord(Lib3MF_Texture2DGroup pTexture2DGroup, const sLib3MFTex2Coord * pUVCoordinate, Lib3MF_uint32 * pPropertyID);

/**
* Obtains a tex2coord to the Texture2DGroup
*
* @param[in] pTexture2DGroup - Texture2DGroup instance.
* @param[in] nPropertyID - the PropertyID of the tex2coord in the Texture2DGroup.
* @param[out] pUVCoordinate - The u/v-coordinate within the texture, horizontally right/vertically up from the origin in the lower left of the texture.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_texture2dgroup_gettex2coord(Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_uint32 nPropertyID, sLib3MFTex2Coord * pUVCoordinate);

/**
* Removes a tex2coords from the Texture2DGroup.
*
* @param[in] pTexture2DGroup - Texture2DGroup instance.
* @param[in] nPropertyID - PropertyID of the tex2coords in the Texture2DGroup.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_texture2dgroup_removetex2coord(Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_uint32 nPropertyID);

/**
* Obtains the texture2D instance of this group.
*
* @param[in] pTexture2DGroup - Texture2DGroup instance.
* @param[out] pTexture2DInstance - the texture2D instance of this group.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_texture2dgroup_gettexture2d(Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_Texture2D * pTexture2DInstance);

/*************************************************************************************************************************
 Class definition for CompositeMaterials
**************************************************************************************************************************/

/**
* Retrieves the count of Composite-s in the CompositeMaterials.
*
* @param[in] pCompositeMaterials - CompositeMaterials instance.
* @param[out] pCount - returns the count of Composite-s
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_compositematerials_getcount(Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint32 * pCount);

/**
* returns all the PropertyIDs of all Composite-Mixing Values in this CompositeMaterials
*
* @param[in] pCompositeMaterials - CompositeMaterials instance.
* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pPropertyIDsBuffer - uint32  buffer of PropertyID of the Composite-Mixing Values in the CompositeMaterials.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_compositematerials_getallpropertyids(Lib3MF_CompositeMaterials pCompositeMaterials, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer);

/**
* Obtains the BaseMaterialGroup instance of this CompositeMaterials.
*
* @param[in] pCompositeMaterials - CompositeMaterials instance.
* @param[out] pBaseMaterialGroupInstance - returns the BaseMaterialGroup instance of this CompositeMaterials
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_compositematerials_getbasematerialgroup(Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_BaseMaterialGroup * pBaseMaterialGroupInstance);

/**
* Adds a new Composite-Mixing Values to the CompositeMaterials.
*
* @param[in] pCompositeMaterials - CompositeMaterials instance.
* @param[in] nCompositeBufferSize - Number of elements in buffer
* @param[in] pCompositeBuffer - CompositeConstituent buffer of The Composite Constituents to be added as composite
* @param[out] pPropertyID - returns new PropertyID of the new Composite in the CompositeMaterials.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_compositematerials_addcomposite(Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint64 nCompositeBufferSize, const sLib3MFCompositeConstituent * pCompositeBuffer, Lib3MF_uint32 * pPropertyID);

/**
* Removes a Composite-Maxing Ratio from the CompositeMaterials.
*
* @param[in] pCompositeMaterials - CompositeMaterials instance.
* @param[in] nPropertyID - PropertyID of the  Composite-Mixing Values in the CompositeMaterials to be removed.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_compositematerials_removecomposite(Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint32 nPropertyID);

/**
* Obtains a Composite-Maxing Ratio of this CompositeMaterials.
*
* @param[in] pCompositeMaterials - CompositeMaterials instance.
* @param[in] nPropertyID - the PropertyID of the Composite-Maxing Ratio in the CompositeMaterials.
* @param[in] nCompositeBufferSize - Number of elements in buffer
* @param[out] pCompositeNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pCompositeBuffer - CompositeConstituent  buffer of The Composite-Mixing Values with the given PropertyID
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_compositematerials_getcomposite(Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint32 nPropertyID, const Lib3MF_uint64 nCompositeBufferSize, Lib3MF_uint64* pCompositeNeededCount, sLib3MFCompositeConstituent * pCompositeBuffer);

/*************************************************************************************************************************
 Class definition for MultiPropertyGroup
**************************************************************************************************************************/

/**
* Retrieves the count of MultiProperty-s in the MultiPropertyGroup.
*
* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
* @param[out] pCount - returns the count of MultiProperty-s
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_multipropertygroup_getcount(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 * pCount);

/**
* returns all the PropertyIDs of all MultiProperty-s in this MultiPropertyGroup
*
* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pPropertyIDsBuffer - uint32  buffer of PropertyID of the MultiProperty-s in the MultiPropertyGroup.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_multipropertygroup_getallpropertyids(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer);

/**
* Adds a new MultiProperty to the MultiPropertyGroup.
*
* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
* @param[in] pPropertyIDsBuffer - uint32 buffer of The PropertyIDs of the new MultiProperty.
* @param[out] pPropertyID - returns the PropertyID of the new MultiProperty in the MultiPropertyGroup.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_multipropertygroup_addmultiproperty(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint64 nPropertyIDsBufferSize, const Lib3MF_uint32 * pPropertyIDsBuffer, Lib3MF_uint32 * pPropertyID);

/**
* Sets the PropertyIDs of a MultiProperty.
*
* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
* @param[in] nPropertyID - the PropertyID of the MultiProperty to be changed.
* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
* @param[in] pPropertyIDsBuffer - uint32 buffer of The new PropertyIDs of the MultiProperty
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_multipropertygroup_setmultiproperty(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nPropertyID, Lib3MF_uint64 nPropertyIDsBufferSize, const Lib3MF_uint32 * pPropertyIDsBuffer);

/**
* Obtains the PropertyIDs of a MultiProperty.
*
* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
* @param[in] nPropertyID - the PropertyID of the MultiProperty to be queried.
* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pPropertyIDsBuffer - uint32  buffer of The PropertyIDs of the MultiProperty
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_multipropertygroup_getmultiproperty(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nPropertyID, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer);

/**
* Removes a MultiProperty from this MultiPropertyGroup.
*
* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
* @param[in] nPropertyID - the PropertyID of the MultiProperty to be removed.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_multipropertygroup_removemultiproperty(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nPropertyID);

/**
* Retrieves the number of layers of this MultiPropertyGroup.
*
* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
* @param[out] pCount - returns the number of layers
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_multipropertygroup_getlayercount(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 * pCount);

/**
* Adds a MultiPropertyLayer to this MultiPropertyGroup.
*
* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
* @param[in] pTheLayer - The MultiPropertyLayer to add to this MultiPropertyGroup
* @param[out] pLayerIndex - returns the index of this MultiPropertyLayer
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_multipropertygroup_addlayer(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, const sLib3MFMultiPropertyLayer * pTheLayer, Lib3MF_uint32 * pLayerIndex);

/**
* Obtains a MultiPropertyLayer of this MultiPropertyGroup.
*
* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
* @param[in] nLayerIndex - The Index of the MultiPropertyLayer queried
* @param[out] pTheLayer - The MultiPropertyLayer with index LayerIndex within MultiPropertyGroup
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_multipropertygroup_getlayer(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nLayerIndex, sLib3MFMultiPropertyLayer * pTheLayer);

/**
* Removes a MultiPropertyLayer from this MultiPropertyGroup.
*
* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
* @param[in] nLayerIndex - The Index of the MultiPropertyLayer to be removed
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_multipropertygroup_removelayer(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nLayerIndex);

/*************************************************************************************************************************
 Class definition for Image3D
**************************************************************************************************************************/

/**
* returns the name of this Image3D
*
* @param[in] pImage3D - Image3D instance.
* @param[in] nNameBufferSize - size of the buffer (including trailing 0)
* @param[out] pNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pNameBuffer -  buffer of the name of this Image3D, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_image3d_getname(Lib3MF_Image3D pImage3D, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer);

/**
* sets a new name of this Image3D
*
* @param[in] pImage3D - Image3D instance.
* @param[in] pName - the new name of this Image3D
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_image3d_setname(Lib3MF_Image3D pImage3D, const char * pName);

/**
* Retrieves, if this Image3D is a ImageStack
*
* @param[in] pImage3D - Image3D instance.
* @param[out] pIsImageStack - returns, whether the Image3D is an ImageStack
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_image3d_isimagestack(Lib3MF_Image3D pImage3D, bool * pIsImageStack);

/*************************************************************************************************************************
 Class definition for ImageStack
**************************************************************************************************************************/

/**
* Retrieves the number of rows in each image of this image3d
*
* @param[in] pImageStack - ImageStack instance.
* @param[out] pRowCount - number of rows
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_imagestack_getrowcount(Lib3MF_ImageStack pImageStack, Lib3MF_uint32 * pRowCount);

/**
* Sets the number of rows in each image of this image3d
*
* @param[in] pImageStack - ImageStack instance.
* @param[in] nRowCount - number of rows
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_imagestack_setrowcount(Lib3MF_ImageStack pImageStack, Lib3MF_uint32 nRowCount);

/**
* Retrieves the number of columns in each image of this image3d
*
* @param[in] pImageStack - ImageStack instance.
* @param[out] pColumnCount - number of columns
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_imagestack_getcolumncount(Lib3MF_ImageStack pImageStack, Lib3MF_uint32 * pColumnCount);

/**
* Sets the number of columns in each image of this image3d
*
* @param[in] pImageStack - ImageStack instance.
* @param[in] nColumnCount - number of columns
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_imagestack_setcolumncount(Lib3MF_ImageStack pImageStack, Lib3MF_uint32 nColumnCount);

/**
* Retrieves the number of images in the stack.
*
* @param[in] pImageStack - ImageStack instance.
* @param[out] pSheetCount - number of images
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_imagestack_getsheetcount(Lib3MF_ImageStack pImageStack, Lib3MF_uint32 * pSheetCount);

/**
* Retrieves a sheet of the stack. Raises an error if sheet is not set.
*
* @param[in] pImageStack - ImageStack instance.
* @param[in] nIndex - index of the image (0-based)
* @param[out] pSheet - attachment containing the image
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_imagestack_getsheet(Lib3MF_ImageStack pImageStack, Lib3MF_uint32 nIndex, Lib3MF_Attachment * pSheet);

/**
* Sets a sheet to an existing attachment.
*
* @param[in] pImageStack - ImageStack instance.
* @param[in] nIndex - index of the image (0-based)
* @param[in] pSheet - attachment containing the image
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_imagestack_setsheet(Lib3MF_ImageStack pImageStack, Lib3MF_uint32 nIndex, Lib3MF_Attachment pSheet);

/**
* Creates a new sheet attachment with empty data.
*
* @param[in] pImageStack - ImageStack instance.
* @param[in] nIndex - index of the image (0-based)
* @param[in] pPath - path of part in the package
* @param[out] pSheet - attachment containing the image
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_imagestack_createemptysheet(Lib3MF_ImageStack pImageStack, Lib3MF_uint32 nIndex, const char * pPath, Lib3MF_Attachment * pSheet);

/**
* Creates a new sheet attachment from a memory buffer.
*
* @param[in] pImageStack - ImageStack instance.
* @param[in] nIndex - index of the image (0-based)
* @param[in] pPath - path of part in the package
* @param[in] nDataBufferSize - Number of elements in buffer
* @param[in] pDataBuffer - uint8 buffer of binary image data
* @param[out] pSheet - attachment containing the image
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_imagestack_createsheetfrombuffer(Lib3MF_ImageStack pImageStack, Lib3MF_uint32 nIndex, const char * pPath, Lib3MF_uint64 nDataBufferSize, const Lib3MF_uint8 * pDataBuffer, Lib3MF_Attachment * pSheet);

/**
* Creates a new sheet attachment from a file on disk.
*
* @param[in] pImageStack - ImageStack instance.
* @param[in] nIndex - index of the image (0-based)
* @param[in] pPath - path of part in the package
* @param[in] pFileName - file name to read from
* @param[out] pSheet - attachment containing the image
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_imagestack_createsheetfromfile(Lib3MF_ImageStack pImageStack, Lib3MF_uint32 nIndex, const char * pPath, const char * pFileName, Lib3MF_Attachment * pSheet);

/*************************************************************************************************************************
 Class definition for Attachment
**************************************************************************************************************************/

/**
* Retrieves an attachment's package path. This function will be removed in a later release.
*
* @param[in] pAttachment - Attachment instance.
* @param[in] nPathBufferSize - size of the buffer (including trailing 0)
* @param[out] pPathNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pPathBuffer -  buffer of returns the attachment's package path string, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_attachment_getpath(Lib3MF_Attachment pAttachment, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer);

/**
* Sets an attachment's package path. This function will be removed in a later release.
*
* @param[in] pAttachment - Attachment instance.
* @param[in] pPath - new path of the attachment.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_attachment_setpath(Lib3MF_Attachment pAttachment, const char * pPath);

/**
* Returns the PackagePart that is this attachment.
*
* @param[in] pAttachment - Attachment instance.
* @param[out] pPackagePart - The PackagePart of this attachment.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_attachment_packagepart(Lib3MF_Attachment pAttachment, Lib3MF_PackagePart * pPackagePart);

/**
* Retrieves an attachment's relationship type
*
* @param[in] pAttachment - Attachment instance.
* @param[in] nPathBufferSize - size of the buffer (including trailing 0)
* @param[out] pPathNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pPathBuffer -  buffer of returns the attachment's package relationship type string, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_attachment_getrelationshiptype(Lib3MF_Attachment pAttachment, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer);

/**
* Sets an attachment's relationship type.
*
* @param[in] pAttachment - Attachment instance.
* @param[in] pPath - new relationship type string.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_attachment_setrelationshiptype(Lib3MF_Attachment pAttachment, const char * pPath);

/**
* Writes out the attachment as file.
*
* @param[in] pAttachment - Attachment instance.
* @param[in] pFileName - file to write into.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_attachment_writetofile(Lib3MF_Attachment pAttachment, const char * pFileName);

/**
* Reads an attachment from a file. The path of this file is only read when this attachment is being written as part of the 3MF package, or via the WriteToFile or WriteToBuffer methods.
*
* @param[in] pAttachment - Attachment instance.
* @param[in] pFileName - file to read from.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_attachment_readfromfile(Lib3MF_Attachment pAttachment, const char * pFileName);

/**
* Reads an attachment from the data provided by a callback function. This callback function is only invoked when this attachment is being written as part of the 3MF package, or via the WriteToFile or WriteToBuffer methods.
*
* @param[in] pAttachment - Attachment instance.
* @param[in] pTheReadCallback - Callback to call for reading a data chunk
* @param[in] nStreamSize - number of bytes the callback returns
* @param[in] pTheSeekCallback - Callback to call for seeking in the stream.
* @param[in] pUserData - Userdata that is passed to the callback function
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_attachment_readfromcallback(Lib3MF_Attachment pAttachment, Lib3MFReadCallback pTheReadCallback, Lib3MF_uint64 nStreamSize, Lib3MFSeekCallback pTheSeekCallback, Lib3MF_pvoid pUserData);

/**
* Retrieves the size of the attachment stream
*
* @param[in] pAttachment - Attachment instance.
* @param[out] pStreamSize - the stream size
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_attachment_getstreamsize(Lib3MF_Attachment pAttachment, Lib3MF_uint64 * pStreamSize);

/**
* Writes out the attachment into a buffer
*
* @param[in] pAttachment - Attachment instance.
* @param[in] nBufferBufferSize - Number of elements in buffer
* @param[out] pBufferNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pBufferBuffer - uint8  buffer of Buffer to write into
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_attachment_writetobuffer(Lib3MF_Attachment pAttachment, const Lib3MF_uint64 nBufferBufferSize, Lib3MF_uint64* pBufferNeededCount, Lib3MF_uint8 * pBufferBuffer);

/**
* Reads an attachment from a memory buffer. This buffer is immediately read (in contrast to the ReadFromCallback and ReadFromFile-methods).
*
* @param[in] pAttachment - Attachment instance.
* @param[in] nBufferBufferSize - Number of elements in buffer
* @param[in] pBufferBuffer - uint8 buffer of Buffer to read from
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_attachment_readfrombuffer(Lib3MF_Attachment pAttachment, Lib3MF_uint64 nBufferBufferSize, const Lib3MF_uint8 * pBufferBuffer);

/*************************************************************************************************************************
 Class definition for Texture2D
**************************************************************************************************************************/

/**
* Retrieves the attachment located at the path of the texture.
*
* @param[in] pTexture2D - Texture2D instance.
* @param[out] pAttachment - attachment that holds the texture's image information.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_texture2d_getattachment(Lib3MF_Texture2D pTexture2D, Lib3MF_Attachment * pAttachment);

/**
* Sets the texture's package path to the path of the attachment.
*
* @param[in] pTexture2D - Texture2D instance.
* @param[in] pAttachment - attachment that holds the texture's image information.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_texture2d_setattachment(Lib3MF_Texture2D pTexture2D, Lib3MF_Attachment pAttachment);

/**
* Retrieves a texture's content type.
*
* @param[in] pTexture2D - Texture2D instance.
* @param[out] pContentType - returns content type enum.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_texture2d_getcontenttype(Lib3MF_Texture2D pTexture2D, eLib3MFTextureType * pContentType);

/**
* Retrieves a texture's content type.
*
* @param[in] pTexture2D - Texture2D instance.
* @param[in] eContentType - new Content Type
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_texture2d_setcontenttype(Lib3MF_Texture2D pTexture2D, eLib3MFTextureType eContentType);

/**
* Retrieves a texture's tilestyle type.
*
* @param[in] pTexture2D - Texture2D instance.
* @param[out] pTileStyleU - returns tilestyle type enum.
* @param[out] pTileStyleV - returns tilestyle type enum.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_texture2d_gettilestyleuv(Lib3MF_Texture2D pTexture2D, eLib3MFTextureTileStyle * pTileStyleU, eLib3MFTextureTileStyle * pTileStyleV);

/**
* Sets a texture's tilestyle type.
*
* @param[in] pTexture2D - Texture2D instance.
* @param[in] eTileStyleU - new tilestyle type enum.
* @param[in] eTileStyleV - new tilestyle type enum.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_texture2d_settilestyleuv(Lib3MF_Texture2D pTexture2D, eLib3MFTextureTileStyle eTileStyleU, eLib3MFTextureTileStyle eTileStyleV);

/**
* Retrieves a texture's filter type.
*
* @param[in] pTexture2D - Texture2D instance.
* @param[out] pFilter - returns filter type enum.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_texture2d_getfilter(Lib3MF_Texture2D pTexture2D, eLib3MFTextureFilter * pFilter);

/**
* Sets a texture's filter type.
*
* @param[in] pTexture2D - Texture2D instance.
* @param[in] eFilter - sets new filter type enum.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_texture2d_setfilter(Lib3MF_Texture2D pTexture2D, eLib3MFTextureFilter eFilter);

/*************************************************************************************************************************
 Class definition for ImplicitPort
**************************************************************************************************************************/

/**
* Retrieves the identifier of the port
*
* @param[in] pImplicitPort - ImplicitPort instance.
* @param[in] nIdentifierBufferSize - size of the buffer (including trailing 0)
* @param[out] pIdentifierNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pIdentifierBuffer -  buffer of the identifier, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitport_getidentifier(Lib3MF_ImplicitPort pImplicitPort, const Lib3MF_uint32 nIdentifierBufferSize, Lib3MF_uint32* pIdentifierNeededChars, char * pIdentifierBuffer);

/**
* Sets the identifier of the port
*
* @param[in] pImplicitPort - ImplicitPort instance.
* @param[in] pIdentifier - the identifier
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitport_setidentifier(Lib3MF_ImplicitPort pImplicitPort, const char * pIdentifier);

/**
* Retrieves the display name of the port
*
* @param[in] pImplicitPort - ImplicitPort instance.
* @param[in] nDisplayNameBufferSize - size of the buffer (including trailing 0)
* @param[out] pDisplayNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pDisplayNameBuffer -  buffer of the display name, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitport_getdisplayname(Lib3MF_ImplicitPort pImplicitPort, const Lib3MF_uint32 nDisplayNameBufferSize, Lib3MF_uint32* pDisplayNameNeededChars, char * pDisplayNameBuffer);

/**
* Sets the display name of the port
*
* @param[in] pImplicitPort - ImplicitPort instance.
* @param[in] pDisplayName - the display name
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitport_setdisplayname(Lib3MF_ImplicitPort pImplicitPort, const char * pDisplayName);

/**
* Sets the type of the port
*
* @param[in] pImplicitPort - ImplicitPort instance.
* @param[in] eImplicitPortType - the type
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitport_settype(Lib3MF_ImplicitPort pImplicitPort, eLib3MFImplicitPortType eImplicitPortType);

/**
* Retrieves the type of the port
*
* @param[in] pImplicitPort - ImplicitPort instance.
* @param[out] pImplicitPortType - the type
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitport_gettype(Lib3MF_ImplicitPort pImplicitPort, eLib3MFImplicitPortType * pImplicitPortType);

/**
* Retrieves the reference of the port, only used for input ports
*
* @param[in] pImplicitPort - ImplicitPort instance.
* @param[in] nReferenceBufferSize - size of the buffer (including trailing 0)
* @param[out] pReferenceNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pReferenceBuffer -  buffer of the reference, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitport_getreference(Lib3MF_ImplicitPort pImplicitPort, const Lib3MF_uint32 nReferenceBufferSize, Lib3MF_uint32* pReferenceNeededChars, char * pReferenceBuffer);

/**
* Sets the reference of the port, only used for input ports
*
* @param[in] pImplicitPort - ImplicitPort instance.
* @param[in] pReference - the reference
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitport_setreference(Lib3MF_ImplicitPort pImplicitPort, const char * pReference);

/*************************************************************************************************************************
 Class definition for Iterator
**************************************************************************************************************************/

/**
* Iterates to the next item in the list.
*
* @param[in] pIterator - Iterator instance.
* @param[out] pHasNext - Iterates to the next item in the list.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_iterator_movenext(Lib3MF_Iterator pIterator, bool * pHasNext);

/**
* Iterates to the previous item in the list.
*
* @param[in] pIterator - Iterator instance.
* @param[out] pHasPrevious - Iterates to the previous item in the list.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_iterator_moveprevious(Lib3MF_Iterator pIterator, bool * pHasPrevious);

/**
* Returns the number of items the iterator captures.
*
* @param[in] pIterator - Iterator instance.
* @param[out] pCount - returns the number of items the iterator captures.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_iterator_count(Lib3MF_Iterator pIterator, Lib3MF_uint64 * pCount);

/*************************************************************************************************************************
 Class definition for ImplicitPortIterator
**************************************************************************************************************************/

/**
* Returns the current element
*
* @param[in] pImplicitPortIterator - ImplicitPortIterator instance.
* @param[out] pPort - The current element
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitportiterator_getcurrent(Lib3MF_ImplicitPortIterator pImplicitPortIterator, Lib3MF_ImplicitPort * pPort);

/*************************************************************************************************************************
 Class definition for ImplicitNode
**************************************************************************************************************************/

/**
* Retrieves the identifier of the node
*
* @param[in] pImplicitNode - ImplicitNode instance.
* @param[in] nIdentifierBufferSize - size of the buffer (including trailing 0)
* @param[out] pIdentifierNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pIdentifierBuffer -  buffer of the identifier, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitnode_getidentifier(Lib3MF_ImplicitNode pImplicitNode, const Lib3MF_uint32 nIdentifierBufferSize, Lib3MF_uint32* pIdentifierNeededChars, char * pIdentifierBuffer);

/**
* Sets the identifier of the node
*
* @param[in] pImplicitNode - ImplicitNode instance.
* @param[in] pIdentifier - the identifier
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitnode_setidentifier(Lib3MF_ImplicitNode pImplicitNode, const char * pIdentifier);

/**
* Retrieves the display name of the node
*
* @param[in] pImplicitNode - ImplicitNode instance.
* @param[in] nDisplayNameBufferSize - size of the buffer (including trailing 0)
* @param[out] pDisplayNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pDisplayNameBuffer -  buffer of the display name, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitnode_getdisplayname(Lib3MF_ImplicitNode pImplicitNode, const Lib3MF_uint32 nDisplayNameBufferSize, Lib3MF_uint32* pDisplayNameNeededChars, char * pDisplayNameBuffer);

/**
* Sets the display name of the node
*
* @param[in] pImplicitNode - ImplicitNode instance.
* @param[in] pDisplayName - the display name
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitnode_setdisplayname(Lib3MF_ImplicitNode pImplicitNode, const char * pDisplayName);

/**
* Retrieves the tag of the node
*
* @param[in] pImplicitNode - ImplicitNode instance.
* @param[in] nTagBufferSize - size of the buffer (including trailing 0)
* @param[out] pTagNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pTagBuffer -  buffer of the tag, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitnode_gettag(Lib3MF_ImplicitNode pImplicitNode, const Lib3MF_uint32 nTagBufferSize, Lib3MF_uint32* pTagNeededChars, char * pTagBuffer);

/**
* Sets the tag of the node
*
* @param[in] pImplicitNode - ImplicitNode instance.
* @param[in] pTag - the tag
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitnode_settag(Lib3MF_ImplicitNode pImplicitNode, const char * pTag);

/**
* Retrieves the type of the node
*
* @param[in] pImplicitNode - ImplicitNode instance.
* @param[out] pType - the type of the node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitnode_getnodetype(Lib3MF_ImplicitNode pImplicitNode, eLib3MFImplicitNodeType * pType);

/**
* Add an input
*
* @param[in] pImplicitNode - ImplicitNode instance.
* @param[in] pIdentifier - the identifier of the input
* @param[in] pDisplayName - the display name of the input
* @param[out] pPort - 
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitnode_addinput(Lib3MF_ImplicitNode pImplicitNode, const char * pIdentifier, const char * pDisplayName, Lib3MF_ImplicitPort * pPort);

/**
* Retrieves the inputs
*
* @param[in] pImplicitNode - ImplicitNode instance.
* @param[out] pIterator - the iterator for the inputs
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitnode_getinputs(Lib3MF_ImplicitNode pImplicitNode, Lib3MF_ImplicitPortIterator * pIterator);

/**
* Add an output
*
* @param[in] pImplicitNode - ImplicitNode instance.
* @param[in] pIdentifier - the identifier of the output
* @param[in] pDisplayName - the display name of the output
* @param[out] pPort - 
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitnode_addoutput(Lib3MF_ImplicitNode pImplicitNode, const char * pIdentifier, const char * pDisplayName, Lib3MF_ImplicitPort * pPort);

/**
* Retrieves the outputs
*
* @param[in] pImplicitNode - ImplicitNode instance.
* @param[out] pIterator - the iterator the outputs
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitnode_getoutputs(Lib3MF_ImplicitNode pImplicitNode, Lib3MF_ImplicitPortIterator * pIterator);

/**
* Retrieves an input
*
* @param[in] pImplicitNode - ImplicitNode instance.
* @param[in] pIdentifier - the identifier of the input
* @param[out] pInput - the input port
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitnode_findinput(Lib3MF_ImplicitNode pImplicitNode, const char * pIdentifier, Lib3MF_ImplicitPort * pInput);

/**
* Retrieves an output
*
* @param[in] pImplicitNode - ImplicitNode instance.
* @param[in] pIdentifier - the identifier of the output
* @param[out] pOutput - the output port
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitnode_findoutput(Lib3MF_ImplicitNode pImplicitNode, const char * pIdentifier, Lib3MF_ImplicitPort * pOutput);

/**
* Checks if the types of the input and output ports are valid for the node type
*
* @param[in] pImplicitNode - ImplicitNode instance.
* @param[out] pValid - true, if the types are valid
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitnode_aretypesvalid(Lib3MF_ImplicitNode pImplicitNode, bool * pValid);

/*************************************************************************************************************************
 Class definition for OneInputNode
**************************************************************************************************************************/

/**
* Retrieves the input
*
* @param[in] pOneInputNode - OneInputNode instance.
* @param[out] pInput - the input
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_oneinputnode_getinputa(Lib3MF_OneInputNode pOneInputNode, Lib3MF_ImplicitPort * pInput);

/**
* Retrieves the output
*
* @param[in] pOneInputNode - OneInputNode instance.
* @param[out] pResult - the output
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_oneinputnode_getoutputresult(Lib3MF_OneInputNode pOneInputNode, Lib3MF_ImplicitPort * pResult);

/*************************************************************************************************************************
 Class definition for SinNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for CosNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for TanNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for ArcSinNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for ArcCosNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for ArcTanNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for SinhNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for CoshNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for TanhNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for RoundNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for CeilNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for FloorNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for SignNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for FractNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for AbsNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for ExpNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for LogNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for Log2Node
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for Log10Node
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for LengthNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for TransposeNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for InverseNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for SqrtNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for ResourceIdNode
**************************************************************************************************************************/

/**
* Sets the Resource that the resourceid attribute of the node will point to
*
* @param[in] pResourceIdNode - ResourceIdNode instance.
* @param[in] pResource - the resource
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_resourceidnode_setresource(Lib3MF_ResourceIdNode pResourceIdNode, Lib3MF_Resource pResource);

/**
* Retrieves the resource of the node
*
* @param[in] pResourceIdNode - ResourceIdNode instance.
* @param[out] pResource - the resource
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_resourceidnode_getresource(Lib3MF_ResourceIdNode pResourceIdNode, Lib3MF_Resource * pResource);

/**
* Retrieves the output
*
* @param[in] pResourceIdNode - ResourceIdNode instance.
* @param[out] pValue - the output
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_resourceidnode_getoutputvalue(Lib3MF_ResourceIdNode pResourceIdNode, Lib3MF_ImplicitPort * pValue);

/*************************************************************************************************************************
 Class definition for TwoInputNode
**************************************************************************************************************************/

/**
* Retrieves the second input
*
* @param[in] pTwoInputNode - TwoInputNode instance.
* @param[out] pB - the second input
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_twoinputnode_getinputb(Lib3MF_TwoInputNode pTwoInputNode, Lib3MF_ImplicitPort * pB);

/*************************************************************************************************************************
 Class definition for AdditionNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for SubtractionNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for MultiplicationNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for DivisionNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for DotNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for CrossNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for ArcTan2Node
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for MatVecMultiplicationNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for MinNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for MaxNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for FmodNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for ModNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for PowNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for SelectNode
**************************************************************************************************************************/

/**
* Retrieves the second input
*
* @param[in] pSelectNode - SelectNode instance.
* @param[out] pB - the second input
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_selectnode_getinputb(Lib3MF_SelectNode pSelectNode, Lib3MF_ImplicitPort * pB);

/**
* Retrieves the third input
*
* @param[in] pSelectNode - SelectNode instance.
* @param[out] pC - the third input
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_selectnode_getinputc(Lib3MF_SelectNode pSelectNode, Lib3MF_ImplicitPort * pC);

/**
* Retrieves the fourth input
*
* @param[in] pSelectNode - SelectNode instance.
* @param[out] pD - the fourth input
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_selectnode_getinputd(Lib3MF_SelectNode pSelectNode, Lib3MF_ImplicitPort * pD);

/*************************************************************************************************************************
 Class definition for ClampNode
**************************************************************************************************************************/

/**
* Retrieves the input for the lower limit
*
* @param[in] pClampNode - ClampNode instance.
* @param[out] pMin - the input for the lower limit
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_clampnode_getinputmin(Lib3MF_ClampNode pClampNode, Lib3MF_ImplicitPort * pMin);

/**
* Retrieves the input for the upper limit
*
* @param[in] pClampNode - ClampNode instance.
* @param[out] pMax - the input for the upper limit
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_clampnode_getinputmax(Lib3MF_ClampNode pClampNode, Lib3MF_ImplicitPort * pMax);

/*************************************************************************************************************************
 Class definition for ComposeVectorNode
**************************************************************************************************************************/

/**
* Retrieves the input for the x component
*
* @param[in] pComposeVectorNode - ComposeVectorNode instance.
* @param[out] pX - the input for the x component
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_composevectornode_getinputx(Lib3MF_ComposeVectorNode pComposeVectorNode, Lib3MF_ImplicitPort * pX);

/**
* Retrieves the input for the y component
*
* @param[in] pComposeVectorNode - ComposeVectorNode instance.
* @param[out] pY - the input for the y component
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_composevectornode_getinputy(Lib3MF_ComposeVectorNode pComposeVectorNode, Lib3MF_ImplicitPort * pY);

/**
* Retrieves the input for the z component
*
* @param[in] pComposeVectorNode - ComposeVectorNode instance.
* @param[out] pZ - the input for the z component
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_composevectornode_getinputz(Lib3MF_ComposeVectorNode pComposeVectorNode, Lib3MF_ImplicitPort * pZ);

/**
* Retrieves the output
*
* @param[in] pComposeVectorNode - ComposeVectorNode instance.
* @param[out] pResult - the output
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_composevectornode_getoutputresult(Lib3MF_ComposeVectorNode pComposeVectorNode, Lib3MF_ImplicitPort * pResult);

/*************************************************************************************************************************
 Class definition for VectorFromScalarNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for DecomposeVectorNode
**************************************************************************************************************************/

/**
* Retrieves the input
*
* @param[in] pDecomposeVectorNode - DecomposeVectorNode instance.
* @param[out] pA - the input port for the vector to decompose
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_decomposevectornode_getinputa(Lib3MF_DecomposeVectorNode pDecomposeVectorNode, Lib3MF_ImplicitPort * pA);

/**
* Retrieves the output for the x component
*
* @param[in] pDecomposeVectorNode - DecomposeVectorNode instance.
* @param[out] pX - the output for the x component
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_decomposevectornode_getoutputx(Lib3MF_DecomposeVectorNode pDecomposeVectorNode, Lib3MF_ImplicitPort * pX);

/**
* Retrieves the output for the y component
*
* @param[in] pDecomposeVectorNode - DecomposeVectorNode instance.
* @param[out] pY - the output for the y component
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_decomposevectornode_getoutputy(Lib3MF_DecomposeVectorNode pDecomposeVectorNode, Lib3MF_ImplicitPort * pY);

/**
* Retrieves the output for the z component
*
* @param[in] pDecomposeVectorNode - DecomposeVectorNode instance.
* @param[out] pZ - the output for the z component
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_decomposevectornode_getoutputz(Lib3MF_DecomposeVectorNode pDecomposeVectorNode, Lib3MF_ImplicitPort * pZ);

/*************************************************************************************************************************
 Class definition for ComposeMatrixNode
**************************************************************************************************************************/

/**
* Retrieves the input for the element 0 0
*
* @param[in] pComposeMatrixNode - ComposeMatrixNode instance.
* @param[out] pM00 - the input for the m00 element
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_composematrixnode_getinputm00(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM00);

/**
* Retrieves the input for the element 0 1
*
* @param[in] pComposeMatrixNode - ComposeMatrixNode instance.
* @param[out] pM01 - the input for the m01 element
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_composematrixnode_getinputm01(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM01);

/**
* Retrieves the input for the element 0 2
*
* @param[in] pComposeMatrixNode - ComposeMatrixNode instance.
* @param[out] pM02 - the input for the m02 element
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_composematrixnode_getinputm02(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM02);

/**
* Retrieves the input for the element 0 3
*
* @param[in] pComposeMatrixNode - ComposeMatrixNode instance.
* @param[out] pM03 - the input for the m03 element
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_composematrixnode_getinputm03(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM03);

/**
* Retrieves the input for the element 1 0
*
* @param[in] pComposeMatrixNode - ComposeMatrixNode instance.
* @param[out] pM10 - the input for the m10 element
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_composematrixnode_getinputm10(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM10);

/**
* Retrieves the input for the element 1 1
*
* @param[in] pComposeMatrixNode - ComposeMatrixNode instance.
* @param[out] pM11 - the input for the m11 element
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_composematrixnode_getinputm11(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM11);

/**
* Retrieves the input for the element 1 2
*
* @param[in] pComposeMatrixNode - ComposeMatrixNode instance.
* @param[out] pM12 - the input for the m12 element
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_composematrixnode_getinputm12(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM12);

/**
* Retrieves the input for the element 1 3
*
* @param[in] pComposeMatrixNode - ComposeMatrixNode instance.
* @param[out] pM13 - the input for the m13 element
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_composematrixnode_getinputm13(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM13);

/**
* Retrieves the input for the element 2 0
*
* @param[in] pComposeMatrixNode - ComposeMatrixNode instance.
* @param[out] pM20 - the input for the m20 element
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_composematrixnode_getinputm20(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM20);

/**
* Retrieves the input for the element 2 1
*
* @param[in] pComposeMatrixNode - ComposeMatrixNode instance.
* @param[out] pM21 - 
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_composematrixnode_getinputm21(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM21);

/**
* Retrieves the input for the element 2 2
*
* @param[in] pComposeMatrixNode - ComposeMatrixNode instance.
* @param[out] pM22 - the input for the m22 element
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_composematrixnode_getinputm22(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM22);

/**
* Retrieves the input for the element 2 3
*
* @param[in] pComposeMatrixNode - ComposeMatrixNode instance.
* @param[out] pM23 - the input for the m23 element
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_composematrixnode_getinputm23(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM23);

/**
* Retrieves the input for the element 3 0
*
* @param[in] pComposeMatrixNode - ComposeMatrixNode instance.
* @param[out] pM30 - the input for the m30 element
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_composematrixnode_getinputm30(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM30);

/**
* Retrieves the input for the element 3 1
*
* @param[in] pComposeMatrixNode - ComposeMatrixNode instance.
* @param[out] pM31 - the input for the m31 element
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_composematrixnode_getinputm31(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM31);

/**
* Retrieves the input for the element 3 2
*
* @param[in] pComposeMatrixNode - ComposeMatrixNode instance.
* @param[out] pM32 - the input for the m32 element
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_composematrixnode_getinputm32(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM32);

/**
* Retrieves the input for the element 3 3
*
* @param[in] pComposeMatrixNode - ComposeMatrixNode instance.
* @param[out] pM33 - the input for the m33 element
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_composematrixnode_getinputm33(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM33);

/**
* Retrieves the output
*
* @param[in] pComposeMatrixNode - ComposeMatrixNode instance.
* @param[out] pResult - the output
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_composematrixnode_getoutputresult(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pResult);

/*************************************************************************************************************************
 Class definition for MatrixFromRowsNode
**************************************************************************************************************************/

/**
* Retrieves the input for the first row
*
* @param[in] pMatrixFromRowsNode - MatrixFromRowsNode instance.
* @param[out] pRow0 - the input for the first row
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_matrixfromrowsnode_getinputa(Lib3MF_MatrixFromRowsNode pMatrixFromRowsNode, Lib3MF_ImplicitPort * pRow0);

/**
* Retrieves the input for the second row
*
* @param[in] pMatrixFromRowsNode - MatrixFromRowsNode instance.
* @param[out] pRow1 - the input for the second row
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_matrixfromrowsnode_getinputb(Lib3MF_MatrixFromRowsNode pMatrixFromRowsNode, Lib3MF_ImplicitPort * pRow1);

/**
* Retrieves the input for the third row
*
* @param[in] pMatrixFromRowsNode - MatrixFromRowsNode instance.
* @param[out] pRow2 - the input for the third row
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_matrixfromrowsnode_getinputc(Lib3MF_MatrixFromRowsNode pMatrixFromRowsNode, Lib3MF_ImplicitPort * pRow2);

/**
* Retrieves the input for the fourth row
*
* @param[in] pMatrixFromRowsNode - MatrixFromRowsNode instance.
* @param[out] pRow3 - the input for the fourth row
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_matrixfromrowsnode_getinputd(Lib3MF_MatrixFromRowsNode pMatrixFromRowsNode, Lib3MF_ImplicitPort * pRow3);

/**
* Retrieves the output
*
* @param[in] pMatrixFromRowsNode - MatrixFromRowsNode instance.
* @param[out] pResult - the output
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_matrixfromrowsnode_getoutputresult(Lib3MF_MatrixFromRowsNode pMatrixFromRowsNode, Lib3MF_ImplicitPort * pResult);

/*************************************************************************************************************************
 Class definition for MatrixFromColumnsNode
**************************************************************************************************************************/

/**
* Retrieves the input for the first column
*
* @param[in] pMatrixFromColumnsNode - MatrixFromColumnsNode instance.
* @param[out] pColumn0 - the input for the first column
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_matrixfromcolumnsnode_getinputa(Lib3MF_MatrixFromColumnsNode pMatrixFromColumnsNode, Lib3MF_ImplicitPort * pColumn0);

/**
* Retrieves the input for the second column
*
* @param[in] pMatrixFromColumnsNode - MatrixFromColumnsNode instance.
* @param[out] pColumn1 - the input for the second column
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_matrixfromcolumnsnode_getinputb(Lib3MF_MatrixFromColumnsNode pMatrixFromColumnsNode, Lib3MF_ImplicitPort * pColumn1);

/**
* Retrieves the input for the third column
*
* @param[in] pMatrixFromColumnsNode - MatrixFromColumnsNode instance.
* @param[out] pColumn2 - the input for the third column
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_matrixfromcolumnsnode_getinputc(Lib3MF_MatrixFromColumnsNode pMatrixFromColumnsNode, Lib3MF_ImplicitPort * pColumn2);

/**
* Retrieves the input for the fourth column
*
* @param[in] pMatrixFromColumnsNode - MatrixFromColumnsNode instance.
* @param[out] pColumn3 - the input for the fourth column
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_matrixfromcolumnsnode_getinputd(Lib3MF_MatrixFromColumnsNode pMatrixFromColumnsNode, Lib3MF_ImplicitPort * pColumn3);

/**
* Retrieves the output
*
* @param[in] pMatrixFromColumnsNode - MatrixFromColumnsNode instance.
* @param[out] pResult - the output
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_matrixfromcolumnsnode_getoutputresult(Lib3MF_MatrixFromColumnsNode pMatrixFromColumnsNode, Lib3MF_ImplicitPort * pResult);

/*************************************************************************************************************************
 Class definition for ConstantNode
**************************************************************************************************************************/

/**
* Sets the constant value of the node
*
* @param[in] pConstantNode - ConstantNode instance.
* @param[in] dValue - the value
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_constantnode_setconstant(Lib3MF_ConstantNode pConstantNode, Lib3MF_double dValue);

/**
* Retrieves the constant value of the node
*
* @param[in] pConstantNode - ConstantNode instance.
* @param[out] pValue - the value
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_constantnode_getconstant(Lib3MF_ConstantNode pConstantNode, Lib3MF_double * pValue);

/**
* Retrieves the output
*
* @param[in] pConstantNode - ConstantNode instance.
* @param[out] pValue - the output
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_constantnode_getoutputvalue(Lib3MF_ConstantNode pConstantNode, Lib3MF_ImplicitPort * pValue);

/*************************************************************************************************************************
 Class definition for ConstVecNode
**************************************************************************************************************************/

/**
* Sets the vector value of the node
*
* @param[in] pConstVecNode - ConstVecNode instance.
* @param[in] pValue - the value
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_constvecnode_setvector(Lib3MF_ConstVecNode pConstVecNode, const sLib3MFVector * pValue);

/**
* Retrieves the vector value of the node
*
* @param[in] pConstVecNode - ConstVecNode instance.
* @param[out] pValue - the value
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_constvecnode_getvector(Lib3MF_ConstVecNode pConstVecNode, sLib3MFVector * pValue);

/**
* Retrieves the output
*
* @param[in] pConstVecNode - ConstVecNode instance.
* @param[out] pVector - the output
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_constvecnode_getoutputvector(Lib3MF_ConstVecNode pConstVecNode, Lib3MF_ImplicitPort * pVector);

/*************************************************************************************************************************
 Class definition for ConstMatNode
**************************************************************************************************************************/

/**
* Sets the matrix value of the node
*
* @param[in] pConstMatNode - ConstMatNode instance.
* @param[in] pValue - the value
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_constmatnode_setmatrix(Lib3MF_ConstMatNode pConstMatNode, const sLib3MFMatrix4x4 * pValue);

/**
* Retrieves the matrix value of the node
*
* @param[in] pConstMatNode - ConstMatNode instance.
* @param[out] pValue - the matrix
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_constmatnode_getmatrix(Lib3MF_ConstMatNode pConstMatNode, sLib3MFMatrix4x4 * pValue);

/**
* Retrieves the output
*
* @param[in] pConstMatNode - ConstMatNode instance.
* @param[out] pMatrix - the output
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_constmatnode_getoutputmatrix(Lib3MF_ConstMatNode pConstMatNode, Lib3MF_ImplicitPort * pMatrix);

/*************************************************************************************************************************
 Class definition for MeshNode
**************************************************************************************************************************/

/**
* Retrieves the input for the model resource id of the mesh
*
* @param[in] pMeshNode - MeshNode instance.
* @param[out] pMesh - the input port for the model resource id of the mesh
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshnode_getinputmesh(Lib3MF_MeshNode pMeshNode, Lib3MF_ImplicitPort * pMesh);

/**
* Retrieves the input for the position
*
* @param[in] pMeshNode - MeshNode instance.
* @param[out] pPos - the input port for the position
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshnode_getinputpos(Lib3MF_MeshNode pMeshNode, Lib3MF_ImplicitPort * pPos);

/**
* Retrieves the output
*
* @param[in] pMeshNode - MeshNode instance.
* @param[out] pDistance - the output port for the signed distance to the mesh
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_meshnode_getoutputdistance(Lib3MF_MeshNode pMeshNode, Lib3MF_ImplicitPort * pDistance);

/*************************************************************************************************************************
 Class definition for UnsignedMeshNode
**************************************************************************************************************************/

/**
* Retrieves the input for the model resource id of the mesh
*
* @param[in] pUnsignedMeshNode - UnsignedMeshNode instance.
* @param[out] pMesh - the input port for the model resource id of the mesh
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_unsignedmeshnode_getinputmesh(Lib3MF_UnsignedMeshNode pUnsignedMeshNode, Lib3MF_ImplicitPort * pMesh);

/**
* Retrieves the input for the position
*
* @param[in] pUnsignedMeshNode - UnsignedMeshNode instance.
* @param[out] pPos - the input port for the position
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_unsignedmeshnode_getinputpos(Lib3MF_UnsignedMeshNode pUnsignedMeshNode, Lib3MF_ImplicitPort * pPos);

/**
* Retrieves the output
*
* @param[in] pUnsignedMeshNode - UnsignedMeshNode instance.
* @param[out] pDistance - the output port for the unsigned distance to the mesh
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_unsignedmeshnode_getoutputdistance(Lib3MF_UnsignedMeshNode pUnsignedMeshNode, Lib3MF_ImplicitPort * pDistance);

/*************************************************************************************************************************
 Class definition for BeamLatticeNode
**************************************************************************************************************************/

/**
* Retrieves the input for the model resource id of the beam lattice
*
* @param[in] pBeamLatticeNode - BeamLatticeNode instance.
* @param[out] pBeamLattice - the input port for the model resource id of the beam lattice (mesh with beamlattice extension)
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlatticenode_getinputbeamlattice(Lib3MF_BeamLatticeNode pBeamLatticeNode, Lib3MF_ImplicitPort * pBeamLattice);

/**
* Retrieves the input for the position
*
* @param[in] pBeamLatticeNode - BeamLatticeNode instance.
* @param[out] pPos - the input port for the position
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlatticenode_getinputpos(Lib3MF_BeamLatticeNode pBeamLatticeNode, Lib3MF_ImplicitPort * pPos);

/**
* Retrieves the output
*
* @param[in] pBeamLatticeNode - BeamLatticeNode instance.
* @param[out] pDistance - the output port for the signed distance to the beam lattice
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlatticenode_getoutputdistance(Lib3MF_BeamLatticeNode pBeamLatticeNode, Lib3MF_ImplicitPort * pDistance);

/**
* Sets the accurate range for distance computation
*
* @param[in] pBeamLatticeNode - BeamLatticeNode instance.
* @param[in] dAccurateRange - the accurate range in model units
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlatticenode_setaccuraterange(Lib3MF_BeamLatticeNode pBeamLatticeNode, Lib3MF_double dAccurateRange);

/**
* Retrieves the accurate range for distance computation
*
* @param[in] pBeamLatticeNode - BeamLatticeNode instance.
* @param[out] pAccurateRange - the accurate range in model units
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_beamlatticenode_getaccuraterange(Lib3MF_BeamLatticeNode pBeamLatticeNode, Lib3MF_double * pAccurateRange);

/*************************************************************************************************************************
 Class definition for FunctionGradientNode
**************************************************************************************************************************/

/**
* Retrieves the input for the function id
*
* @param[in] pFunctionGradientNode - FunctionGradientNode instance.
* @param[out] pFunction - the input port for the function
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functiongradientnode_getinputfunctionid(Lib3MF_FunctionGradientNode pFunctionGradientNode, Lib3MF_ImplicitPort * pFunction);

/**
* Retrieves the input for the position
*
* @param[in] pFunctionGradientNode - FunctionGradientNode instance.
* @param[out] pPos - the input port for the position
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functiongradientnode_getinputpos(Lib3MF_FunctionGradientNode pFunctionGradientNode, Lib3MF_ImplicitPort * pPos);

/**
* Retrieves the input for the finite difference step
*
* @param[in] pFunctionGradientNode - FunctionGradientNode instance.
* @param[out] pStep - the input port for the finite difference step
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functiongradientnode_getinputstep(Lib3MF_FunctionGradientNode pFunctionGradientNode, Lib3MF_ImplicitPort * pStep);

/**
* Sets the name of the referenced scalar output
*
* @param[in] pFunctionGradientNode - FunctionGradientNode instance.
* @param[in] pScalarOutputName - the name of the scalar output of the referenced function
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functiongradientnode_setscalaroutputname(Lib3MF_FunctionGradientNode pFunctionGradientNode, const char * pScalarOutputName);

/**
* Retrieves the name of the referenced scalar output
*
* @param[in] pFunctionGradientNode - FunctionGradientNode instance.
* @param[in] nScalarOutputNameBufferSize - size of the buffer (including trailing 0)
* @param[out] pScalarOutputNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pScalarOutputNameBuffer -  buffer of the name of the scalar output of the referenced function, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functiongradientnode_getscalaroutputname(Lib3MF_FunctionGradientNode pFunctionGradientNode, const Lib3MF_uint32 nScalarOutputNameBufferSize, Lib3MF_uint32* pScalarOutputNameNeededChars, char * pScalarOutputNameBuffer);

/**
* Sets the name of the referenced vector input
*
* @param[in] pFunctionGradientNode - FunctionGradientNode instance.
* @param[in] pVectorInputName - the name of the vector input (float3) of the referenced function
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functiongradientnode_setvectorinputname(Lib3MF_FunctionGradientNode pFunctionGradientNode, const char * pVectorInputName);

/**
* Retrieves the name of the referenced vector input
*
* @param[in] pFunctionGradientNode - FunctionGradientNode instance.
* @param[in] nVectorInputNameBufferSize - size of the buffer (including trailing 0)
* @param[out] pVectorInputNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pVectorInputNameBuffer -  buffer of the name of the vector input (float3) of the referenced function, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functiongradientnode_getvectorinputname(Lib3MF_FunctionGradientNode pFunctionGradientNode, const Lib3MF_uint32 nVectorInputNameBufferSize, Lib3MF_uint32* pVectorInputNameNeededChars, char * pVectorInputNameBuffer);

/**
* Retrieves the normalized gradient output
*
* @param[in] pFunctionGradientNode - FunctionGradientNode instance.
* @param[out] pNormalizedGradient - the output port for the normalized gradient
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functiongradientnode_getoutputnormalizedgradient(Lib3MF_FunctionGradientNode pFunctionGradientNode, Lib3MF_ImplicitPort * pNormalizedGradient);

/**
* Retrieves the raw gradient output
*
* @param[in] pFunctionGradientNode - FunctionGradientNode instance.
* @param[out] pGradient - the output port for the raw gradient
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functiongradientnode_getoutputgradient(Lib3MF_FunctionGradientNode pFunctionGradientNode, Lib3MF_ImplicitPort * pGradient);

/**
* Retrieves the gradient magnitude output
*
* @param[in] pFunctionGradientNode - FunctionGradientNode instance.
* @param[out] pMagnitude - the output port for the gradient magnitude
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functiongradientnode_getoutputmagnitude(Lib3MF_FunctionGradientNode pFunctionGradientNode, Lib3MF_ImplicitPort * pMagnitude);

/*************************************************************************************************************************
 Class definition for NormalizeDistanceNode
**************************************************************************************************************************/

/**
* Retrieves the input for the function id
*
* @param[in] pNormalizeDistanceNode - NormalizeDistanceNode instance.
* @param[out] pFunction - the input port for the function
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_normalizedistancenode_getinputfunctionid(Lib3MF_NormalizeDistanceNode pNormalizeDistanceNode, Lib3MF_ImplicitPort * pFunction);

/**
* Retrieves the input for the position
*
* @param[in] pNormalizeDistanceNode - NormalizeDistanceNode instance.
* @param[out] pPos - the input port for the position (vector)
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_normalizedistancenode_getinputpos(Lib3MF_NormalizeDistanceNode pNormalizeDistanceNode, Lib3MF_ImplicitPort * pPos);

/**
* Retrieves the input for the finite difference step
*
* @param[in] pNormalizeDistanceNode - NormalizeDistanceNode instance.
* @param[out] pStep - the input port for the finite difference step
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_normalizedistancenode_getinputstep(Lib3MF_NormalizeDistanceNode pNormalizeDistanceNode, Lib3MF_ImplicitPort * pStep);

/**
* Sets the name of the referenced scalar output
*
* @param[in] pNormalizeDistanceNode - NormalizeDistanceNode instance.
* @param[in] pScalarOutputName - the name of the scalar output of the referenced function
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_normalizedistancenode_setscalaroutputname(Lib3MF_NormalizeDistanceNode pNormalizeDistanceNode, const char * pScalarOutputName);

/**
* Retrieves the name of the referenced scalar output
*
* @param[in] pNormalizeDistanceNode - NormalizeDistanceNode instance.
* @param[in] nScalarOutputNameBufferSize - size of the buffer (including trailing 0)
* @param[out] pScalarOutputNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pScalarOutputNameBuffer -  buffer of the name of the scalar output of the referenced function, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_normalizedistancenode_getscalaroutputname(Lib3MF_NormalizeDistanceNode pNormalizeDistanceNode, const Lib3MF_uint32 nScalarOutputNameBufferSize, Lib3MF_uint32* pScalarOutputNameNeededChars, char * pScalarOutputNameBuffer);

/**
* Sets the name of the referenced vector input
*
* @param[in] pNormalizeDistanceNode - NormalizeDistanceNode instance.
* @param[in] pVectorInputName - the name of the vector input (float3) of the referenced function
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_normalizedistancenode_setvectorinputname(Lib3MF_NormalizeDistanceNode pNormalizeDistanceNode, const char * pVectorInputName);

/**
* Retrieves the name of the referenced vector input
*
* @param[in] pNormalizeDistanceNode - NormalizeDistanceNode instance.
* @param[in] nVectorInputNameBufferSize - size of the buffer (including trailing 0)
* @param[out] pVectorInputNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pVectorInputNameBuffer -  buffer of the name of the vector input (float3) of the referenced function, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_normalizedistancenode_getvectorinputname(Lib3MF_NormalizeDistanceNode pNormalizeDistanceNode, const Lib3MF_uint32 nVectorInputNameBufferSize, Lib3MF_uint32* pVectorInputNameNeededChars, char * pVectorInputNameBuffer);

/**
* Retrieves the normalized result output
*
* @param[in] pNormalizeDistanceNode - NormalizeDistanceNode instance.
* @param[out] pResult - the output port for the normalized distance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_normalizedistancenode_getoutputresult(Lib3MF_NormalizeDistanceNode pNormalizeDistanceNode, Lib3MF_ImplicitPort * pResult);

/*************************************************************************************************************************
 Class definition for FunctionCallNode
**************************************************************************************************************************/

/**
* Retrieves the input for the function id
*
* @param[in] pFunctionCallNode - FunctionCallNode instance.
* @param[out] pFunction - the input port for the function
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functioncallnode_getinputfunctionid(Lib3MF_FunctionCallNode pFunctionCallNode, Lib3MF_ImplicitPort * pFunction);

/*************************************************************************************************************************
 Class definition for NodeIterator
**************************************************************************************************************************/

/**
* Returns the current element
*
* @param[in] pNodeIterator - NodeIterator instance.
* @param[out] pNode - The current element
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_nodeiterator_getcurrent(Lib3MF_NodeIterator pNodeIterator, Lib3MF_ImplicitNode * pNode);

/*************************************************************************************************************************
 Class definition for Function
**************************************************************************************************************************/

/**
* Retrieves the display name of the function
*
* @param[in] pFunction - Function instance.
* @param[in] nDisplayNameBufferSize - size of the buffer (including trailing 0)
* @param[out] pDisplayNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pDisplayNameBuffer -  buffer of the display name, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_function_getdisplayname(Lib3MF_Function pFunction, const Lib3MF_uint32 nDisplayNameBufferSize, Lib3MF_uint32* pDisplayNameNeededChars, char * pDisplayNameBuffer);

/**
* Sets the display name of the function
*
* @param[in] pFunction - Function instance.
* @param[in] pDisplayName - the display name
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_function_setdisplayname(Lib3MF_Function pFunction, const char * pDisplayName);

/**
* Add an input
*
* @param[in] pFunction - Function instance.
* @param[in] pIdentifier - the identifier of the input
* @param[in] pDisplayName - the display name of the input
* @param[in] eType - the type of the input
* @param[out] pPort - The added input port
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_function_addinput(Lib3MF_Function pFunction, const char * pIdentifier, const char * pDisplayName, eLib3MFImplicitPortType eType, Lib3MF_ImplicitPort * pPort);

/**
* Retrieves the inputs
*
* @param[in] pFunction - Function instance.
* @param[out] pIterator - iterator for the list of inputs
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_function_getinputs(Lib3MF_Function pFunction, Lib3MF_ImplicitPortIterator * pIterator);

/**
* Removes an input
*
* @param[in] pFunction - Function instance.
* @param[in] pInput - The input to be removed
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_function_removeinput(Lib3MF_Function pFunction, Lib3MF_ImplicitPort pInput);

/**
* Add an output
*
* @param[in] pFunction - Function instance.
* @param[in] pIdentifier - the identifier of the output
* @param[in] pDisplayName - the display name of the output
* @param[in] eType - the type of the input
* @param[out] pPort - The added input port
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_function_addoutput(Lib3MF_Function pFunction, const char * pIdentifier, const char * pDisplayName, eLib3MFImplicitPortType eType, Lib3MF_ImplicitPort * pPort);

/**
* Retrieves the outputs
*
* @param[in] pFunction - Function instance.
* @param[out] pIterator - iterator for the outputs
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_function_getoutputs(Lib3MF_Function pFunction, Lib3MF_ImplicitPortIterator * pIterator);

/**
* Removes an output
*
* @param[in] pFunction - Function instance.
* @param[in] pOutput - The output to be removed
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_function_removeoutput(Lib3MF_Function pFunction, Lib3MF_ImplicitPort pOutput);

/**
* Retrieves an input
*
* @param[in] pFunction - Function instance.
* @param[in] pIdentifier - the identifier of the input
* @param[out] pInput - the input port
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_function_findinput(Lib3MF_Function pFunction, const char * pIdentifier, Lib3MF_ImplicitPort * pInput);

/**
* Retrieves an output
*
* @param[in] pFunction - Function instance.
* @param[in] pIdentifier - the identifier of the output
* @param[out] pOutput - the output port
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_function_findoutput(Lib3MF_Function pFunction, const char * pIdentifier, Lib3MF_ImplicitPort * pOutput);

/*************************************************************************************************************************
 Class definition for ImplicitFunction
**************************************************************************************************************************/

/**
* Retrieves the identifier of the function
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] nIdentifierBufferSize - size of the buffer (including trailing 0)
* @param[out] pIdentifierNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pIdentifierBuffer -  buffer of the identifier, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_getidentifier(Lib3MF_ImplicitFunction pImplicitFunction, const Lib3MF_uint32 nIdentifierBufferSize, Lib3MF_uint32* pIdentifierNeededChars, char * pIdentifierBuffer);

/**
* Sets the identifier of the function
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_setidentifier(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier);

/**
* Add a node
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] eNodeType - the type of the node
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addnode(Lib3MF_ImplicitFunction pImplicitFunction, eLib3MFImplicitNodeType eNodeType, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_ImplicitNode * pNode);

/**
* Add a SinNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addsinnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_SinNode * pNode);

/**
* Add a CosNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addcosnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_CosNode * pNode);

/**
* Add a TanNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addtannode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_TanNode * pNode);

/**
* Add a ArcSinNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addarcsinnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_ArcSinNode * pNode);

/**
* Add a ArcCosNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addarccosnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_ArcCosNode * pNode);

/**
* Add a ArcTan2Node
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addarctan2node(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_ArcTan2Node * pNode);

/**
* Add a SinhNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addsinhnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_SinhNode * pNode);

/**
* Add a CoshNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addcoshnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_CoshNode * pNode);

/**
* Add a TanhNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addtanhnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_TanhNode * pNode);

/**
* Add a RoundNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addroundnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_RoundNode * pNode);

/**
* Add a CeilNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addceilnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_CeilNode * pNode);

/**
* Add a FloorNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addfloornode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_FloorNode * pNode);

/**
* Add a SignNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addsignnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_SignNode * pNode);

/**
* Add a FractNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addfractnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_FractNode * pNode);

/**
* Add a AbsNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addabsnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_AbsNode * pNode);

/**
* Add a ExpNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addexpnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_ExpNode * pNode);

/**
* Add a LogNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addlognode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_LogNode * pNode);

/**
* Add a Log2Node
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addlog2node(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_Log2Node * pNode);

/**
* Add a Log10Node
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addlog10node(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_Log10Node * pNode);

/**
* Add a LengthNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addlengthnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_LengthNode * pNode);

/**
* Add a TransposeNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addtransposenode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_TransposeNode * pNode);

/**
* Add a InverseNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addinversenode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_InverseNode * pNode);

/**
* Add a SqrtNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addsqrtnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_SqrtNode * pNode);

/**
* Add a ResourceIdNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addresourceidnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_ResourceIdNode * pNode);

/**
* Add an AdditionNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addadditionnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_AdditionNode * pNode);

/**
* Add a SubtractionNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addsubtractionnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_SubtractionNode * pNode);

/**
* Add a MultiplicationNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addmultiplicationnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_MultiplicationNode * pNode);

/**
* Add a DivisionNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_adddivisionnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_DivisionNode * pNode);

/**
* Add a DotNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_adddotnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_DotNode * pNode);

/**
* Add a CrossNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addcrossnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_CrossNode * pNode);

/**
* Add a MatVecMultiplicationNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addmatvecmultiplicationnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_MatVecMultiplicationNode * pNode);

/**
* Add a MinNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addminnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_MinNode * pNode);

/**
* Add a MaxNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addmaxnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_MaxNode * pNode);

/**
* Add a FmodNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addfmodnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_FmodNode * pNode);

/**
* Add a PowNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addpownode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_PowNode * pNode);

/**
* Add a SelectNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addselectnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_SelectNode * pNode);

/**
* Add a ClampNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] eConfiguration - the configuration of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addclampnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_ClampNode * pNode);

/**
* Add a ComposeVectorNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addcomposevectornode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_ComposeVectorNode * pNode);

/**
* Add a VectorFromScalar
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addvectorfromscalarnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_VectorFromScalarNode * pNode);

/**
* Add a DecomposeVectorNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_adddecomposevectornode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_DecomposeVectorNode * pNode);

/**
* Add a ComposeMatrixNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addcomposematrixnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_ComposeMatrixNode * pNode);

/**
* Add a MatrixFromRowsNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addmatrixfromrowsnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_MatrixFromRowsNode * pNode);

/**
* Add a MatrixFromColumnsNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addmatrixfromcolumnsnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_MatrixFromColumnsNode * pNode);

/**
* Add a ConstantNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addconstantnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_ConstantNode * pNode);

/**
* Add a ConstVecNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addconstvecnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_ConstVecNode * pNode);

/**
* Add a ConstMatNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addconstmatnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_ConstMatNode * pNode);

/**
* Add a MeshNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addmeshnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_MeshNode * pNode);

/**
* Add a UnsignedMeshNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addunsignedmeshnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_UnsignedMeshNode * pNode);

/**
* Add a BeamLatticeNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addbeamlatticenode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_BeamLatticeNode * pNode);

/**
* Add a FunctionGradientNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addfunctiongradientnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_FunctionGradientNode * pNode);

/**
* Add a NormalizeDistanceNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addnormalizedistancenode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_NormalizeDistanceNode * pNode);

/**
* Add a FunctionCallNode
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pIdentifier - the identifier of the node
* @param[in] pDisplayName - the display name of the node
* @param[in] pTag - the tag of the node
* @param[out] pNode - the added node
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addfunctioncallnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_FunctionCallNode * pNode);

/**
* Retrieves the nodes
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[out] pIterator - iterator for the list of nodes
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_getnodes(Lib3MF_ImplicitFunction pImplicitFunction, Lib3MF_NodeIterator * pIterator);

/**
* Removes a node
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pNode - The node to be removed
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_removenode(Lib3MF_ImplicitFunction pImplicitFunction, Lib3MF_ImplicitNode pNode);

/**
* Add a link
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pSource - the source port
* @param[in] pTarget - the target port
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addlink(Lib3MF_ImplicitFunction pImplicitFunction, Lib3MF_ImplicitPort pSource, Lib3MF_ImplicitPort pTarget);

/**
* Add a link
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @param[in] pSource - name of the source port in the format nodename.portname
* @param[in] pTarget - name of the target port in the format nodename.portname
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_addlinkbynames(Lib3MF_ImplicitFunction pImplicitFunction, const char * pSource, const char * pTarget);

/**
* Clears the function
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_clear(Lib3MF_ImplicitFunction pImplicitFunction);

/**
* Sorts the nodes topologically
*
* @param[in] pImplicitFunction - ImplicitFunction instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_implicitfunction_sortnodestopologically(Lib3MF_ImplicitFunction pImplicitFunction);

/*************************************************************************************************************************
 Class definition for FunctionFromImage3D
**************************************************************************************************************************/

/**
* Returns the selected 3D image.
*
* @param[in] pFunctionFromImage3D - FunctionFromImage3D instance.
* @param[out] pImage3D - image instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functionfromimage3d_getimage3d(Lib3MF_FunctionFromImage3D pFunctionFromImage3D, Lib3MF_Image3D * pImage3D);

/**
* Sets the 3D image of the selector.
*
* @param[in] pFunctionFromImage3D - FunctionFromImage3D instance.
* @param[in] pImage3D - image instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functionfromimage3d_setimage3d(Lib3MF_FunctionFromImage3D pFunctionFromImage3D, Lib3MF_Image3D pImage3D);

/**
* Sets the texture filter of the selector.
*
* @param[in] pFunctionFromImage3D - FunctionFromImage3D instance.
* @param[in] eFilter - texture filter
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functionfromimage3d_setfilter(Lib3MF_FunctionFromImage3D pFunctionFromImage3D, eLib3MFTextureFilter eFilter);

/**
* Returns the texture filter of the selector.
*
* @param[in] pFunctionFromImage3D - FunctionFromImage3D instance.
* @param[out] pFilter - texture filter
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functionfromimage3d_getfilter(Lib3MF_FunctionFromImage3D pFunctionFromImage3D, eLib3MFTextureFilter * pFilter);

/**
* Sets the tile styles of the selector.
*
* @param[in] pFunctionFromImage3D - FunctionFromImage3D instance.
* @param[in] eTileStyleU - tile style in U
* @param[in] eTileStyleV - tile style in V
* @param[in] eTileStyleW - tile style in W
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functionfromimage3d_settilestyles(Lib3MF_FunctionFromImage3D pFunctionFromImage3D, eLib3MFTextureTileStyle eTileStyleU, eLib3MFTextureTileStyle eTileStyleV, eLib3MFTextureTileStyle eTileStyleW);

/**
* Retrieves the tile styles of the selector.
*
* @param[in] pFunctionFromImage3D - FunctionFromImage3D instance.
* @param[out] pTileStyleU - tile style in U
* @param[out] pTileStyleV - tile style in V
* @param[out] pTileStyleW - tile style in W
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functionfromimage3d_gettilestyles(Lib3MF_FunctionFromImage3D pFunctionFromImage3D, eLib3MFTextureTileStyle * pTileStyleU, eLib3MFTextureTileStyle * pTileStyleV, eLib3MFTextureTileStyle * pTileStyleW);

/**
* returns the offset value for the pixel values in the Image3D
*
* @param[in] pFunctionFromImage3D - FunctionFromImage3D instance.
* @param[out] pOffset - the offset value for the pixel values in the Image3D
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functionfromimage3d_getoffset(Lib3MF_FunctionFromImage3D pFunctionFromImage3D, Lib3MF_double * pOffset);

/**
* Sets the offset value for the pixel values in the Image3D
*
* @param[in] pFunctionFromImage3D - FunctionFromImage3D instance.
* @param[in] dOffset - the offset value for the pixel values in the Image3D
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functionfromimage3d_setoffset(Lib3MF_FunctionFromImage3D pFunctionFromImage3D, Lib3MF_double dOffset);

/**
* returns the scale value for the pixel values in the Image3D
*
* @param[in] pFunctionFromImage3D - FunctionFromImage3D instance.
* @param[out] pScale - the scale value for the pixel values in the Image3D
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functionfromimage3d_getscale(Lib3MF_FunctionFromImage3D pFunctionFromImage3D, Lib3MF_double * pScale);

/**
* Sets the scale value for the pixel values in the Image3D
*
* @param[in] pFunctionFromImage3D - FunctionFromImage3D instance.
* @param[in] dScale - the scale value for the pixel values in the Image3D
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_functionfromimage3d_setscale(Lib3MF_FunctionFromImage3D pFunctionFromImage3D, Lib3MF_double dScale);

/*************************************************************************************************************************
 Class definition for BuildItem
**************************************************************************************************************************/

/**
* Retrieves the object resource associated to a build item
*
* @param[in] pBuildItem - BuildItem instance.
* @param[out] pObjectResource - returns the associated resource instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_builditem_getobjectresource(Lib3MF_BuildItem pBuildItem, Lib3MF_Object * pObjectResource);

/**
* returns, whether a build item has a UUID and, if true, the build item's UUID
*
* @param[in] pBuildItem - BuildItem instance.
* @param[out] pHasUUID - flag whether the build item has a UUID
* @param[in] nUUIDBufferSize - size of the buffer (including trailing 0)
* @param[out] pUUIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pUUIDBuffer -  buffer of the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx', may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_builditem_getuuid(Lib3MF_BuildItem pBuildItem, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer);

/**
* sets the build item's UUID
*
* @param[in] pBuildItem - BuildItem instance.
* @param[in] pUUID - the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_builditem_setuuid(Lib3MF_BuildItem pBuildItem, const char * pUUID);

/**
* Retrieves the object UniqueResourceID associated to a build item
*
* @param[in] pBuildItem - BuildItem instance.
* @param[out] pUniqueResourceID - returns the UniqueResourceID of the object
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_builditem_getobjectresourceid(Lib3MF_BuildItem pBuildItem, Lib3MF_uint32 * pUniqueResourceID);

/**
* Checks, if a build item has a non-identity transformation matrix
*
* @param[in] pBuildItem - BuildItem instance.
* @param[out] pHasTransform - returns true, if the transformation matrix is not the identity
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_builditem_hasobjecttransform(Lib3MF_BuildItem pBuildItem, bool * pHasTransform);

/**
* Retrieves a build item's transformation matrix.
*
* @param[in] pBuildItem - BuildItem instance.
* @param[out] pTransform - returns the transformation matrix
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_builditem_getobjecttransform(Lib3MF_BuildItem pBuildItem, sLib3MFTransform * pTransform);

/**
* Sets a build item's transformation matrix.
*
* @param[in] pBuildItem - BuildItem instance.
* @param[in] pTransform - new transformation matrix
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_builditem_setobjecttransform(Lib3MF_BuildItem pBuildItem, const sLib3MFTransform * pTransform);

/**
* Retrieves a build item's part number string
*
* @param[in] pBuildItem - BuildItem instance.
* @param[in] nPartNumberBufferSize - size of the buffer (including trailing 0)
* @param[out] pPartNumberNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pPartNumberBuffer -  buffer of Returns a build item's part number string, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_builditem_getpartnumber(Lib3MF_BuildItem pBuildItem, const Lib3MF_uint32 nPartNumberBufferSize, Lib3MF_uint32* pPartNumberNeededChars, char * pPartNumberBuffer);

/**
* Sets a build item's part number string
*
* @param[in] pBuildItem - BuildItem instance.
* @param[in] pSetPartnumber - new part number string for referencing parts from the outside world
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_builditem_setpartnumber(Lib3MF_BuildItem pBuildItem, const char * pSetPartnumber);

/**
* Returns the metadatagroup of this build item
*
* @param[in] pBuildItem - BuildItem instance.
* @param[out] pMetaDataGroup - returns an Instance of the metadatagroup of this build item
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_builditem_getmetadatagroup(Lib3MF_BuildItem pBuildItem, Lib3MF_MetaDataGroup * pMetaDataGroup);

/**
* Returns the outbox of a build item
*
* @param[in] pBuildItem - BuildItem instance.
* @param[out] pOutbox - Outbox of this build item
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_builditem_getoutbox(Lib3MF_BuildItem pBuildItem, sLib3MFBox * pOutbox);

/*************************************************************************************************************************
 Class definition for BuildItemIterator
**************************************************************************************************************************/

/**
* Iterates to the next build item in the list.
*
* @param[in] pBuildItemIterator - BuildItemIterator instance.
* @param[out] pHasNext - Iterates to the next build item in the list.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_builditemiterator_movenext(Lib3MF_BuildItemIterator pBuildItemIterator, bool * pHasNext);

/**
* Iterates to the previous build item in the list.
*
* @param[in] pBuildItemIterator - BuildItemIterator instance.
* @param[out] pHasPrevious - Iterates to the previous build item in the list.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_builditemiterator_moveprevious(Lib3MF_BuildItemIterator pBuildItemIterator, bool * pHasPrevious);

/**
* Returns the build item the iterator points at.
*
* @param[in] pBuildItemIterator - BuildItemIterator instance.
* @param[out] pBuildItem - returns the build item instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_builditemiterator_getcurrent(Lib3MF_BuildItemIterator pBuildItemIterator, Lib3MF_BuildItem * pBuildItem);

/**
* Creates a new build item iterator with the same build item list.
*
* @param[in] pBuildItemIterator - BuildItemIterator instance.
* @param[out] pOutBuildItemIterator - returns the cloned Iterator instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_builditemiterator_clone(Lib3MF_BuildItemIterator pBuildItemIterator, Lib3MF_BuildItemIterator * pOutBuildItemIterator);

/**
* Returns the number of build items the iterator captures.
*
* @param[in] pBuildItemIterator - BuildItemIterator instance.
* @param[out] pCount - returns the number of build items the iterator captures.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_builditemiterator_count(Lib3MF_BuildItemIterator pBuildItemIterator, Lib3MF_uint64 * pCount);

/*************************************************************************************************************************
 Class definition for Slice
**************************************************************************************************************************/

/**
* Set all vertices of a slice. All polygons will be cleared.
*
* @param[in] pSlice - Slice instance.
* @param[in] nVerticesBufferSize - Number of elements in buffer
* @param[in] pVerticesBuffer - Position2D buffer of contains the positions.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_slice_setvertices(Lib3MF_Slice pSlice, Lib3MF_uint64 nVerticesBufferSize, const sLib3MFPosition2D * pVerticesBuffer);

/**
* Get all vertices of a slice
*
* @param[in] pSlice - Slice instance.
* @param[in] nVerticesBufferSize - Number of elements in buffer
* @param[out] pVerticesNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pVerticesBuffer - Position2D  buffer of contains the positions.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_slice_getvertices(Lib3MF_Slice pSlice, const Lib3MF_uint64 nVerticesBufferSize, Lib3MF_uint64* pVerticesNeededCount, sLib3MFPosition2D * pVerticesBuffer);

/**
* Get the number of vertices in a slice
*
* @param[in] pSlice - Slice instance.
* @param[out] pCount - the number of vertices in the slice
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_slice_getvertexcount(Lib3MF_Slice pSlice, Lib3MF_uint64 * pCount);

/**
* Add a new polygon to this slice
*
* @param[in] pSlice - Slice instance.
* @param[in] nIndicesBufferSize - Number of elements in buffer
* @param[in] pIndicesBuffer - uint32 buffer of the new indices of the new polygon
* @param[out] pIndex - the index of the new polygon
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_slice_addpolygon(Lib3MF_Slice pSlice, Lib3MF_uint64 nIndicesBufferSize, const Lib3MF_uint32 * pIndicesBuffer, Lib3MF_uint64 * pIndex);

/**
* Get the number of polygons in the slice
*
* @param[in] pSlice - Slice instance.
* @param[out] pCount - the number of polygons in the slice
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_slice_getpolygoncount(Lib3MF_Slice pSlice, Lib3MF_uint64 * pCount);

/**
* Set all indices of a polygon
*
* @param[in] pSlice - Slice instance.
* @param[in] nIndex - the index of the polygon to manipulate
* @param[in] nIndicesBufferSize - Number of elements in buffer
* @param[in] pIndicesBuffer - uint32 buffer of the new indices of the index-th polygon
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_slice_setpolygonindices(Lib3MF_Slice pSlice, Lib3MF_uint64 nIndex, Lib3MF_uint64 nIndicesBufferSize, const Lib3MF_uint32 * pIndicesBuffer);

/**
* Get all vertices of a slice
*
* @param[in] pSlice - Slice instance.
* @param[in] nIndex - the index of the polygon to manipulate
* @param[in] nIndicesBufferSize - Number of elements in buffer
* @param[out] pIndicesNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pIndicesBuffer - uint32  buffer of the indices of the index-th polygon 
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_slice_getpolygonindices(Lib3MF_Slice pSlice, Lib3MF_uint64 nIndex, const Lib3MF_uint64 nIndicesBufferSize, Lib3MF_uint64* pIndicesNeededCount, Lib3MF_uint32 * pIndicesBuffer);

/**
* Get the number of vertices in a slice
*
* @param[in] pSlice - Slice instance.
* @param[in] nIndex - the index of the polygon to manipulate
* @param[out] pCount - the number of indices of the index-th polygon
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_slice_getpolygonindexcount(Lib3MF_Slice pSlice, Lib3MF_uint64 nIndex, Lib3MF_uint64 * pCount);

/**
* Get the upper Z-Coordinate of this slice.
*
* @param[in] pSlice - Slice instance.
* @param[out] pZTop - the upper Z-Coordinate of this slice
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_slice_getztop(Lib3MF_Slice pSlice, Lib3MF_double * pZTop);

/*************************************************************************************************************************
 Class definition for SliceStack
**************************************************************************************************************************/

/**
* Get the lower Z-Coordinate of the slice stack.
*
* @param[in] pSliceStack - SliceStack instance.
* @param[out] pZBottom - the lower Z-Coordinate the slice stack
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_slicestack_getbottomz(Lib3MF_SliceStack pSliceStack, Lib3MF_double * pZBottom);

/**
* Returns the number of slices
*
* @param[in] pSliceStack - SliceStack instance.
* @param[out] pCount - the number of slices
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_slicestack_getslicecount(Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 * pCount);

/**
* Query a slice from the slice stack
*
* @param[in] pSliceStack - SliceStack instance.
* @param[in] nSliceIndex - the index of the slice
* @param[out] pTheSlice - the Slice instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_slicestack_getslice(Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 nSliceIndex, Lib3MF_Slice * pTheSlice);

/**
* Returns the number of slices
*
* @param[in] pSliceStack - SliceStack instance.
* @param[in] dZTop - upper Z coordinate of the slice
* @param[out] pTheSlice - a new Slice instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_slicestack_addslice(Lib3MF_SliceStack pSliceStack, Lib3MF_double dZTop, Lib3MF_Slice * pTheSlice);

/**
* Returns the number of slice refs
*
* @param[in] pSliceStack - SliceStack instance.
* @param[out] pCount - the number of slicereferences
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_slicestack_getslicerefcount(Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 * pCount);

/**
* Adds another existing slicestack as sliceref in this slicestack
*
* @param[in] pSliceStack - SliceStack instance.
* @param[in] pTheSliceStack - the slicestack to use as sliceref
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_slicestack_addslicestackreference(Lib3MF_SliceStack pSliceStack, Lib3MF_SliceStack pTheSliceStack);

/**
* Adds another existing slicestack as sliceref in this slicestack
*
* @param[in] pSliceStack - SliceStack instance.
* @param[in] nSliceRefIndex - the index of the slice ref
* @param[out] pTheSliceStack - the slicestack that is used as sliceref
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_slicestack_getslicestackreference(Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 nSliceRefIndex, Lib3MF_SliceStack * pTheSliceStack);

/**
* Removes the indirection of slices via slice-refs, i.e. creates the slices of all slice refs of this SliceStack as actual slices of this SliceStack. All previously existing slices or slicerefs will be removed.
*
* @param[in] pSliceStack - SliceStack instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_slicestack_collapseslicereferences(Lib3MF_SliceStack pSliceStack);

/**
* Sets the package path where this Slice should be stored. Input an empty string to reset the path
*
* @param[in] pSliceStack - SliceStack instance.
* @param[in] pPath - the package path where this Slice should be stored
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_slicestack_setownpath(Lib3MF_SliceStack pSliceStack, const char * pPath);

/**
* Obtains the package path where this Slice should be stored. Returns an empty string if the slicestack is stored within the root model.
*
* @param[in] pSliceStack - SliceStack instance.
* @param[in] nPathBufferSize - size of the buffer (including trailing 0)
* @param[out] pPathNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pPathBuffer -  buffer of the package path where this Slice will be stored, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_slicestack_getownpath(Lib3MF_SliceStack pSliceStack, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer);

/*************************************************************************************************************************
 Class definition for Consumer
**************************************************************************************************************************/

/**
* Gets the consumerid
*
* @param[in] pConsumer - Consumer instance.
* @param[in] nConsumerIDBufferSize - size of the buffer (including trailing 0)
* @param[out] pConsumerIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pConsumerIDBuffer -  buffer of A unique identifier for the consumers, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_consumer_getconsumerid(Lib3MF_Consumer pConsumer, const Lib3MF_uint32 nConsumerIDBufferSize, Lib3MF_uint32* pConsumerIDNeededChars, char * pConsumerIDBuffer);

/**
* Getts the keyid
*
* @param[in] pConsumer - Consumer instance.
* @param[in] nKeyIDBufferSize - size of the buffer (including trailing 0)
* @param[out] pKeyIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pKeyIDBuffer -  buffer of The identifier for the key of this consumer, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_consumer_getkeyid(Lib3MF_Consumer pConsumer, const Lib3MF_uint32 nKeyIDBufferSize, Lib3MF_uint32* pKeyIDNeededChars, char * pKeyIDBuffer);

/**
* Gets the keyvalue associated with this consumer
*
* @param[in] pConsumer - Consumer instance.
* @param[in] nKeyValueBufferSize - size of the buffer (including trailing 0)
* @param[out] pKeyValueNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pKeyValueBuffer -  buffer of The public key, when available, of this consumer, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_consumer_getkeyvalue(Lib3MF_Consumer pConsumer, const Lib3MF_uint32 nKeyValueBufferSize, Lib3MF_uint32* pKeyValueNeededChars, char * pKeyValueBuffer);

/*************************************************************************************************************************
 Class definition for AccessRight
**************************************************************************************************************************/

/**
* Gets the consumer associated with this access right
*
* @param[in] pAccessRight - AccessRight instance.
* @param[out] pConsumer - The consumer instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_accessright_getconsumer(Lib3MF_AccessRight pAccessRight, Lib3MF_Consumer * pConsumer);

/**
* Gets the associated encryption algorithm
*
* @param[in] pAccessRight - AccessRight instance.
* @param[out] pAlgorithm - The algorithm used for the key in this accessright
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_accessright_getwrappingalgorithm(Lib3MF_AccessRight pAccessRight, eLib3MFWrappingAlgorithm * pAlgorithm);

/**
* Gets the associated mask generation function algorithm
*
* @param[in] pAccessRight - AccessRight instance.
* @param[out] pAlgorithm - The MFG1 algorithm
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_accessright_getmgfalgorithm(Lib3MF_AccessRight pAccessRight, eLib3MFMgfAlgorithm * pAlgorithm);

/**
* Gets the digest method assoicated
*
* @param[in] pAccessRight - AccessRight instance.
* @param[out] pAlgorithm - The digest method for this accessright
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_accessright_getdigestmethod(Lib3MF_AccessRight pAccessRight, eLib3MFDigestMethod * pAlgorithm);

/*************************************************************************************************************************
 Class definition for ContentEncryptionParams
**************************************************************************************************************************/

/**
* Returns the encryption method to be used in this encryption process
*
* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
* @param[out] pAlgorithm - 
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_contentencryptionparams_getencryptionalgorithm(Lib3MF_ContentEncryptionParams pContentEncryptionParams, eLib3MFEncryptionAlgorithm * pAlgorithm);

/**
* Gets the key for the resource associated
*
* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
* @param[in] nByteDataBufferSize - Number of elements in buffer
* @param[out] pByteDataNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pByteDataBuffer - uint8  buffer of Pointer to a buffer where to place the key.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_contentencryptionparams_getkey(Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer);

/**
* Gets the IV data
*
* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
* @param[in] nByteDataBufferSize - Number of elements in buffer
* @param[out] pByteDataNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pByteDataBuffer - uint8  buffer of Pointer to a buffer where to place the data.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_contentencryptionparams_getinitializationvector(Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer);

/**
* A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
*
* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
* @param[in] nByteDataBufferSize - Number of elements in buffer
* @param[out] pByteDataNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pByteDataBuffer - uint8  buffer of Pointer to a buffer where to place the data.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_contentencryptionparams_getauthenticationtag(Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer);

/**
* Sets the authentication tag
*
* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
* @param[in] nByteDataBufferSize - Number of elements in buffer
* @param[in] pByteDataBuffer - uint8 buffer of The authentication tag size
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_contentencryptionparams_setauthenticationtag(Lib3MF_ContentEncryptionParams pContentEncryptionParams, Lib3MF_uint64 nByteDataBufferSize, const Lib3MF_uint8 * pByteDataBuffer);

/**
* A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
*
* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
* @param[in] nByteDataBufferSize - Number of elements in buffer
* @param[out] pByteDataNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pByteDataBuffer - uint8  buffer of Buffer where the data will be placed
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_contentencryptionparams_getadditionalauthenticationdata(Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer);

/**
* A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
*
* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
* @param[out] pDescriptor - 
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_contentencryptionparams_getdescriptor(Lib3MF_ContentEncryptionParams pContentEncryptionParams, Lib3MF_uint64 * pDescriptor);

/**
* Gets the resourcedatagroup keyuuid
*
* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
* @param[in] nUUIDBufferSize - size of the buffer (including trailing 0)
* @param[out] pUUIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pUUIDBuffer -  buffer of The resourcedatagroup keyuuid that may be use to reference an external key, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_contentencryptionparams_getkeyuuid(Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer);

/*************************************************************************************************************************
 Class definition for ResourceData
**************************************************************************************************************************/

/**
* Gets the encrypted part path
*
* @param[in] pResourceData - ResourceData instance.
* @param[out] pPath - The part path
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_resourcedata_getpath(Lib3MF_ResourceData pResourceData, Lib3MF_PackagePart * pPath);

/**
* Gets the encryption algorithm used to encrypt this ResourceData
*
* @param[in] pResourceData - ResourceData instance.
* @param[out] pEncryptionAlgorithm - The encryption algorithm
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_resourcedata_getencryptionalgorithm(Lib3MF_ResourceData pResourceData, eLib3MFEncryptionAlgorithm * pEncryptionAlgorithm);

/**
* Tells whether this ResourceData is compressed or not
*
* @param[in] pResourceData - ResourceData instance.
* @param[out] pCompression - The compression method
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_resourcedata_getcompression(Lib3MF_ResourceData pResourceData, eLib3MFCompression * pCompression);

/**
* Tells whether this ResourceData is compressed or not
*
* @param[in] pResourceData - ResourceData instance.
* @param[in] nByteDataBufferSize - Number of elements in buffer
* @param[out] pByteDataNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pByteDataBuffer - uint8  buffer of The compression method
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_resourcedata_getadditionalauthenticationdata(Lib3MF_ResourceData pResourceData, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer);

/*************************************************************************************************************************
 Class definition for ResourceDataGroup
**************************************************************************************************************************/

/**
* Sets the resourcedatagroup keyuuid
*
* @param[in] pResourceDataGroup - ResourceDataGroup instance.
* @param[in] nUUIDBufferSize - size of the buffer (including trailing 0)
* @param[out] pUUIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pUUIDBuffer -  buffer of The new resourcedatagroup keyuuid., may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_resourcedatagroup_getkeyuuid(Lib3MF_ResourceDataGroup pResourceDataGroup, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer);

/**
* Add accessright to resourcedatagroup element
*
* @param[in] pResourceDataGroup - ResourceDataGroup instance.
* @param[in] pConsumer - The Consumer reference
* @param[in] eWrappingAlgorithm - The key wrapping algorithm to be used
* @param[in] eMgfAlgorithm - The mask generation function to be used
* @param[in] eDigestMethod - The digest mechanism to be used
* @param[out] pTheAccessRight - The acess right instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_resourcedatagroup_addaccessright(Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_Consumer pConsumer, eLib3MFWrappingAlgorithm eWrappingAlgorithm, eLib3MFMgfAlgorithm eMgfAlgorithm, eLib3MFDigestMethod eDigestMethod, Lib3MF_AccessRight * pTheAccessRight);

/**
* Finds the AccessRight associated with a Consumer
*
* @param[in] pResourceDataGroup - ResourceDataGroup instance.
* @param[in] pConsumer - The Consumer instance
* @param[out] pTheAccessRight - The AcessRight instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_resourcedatagroup_findaccessrightbyconsumer(Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_Consumer pConsumer, Lib3MF_AccessRight * pTheAccessRight);

/**
* Removes access from a Consumer on this resource data group
*
* @param[in] pResourceDataGroup - ResourceDataGroup instance.
* @param[in] pConsumer - The Consumer instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_resourcedatagroup_removeaccessright(Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_Consumer pConsumer);

/*************************************************************************************************************************
 Class definition for KeyStore
**************************************************************************************************************************/

/**
* Adds a consumer to the keystore
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] pConsumerID - A unique identifier for the consumer
* @param[in] pKeyID - The id of the key of the consumer
* @param[in] pKeyValue - The public key for this consumer in PEM format
* @param[out] pConsumer - The consumer instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_keystore_addconsumer(Lib3MF_KeyStore pKeyStore, const char * pConsumerID, const char * pKeyID, const char * pKeyValue, Lib3MF_Consumer * pConsumer);

/**
* Gets the number of consumers in the keystore
*
* @param[in] pKeyStore - KeyStore instance.
* @param[out] pCount - The consumer count
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_keystore_getconsumercount(Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 * pCount);

/**
* Get a consumer from the keystore
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] nConsumerIndex - The index of the consumer
* @param[out] pConsumer - The consumer instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_keystore_getconsumer(Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 nConsumerIndex, Lib3MF_Consumer * pConsumer);

/**
* Removes a consumer from the keystore
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] pConsumer - The consumer instance to remove
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_keystore_removeconsumer(Lib3MF_KeyStore pKeyStore, Lib3MF_Consumer pConsumer);

/**
* Finds a consumer by ID
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] pConsumerID - The ID of the consumer
* @param[out] pConsumer - The consumer instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_keystore_findconsumer(Lib3MF_KeyStore pKeyStore, const char * pConsumerID, Lib3MF_Consumer * pConsumer);

/**
* Gets the number of resource data group in the keysore
*
* @param[in] pKeyStore - KeyStore instance.
* @param[out] pCount - The number of resource data available
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_keystore_getresourcedatagroupcount(Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 * pCount);

/**
* Adds a resource data group into the keystore.
*
* @param[in] pKeyStore - KeyStore instance.
* @param[out] pResourceDataGroup - The resource data group instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_keystore_addresourcedatagroup(Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceDataGroup * pResourceDataGroup);

/**
* Gets a resource data group
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] nResourceDataIndex - The index of the resource data
* @param[out] pResourceDataGroup - The resource data group instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_keystore_getresourcedatagroup(Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 nResourceDataIndex, Lib3MF_ResourceDataGroup * pResourceDataGroup);

/**
* Removes a resource data group
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] pResourceDataGroup - The resource data group instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_keystore_removeresourcedatagroup(Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceDataGroup pResourceDataGroup);

/**
* Finds a resource data group that contains a particular resourcedata
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] pPartPath - The target path for the resourcedata hold by the resource data group
* @param[out] pResourceDataGroup - The data resource instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_keystore_findresourcedatagroup(Lib3MF_KeyStore pKeyStore, Lib3MF_PackagePart pPartPath, Lib3MF_ResourceDataGroup * pResourceDataGroup);

/**
* Add resourcedata to resourcedatagroup element
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] pResourceDataGroup - The resource data group where to add this resource data
* @param[in] pPartPath - The path of the part to be encrypted
* @param[in] eAlgorithm - The encryption algorithm to be used to encrypt this resource
* @param[in] eCompression - Whether compression should be used prior to encryption
* @param[in] nAdditionalAuthenticationDataBufferSize - Number of elements in buffer
* @param[in] pAdditionalAuthenticationDataBuffer - uint8 buffer of Additional data to be encrypted along the contents for better security
* @param[out] pResourceData - The data resource instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_keystore_addresourcedata(Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_PackagePart pPartPath, eLib3MFEncryptionAlgorithm eAlgorithm, eLib3MFCompression eCompression, Lib3MF_uint64 nAdditionalAuthenticationDataBufferSize, const Lib3MF_uint8 * pAdditionalAuthenticationDataBuffer, Lib3MF_ResourceData * pResourceData);

/**
* Removes a resource data
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] pResourceData - The resource data to be removed
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_keystore_removeresourcedata(Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceData pResourceData);

/**
* Finds a resource data on this resource group
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] pResourcePath - The target path for the resourcedata
* @param[out] pResourceData - The resource data instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_keystore_findresourcedata(Lib3MF_KeyStore pKeyStore, Lib3MF_PackagePart pResourcePath, Lib3MF_ResourceData * pResourceData);

/**
* Gets the number of resource data in the keysore
*
* @param[in] pKeyStore - KeyStore instance.
* @param[out] pCount - The number of resource data available
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_keystore_getresourcedatacount(Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 * pCount);

/**
* Gets a resource data
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] nResourceDataIndex - The index of the resource data
* @param[out] pResourceData - The data resource instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_keystore_getresourcedata(Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 nResourceDataIndex, Lib3MF_ResourceData * pResourceData);

/**
* Gets the keystore UUID
*
* @param[in] pKeyStore - KeyStore instance.
* @param[out] pHasUUID - flag whether the keystore has a UUID
* @param[in] nUUIDBufferSize - size of the buffer (including trailing 0)
* @param[out] pUUIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pUUIDBuffer -  buffer of returns the keystore uuid., may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_keystore_getuuid(Lib3MF_KeyStore pKeyStore, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer);

/**
* Sets the keystore UUID
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] pUUID - The new keystore uuid.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_keystore_setuuid(Lib3MF_KeyStore pKeyStore, const char * pUUID);

/*************************************************************************************************************************
 Class definition for Model
**************************************************************************************************************************/

/**
* Returns the PackagePart within the OPC package that holds the root model.
*
* @param[in] pModel - Model instance.
* @param[out] pRootModelPart - the PackagePart within the OPC package that holds the model-file
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_rootmodelpart(Lib3MF_Model pModel, Lib3MF_PackagePart * pRootModelPart);

/**
* Returns a new PackagePart for use within the OPC package.
*
* @param[in] pModel - Model instance.
* @param[in] pAbsolutePath - the absolute Path (physical location) within the OPC package
* @param[out] pModelPart - the new PackagePart within the OPC package
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_findorcreatepackagepart(Lib3MF_Model pModel, const char * pAbsolutePath, Lib3MF_PackagePart * pModelPart);

/**
* sets the units of a model.
*
* @param[in] pModel - Model instance.
* @param[in] eUnit - Unit enum value for the model unit
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_setunit(Lib3MF_Model pModel, eLib3MFModelUnit eUnit);

/**
* returns the units of a model.
*
* @param[in] pModel - Model instance.
* @param[out] pUnit - Unit enum value for the model unit
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getunit(Lib3MF_Model pModel, eLib3MFModelUnit * pUnit);

/**
* retrieves the language of a model
*
* @param[in] pModel - Model instance.
* @param[in] nLanguageBufferSize - size of the buffer (including trailing 0)
* @param[out] pLanguageNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pLanguageBuffer -  buffer of language identifier, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getlanguage(Lib3MF_Model pModel, const Lib3MF_uint32 nLanguageBufferSize, Lib3MF_uint32* pLanguageNeededChars, char * pLanguageBuffer);

/**
* sets the language of a model
*
* @param[in] pModel - Model instance.
* @param[in] pLanguage - language identifier
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_setlanguage(Lib3MF_Model pModel, const char * pLanguage);

/**
* creates a model writer instance for a specific file type
*
* @param[in] pModel - Model instance.
* @param[in] pWriterClass -  string identifier for the file type
* @param[out] pWriterInstance -  string identifier for the file type
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_querywriter(Lib3MF_Model pModel, const char * pWriterClass, Lib3MF_Writer * pWriterInstance);

/**
* creates a model reader instance for a specific file type
*
* @param[in] pModel - Model instance.
* @param[in] pReaderClass -  string identifier for the file type
* @param[out] pReaderInstance -  string identifier for the file type
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_queryreader(Lib3MF_Model pModel, const char * pReaderClass, Lib3MF_Reader * pReaderInstance);

/**
* finds a model resource by its UniqueResourceID
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - UniqueResourceID
* @param[out] pResource - returns the resource instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getresourcebyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_Resource * pResource);

/**
* finds a model texture by its UniqueResourceID
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - UniqueResourceID
* @param[out] pTextureInstance - returns the texture2d instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_gettexture2dbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_Texture2D * pTextureInstance);

/**
* returns a Property's type
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - Resource ID of the Property to Query
* @param[out] pThePropertyType - returns a Property's type
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getpropertytypebyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, eLib3MFPropertyType * pThePropertyType);

/**
* finds a model base material group by its UniqueResourceID
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - UniqueResourceID
* @param[out] pBaseMaterialGroupInstance - returns the BaseMaterialGroup instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getbasematerialgroupbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_BaseMaterialGroup * pBaseMaterialGroupInstance);

/**
* finds a model texture2d group by its UniqueResourceID
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - UniqueResourceID
* @param[out] pTexture2DGroupInstance - returns the Texture2DGroup instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_gettexture2dgroupbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_Texture2DGroup * pTexture2DGroupInstance);

/**
* finds a model CompositeMaterials by its UniqueResourceID
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - UniqueResourceID
* @param[out] pCompositeMaterialsInstance - returns the CompositeMaterials instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getcompositematerialsbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_CompositeMaterials * pCompositeMaterialsInstance);

/**
* finds a model MultiPropertyGroup by its UniqueResourceID
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - UniqueResourceID
* @param[out] pMultiPropertyGroupInstance - returns the MultiPropertyGroup instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getmultipropertygroupbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_MultiPropertyGroup * pMultiPropertyGroupInstance);

/**
* finds a mesh object by its UniqueResourceID
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - UniqueResourceID
* @param[out] pMeshObjectInstance - returns the mesh object instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getmeshobjectbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_MeshObject * pMeshObjectInstance);

/**
* finds a components object by its UniqueResourceID
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - UniqueResourceID
* @param[out] pComponentsObjectInstance - returns the components object instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getcomponentsobjectbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_ComponentsObject * pComponentsObjectInstance);

/**
* finds a model color group by its UniqueResourceID
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - UniqueResourceID
* @param[out] pColorGroupInstance - returns the ColorGroup instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getcolorgroupbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_ColorGroup * pColorGroupInstance);

/**
* finds a model slicestack by its UniqueResourceID
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - UniqueResourceID
* @param[out] pSliceStacInstance - returns the slicestack instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getslicestackbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_SliceStack * pSliceStacInstance);

/**
* finds a level set object by its UniqueResourceID
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - UniqueResourceID
* @param[out] pLevelSetObjectInstance - returns the level set object instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getlevelsetbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_LevelSet * pLevelSetObjectInstance);

/**
* returns, whether a build has a UUID and, if true, the build's UUID
*
* @param[in] pModel - Model instance.
* @param[out] pHasUUID - flag whether the build has a UUID
* @param[in] nUUIDBufferSize - size of the buffer (including trailing 0)
* @param[out] pUUIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pUUIDBuffer -  buffer of the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx', may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getbuilduuid(Lib3MF_Model pModel, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer);

/**
* sets the build's UUID
*
* @param[in] pModel - Model instance.
* @param[in] pUUID - the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_setbuilduuid(Lib3MF_Model pModel, const char * pUUID);

/**
* creates a build item iterator instance with all build items.
*
* @param[in] pModel - Model instance.
* @param[out] pBuildItemIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getbuilditems(Lib3MF_Model pModel, Lib3MF_BuildItemIterator * pBuildItemIterator);

/**
* Returns the outbox of a Model
*
* @param[in] pModel - Model instance.
* @param[out] pOutbox - Outbox of this Model
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getoutbox(Lib3MF_Model pModel, sLib3MFBox * pOutbox);

/**
* creates a resource iterator instance with all resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getresources(Lib3MF_Model pModel, Lib3MF_ResourceIterator * pResourceIterator);

/**
* creates a resource iterator instance with all object resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getobjects(Lib3MF_Model pModel, Lib3MF_ObjectIterator * pResourceIterator);

/**
* creates a resource iterator instance with all mesh object resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getmeshobjects(Lib3MF_Model pModel, Lib3MF_MeshObjectIterator * pResourceIterator);

/**
* creates a resource iterator instance with all components object resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getcomponentsobjects(Lib3MF_Model pModel, Lib3MF_ComponentsObjectIterator * pResourceIterator);

/**
* creates a Texture2DIterator instance with all texture2d resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_gettexture2ds(Lib3MF_Model pModel, Lib3MF_Texture2DIterator * pResourceIterator);

/**
* creates a BaseMaterialGroupIterator instance with all base material resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getbasematerialgroups(Lib3MF_Model pModel, Lib3MF_BaseMaterialGroupIterator * pResourceIterator);

/**
* creates a ColorGroupIterator instance with all ColorGroup resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getcolorgroups(Lib3MF_Model pModel, Lib3MF_ColorGroupIterator * pResourceIterator);

/**
* creates a Texture2DGroupIterator instance with all base material resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_gettexture2dgroups(Lib3MF_Model pModel, Lib3MF_Texture2DGroupIterator * pResourceIterator);

/**
* creates a CompositeMaterialsIterator instance with all CompositeMaterials resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getcompositematerials(Lib3MF_Model pModel, Lib3MF_CompositeMaterialsIterator * pResourceIterator);

/**
* creates a MultiPropertyGroupsIterator instance with all MultiPropertyGroup resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getmultipropertygroups(Lib3MF_Model pModel, Lib3MF_MultiPropertyGroupIterator * pResourceIterator);

/**
* creates a resource iterator instance with all slice stack resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getslicestacks(Lib3MF_Model pModel, Lib3MF_SliceStackIterator * pResourceIterator);

/**
* creates a resource iterator instance with all image3d resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getimage3ds(Lib3MF_Model pModel, Lib3MF_Image3DIterator * pResourceIterator);

/**
* Merges all components and objects which are referenced by a build item into a mesh. The memory is duplicated and a new model is created.
*
* @param[in] pModel - Model instance.
* @param[out] pMergedModelInstance - returns the merged model instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_mergetomodel(Lib3MF_Model pModel, Lib3MF_Model * pMergedModelInstance);

/**
* Merges the given model into this model.
*
* @param[in] pModel - Model instance.
* @param[in] pModelInstance - model to be merged
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_mergefrommodel(Lib3MF_Model pModel, Lib3MF_Model pModelInstance);

/**
* adds an empty mesh object to the model.
*
* @param[in] pModel - Model instance.
* @param[out] pMeshObjectInstance -  returns the mesh object instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_addmeshobject(Lib3MF_Model pModel, Lib3MF_MeshObject * pMeshObjectInstance);

/**
* adds an empty component object to the model.
*
* @param[in] pModel - Model instance.
* @param[out] pComponentsObjectInstance -  returns the components object instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_addcomponentsobject(Lib3MF_Model pModel, Lib3MF_ComponentsObject * pComponentsObjectInstance);

/**
* creates a new model slicestack by its id
*
* @param[in] pModel - Model instance.
* @param[in] dZBottom - Bottom Z value of the slicestack
* @param[out] pSliceStackInstance - returns the new slicestack instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_addslicestack(Lib3MF_Model pModel, Lib3MF_double dZBottom, Lib3MF_SliceStack * pSliceStackInstance);

/**
* adds a texture2d resource to the model. Its path is given by that of an existing attachment.
*
* @param[in] pModel - Model instance.
* @param[in] pTextureAttachment - attachment containing the image data.
* @param[out] pTexture2DInstance - returns the new texture instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_addtexture2dfromattachment(Lib3MF_Model pModel, Lib3MF_Attachment pTextureAttachment, Lib3MF_Texture2D * pTexture2DInstance);

/**
* adds an empty BaseMaterialGroup resource to the model.
*
* @param[in] pModel - Model instance.
* @param[out] pBaseMaterialGroupInstance - returns the new base material instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_addbasematerialgroup(Lib3MF_Model pModel, Lib3MF_BaseMaterialGroup * pBaseMaterialGroupInstance);

/**
* adds an empty ColorGroup resource to the model.
*
* @param[in] pModel - Model instance.
* @param[out] pColorGroupInstance - returns the new ColorGroup instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_addcolorgroup(Lib3MF_Model pModel, Lib3MF_ColorGroup * pColorGroupInstance);

/**
* adds an empty Texture2DGroup resource to the model.
*
* @param[in] pModel - Model instance.
* @param[in] pTexture2DInstance - The texture2D instance of the created Texture2DGroup.
* @param[out] pTexture2DGroupInstance - returns the new Texture2DGroup instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_addtexture2dgroup(Lib3MF_Model pModel, Lib3MF_Texture2D pTexture2DInstance, Lib3MF_Texture2DGroup * pTexture2DGroupInstance);

/**
* adds an empty CompositeMaterials resource to the model.
*
* @param[in] pModel - Model instance.
* @param[in] pBaseMaterialGroupInstance - The BaseMaterialGroup instance of the created CompositeMaterials.
* @param[out] pCompositeMaterialsInstance - returns the new CompositeMaterials instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_addcompositematerials(Lib3MF_Model pModel, Lib3MF_BaseMaterialGroup pBaseMaterialGroupInstance, Lib3MF_CompositeMaterials * pCompositeMaterialsInstance);

/**
* adds an empty MultiPropertyGroup resource to the model.
*
* @param[in] pModel - Model instance.
* @param[out] pMultiPropertyGroupInstance - returns the new MultiPropertyGroup instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_addmultipropertygroup(Lib3MF_Model pModel, Lib3MF_MultiPropertyGroup * pMultiPropertyGroupInstance);

/**
* creates a new 3D Image Resource
*
* @param[in] pModel - Model instance.
* @param[in] nColumnCount - the number of columns in each sheet.
* @param[in] nRowCount - the number of rows in each sheet.
* @param[in] nSheetCount - the number of sheets in the image stack.
* @param[out] pInstance - returns the new ImageStack instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_addimagestack(Lib3MF_Model pModel, Lib3MF_uint32 nColumnCount, Lib3MF_uint32 nRowCount, Lib3MF_uint32 nSheetCount, Lib3MF_ImageStack * pInstance);

/**
* finds an ImageStack object by its UniqueResourceID
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - UniqueResourceID
* @param[out] pImageStackInstance - returns the image stack instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getimagestackbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_ImageStack * pImageStackInstance);

/**
* adds a build item to the model.
*
* @param[in] pModel - Model instance.
* @param[in] pObject - Object instance.
* @param[in] pTransform - Transformation matrix.
* @param[out] pBuildItemInstance - returns the build item instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_addbuilditem(Lib3MF_Model pModel, Lib3MF_Object pObject, const sLib3MFTransform * pTransform, Lib3MF_BuildItem * pBuildItemInstance);

/**
* removes a build item from the model
*
* @param[in] pModel - Model instance.
* @param[in] pBuildItemInstance - Build item to remove.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_removebuilditem(Lib3MF_Model pModel, Lib3MF_BuildItem pBuildItemInstance);

/**
* Returns the metadata of the model as MetaDataGroup
*
* @param[in] pModel - Model instance.
* @param[out] pTheMetaDataGroup - returns an Instance of the metadatagroup of the model
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getmetadatagroup(Lib3MF_Model pModel, Lib3MF_MetaDataGroup * pTheMetaDataGroup);

/**
* adds an attachment stream to the model. The OPC part will be related to the model stream with a certain relationship type.
*
* @param[in] pModel - Model instance.
* @param[in] pURI - Path of the attachment
* @param[in] pRelationShipType - Relationship type of the attachment
* @param[out] pAttachmentInstance - Instance of the attachment object
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_addattachment(Lib3MF_Model pModel, const char * pURI, const char * pRelationShipType, Lib3MF_Attachment * pAttachmentInstance);

/**
* Removes attachment from the model.
*
* @param[in] pModel - Model instance.
* @param[in] pAttachmentInstance - Attachment instance to remove
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_removeattachment(Lib3MF_Model pModel, Lib3MF_Attachment pAttachmentInstance);

/**
* retrieves an attachment stream object from the model..
*
* @param[in] pModel - Model instance.
* @param[in] nIndex - Index of the attachment stream
* @param[out] pAttachmentInstance - Instance of the attachment object
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getattachment(Lib3MF_Model pModel, Lib3MF_uint32 nIndex, Lib3MF_Attachment * pAttachmentInstance);

/**
* retrieves an attachment stream object from the model.
*
* @param[in] pModel - Model instance.
* @param[in] pURI - Path URI in the package
* @param[out] pAttachmentInstance - Instance of the attachment object
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_findattachment(Lib3MF_Model pModel, const char * pURI, Lib3MF_Attachment * pAttachmentInstance);

/**
* retrieves the number of attachments of the model.
*
* @param[in] pModel - Model instance.
* @param[out] pAttachmentCount - Returns the number of attachments.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getattachmentcount(Lib3MF_Model pModel, Lib3MF_uint32 * pAttachmentCount);

/**
* Retrieve whether the OPC package contains a package thumbnail.
*
* @param[in] pModel - Model instance.
* @param[out] pHasThumbnail - returns whether the OPC package contains a package thumbnail
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_haspackagethumbnailattachment(Lib3MF_Model pModel, bool * pHasThumbnail);

/**
* Create a new or the existing package thumbnail for the OPC package.
*
* @param[in] pModel - Model instance.
* @param[out] pAttachment - Instance of a new or the existing thumbnailattachment object.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_createpackagethumbnailattachment(Lib3MF_Model pModel, Lib3MF_Attachment * pAttachment);

/**
* Get the attachment to the OPC package containing the package thumbnail.
*
* @param[in] pModel - Model instance.
* @param[out] pAttachment - Instance of the thumbnailattachment object or NULL.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getpackagethumbnailattachment(Lib3MF_Model pModel, Lib3MF_Attachment * pAttachment);

/**
* Remove the attachment to the OPC package containing the package thumbnail.
*
* @param[in] pModel - Model instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_removepackagethumbnailattachment(Lib3MF_Model pModel);

/**
* Adds a new Content Type to the model.
*
* @param[in] pModel - Model instance.
* @param[in] pExtension - File Extension
* @param[in] pContentType - Content Type Identifier
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_addcustomcontenttype(Lib3MF_Model pModel, const char * pExtension, const char * pContentType);

/**
* Removes a custom Content Type from the model (UTF8 version).
*
* @param[in] pModel - Model instance.
* @param[in] pExtension - File Extension
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_removecustomcontenttype(Lib3MF_Model pModel, const char * pExtension);

/**
* Sets the random number generator callback for use in the library
*
* @param[in] pModel - Model instance.
* @param[in] pTheCallback - The callback used to generate random numbers
* @param[in] pUserData - Userdata to be passed to the callback function
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_setrandomnumbercallback(Lib3MF_Model pModel, Lib3MFRandomNumberCallback pTheCallback, Lib3MF_pvoid pUserData);

/**
* Gets the keystore associated with this model
*
* @param[in] pModel - Model instance.
* @param[out] pKeyStore - The package keystore
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getkeystore(Lib3MF_Model pModel, Lib3MF_KeyStore * pKeyStore);

/**
* creates a resource iterator for all functions
*
* @param[in] pModel - Model instance.
* @param[out] pTheResourceIterator - returns the resource iterator
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getfunctions(Lib3MF_Model pModel, Lib3MF_FunctionIterator * pTheResourceIterator);

/**
* adds a function described by nodes to the model
*
* @param[in] pModel - Model instance.
* @param[out] pFunctionInstance - returns the function instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_addimplicitfunction(Lib3MF_Model pModel, Lib3MF_ImplicitFunction * pFunctionInstance);

/**
* adds a function defined by an image3d to the model
*
* @param[in] pModel - Model instance.
* @param[in] pImage3DInstance - the Image3D-instance used for this function
* @param[out] pFunctionInstance - returns the function instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_addfunctionfromimage3d(Lib3MF_Model pModel, Lib3MF_Image3D pImage3DInstance, Lib3MF_FunctionFromImage3D * pFunctionInstance);

/**
* adds a volume data resource to the model.
*
* @param[in] pModel - Model instance.
* @param[out] pVolumeDataInstance - returns the new volume data instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_addvolumedata(Lib3MF_Model pModel, Lib3MF_VolumeData * pVolumeDataInstance);

/**
* adds an empty boundary shape object to the model.
*
* @param[in] pModel - Model instance.
* @param[out] pLevelSetInstance -  returns the mesh object instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_addlevelset(Lib3MF_Model pModel, Lib3MF_LevelSet * pLevelSetInstance);

/**
* creates a resource iterator instance with all boundary shape resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_getlevelsets(Lib3MF_Model pModel, Lib3MF_LevelSetIterator * pResourceIterator);

/**
* Removes a resource from the model
*
* @param[in] pModel - Model instance.
* @param[in] pResource - The resource to remove
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_model_removeresource(Lib3MF_Model pModel, Lib3MF_Resource pResource);

/*************************************************************************************************************************
 Global functions
**************************************************************************************************************************/

/**
* retrieves the binary version of this library.
*
* @param[out] pMajor - returns the major version of this library
* @param[out] pMinor - returns the minor version of this library
* @param[out] pMicro - returns the micro version of this library
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_getlibraryversion(Lib3MF_uint32 * pMajor, Lib3MF_uint32 * pMinor, Lib3MF_uint32 * pMicro);

/**
* retrieves prerelease information of this library.
*
* @param[out] pHasPrereleaseInfo - Does the library provide prerelease version?
* @param[in] nPrereleaseInfoBufferSize - size of the buffer (including trailing 0)
* @param[out] pPrereleaseInfoNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pPrereleaseInfoBuffer -  buffer of retrieves prerelease information of this library., may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_getprereleaseinformation(bool * pHasPrereleaseInfo, const Lib3MF_uint32 nPrereleaseInfoBufferSize, Lib3MF_uint32* pPrereleaseInfoNeededChars, char * pPrereleaseInfoBuffer);

/**
* retrieves build information of this library.
*
* @param[out] pHasBuildInfo - Does the library provide build version?
* @param[in] nBuildInformationBufferSize - size of the buffer (including trailing 0)
* @param[out] pBuildInformationNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pBuildInformationBuffer -  buffer of retrieves build information of this library., may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_getbuildinformation(bool * pHasBuildInfo, const Lib3MF_uint32 nBuildInformationBufferSize, Lib3MF_uint32* pBuildInformationNeededChars, char * pBuildInformationBuffer);

/**
* retrieves whether a specification is supported, and if so, which version.
*
* @param[in] pSpecificationURL - URL of extension to check
* @param[out] pIsSupported - returns whether this specification is supported
* @param[out] pMajor - returns the major version of the extension (if IsSupported)
* @param[out] pMinor - returns the minor version of the extension (if IsSupported)
* @param[out] pMicro - returns the micro version of the extension (if IsSupported)
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_getspecificationversion(const char * pSpecificationURL, bool * pIsSupported, Lib3MF_uint32 * pMajor, Lib3MF_uint32 * pMinor, Lib3MF_uint32 * pMicro);

/**
* creates an empty model instance.
*
* @param[out] pModel - returns an empty model instance
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_createmodel(Lib3MF_Model * pModel);

/**
* releases shared ownership of an object instance
*
* @param[in] pInstance - the object instance to release
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_release(Lib3MF_Base pInstance);

/**
* acquires shared ownership of an object instance
*
* @param[in] pInstance - the object instance to acquire
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_acquire(Lib3MF_Base pInstance);

/**
* Sets the journal file path
*
* @param[in] pJournalPath - File name of the journal file
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_setjournal(const char * pJournalPath);

/**
* Retrieves the last error string of an instance
*
* @param[in] pInstance - Object where the error occured.
* @param[in] nLastErrorStringBufferSize - size of the buffer (including trailing 0)
* @param[out] pLastErrorStringNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pLastErrorStringBuffer -  buffer of Last Error String, may be NULL
* @param[out] pHasLastError - Returns if the instance has a last error.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_getlasterror(Lib3MF_Base pInstance, const Lib3MF_uint32 nLastErrorStringBufferSize, Lib3MF_uint32* pLastErrorStringNeededChars, char * pLastErrorStringBuffer, bool * pHasLastError);

/**
* Returns the address of the SymbolLookupMethod
*
* @param[out] pSymbolLookupMethod - Address of the SymbolAddressMethod
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_getsymbollookupmethod(Lib3MF_pvoid * pSymbolLookupMethod);

/**
* Return an English text for a progress identifier.|Note: this is the only function you can call from your callback function.
*
* @param[in] eTheProgressIdentifier - the progress identifier that is passed to the callback function
* @param[in] nProgressMessageBufferSize - size of the buffer (including trailing 0)
* @param[out] pProgressMessageNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pProgressMessageBuffer -  buffer of English text for the progress identifier, may be NULL
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_retrieveprogressmessage(eLib3MFProgressIdentifier eTheProgressIdentifier, const Lib3MF_uint32 nProgressMessageBufferSize, Lib3MF_uint32* pProgressMessageNeededChars, char * pProgressMessageBuffer);

/**
* Creates a Color from uint8 RGBA values
*
* @param[in] nRed - Red value of color (0-255)
* @param[in] nGreen - Green value of color (0-255)
* @param[in] nBlue - Blue value of color (0-255)
* @param[in] nAlpha - Alpha value of color (0-255)
* @param[out] pTheColor - Assembled color
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_rgbatocolor(Lib3MF_uint8 nRed, Lib3MF_uint8 nGreen, Lib3MF_uint8 nBlue, Lib3MF_uint8 nAlpha, sLib3MFColor * pTheColor);

/**
* Creates a Color from uint8 RGBA values
*
* @param[in] fRed - Red value of color (0-1)
* @param[in] fGreen - Green value of color (0-1)
* @param[in] fBlue - Blue value of color (0-1)
* @param[in] fAlpha - Alpha value of color (0-1)
* @param[out] pTheColor - Assembled color
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_floatrgbatocolor(Lib3MF_single fRed, Lib3MF_single fGreen, Lib3MF_single fBlue, Lib3MF_single fAlpha, sLib3MFColor * pTheColor);

/**
* Calculates uint8-RGBA-values from a Color
*
* @param[in] pTheColor - Color to handle
* @param[out] pRed - Red value of color (0-255)
* @param[out] pGreen - Green value of color (0-255)
* @param[out] pBlue - Blue value of color (0-255)
* @param[out] pAlpha - Alpha value of color (0-255)
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_colortorgba(const sLib3MFColor * pTheColor, Lib3MF_uint8 * pRed, Lib3MF_uint8 * pGreen, Lib3MF_uint8 * pBlue, Lib3MF_uint8 * pAlpha);

/**
* Calculates float-RGBA-values from a Color
*
* @param[in] pTheColor - Color to handle
* @param[out] pRed - Red value of color (0-1)
* @param[out] pGreen - Green value of color (0-1)
* @param[out] pBlue - Blue value of color (0-1)
* @param[out] pAlpha - Alpha value of color (0-1)
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_colortofloatrgba(const sLib3MFColor * pTheColor, Lib3MF_single * pRed, Lib3MF_single * pGreen, Lib3MF_single * pBlue, Lib3MF_single * pAlpha);

/**
* Creates an identity transform
*
* @param[out] pTransform - Transformation matrix.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_getidentitytransform(sLib3MFTransform * pTransform);

/**
* Creates a uniform scale transform
*
* @param[in] fFactor - Factor in X, Y and Z
* @param[out] pTransform - Transformation matrix.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_getuniformscaletransform(Lib3MF_single fFactor, sLib3MFTransform * pTransform);

/**
* Creates a scale transform
*
* @param[in] fFactorX - Factor in X
* @param[in] fFactorY - Factor in Y
* @param[in] fFactorZ - Factor in Z
* @param[out] pTransform - Transformation matrix.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_getscaletransform(Lib3MF_single fFactorX, Lib3MF_single fFactorY, Lib3MF_single fFactorZ, sLib3MFTransform * pTransform);

/**
* Creates an translation transform
*
* @param[in] fVectorX - Translation in X
* @param[in] fVectorY - Translation in Y
* @param[in] fVectorZ - Translation in Z
* @param[out] pTransform - Transformation matrix.
* @return error code or 0 (success)
*/
LIB3MF_DECLSPEC Lib3MFResult lib3mf_gettranslationtransform(Lib3MF_single fVectorX, Lib3MF_single fVectorY, Lib3MF_single fVectorZ, sLib3MFTransform * pTransform);

#ifdef __cplusplus
}
#endif

#endif // __LIB3MF_HEADER

