/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.rest.handler;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.ad.model.ADTask;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.timeseries.function.ExecutorFunction;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.model.Job;
import org.opensearch.timeseries.model.TaskType;
import org.opensearch.timeseries.model.TimeSeriesTask;
import org.opensearch.timeseries.task.TaskCacheManager;
import org.opensearch.timeseries.task.TaskManager;
import org.opensearch.timeseries.util.RestHandlerUtils;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class ConfigUpdateConfirmer<IndexType extends Enum<IndexType>, IndexManagementType extends IndexManagement<IndexType>, TaskCacheManagerType extends TaskCacheManager, TaskTypeEnum extends TaskType, TaskClass extends TimeSeriesTask, TaskManagerType extends TaskManager<TaskCacheManagerType, TaskTypeEnum, TaskClass, IndexType, IndexManagementType>> {
    private final Logger logger = LogManager.getLogger(ConfigUpdateConfirmer.class);
    private final TaskManagerType taskManager;
    private final TransportService transportService;

    public ConfigUpdateConfirmer(TaskManagerType taskManager, TransportService transportService) {
        this.taskManager = taskManager;
        this.transportService = transportService;
    }

    public void confirmJobRunning(ClusterService clusterService, Client client, String id, ActionListener listener, ExecutorFunction function, NamedXContentRegistry xContentRegistry) {
        if (clusterService.state().metadata().indices().containsKey(".opendistro-anomaly-detector-jobs")) {
            GetRequest request = new GetRequest(".opendistro-anomaly-detector-jobs").id(id);
            client.get(request, ActionListener.wrap(response -> this.onGetJobResponseForWrite((GetResponse)response, listener, function, xContentRegistry), exception -> {
                this.logger.error("Fail to get job: " + id, (Throwable)exception);
                listener.onFailure(exception);
            }));
        } else {
            function.execute();
        }
    }

    private void onGetJobResponseForWrite(GetResponse response, ActionListener listener, ExecutorFunction function, NamedXContentRegistry xContentRegistry) {
        String jobId;
        if (response.isExists() && (jobId = response.getId()) != null) {
            try (XContentParser parser = RestHandlerUtils.createXContentParserFromRegistry(xContentRegistry, response.getSourceAsBytesRef());){
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                Job adJob = Job.parse(parser);
                if (adJob.isEnabled()) {
                    listener.onFailure((Exception)new OpenSearchStatusException("Job is running: " + jobId, RestStatus.BAD_REQUEST, new Object[0]));
                    return;
                }
            }
            catch (IOException e) {
                String message = "Failed to parse job " + jobId;
                this.logger.error(message, (Throwable)e);
                listener.onFailure((Exception)new OpenSearchStatusException(message, RestStatus.BAD_REQUEST, new Object[0]));
            }
        }
        function.execute();
    }

    public void confirmBatchRunning(String configId, List<TaskTypeEnum> tasks, ActionListener<Void> listener) {
        ((TaskManager)this.taskManager).getAndExecuteOnLatestConfigLevelTask(configId, tasks, task -> {
            if (task.isPresent() && !((TimeSeriesTask)task.get()).isDone()) {
                String batchTaskName = task.get() instanceof ADTask ? "Historical" : "Run once";
                listener.onFailure((Exception)new OpenSearchStatusException(batchTaskName + " is running", RestStatus.BAD_REQUEST, new Object[0]));
            } else {
                listener.onResponse(null);
            }
        }, this.transportService, false, listener);
    }
}

