/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchException;
import org.opensearch.common.ValidationException;
import org.opensearch.common.regex.Regex;
import org.opensearch.core.common.Strings;
import org.opensearch.indexmanagement.indexstatemanagement.model.ISMTemplate;
import org.opensearch.indexmanagement.util.IndexManagementException;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a*\u0010\u0005\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0018\u00010\u0006*\b\u0012\u0004\u0012\u00020\u00070\u0003\u001a\"\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001aL\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\r*\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00030\r2\u0006\u0010\u000e\u001a\u00020\u00042\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"validateFormat", "Lorg/opensearch/OpenSearchException;", "indexPatterns", "", "", "findSelfConflictingTemplates", "Lkotlin/Pair;", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/ISMTemplate;", "overlapping", "", "p1", "p2", "findConflictingPolicyTemplates", "", "candidate", "priority", "", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nISMTemplateService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ISMTemplateService.kt\norg/opensearch/indexmanagement/indexstatemanagement/ISMTemplateServiceKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,131:1\n1869#2,2:132\n1563#2:135\n1634#2,3:136\n1878#2,3:139\n774#2:152\n865#2,2:153\n1563#2:155\n1634#2,3:156\n1869#2,2:159\n216#3:134\n217#3:142\n216#3:151\n217#3:161\n37#4:143\n36#4,3:144\n37#4:147\n36#4,3:148\n*S KotlinDebug\n*F\n+ 1 ISMTemplateService.kt\norg/opensearch/indexmanagement/indexstatemanagement/ISMTemplateServiceKt\n*L\n75#1:132,2\n85#1:135\n85#1:136,3\n87#1:139,3\n120#1:152\n120#1:153,2\n121#1:155\n121#1:156,3\n122#1:159,2\n83#1:134\n83#1:142\n119#1:151\n119#1:161\n102#1:143\n102#1:144,3\n103#1:147\n103#1:148,3\n*E\n"})
public final class ISMTemplateServiceKt {
    @Nullable
    public static final OpenSearchException validateFormat(@NotNull List<String> indexPatterns) {
        Intrinsics.checkNotNullParameter(indexPatterns, (String)"indexPatterns");
        List indexPatternFormatErrors = new ArrayList();
        boolean hasInclusionPattern = false;
        for (String indexPattern : indexPatterns) {
            String patternToValidate;
            boolean isExclusionPattern = StringsKt.startsWith$default((String)indexPattern, (String)"-", (boolean)false, (int)2, null);
            if (!isExclusionPattern) {
                hasInclusionPattern = true;
            }
            if (isExclusionPattern) {
                String string = indexPattern.substring(1);
                v1 = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            } else {
                v1 = patternToValidate = indexPattern;
            }
            if (isExclusionPattern && ((CharSequence)patternToValidate).length() == 0) {
                indexPatternFormatErrors.add("index_pattern [" + indexPattern + "] must have content after '-' exclusion prefix");
            }
            if (StringsKt.contains$default((CharSequence)patternToValidate, (CharSequence)"#", (boolean)false, (int)2, null)) {
                indexPatternFormatErrors.add("index_pattern [" + indexPattern + "] must not contain a '#'");
            }
            if (StringsKt.contains$default((CharSequence)patternToValidate, (CharSequence)":", (boolean)false, (int)2, null)) {
                indexPatternFormatErrors.add("index_pattern [" + indexPattern + "] must not contain a ':'");
            }
            if (StringsKt.startsWith$default((String)patternToValidate, (String)"_", (boolean)false, (int)2, null)) {
                indexPatternFormatErrors.add("index_pattern [" + indexPattern + "] must not start with '_'");
            }
            if (Strings.validFileNameExcludingAstrix((String)patternToValidate)) continue;
            indexPatternFormatErrors.add("index_pattern [" + indexPattern + "] must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
        if (!hasInclusionPattern) {
            indexPatternFormatErrors.add("index_patterns must contain at least one inclusion pattern (patterns cannot be all exclusions)");
        }
        if (indexPatternFormatErrors.size() > 0) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationErrors((Iterable)indexPatternFormatErrors);
            return IndexManagementException.Companion.wrap((Exception)validationException);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Pair<List<String>, List<String>> findSelfConflictingTemplates(@NotNull List<ISMTemplate> $this$findSelfConflictingTemplates) {
        List templateList;
        Object element$iv;
        Intrinsics.checkNotNullParameter($this$findSelfConflictingTemplates, (String)"<this>");
        Map priorityToTemplates = new LinkedHashMap();
        Object $this$forEach$iv = $this$findSelfConflictingTemplates;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            ISMTemplate it = (ISMTemplate)element$iv;
            boolean bl = false;
            templateList = (List)priorityToTemplates.get(it.getPriority());
            if (templateList != null) {
                priorityToTemplates.put(it.getPriority(), CollectionsKt.plus((Collection)templateList, (Object)it));
                continue;
            }
            Map map = priorityToTemplates;
            Integer n = it.getPriority();
            Object object = new ISMTemplate[]{it};
            object = CollectionsKt.mutableListOf((Object[])object);
            map.put(n, object);
        }
        $this$forEach$iv = priorityToTemplates;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Object object = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            templateList = (List)object.getValue();
            Iterable $this$map$iv = templateList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ISMTemplate iSMTemplate = (ISMTemplate)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getIndexPatterns());
            }
            List indexPatternsList = (List)destination$iv$iv;
            if (indexPatternsList.size() <= 1) continue;
            Iterable $this$forEachIndexed$iv = indexPatternsList;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void indexPatterns;
                int n;
                Object item$iv$iv;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                item$iv$iv = (List)item$iv;
                int ind = n;
                boolean bl3 = false;
                List comparePatterns = CollectionsKt.flatten((Iterable)indexPatternsList.subList(ind + 1, indexPatternsList.size()));
                if (!ISMTemplateServiceKt.overlapping((List<String>)indexPatterns, comparePatterns)) continue;
                return TuplesKt.to((Object)indexPatterns, (Object)comparePatterns);
            }
        }
        return null;
    }

    public static final boolean overlapping(@NotNull List<String> p1, @NotNull List<String> p2) {
        Intrinsics.checkNotNullParameter(p1, (String)"p1");
        Intrinsics.checkNotNullParameter(p2, (String)"p2");
        if (p1.isEmpty() || p2.isEmpty()) {
            return false;
        }
        Collection $this$toTypedArray$iv = p1;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Automaton a1 = Regex.simpleMatchToAutomaton((String[])Arrays.copyOf(stringArray, stringArray.length));
        Collection $this$toTypedArray$iv2 = p2;
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        String[] stringArray2 = thisCollection$iv2.toArray(new String[0]);
        Automaton a2 = Regex.simpleMatchToAutomaton((String[])Arrays.copyOf(stringArray2, stringArray2.length));
        return !Operations.isEmpty((Automaton)Operations.intersection((Automaton)a1, (Automaton)a2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, List<String>> findConflictingPolicyTemplates(@NotNull Map<String, ? extends List<ISMTemplate>> $this$findConflictingPolicyTemplates, @NotNull String candidate, @NotNull List<String> indexPatterns, int priority) {
        Intrinsics.checkNotNullParameter($this$findConflictingPolicyTemplates, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        Intrinsics.checkNotNullParameter(indexPatterns, (String)"indexPatterns");
        Map overlappingTemplates = new LinkedHashMap();
        Map<String, ? extends List<ISMTemplate>> $this$forEach$iv = $this$findConflictingPolicyTemplates;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends List<ISMTemplate>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            ISMTemplate it;
            void $this$filterTo$iv$iv;
            Map.Entry<String, ? extends List<ISMTemplate>> element$iv;
            Map.Entry<String, ? extends List<ISMTemplate>> entry = element$iv = iterator.next();
            boolean bl = false;
            String policyID = entry.getKey();
            List<ISMTemplate> templateList = entry.getValue();
            Iterable $this$filter$iv = templateList;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ISMTemplate)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getPriority() == priority)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ISMTemplate)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getIndexPatterns());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                List it2 = (List)element$iv2;
                boolean bl4 = false;
                if (!ISMTemplateServiceKt.overlapping(indexPatterns, it2)) continue;
                overlappingTemplates.put(policyID, it2);
            }
        }
        overlappingTemplates.remove(candidate);
        return overlappingTemplates;
    }
}

