/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.HttpEntity;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.io.entity.HttpEntityWrapper;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.util.Args;

public final class DeflateCompressingEntity
extends HttpEntityWrapper {
    private static final String DEFLATE_CODEC = "deflate";

    public DeflateCompressingEntity(HttpEntity entity) {
        super(entity);
    }

    @Override
    public String getContentEncoding() {
        return DEFLATE_CODEC;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public boolean isChunked() {
        return true;
    }

    @Override
    public InputStream getContent() throws IOException {
        throw new UnsupportedOperationException("getContent() not supported");
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        Args.notNull(out, "Output stream");
        try (DeflaterOutputStream deflater = new DeflaterOutputStream(out, new Deflater(-1, false));){
            super.writeTo(deflater);
        }
    }
}

