/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import git4idea.branch.GitBranchType;
import git4idea.branch.GitRefType;
import git4idea.branch.GitTagType;
import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.RefInfo;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\u000e\u001a\u00020\u000f2 \u0010\u0010\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0003\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u0011J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003H\u00c6\u0003J9\u0010\u0016\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lgit4idea/ui/branch/dashboard/RefsCollection;", "", "localBranches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "remoteBranches", "tags", "Lgit4idea/ui/branch/dashboard/RefInfo;", "<init>", "(Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;)V", "getLocalBranches", "()Ljava/util/Collection;", "getRemoteBranches", "getTags", "forEach", "", "action", "Lkotlin/Function2;", "Lgit4idea/branch/GitRefType;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.vcs.git"})
public final class RefsCollection {
    @NotNull
    private final Collection<BranchInfo> localBranches;
    @NotNull
    private final Collection<BranchInfo> remoteBranches;
    @NotNull
    private final Collection<RefInfo> tags;

    public RefsCollection(@NotNull Collection<BranchInfo> localBranches2, @NotNull Collection<BranchInfo> remoteBranches2, @NotNull Collection<RefInfo> tags2) {
        Intrinsics.checkNotNullParameter(localBranches2, (String)"localBranches");
        Intrinsics.checkNotNullParameter(remoteBranches2, (String)"remoteBranches");
        Intrinsics.checkNotNullParameter(tags2, (String)"tags");
        this.localBranches = localBranches2;
        this.remoteBranches = remoteBranches2;
        this.tags = tags2;
    }

    @NotNull
    public final Collection<BranchInfo> getLocalBranches() {
        return this.localBranches;
    }

    @NotNull
    public final Collection<BranchInfo> getRemoteBranches() {
        return this.remoteBranches;
    }

    @NotNull
    public final Collection<RefInfo> getTags() {
        return this.tags;
    }

    public final void forEach(@NotNull Function2<? super Collection<? extends RefInfo>, ? super GitRefType, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Pair[] pairArray2 = new Pair[]{TuplesKt.to(this.localBranches, (Object)GitBranchType.LOCAL), TuplesKt.to(this.remoteBranches, (Object)GitBranchType.REMOTE), TuplesKt.to(this.tags, (Object)GitTagType.INSTANCE)};
        for (Pair[] pairArray2 : CollectionsKt.listOf((Object[])pairArray2)) {
            Collection refs = (Collection)pairArray2.component1();
            GitRefType group = (GitRefType)pairArray2.component2();
            action.invoke((Object)refs, (Object)group);
        }
    }

    @NotNull
    public final Collection<BranchInfo> component1() {
        return this.localBranches;
    }

    @NotNull
    public final Collection<BranchInfo> component2() {
        return this.remoteBranches;
    }

    @NotNull
    public final Collection<RefInfo> component3() {
        return this.tags;
    }

    @NotNull
    public final RefsCollection copy(@NotNull Collection<BranchInfo> localBranches2, @NotNull Collection<BranchInfo> remoteBranches2, @NotNull Collection<RefInfo> tags2) {
        Intrinsics.checkNotNullParameter(localBranches2, (String)"localBranches");
        Intrinsics.checkNotNullParameter(remoteBranches2, (String)"remoteBranches");
        Intrinsics.checkNotNullParameter(tags2, (String)"tags");
        return new RefsCollection(localBranches2, remoteBranches2, tags2);
    }

    public static /* synthetic */ RefsCollection copy$default(RefsCollection refsCollection, Collection collection, Collection collection2, Collection collection3, int n, Object object) {
        if ((n & 1) != 0) {
            collection = refsCollection.localBranches;
        }
        if ((n & 2) != 0) {
            collection2 = refsCollection.remoteBranches;
        }
        if ((n & 4) != 0) {
            collection3 = refsCollection.tags;
        }
        return refsCollection.copy(collection, collection2, collection3);
    }

    @NotNull
    public String toString() {
        return "RefsCollection(localBranches=" + this.localBranches + ", remoteBranches=" + this.remoteBranches + ", tags=" + this.tags + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.localBranches).hashCode();
        result2 = result2 * 31 + ((Object)this.remoteBranches).hashCode();
        result2 = result2 * 31 + ((Object)this.tags).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RefsCollection)) {
            return false;
        }
        RefsCollection refsCollection = (RefsCollection)other;
        if (!Intrinsics.areEqual(this.localBranches, refsCollection.localBranches)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.remoteBranches, refsCollection.remoteBranches)) {
            return false;
        }
        return Intrinsics.areEqual(this.tags, refsCollection.tags);
    }
}

