# SPDX-FileCopyrightText: Copyright (c) 2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
# SPDX-License-Identifier: Apache-2.0

# Automatically generated by Numbast Static Binding Generator
# Generator Information:
# Ast_canopy version: 0.6.1.dev18+gc41f52f6f.d20251223
# Numbast version: 0.6.1.dev0+ga900697e9.d20251217
# Generation command: static_binding_generator --cfg-path configs/cuda_fp8.yml --output-dir ./numba_cuda/numba/cuda/_internal
# Static binding generator parameters: {'cfg_path': 'configs/cuda_fp8.yml', 'output_dir': './numba_cuda/numba/cuda/_internal', 'run_ruff_format': True, 'bypass_parse_error': False}
# Config file path (relative to the path of the generated binding): ../../../../../configs/cuda_fp8.yml
# Cudatoolkit version: (13, 0)


# Imports:
from numba.cuda.typing.templates import ConcreteTemplate
from numba.cuda.types import float16
from numba.cuda.types import IntEnumMember
from numba import types
from numba.cuda.extending import make_attribute_wrapper
from numba.cuda.types import bool_
from numba.cuda.types import uint64
from llvmlite import ir
from cuda.bindings.runtime import cudaRoundMode
from numba.cuda.typing.templates import Registry as TypingRegistry
from numba.cuda.types import uint32
from numba.cuda.types import float32
from enum import IntEnum
from numba.cuda.datamodel import StructModel
from numba.cuda.core.imputils import Registry as TargetRegistry
from numba.cuda.extending import as_numba_type
from numba.cuda.types import Function
from numba.cuda.types import Type
from numba.cuda.types import int32
from numba.types import BoundFunction
from numba.cuda.types import uint8
from numba.cuda.typing.templates import AttributeTemplate
from numba.cuda.vector_types import vector_types
from numba.cuda.types import int8
from numba.core.typing import signature
from numba.cuda.types import bfloat16
from numba.cuda.typing import signature
from numba.cuda.extending import register_model
from numba.cuda.types import float64
from numba.cuda.datamodel import PrimitiveModel
from numba.cuda._internal.cuda_bf16 import (
    _type_unnamed1405307 as bfloat16_raw_type,
)
import numba
from numba.cuda.types import int16
from numba.cuda.types import int64
import io
from numba.cuda.types import Number
from numba.cuda.types import uint16
from numba.cuda import CUSource


float32x2 = vector_types["float32x2"]
float64x2 = vector_types["float64x2"]
float32x4 = vector_types["float32x4"]
float64x4 = vector_types["float64x4"]


typing_registry = TypingRegistry()
register = typing_registry.register
register_attr = typing_registry.register_attr
register_global = typing_registry.register_global
target_registry = TargetRegistry()
lower = target_registry.lower
lower_attr = target_registry.lower_getattr
lower_constant = target_registry.lower_constant
lower_cast = target_registry.lower_cast

# Shim Stream:


class _KeyedStringIO(io.StringIO):
    def __init__(self, *arg, **kwarg):
        super().__init__(*arg, *kwarg)
        self._keys = set()

    def write_with_key(self, key: str, value: str):
        if key in self._keys:
            return
        self._keys.add(key)
        self.write(value)

    def reset(self):
        self._keys.clear()
        self.seek(0)


shim_defines = ""
shim_include = "#include <" + "cuda_fp8.h" + ">"
shim_prefix = shim_defines + "\n" + shim_include
shim_stream = _KeyedStringIO()
shim_stream.write(shim_prefix)
shim_obj = CUSource(shim_stream)


from numba.cuda.target import CUDATargetContext

from llvmlite import ir


def prepare_ir_types(
    context: CUDATargetContext, argtys: list[ir.Type]
) -> list[ir.Type]:
    """
    Prepare IR types for passing arguments via pointers in function calls.

    This utility wraps each argument type in a PointerType to enable
    the call convention used by FunctionCallConv, where arguments are
    passed by reference.

    Parameters
    ----------
    context : context object
        The compilation context providing the get_value_type method.
    argtys : list[ir.Type]
        List of LLVM IR types representing function arguments.

    Returns
    -------
    list[ir.Type]
        List of pointer types wrapping the value types of each argument.
    """
    return [ir.PointerType(context.get_value_type(argty)) for argty in argtys]


from numba.cuda import types, cgutils

from llvmlite import ir


class BaseCallConv:
    shim_function_template = "{mangled_name}_nbst"

    def __init__(
        self,
        itanium_mangled_name: str,
        shim_writer: object,
        shim_code: str,
    ):
        self.shim_writer = shim_writer
        self.itanium_mangled_name = itanium_mangled_name
        self.shim_code = shim_code

        self.shim_function_name = self.shim_function_template.format(
            mangled_name=self.itanium_mangled_name
        )

    def _lazy_write_shim(self, shim_code: str):
        self.shim_writer.write_to_shim(shim_code, self.shim_function_name)

    def _lower(self, builder, context, sig, args):
        self._lazy_write_shim(self.shim_code)
        return self._lower_impl(builder, context, sig, args)

    def _lower_impl(self, builder, context, sig, args):
        raise NotImplementedError

    def __call__(self, builder, context, sig, args):
        return self._lower(builder, context, sig, args)


class FunctionCallConv(BaseCallConv):
    def _lower_impl(self, builder, context, sig, args):
        return_type = sig.return_type
        # 1. Prepare return value pointer
        if return_type == types.void:
            # Void return type in C++ is shimmed as int& ignored
            retval_ty = ir.IntType(32)
            retval_ptr = builder.alloca(retval_ty, name="ignored")
        else:
            retval_ty = context.get_value_type(return_type)
            retval_ptr = builder.alloca(retval_ty, name="retval")

        # 2. Prepare arguments
        arg_pointer_types = prepare_ir_types(context, sig.args)

        # All arguments are passed by pointer
        ptrs = [
            cgutils.alloca_once(builder, context.get_value_type(argty))
            for argty in sig.args
        ]
        for ptr, argty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(argty, "alignof_", None))

        # 3. Declare shim
        # Shim signature: int (retval_type*, arg0_type*, ...)
        fnty = ir.FunctionType(
            ir.IntType(32), [ir.PointerType(retval_ty)] + arg_pointer_types
        )
        fn = cgutils.get_or_insert_function(
            builder.module, fnty, self.shim_function_name
        )

        # 4. Call shim
        builder.call(fn, (retval_ptr, *ptrs))

        # 5. Return
        if return_type == types.void:
            return None
        else:
            return builder.load(
                retval_ptr, align=getattr(return_type, "alignof_", None)
            )


class ShimWriterAdapter:
    def __init__(self, stream):
        self.stream = stream

    def write_to_shim(self, content, id):
        self.stream.write_with_key(id, content)


shim_writer = ShimWriterAdapter(shim_stream)

# Enums:


class saturation_t(IntEnum):
    NOSAT = 0
    SATFINITE = 1


class fp8_interpretation_t(IntEnum):
    E4M3 = 0
    E5M2 = 1


# Structs:


# Typing for fp8_e5m2
class _type_class_fp8_e5m2(Number):
    def __init__(self):
        super().__init__(name="fp8_e5m2")
        self.alignof_ = 1
        self.bitwidth = 1 * 8

    def can_convert_from(self, typingctx, other):
        from numba.cuda.typeconv import Conversion

        if other in []:
            return Conversion.safe


_type_fp8_e5m2 = _type_class_fp8_e5m2()


# Make Python API for struct
fp8_e5m2 = type("fp8_e5m2", (), {"_nbtype": _type_fp8_e5m2})

as_numba_type.register(fp8_e5m2, _type_fp8_e5m2)


@register_model(_type_class_fp8_e5m2)
class _model_fp8_e5m2(PrimitiveModel):
    def __init__(self, dmm, fe_type):
        be_type = ir.IntType(fe_type.bitwidth)
        super(_model_fp8_e5m2, self).__init__(dmm, fe_type, be_type)


def _lower__ZN13__nv_fp8_e5m2C1Ev(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e5m2C1Ev_nbst(__nv_fp8_e5m2 *self ) {
        new (self) __nv_fp8_e5m2();
        return 0;
    }
        """

    @lower(
        fp8_e5m2,
    )
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e5m2C1Ev",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e5m2C1Ev(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e5m2C1E6__half(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e5m2C1E6__half_nbst(__nv_fp8_e5m2 *self , __half* f) {
        new (self) __nv_fp8_e5m2(*f);
        return 0;
    }
        """

    @lower(fp8_e5m2, float16)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e5m2C1E6__half",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e5m2C1E6__half(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e5m2C1E13__nv_bfloat16(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e5m2C1E13__nv_bfloat16_nbst(__nv_fp8_e5m2 *self , __nv_bfloat16* f) {
        new (self) __nv_fp8_e5m2(*f);
        return 0;
    }
        """

    @lower(fp8_e5m2, bfloat16)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e5m2C1E13__nv_bfloat16",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e5m2C1E13__nv_bfloat16(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e5m2C1Ef(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e5m2C1Ef_nbst(__nv_fp8_e5m2 *self , float* f) {
        new (self) __nv_fp8_e5m2(*f);
        return 0;
    }
        """

    @lower(fp8_e5m2, float32)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e5m2C1Ef",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e5m2C1Ef(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e5m2C1Ed(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e5m2C1Ed_nbst(__nv_fp8_e5m2 *self , double* f) {
        new (self) __nv_fp8_e5m2(*f);
        return 0;
    }
        """

    @lower(fp8_e5m2, float64)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e5m2C1Ed",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e5m2C1Ed(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e5m2C1Et(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e5m2C1Et_nbst(__nv_fp8_e5m2 *self , unsigned short* val) {
        new (self) __nv_fp8_e5m2(*val);
        return 0;
    }
        """

    @lower(fp8_e5m2, uint16)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e5m2C1Et",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e5m2C1Et(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e5m2C1Ej(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e5m2C1Ej_nbst(__nv_fp8_e5m2 *self , unsigned int* val) {
        new (self) __nv_fp8_e5m2(*val);
        return 0;
    }
        """

    @lower(fp8_e5m2, uint32)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e5m2C1Ej",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e5m2C1Ej(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e5m2C1Em(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e5m2C1Em_nbst(__nv_fp8_e5m2 *self , unsigned long* val) {
        new (self) __nv_fp8_e5m2(*val);
        return 0;
    }
        """

    @lower(fp8_e5m2, uint64)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e5m2C1Em",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e5m2C1Em(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e5m2C1Ey(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e5m2C1Ey_nbst(__nv_fp8_e5m2 *self , unsigned long long* val) {
        new (self) __nv_fp8_e5m2(*val);
        return 0;
    }
        """

    @lower(fp8_e5m2, uint64)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e5m2C1Ey",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e5m2C1Ey(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e5m2C1Es(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e5m2C1Es_nbst(__nv_fp8_e5m2 *self , short* val) {
        new (self) __nv_fp8_e5m2(*val);
        return 0;
    }
        """

    @lower(fp8_e5m2, int16)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e5m2C1Es",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e5m2C1Es(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e5m2C1Ei(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e5m2C1Ei_nbst(__nv_fp8_e5m2 *self , int* val) {
        new (self) __nv_fp8_e5m2(*val);
        return 0;
    }
        """

    @lower(fp8_e5m2, int32)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e5m2C1Ei",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e5m2C1Ei(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e5m2C1El(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e5m2C1El_nbst(__nv_fp8_e5m2 *self , long* val) {
        new (self) __nv_fp8_e5m2(*val);
        return 0;
    }
        """

    @lower(fp8_e5m2, int64)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e5m2C1El",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e5m2C1El(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e5m2C1Ex(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e5m2C1Ex_nbst(__nv_fp8_e5m2 *self , long long* val) {
        new (self) __nv_fp8_e5m2(*val);
        return 0;
    }
        """

    @lower(fp8_e5m2, int64)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e5m2C1Ex",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e5m2C1Ex(shim_stream, shim_obj)


@register
class _ctor_template___nv_fp8_e5m2(ConcreteTemplate):
    key = globals()["fp8_e5m2"]
    cases = [
        signature(
            _type_fp8_e5m2,
        ),
        signature(_type_fp8_e5m2, float16),
        signature(_type_fp8_e5m2, bfloat16),
        signature(_type_fp8_e5m2, float32),
        signature(_type_fp8_e5m2, float64),
        signature(_type_fp8_e5m2, uint16),
        signature(_type_fp8_e5m2, uint32),
        signature(_type_fp8_e5m2, uint64),
        signature(_type_fp8_e5m2, uint64),
        signature(_type_fp8_e5m2, int16),
        signature(_type_fp8_e5m2, int32),
        signature(_type_fp8_e5m2, int64),
        signature(_type_fp8_e5m2, int64),
    ]


register_global(fp8_e5m2, Function(_ctor_template___nv_fp8_e5m2))


def _from___nv_fp8_e5m2_to_float16_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e5m2cv6__halfEv_nbst(__half &retval, __nv_fp8_e5m2 *self) {
        retval = self->operator __half();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e5m2, float16)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e5m2cv6__halfEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e5m2_to_float16_lower(shim_stream, shim_obj)


def _from___nv_fp8_e5m2_to_float32_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e5m2cvfEv_nbst(float &retval, __nv_fp8_e5m2 *self) {
        retval = self->operator float();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e5m2, float32)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e5m2cvfEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e5m2_to_float32_lower(shim_stream, shim_obj)


def _from___nv_fp8_e5m2_to_bfloat16_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e5m2cv13__nv_bfloat16Ev_nbst(__nv_bfloat16 &retval, __nv_fp8_e5m2 *self) {
        retval = self->operator __nv_bfloat16();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e5m2, bfloat16)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e5m2cv13__nv_bfloat16Ev",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e5m2_to_bfloat16_lower(shim_stream, shim_obj)


def _from___nv_fp8_e5m2_to_float64_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e5m2cvdEv_nbst(double &retval, __nv_fp8_e5m2 *self) {
        retval = self->operator double();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e5m2, float64)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e5m2cvdEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e5m2_to_float64_lower(shim_stream, shim_obj)


def _from___nv_fp8_e5m2_to_uint8_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e5m2cvhEv_nbst(unsigned char &retval, __nv_fp8_e5m2 *self) {
        retval = self->operator unsigned char();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e5m2, uint8)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e5m2cvhEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e5m2_to_uint8_lower(shim_stream, shim_obj)


def _from___nv_fp8_e5m2_to_uint16_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e5m2cvtEv_nbst(unsigned short &retval, __nv_fp8_e5m2 *self) {
        retval = self->operator unsigned short();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e5m2, uint16)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e5m2cvtEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e5m2_to_uint16_lower(shim_stream, shim_obj)


def _from___nv_fp8_e5m2_to_uint32_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e5m2cvjEv_nbst(unsigned int &retval, __nv_fp8_e5m2 *self) {
        retval = self->operator unsigned int();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e5m2, uint32)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e5m2cvjEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e5m2_to_uint32_lower(shim_stream, shim_obj)


def _from___nv_fp8_e5m2_to_uint64_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e5m2cvmEv_nbst(unsigned long &retval, __nv_fp8_e5m2 *self) {
        retval = self->operator unsigned long();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e5m2, uint64)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e5m2cvmEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e5m2_to_uint64_lower(shim_stream, shim_obj)


def _from___nv_fp8_e5m2_to_int8_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e5m2cvaEv_nbst(signed char &retval, __nv_fp8_e5m2 *self) {
        retval = self->operator signed char();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e5m2, int8)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e5m2cvaEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e5m2_to_int8_lower(shim_stream, shim_obj)


def _from___nv_fp8_e5m2_to_int16_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e5m2cvsEv_nbst(short &retval, __nv_fp8_e5m2 *self) {
        retval = self->operator short();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e5m2, int16)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e5m2cvsEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e5m2_to_int16_lower(shim_stream, shim_obj)


def _from___nv_fp8_e5m2_to_int32_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e5m2cviEv_nbst(int &retval, __nv_fp8_e5m2 *self) {
        retval = self->operator int();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e5m2, int32)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e5m2cviEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e5m2_to_int32_lower(shim_stream, shim_obj)


def _from___nv_fp8_e5m2_to_int64_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e5m2cvlEv_nbst(long &retval, __nv_fp8_e5m2 *self) {
        retval = self->operator long();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e5m2, int64)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e5m2cvlEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e5m2_to_int64_lower(shim_stream, shim_obj)


def _from___nv_fp8_e5m2_to_int64_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e5m2cvxEv_nbst(long long &retval, __nv_fp8_e5m2 *self) {
        retval = self->operator long long();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e5m2, int64)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e5m2cvxEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e5m2_to_int64_lower(shim_stream, shim_obj)


def _from___nv_fp8_e5m2_to_bool__lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e5m2cvbEv_nbst(bool &retval, __nv_fp8_e5m2 *self) {
        retval = self->operator bool();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e5m2, bool_)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e5m2cvbEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e5m2_to_bool__lower(shim_stream, shim_obj)


# Typing for fp8x2_e5m2
class _type_class_fp8x2_e5m2(Type):
    def __init__(self):
        super().__init__(name="fp8x2_e5m2")
        self.alignof_ = 2
        self.bitwidth = 2 * 8

    def can_convert_from(self, typingctx, other):
        from numba.cuda.typeconv import Conversion

        if other in []:
            return Conversion.safe


_type_fp8x2_e5m2 = _type_class_fp8x2_e5m2()


# Make Python API for struct
fp8x2_e5m2 = type("fp8x2_e5m2", (), {"_nbtype": _type_fp8x2_e5m2})

as_numba_type.register(fp8x2_e5m2, _type_fp8x2_e5m2)


@register_model(_type_class_fp8x2_e5m2)
class _model_fp8x2_e5m2(StructModel):
    def __init__(self, dmm, fe_type):
        members = [("__x", uint16)]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_fp8x2_e5m2(AttributeTemplate):
    key = _type_fp8x2_e5m2

    def resolve___x(self, obj):
        return uint16


make_attribute_wrapper(_type_class_fp8x2_e5m2, "__x", "__x")


def _lower__ZN15__nv_fp8x2_e5m2C1Ev(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN15__nv_fp8x2_e5m2C1Ev_nbst(__nv_fp8x2_e5m2 *self ) {
        new (self) __nv_fp8x2_e5m2();
        return 0;
    }
        """

    @lower(
        fp8x2_e5m2,
    )
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN15__nv_fp8x2_e5m2C1Ev",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN15__nv_fp8x2_e5m2C1Ev(shim_stream, shim_obj)


def _lower__ZN15__nv_fp8x2_e5m2C1E6float2(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN15__nv_fp8x2_e5m2C1E6float2_nbst(__nv_fp8x2_e5m2 *self , float2* f) {
        new (self) __nv_fp8x2_e5m2(*f);
        return 0;
    }
        """

    @lower(fp8x2_e5m2, float32x2)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN15__nv_fp8x2_e5m2C1E6float2",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN15__nv_fp8x2_e5m2C1E6float2(shim_stream, shim_obj)


def _lower__ZN15__nv_fp8x2_e5m2C1E7double2(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN15__nv_fp8x2_e5m2C1E7double2_nbst(__nv_fp8x2_e5m2 *self , double2* f) {
        new (self) __nv_fp8x2_e5m2(*f);
        return 0;
    }
        """

    @lower(fp8x2_e5m2, float64x2)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN15__nv_fp8x2_e5m2C1E7double2",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN15__nv_fp8x2_e5m2C1E7double2(shim_stream, shim_obj)


@register
class _ctor_template___nv_fp8x2_e5m2(ConcreteTemplate):
    key = globals()["fp8x2_e5m2"]
    cases = [
        signature(
            _type_fp8x2_e5m2,
        ),
        signature(_type_fp8x2_e5m2, float32x2),
        signature(_type_fp8x2_e5m2, float64x2),
    ]


register_global(fp8x2_e5m2, Function(_ctor_template___nv_fp8x2_e5m2))


def _from___nv_fp8x2_e5m2_to_float32x2_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK15__nv_fp8x2_e5m2cv6float2Ev_nbst(float2 &retval, __nv_fp8x2_e5m2 *self) {
        retval = self->operator float2();
        return 0;
    }
        """

    @lower_cast(_type_fp8x2_e5m2, float32x2)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK15__nv_fp8x2_e5m2cv6float2Ev",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8x2_e5m2_to_float32x2_lower(shim_stream, shim_obj)


# Typing for fp8x4_e5m2
class _type_class_fp8x4_e5m2(Type):
    def __init__(self):
        super().__init__(name="fp8x4_e5m2")
        self.alignof_ = 4
        self.bitwidth = 4 * 8

    def can_convert_from(self, typingctx, other):
        from numba.cuda.typeconv import Conversion

        if other in []:
            return Conversion.safe


_type_fp8x4_e5m2 = _type_class_fp8x4_e5m2()


# Make Python API for struct
fp8x4_e5m2 = type("fp8x4_e5m2", (), {"_nbtype": _type_fp8x4_e5m2})

as_numba_type.register(fp8x4_e5m2, _type_fp8x4_e5m2)


@register_model(_type_class_fp8x4_e5m2)
class _model_fp8x4_e5m2(StructModel):
    def __init__(self, dmm, fe_type):
        members = [("__x", uint32)]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_fp8x4_e5m2(AttributeTemplate):
    key = _type_fp8x4_e5m2

    def resolve___x(self, obj):
        return uint32


make_attribute_wrapper(_type_class_fp8x4_e5m2, "__x", "__x")


def _lower__ZN15__nv_fp8x4_e5m2C1Ev(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN15__nv_fp8x4_e5m2C1Ev_nbst(__nv_fp8x4_e5m2 *self ) {
        new (self) __nv_fp8x4_e5m2();
        return 0;
    }
        """

    @lower(
        fp8x4_e5m2,
    )
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN15__nv_fp8x4_e5m2C1Ev",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN15__nv_fp8x4_e5m2C1Ev(shim_stream, shim_obj)


def _lower__ZN15__nv_fp8x4_e5m2C1E6float4(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN15__nv_fp8x4_e5m2C1E6float4_nbst(__nv_fp8x4_e5m2 *self , float4* f) {
        new (self) __nv_fp8x4_e5m2(*f);
        return 0;
    }
        """

    @lower(fp8x4_e5m2, float32x4)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN15__nv_fp8x4_e5m2C1E6float4",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN15__nv_fp8x4_e5m2C1E6float4(shim_stream, shim_obj)


def _lower__ZN15__nv_fp8x4_e5m2C1E7double4(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN15__nv_fp8x4_e5m2C1E7double4_nbst(__nv_fp8x4_e5m2 *self , double4* f) {
        new (self) __nv_fp8x4_e5m2(*f);
        return 0;
    }
        """

    @lower(fp8x4_e5m2, float64x4)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN15__nv_fp8x4_e5m2C1E7double4",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN15__nv_fp8x4_e5m2C1E7double4(shim_stream, shim_obj)


@register
class _ctor_template___nv_fp8x4_e5m2(ConcreteTemplate):
    key = globals()["fp8x4_e5m2"]
    cases = [
        signature(
            _type_fp8x4_e5m2,
        ),
        signature(_type_fp8x4_e5m2, float32x4),
        signature(_type_fp8x4_e5m2, float64x4),
    ]


register_global(fp8x4_e5m2, Function(_ctor_template___nv_fp8x4_e5m2))


def _from___nv_fp8x4_e5m2_to_float32x4_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK15__nv_fp8x4_e5m2cv6float4Ev_nbst(float4 &retval, __nv_fp8x4_e5m2 *self) {
        retval = self->operator float4();
        return 0;
    }
        """

    @lower_cast(_type_fp8x4_e5m2, float32x4)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK15__nv_fp8x4_e5m2cv6float4Ev",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8x4_e5m2_to_float32x4_lower(shim_stream, shim_obj)


# Typing for fp8_e4m3
class _type_class_fp8_e4m3(Number):
    def __init__(self):
        super().__init__(name="fp8_e4m3")
        self.alignof_ = 1
        self.bitwidth = 1 * 8

    def can_convert_from(self, typingctx, other):
        from numba.cuda.typeconv import Conversion

        if other in []:
            return Conversion.safe


_type_fp8_e4m3 = _type_class_fp8_e4m3()


# Make Python API for struct
fp8_e4m3 = type("fp8_e4m3", (), {"_nbtype": _type_fp8_e4m3})

as_numba_type.register(fp8_e4m3, _type_fp8_e4m3)


@register_model(_type_class_fp8_e4m3)
class _model_fp8_e4m3(PrimitiveModel):
    def __init__(self, dmm, fe_type):
        be_type = ir.IntType(fe_type.bitwidth)
        super(_model_fp8_e4m3, self).__init__(dmm, fe_type, be_type)


def _lower__ZN13__nv_fp8_e4m3C1Ev(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e4m3C1Ev_nbst(__nv_fp8_e4m3 *self ) {
        new (self) __nv_fp8_e4m3();
        return 0;
    }
        """

    @lower(
        fp8_e4m3,
    )
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e4m3C1Ev",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e4m3C1Ev(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e4m3C1E6__half(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e4m3C1E6__half_nbst(__nv_fp8_e4m3 *self , __half* f) {
        new (self) __nv_fp8_e4m3(*f);
        return 0;
    }
        """

    @lower(fp8_e4m3, float16)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e4m3C1E6__half",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e4m3C1E6__half(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e4m3C1E13__nv_bfloat16(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e4m3C1E13__nv_bfloat16_nbst(__nv_fp8_e4m3 *self , __nv_bfloat16* f) {
        new (self) __nv_fp8_e4m3(*f);
        return 0;
    }
        """

    @lower(fp8_e4m3, bfloat16)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e4m3C1E13__nv_bfloat16",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e4m3C1E13__nv_bfloat16(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e4m3C1Ef(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e4m3C1Ef_nbst(__nv_fp8_e4m3 *self , float* f) {
        new (self) __nv_fp8_e4m3(*f);
        return 0;
    }
        """

    @lower(fp8_e4m3, float32)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e4m3C1Ef",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e4m3C1Ef(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e4m3C1Ed(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e4m3C1Ed_nbst(__nv_fp8_e4m3 *self , double* f) {
        new (self) __nv_fp8_e4m3(*f);
        return 0;
    }
        """

    @lower(fp8_e4m3, float64)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e4m3C1Ed",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e4m3C1Ed(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e4m3C1Et(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e4m3C1Et_nbst(__nv_fp8_e4m3 *self , unsigned short* val) {
        new (self) __nv_fp8_e4m3(*val);
        return 0;
    }
        """

    @lower(fp8_e4m3, uint16)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e4m3C1Et",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e4m3C1Et(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e4m3C1Ej(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e4m3C1Ej_nbst(__nv_fp8_e4m3 *self , unsigned int* val) {
        new (self) __nv_fp8_e4m3(*val);
        return 0;
    }
        """

    @lower(fp8_e4m3, uint32)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e4m3C1Ej",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e4m3C1Ej(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e4m3C1Em(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e4m3C1Em_nbst(__nv_fp8_e4m3 *self , unsigned long* val) {
        new (self) __nv_fp8_e4m3(*val);
        return 0;
    }
        """

    @lower(fp8_e4m3, uint64)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e4m3C1Em",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e4m3C1Em(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e4m3C1Ey(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e4m3C1Ey_nbst(__nv_fp8_e4m3 *self , unsigned long long* val) {
        new (self) __nv_fp8_e4m3(*val);
        return 0;
    }
        """

    @lower(fp8_e4m3, uint64)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e4m3C1Ey",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e4m3C1Ey(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e4m3C1Es(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e4m3C1Es_nbst(__nv_fp8_e4m3 *self , short* val) {
        new (self) __nv_fp8_e4m3(*val);
        return 0;
    }
        """

    @lower(fp8_e4m3, int16)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e4m3C1Es",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e4m3C1Es(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e4m3C1Ei(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e4m3C1Ei_nbst(__nv_fp8_e4m3 *self , int* val) {
        new (self) __nv_fp8_e4m3(*val);
        return 0;
    }
        """

    @lower(fp8_e4m3, int32)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e4m3C1Ei",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e4m3C1Ei(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e4m3C1El(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e4m3C1El_nbst(__nv_fp8_e4m3 *self , long* val) {
        new (self) __nv_fp8_e4m3(*val);
        return 0;
    }
        """

    @lower(fp8_e4m3, int64)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e4m3C1El",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e4m3C1El(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e4m3C1Ex(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e4m3C1Ex_nbst(__nv_fp8_e4m3 *self , long long* val) {
        new (self) __nv_fp8_e4m3(*val);
        return 0;
    }
        """

    @lower(fp8_e4m3, int64)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e4m3C1Ex",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e4m3C1Ex(shim_stream, shim_obj)


@register
class _ctor_template___nv_fp8_e4m3(ConcreteTemplate):
    key = globals()["fp8_e4m3"]
    cases = [
        signature(
            _type_fp8_e4m3,
        ),
        signature(_type_fp8_e4m3, float16),
        signature(_type_fp8_e4m3, bfloat16),
        signature(_type_fp8_e4m3, float32),
        signature(_type_fp8_e4m3, float64),
        signature(_type_fp8_e4m3, uint16),
        signature(_type_fp8_e4m3, uint32),
        signature(_type_fp8_e4m3, uint64),
        signature(_type_fp8_e4m3, uint64),
        signature(_type_fp8_e4m3, int16),
        signature(_type_fp8_e4m3, int32),
        signature(_type_fp8_e4m3, int64),
        signature(_type_fp8_e4m3, int64),
    ]


register_global(fp8_e4m3, Function(_ctor_template___nv_fp8_e4m3))


def _from___nv_fp8_e4m3_to_float16_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e4m3cv6__halfEv_nbst(__half &retval, __nv_fp8_e4m3 *self) {
        retval = self->operator __half();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e4m3, float16)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e4m3cv6__halfEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e4m3_to_float16_lower(shim_stream, shim_obj)


def _from___nv_fp8_e4m3_to_float32_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e4m3cvfEv_nbst(float &retval, __nv_fp8_e4m3 *self) {
        retval = self->operator float();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e4m3, float32)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e4m3cvfEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e4m3_to_float32_lower(shim_stream, shim_obj)


def _from___nv_fp8_e4m3_to_bfloat16_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e4m3cv13__nv_bfloat16Ev_nbst(__nv_bfloat16 &retval, __nv_fp8_e4m3 *self) {
        retval = self->operator __nv_bfloat16();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e4m3, bfloat16)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e4m3cv13__nv_bfloat16Ev",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e4m3_to_bfloat16_lower(shim_stream, shim_obj)


def _from___nv_fp8_e4m3_to_float64_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e4m3cvdEv_nbst(double &retval, __nv_fp8_e4m3 *self) {
        retval = self->operator double();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e4m3, float64)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e4m3cvdEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e4m3_to_float64_lower(shim_stream, shim_obj)


def _from___nv_fp8_e4m3_to_uint8_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e4m3cvhEv_nbst(unsigned char &retval, __nv_fp8_e4m3 *self) {
        retval = self->operator unsigned char();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e4m3, uint8)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e4m3cvhEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e4m3_to_uint8_lower(shim_stream, shim_obj)


def _from___nv_fp8_e4m3_to_uint16_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e4m3cvtEv_nbst(unsigned short &retval, __nv_fp8_e4m3 *self) {
        retval = self->operator unsigned short();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e4m3, uint16)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e4m3cvtEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e4m3_to_uint16_lower(shim_stream, shim_obj)


def _from___nv_fp8_e4m3_to_uint32_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e4m3cvjEv_nbst(unsigned int &retval, __nv_fp8_e4m3 *self) {
        retval = self->operator unsigned int();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e4m3, uint32)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e4m3cvjEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e4m3_to_uint32_lower(shim_stream, shim_obj)


def _from___nv_fp8_e4m3_to_uint64_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e4m3cvmEv_nbst(unsigned long &retval, __nv_fp8_e4m3 *self) {
        retval = self->operator unsigned long();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e4m3, uint64)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e4m3cvmEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e4m3_to_uint64_lower(shim_stream, shim_obj)


def _from___nv_fp8_e4m3_to_uint64_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e4m3cvyEv_nbst(unsigned long long &retval, __nv_fp8_e4m3 *self) {
        retval = self->operator unsigned long long();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e4m3, uint64)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e4m3cvyEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e4m3_to_uint64_lower(shim_stream, shim_obj)


def _from___nv_fp8_e4m3_to_int8_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e4m3cvaEv_nbst(signed char &retval, __nv_fp8_e4m3 *self) {
        retval = self->operator signed char();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e4m3, int8)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e4m3cvaEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e4m3_to_int8_lower(shim_stream, shim_obj)


def _from___nv_fp8_e4m3_to_int8_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e4m3cvcEv_nbst(char &retval, __nv_fp8_e4m3 *self) {
        retval = self->operator char();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e4m3, int8)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e4m3cvcEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e4m3_to_int8_lower(shim_stream, shim_obj)


def _from___nv_fp8_e4m3_to_int16_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e4m3cvsEv_nbst(short &retval, __nv_fp8_e4m3 *self) {
        retval = self->operator short();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e4m3, int16)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e4m3cvsEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e4m3_to_int16_lower(shim_stream, shim_obj)


def _from___nv_fp8_e4m3_to_int32_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e4m3cviEv_nbst(int &retval, __nv_fp8_e4m3 *self) {
        retval = self->operator int();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e4m3, int32)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e4m3cviEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e4m3_to_int32_lower(shim_stream, shim_obj)


def _from___nv_fp8_e4m3_to_int64_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e4m3cvlEv_nbst(long &retval, __nv_fp8_e4m3 *self) {
        retval = self->operator long();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e4m3, int64)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e4m3cvlEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e4m3_to_int64_lower(shim_stream, shim_obj)


def _from___nv_fp8_e4m3_to_int64_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e4m3cvxEv_nbst(long long &retval, __nv_fp8_e4m3 *self) {
        retval = self->operator long long();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e4m3, int64)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e4m3cvxEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e4m3_to_int64_lower(shim_stream, shim_obj)


def _from___nv_fp8_e4m3_to_bool__lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e4m3cvbEv_nbst(bool &retval, __nv_fp8_e4m3 *self) {
        retval = self->operator bool();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e4m3, bool_)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e4m3cvbEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e4m3_to_bool__lower(shim_stream, shim_obj)


# Typing for fp8x2_e4m3
class _type_class_fp8x2_e4m3(Type):
    def __init__(self):
        super().__init__(name="fp8x2_e4m3")
        self.alignof_ = 2
        self.bitwidth = 2 * 8

    def can_convert_from(self, typingctx, other):
        from numba.cuda.typeconv import Conversion

        if other in []:
            return Conversion.safe


_type_fp8x2_e4m3 = _type_class_fp8x2_e4m3()


# Make Python API for struct
fp8x2_e4m3 = type("fp8x2_e4m3", (), {"_nbtype": _type_fp8x2_e4m3})

as_numba_type.register(fp8x2_e4m3, _type_fp8x2_e4m3)


@register_model(_type_class_fp8x2_e4m3)
class _model_fp8x2_e4m3(StructModel):
    def __init__(self, dmm, fe_type):
        members = [("__x", uint16)]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_fp8x2_e4m3(AttributeTemplate):
    key = _type_fp8x2_e4m3

    def resolve___x(self, obj):
        return uint16


make_attribute_wrapper(_type_class_fp8x2_e4m3, "__x", "__x")


def _lower__ZN15__nv_fp8x2_e4m3C1Ev(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN15__nv_fp8x2_e4m3C1Ev_nbst(__nv_fp8x2_e4m3 *self ) {
        new (self) __nv_fp8x2_e4m3();
        return 0;
    }
        """

    @lower(
        fp8x2_e4m3,
    )
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN15__nv_fp8x2_e4m3C1Ev",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN15__nv_fp8x2_e4m3C1Ev(shim_stream, shim_obj)


def _lower__ZN15__nv_fp8x2_e4m3C1E6float2(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN15__nv_fp8x2_e4m3C1E6float2_nbst(__nv_fp8x2_e4m3 *self , float2* f) {
        new (self) __nv_fp8x2_e4m3(*f);
        return 0;
    }
        """

    @lower(fp8x2_e4m3, float32x2)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN15__nv_fp8x2_e4m3C1E6float2",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN15__nv_fp8x2_e4m3C1E6float2(shim_stream, shim_obj)


def _lower__ZN15__nv_fp8x2_e4m3C1E7double2(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN15__nv_fp8x2_e4m3C1E7double2_nbst(__nv_fp8x2_e4m3 *self , double2* f) {
        new (self) __nv_fp8x2_e4m3(*f);
        return 0;
    }
        """

    @lower(fp8x2_e4m3, float64x2)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN15__nv_fp8x2_e4m3C1E7double2",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN15__nv_fp8x2_e4m3C1E7double2(shim_stream, shim_obj)


@register
class _ctor_template___nv_fp8x2_e4m3(ConcreteTemplate):
    key = globals()["fp8x2_e4m3"]
    cases = [
        signature(
            _type_fp8x2_e4m3,
        ),
        signature(_type_fp8x2_e4m3, float32x2),
        signature(_type_fp8x2_e4m3, float64x2),
    ]


register_global(fp8x2_e4m3, Function(_ctor_template___nv_fp8x2_e4m3))


def _from___nv_fp8x2_e4m3_to_float32x2_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK15__nv_fp8x2_e4m3cv6float2Ev_nbst(float2 &retval, __nv_fp8x2_e4m3 *self) {
        retval = self->operator float2();
        return 0;
    }
        """

    @lower_cast(_type_fp8x2_e4m3, float32x2)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK15__nv_fp8x2_e4m3cv6float2Ev",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8x2_e4m3_to_float32x2_lower(shim_stream, shim_obj)


# Typing for fp8x4_e4m3
class _type_class_fp8x4_e4m3(Type):
    def __init__(self):
        super().__init__(name="fp8x4_e4m3")
        self.alignof_ = 4
        self.bitwidth = 4 * 8

    def can_convert_from(self, typingctx, other):
        from numba.cuda.typeconv import Conversion

        if other in []:
            return Conversion.safe


_type_fp8x4_e4m3 = _type_class_fp8x4_e4m3()


# Make Python API for struct
fp8x4_e4m3 = type("fp8x4_e4m3", (), {"_nbtype": _type_fp8x4_e4m3})

as_numba_type.register(fp8x4_e4m3, _type_fp8x4_e4m3)


@register_model(_type_class_fp8x4_e4m3)
class _model_fp8x4_e4m3(StructModel):
    def __init__(self, dmm, fe_type):
        members = [("__x", uint32)]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_fp8x4_e4m3(AttributeTemplate):
    key = _type_fp8x4_e4m3

    def resolve___x(self, obj):
        return uint32


make_attribute_wrapper(_type_class_fp8x4_e4m3, "__x", "__x")


def _lower__ZN15__nv_fp8x4_e4m3C1Ev(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN15__nv_fp8x4_e4m3C1Ev_nbst(__nv_fp8x4_e4m3 *self ) {
        new (self) __nv_fp8x4_e4m3();
        return 0;
    }
        """

    @lower(
        fp8x4_e4m3,
    )
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN15__nv_fp8x4_e4m3C1Ev",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN15__nv_fp8x4_e4m3C1Ev(shim_stream, shim_obj)


def _lower__ZN15__nv_fp8x4_e4m3C1E6float4(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN15__nv_fp8x4_e4m3C1E6float4_nbst(__nv_fp8x4_e4m3 *self , float4* f) {
        new (self) __nv_fp8x4_e4m3(*f);
        return 0;
    }
        """

    @lower(fp8x4_e4m3, float32x4)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN15__nv_fp8x4_e4m3C1E6float4",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN15__nv_fp8x4_e4m3C1E6float4(shim_stream, shim_obj)


def _lower__ZN15__nv_fp8x4_e4m3C1E7double4(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN15__nv_fp8x4_e4m3C1E7double4_nbst(__nv_fp8x4_e4m3 *self , double4* f) {
        new (self) __nv_fp8x4_e4m3(*f);
        return 0;
    }
        """

    @lower(fp8x4_e4m3, float64x4)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN15__nv_fp8x4_e4m3C1E7double4",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN15__nv_fp8x4_e4m3C1E7double4(shim_stream, shim_obj)


@register
class _ctor_template___nv_fp8x4_e4m3(ConcreteTemplate):
    key = globals()["fp8x4_e4m3"]
    cases = [
        signature(
            _type_fp8x4_e4m3,
        ),
        signature(_type_fp8x4_e4m3, float32x4),
        signature(_type_fp8x4_e4m3, float64x4),
    ]


register_global(fp8x4_e4m3, Function(_ctor_template___nv_fp8x4_e4m3))


def _from___nv_fp8x4_e4m3_to_float32x4_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK15__nv_fp8x4_e4m3cv6float4Ev_nbst(float4 &retval, __nv_fp8x4_e4m3 *self) {
        retval = self->operator float4();
        return 0;
    }
        """

    @lower_cast(_type_fp8x4_e4m3, float32x4)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK15__nv_fp8x4_e4m3cv6float4Ev",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8x4_e4m3_to_float32x4_lower(shim_stream, shim_obj)


# Typing for fp8_e8m0
class _type_class_fp8_e8m0(Number):
    def __init__(self):
        super().__init__(name="fp8_e8m0")
        self.alignof_ = 1
        self.bitwidth = 1 * 8

    def can_convert_from(self, typingctx, other):
        from numba.cuda.typeconv import Conversion

        if other in []:
            return Conversion.safe


_type_fp8_e8m0 = _type_class_fp8_e8m0()


# Make Python API for struct
fp8_e8m0 = type("fp8_e8m0", (), {"_nbtype": _type_fp8_e8m0})

as_numba_type.register(fp8_e8m0, _type_fp8_e8m0)


@register_model(_type_class_fp8_e8m0)
class _model_fp8_e8m0(PrimitiveModel):
    def __init__(self, dmm, fe_type):
        be_type = ir.IntType(fe_type.bitwidth)
        super(_model_fp8_e8m0, self).__init__(dmm, fe_type, be_type)


def _lower__ZN13__nv_fp8_e8m0C1Ev(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e8m0C1Ev_nbst(__nv_fp8_e8m0 *self ) {
        new (self) __nv_fp8_e8m0();
        return 0;
    }
        """

    @lower(
        fp8_e8m0,
    )
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e8m0C1Ev",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e8m0C1Ev(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e8m0C1E6__half(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e8m0C1E6__half_nbst(__nv_fp8_e8m0 *self , __half* f) {
        new (self) __nv_fp8_e8m0(*f);
        return 0;
    }
        """

    @lower(fp8_e8m0, float16)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e8m0C1E6__half",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e8m0C1E6__half(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e8m0C1E13__nv_bfloat16(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e8m0C1E13__nv_bfloat16_nbst(__nv_fp8_e8m0 *self , __nv_bfloat16* f) {
        new (self) __nv_fp8_e8m0(*f);
        return 0;
    }
        """

    @lower(fp8_e8m0, bfloat16)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e8m0C1E13__nv_bfloat16",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e8m0C1E13__nv_bfloat16(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e8m0C1Ef(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e8m0C1Ef_nbst(__nv_fp8_e8m0 *self , float* f) {
        new (self) __nv_fp8_e8m0(*f);
        return 0;
    }
        """

    @lower(fp8_e8m0, float32)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e8m0C1Ef",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e8m0C1Ef(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e8m0C1Ed(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e8m0C1Ed_nbst(__nv_fp8_e8m0 *self , double* f) {
        new (self) __nv_fp8_e8m0(*f);
        return 0;
    }
        """

    @lower(fp8_e8m0, float64)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e8m0C1Ed",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e8m0C1Ed(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e8m0C1Et(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e8m0C1Et_nbst(__nv_fp8_e8m0 *self , unsigned short* val) {
        new (self) __nv_fp8_e8m0(*val);
        return 0;
    }
        """

    @lower(fp8_e8m0, uint16)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e8m0C1Et",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e8m0C1Et(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e8m0C1Ej(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e8m0C1Ej_nbst(__nv_fp8_e8m0 *self , unsigned int* val) {
        new (self) __nv_fp8_e8m0(*val);
        return 0;
    }
        """

    @lower(fp8_e8m0, uint32)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e8m0C1Ej",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e8m0C1Ej(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e8m0C1Ey(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e8m0C1Ey_nbst(__nv_fp8_e8m0 *self , unsigned long long* val) {
        new (self) __nv_fp8_e8m0(*val);
        return 0;
    }
        """

    @lower(fp8_e8m0, uint64)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e8m0C1Ey",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e8m0C1Ey(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e8m0C1Em(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e8m0C1Em_nbst(__nv_fp8_e8m0 *self , unsigned long* val) {
        new (self) __nv_fp8_e8m0(*val);
        return 0;
    }
        """

    @lower(fp8_e8m0, uint64)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e8m0C1Em",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e8m0C1Em(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e8m0C1Es(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e8m0C1Es_nbst(__nv_fp8_e8m0 *self , short* val) {
        new (self) __nv_fp8_e8m0(*val);
        return 0;
    }
        """

    @lower(fp8_e8m0, int16)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e8m0C1Es",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e8m0C1Es(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e8m0C1Ei(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e8m0C1Ei_nbst(__nv_fp8_e8m0 *self , int* val) {
        new (self) __nv_fp8_e8m0(*val);
        return 0;
    }
        """

    @lower(fp8_e8m0, int32)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e8m0C1Ei",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e8m0C1Ei(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e8m0C1Ex(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e8m0C1Ex_nbst(__nv_fp8_e8m0 *self , long long* val) {
        new (self) __nv_fp8_e8m0(*val);
        return 0;
    }
        """

    @lower(fp8_e8m0, int64)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e8m0C1Ex",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e8m0C1Ex(shim_stream, shim_obj)


def _lower__ZN13__nv_fp8_e8m0C1El(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN13__nv_fp8_e8m0C1El_nbst(__nv_fp8_e8m0 *self , long* val) {
        new (self) __nv_fp8_e8m0(*val);
        return 0;
    }
        """

    @lower(fp8_e8m0, int64)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN13__nv_fp8_e8m0C1El",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN13__nv_fp8_e8m0C1El(shim_stream, shim_obj)


@register
class _ctor_template___nv_fp8_e8m0(ConcreteTemplate):
    key = globals()["fp8_e8m0"]
    cases = [
        signature(
            _type_fp8_e8m0,
        ),
        signature(_type_fp8_e8m0, float16),
        signature(_type_fp8_e8m0, bfloat16),
        signature(_type_fp8_e8m0, float32),
        signature(_type_fp8_e8m0, float64),
        signature(_type_fp8_e8m0, uint16),
        signature(_type_fp8_e8m0, uint32),
        signature(_type_fp8_e8m0, uint64),
        signature(_type_fp8_e8m0, uint64),
        signature(_type_fp8_e8m0, int16),
        signature(_type_fp8_e8m0, int32),
        signature(_type_fp8_e8m0, int64),
        signature(_type_fp8_e8m0, int64),
    ]


register_global(fp8_e8m0, Function(_ctor_template___nv_fp8_e8m0))


def _from___nv_fp8_e8m0_to_float32_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e8m0cvfEv_nbst(float &retval, __nv_fp8_e8m0 *self) {
        retval = self->operator float();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e8m0, float32)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e8m0cvfEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e8m0_to_float32_lower(shim_stream, shim_obj)


def _from___nv_fp8_e8m0_to_bfloat16_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e8m0cv13__nv_bfloat16Ev_nbst(__nv_bfloat16 &retval, __nv_fp8_e8m0 *self) {
        retval = self->operator __nv_bfloat16();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e8m0, bfloat16)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e8m0cv13__nv_bfloat16Ev",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e8m0_to_bfloat16_lower(shim_stream, shim_obj)


def _from___nv_fp8_e8m0_to_float64_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e8m0cvdEv_nbst(double &retval, __nv_fp8_e8m0 *self) {
        retval = self->operator double();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e8m0, float64)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e8m0cvdEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e8m0_to_float64_lower(shim_stream, shim_obj)


def _from___nv_fp8_e8m0_to_float16_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e8m0cv6__halfEv_nbst(__half &retval, __nv_fp8_e8m0 *self) {
        retval = self->operator __half();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e8m0, float16)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e8m0cv6__halfEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e8m0_to_float16_lower(shim_stream, shim_obj)


def _from___nv_fp8_e8m0_to_uint8_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e8m0cvhEv_nbst(unsigned char &retval, __nv_fp8_e8m0 *self) {
        retval = self->operator unsigned char();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e8m0, uint8)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e8m0cvhEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e8m0_to_uint8_lower(shim_stream, shim_obj)


def _from___nv_fp8_e8m0_to_uint16_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e8m0cvtEv_nbst(unsigned short &retval, __nv_fp8_e8m0 *self) {
        retval = self->operator unsigned short();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e8m0, uint16)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e8m0cvtEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e8m0_to_uint16_lower(shim_stream, shim_obj)


def _from___nv_fp8_e8m0_to_uint32_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e8m0cvjEv_nbst(unsigned int &retval, __nv_fp8_e8m0 *self) {
        retval = self->operator unsigned int();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e8m0, uint32)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e8m0cvjEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e8m0_to_uint32_lower(shim_stream, shim_obj)


def _from___nv_fp8_e8m0_to_uint64_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e8m0cvmEv_nbst(unsigned long &retval, __nv_fp8_e8m0 *self) {
        retval = self->operator unsigned long();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e8m0, uint64)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e8m0cvmEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e8m0_to_uint64_lower(shim_stream, shim_obj)


def _from___nv_fp8_e8m0_to_uint64_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e8m0cvyEv_nbst(unsigned long long &retval, __nv_fp8_e8m0 *self) {
        retval = self->operator unsigned long long();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e8m0, uint64)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e8m0cvyEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e8m0_to_uint64_lower(shim_stream, shim_obj)


def _from___nv_fp8_e8m0_to_int8_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e8m0cvaEv_nbst(signed char &retval, __nv_fp8_e8m0 *self) {
        retval = self->operator signed char();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e8m0, int8)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e8m0cvaEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e8m0_to_int8_lower(shim_stream, shim_obj)


def _from___nv_fp8_e8m0_to_int8_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e8m0cvcEv_nbst(char &retval, __nv_fp8_e8m0 *self) {
        retval = self->operator char();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e8m0, int8)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e8m0cvcEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e8m0_to_int8_lower(shim_stream, shim_obj)


def _from___nv_fp8_e8m0_to_int16_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e8m0cvsEv_nbst(short &retval, __nv_fp8_e8m0 *self) {
        retval = self->operator short();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e8m0, int16)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e8m0cvsEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e8m0_to_int16_lower(shim_stream, shim_obj)


def _from___nv_fp8_e8m0_to_int32_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e8m0cviEv_nbst(int &retval, __nv_fp8_e8m0 *self) {
        retval = self->operator int();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e8m0, int32)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e8m0cviEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e8m0_to_int32_lower(shim_stream, shim_obj)


def _from___nv_fp8_e8m0_to_int64_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e8m0cvlEv_nbst(long &retval, __nv_fp8_e8m0 *self) {
        retval = self->operator long();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e8m0, int64)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e8m0cvlEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e8m0_to_int64_lower(shim_stream, shim_obj)


def _from___nv_fp8_e8m0_to_int64_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e8m0cvxEv_nbst(long long &retval, __nv_fp8_e8m0 *self) {
        retval = self->operator long long();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e8m0, int64)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e8m0cvxEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e8m0_to_int64_lower(shim_stream, shim_obj)


def _from___nv_fp8_e8m0_to_bool__lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK13__nv_fp8_e8m0cvbEv_nbst(bool &retval, __nv_fp8_e8m0 *self) {
        retval = self->operator bool();
        return 0;
    }
        """

    @lower_cast(_type_fp8_e8m0, bool_)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK13__nv_fp8_e8m0cvbEv",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8_e8m0_to_bool__lower(shim_stream, shim_obj)


# Typing for fp8x2_e8m0
class _type_class_fp8x2_e8m0(Type):
    def __init__(self):
        super().__init__(name="fp8x2_e8m0")
        self.alignof_ = 2
        self.bitwidth = 2 * 8

    def can_convert_from(self, typingctx, other):
        from numba.cuda.typeconv import Conversion

        if other in []:
            return Conversion.safe


_type_fp8x2_e8m0 = _type_class_fp8x2_e8m0()


# Make Python API for struct
fp8x2_e8m0 = type("fp8x2_e8m0", (), {"_nbtype": _type_fp8x2_e8m0})

as_numba_type.register(fp8x2_e8m0, _type_fp8x2_e8m0)


@register_model(_type_class_fp8x2_e8m0)
class _model_fp8x2_e8m0(StructModel):
    def __init__(self, dmm, fe_type):
        members = [("__x", uint16)]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_fp8x2_e8m0(AttributeTemplate):
    key = _type_fp8x2_e8m0

    def resolve___x(self, obj):
        return uint16


make_attribute_wrapper(_type_class_fp8x2_e8m0, "__x", "__x")


def _lower__ZN15__nv_fp8x2_e8m0C1Ev(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN15__nv_fp8x2_e8m0C1Ev_nbst(__nv_fp8x2_e8m0 *self ) {
        new (self) __nv_fp8x2_e8m0();
        return 0;
    }
        """

    @lower(
        fp8x2_e8m0,
    )
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN15__nv_fp8x2_e8m0C1Ev",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN15__nv_fp8x2_e8m0C1Ev(shim_stream, shim_obj)


def _lower__ZN15__nv_fp8x2_e8m0C1E6float2(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN15__nv_fp8x2_e8m0C1E6float2_nbst(__nv_fp8x2_e8m0 *self , float2* f) {
        new (self) __nv_fp8x2_e8m0(*f);
        return 0;
    }
        """

    @lower(fp8x2_e8m0, float32x2)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN15__nv_fp8x2_e8m0C1E6float2",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN15__nv_fp8x2_e8m0C1E6float2(shim_stream, shim_obj)


def _lower__ZN15__nv_fp8x2_e8m0C1E7double2(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN15__nv_fp8x2_e8m0C1E7double2_nbst(__nv_fp8x2_e8m0 *self , double2* f) {
        new (self) __nv_fp8x2_e8m0(*f);
        return 0;
    }
        """

    @lower(fp8x2_e8m0, float64x2)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN15__nv_fp8x2_e8m0C1E7double2",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN15__nv_fp8x2_e8m0C1E7double2(shim_stream, shim_obj)


@register
class _ctor_template___nv_fp8x2_e8m0(ConcreteTemplate):
    key = globals()["fp8x2_e8m0"]
    cases = [
        signature(
            _type_fp8x2_e8m0,
        ),
        signature(_type_fp8x2_e8m0, float32x2),
        signature(_type_fp8x2_e8m0, float64x2),
    ]


register_global(fp8x2_e8m0, Function(_ctor_template___nv_fp8x2_e8m0))


def _from___nv_fp8x2_e8m0_to_float32x2_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK15__nv_fp8x2_e8m0cv6float2Ev_nbst(float2 &retval, __nv_fp8x2_e8m0 *self) {
        retval = self->operator float2();
        return 0;
    }
        """

    @lower_cast(_type_fp8x2_e8m0, float32x2)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK15__nv_fp8x2_e8m0cv6float2Ev",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8x2_e8m0_to_float32x2_lower(shim_stream, shim_obj)


# Typing for fp8x4_e8m0
class _type_class_fp8x4_e8m0(Type):
    def __init__(self):
        super().__init__(name="fp8x4_e8m0")
        self.alignof_ = 4
        self.bitwidth = 4 * 8

    def can_convert_from(self, typingctx, other):
        from numba.cuda.typeconv import Conversion

        if other in []:
            return Conversion.safe


_type_fp8x4_e8m0 = _type_class_fp8x4_e8m0()


# Make Python API for struct
fp8x4_e8m0 = type("fp8x4_e8m0", (), {"_nbtype": _type_fp8x4_e8m0})

as_numba_type.register(fp8x4_e8m0, _type_fp8x4_e8m0)


@register_model(_type_class_fp8x4_e8m0)
class _model_fp8x4_e8m0(StructModel):
    def __init__(self, dmm, fe_type):
        members = [("__x", uint32)]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_fp8x4_e8m0(AttributeTemplate):
    key = _type_fp8x4_e8m0

    def resolve___x(self, obj):
        return uint32


make_attribute_wrapper(_type_class_fp8x4_e8m0, "__x", "__x")


def _lower__ZN15__nv_fp8x4_e8m0C1Ev(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN15__nv_fp8x4_e8m0C1Ev_nbst(__nv_fp8x4_e8m0 *self ) {
        new (self) __nv_fp8x4_e8m0();
        return 0;
    }
        """

    @lower(
        fp8x4_e8m0,
    )
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN15__nv_fp8x4_e8m0C1Ev",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN15__nv_fp8x4_e8m0C1Ev(shim_stream, shim_obj)


def _lower__ZN15__nv_fp8x4_e8m0C1E6float4(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN15__nv_fp8x4_e8m0C1E6float4_nbst(__nv_fp8x4_e8m0 *self , float4* f) {
        new (self) __nv_fp8x4_e8m0(*f);
        return 0;
    }
        """

    @lower(fp8x4_e8m0, float32x4)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN15__nv_fp8x4_e8m0C1E6float4",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN15__nv_fp8x4_e8m0C1E6float4(shim_stream, shim_obj)


def _lower__ZN15__nv_fp8x4_e8m0C1E7double4(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN15__nv_fp8x4_e8m0C1E7double4_nbst(__nv_fp8x4_e8m0 *self , double4* f) {
        new (self) __nv_fp8x4_e8m0(*f);
        return 0;
    }
        """

    @lower(fp8x4_e8m0, float64x4)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        ctor_callconv = FunctionCallConv(
            itanium_mangled_name="_ZN15__nv_fp8x4_e8m0C1E7double4",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return ctor_callconv(builder, context, sig, args)


_lower__ZN15__nv_fp8x4_e8m0C1E7double4(shim_stream, shim_obj)


@register
class _ctor_template___nv_fp8x4_e8m0(ConcreteTemplate):
    key = globals()["fp8x4_e8m0"]
    cases = [
        signature(
            _type_fp8x4_e8m0,
        ),
        signature(_type_fp8x4_e8m0, float32x4),
        signature(_type_fp8x4_e8m0, float64x4),
    ]


register_global(fp8x4_e8m0, Function(_ctor_template___nv_fp8x4_e8m0))


def _from___nv_fp8x4_e8m0_to_float32x4_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZNK15__nv_fp8x4_e8m0cv6float4Ev_nbst(float4 &retval, __nv_fp8x4_e8m0 *self) {
        retval = self->operator float4();
        return 0;
    }
        """

    @lower_cast(_type_fp8x4_e8m0, float32x4)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZNK15__nv_fp8x4_e8m0cv6float4Ev",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        sig = signature(toty, fromty)
        return callconv(builder, context, sig, [value])


_from___nv_fp8x4_e8m0_to_float32x4_lower(shim_stream, shim_obj)


# Functions:


def cvt_double_to_fp8():
    pass


def _lower__ZL22__nv_cvt_double_to_fp8d17__nv_saturation_t25__nv_fp8_interpretation_t_nbst(
    shim_stream, shim_obj
):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL22__nv_cvt_double_to_fp8d17__nv_saturation_t25__nv_fp8_interpretation_t_nbst(unsigned char &retval , double* x, __nv_saturation_t* saturate, __nv_fp8_interpretation_t* fp8_interpretation) {
        retval = __nv_cvt_double_to_fp8(*x, *saturate, *fp8_interpretation);
        return 0;
    }
        """

    @lower(
        cvt_double_to_fp8,
        float64,
        IntEnumMember(saturation_t, int64),
        IntEnumMember(fp8_interpretation_t, int64),
    )
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZL22__nv_cvt_double_to_fp8d17__nv_saturation_t25__nv_fp8_interpretation_t",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return callconv(builder, context, sig, args)


_lower__ZL22__nv_cvt_double_to_fp8d17__nv_saturation_t25__nv_fp8_interpretation_t_nbst(
    shim_stream, shim_obj
)


def cvt_double2_to_fp8x2():
    pass


def _lower__ZL25__nv_cvt_double2_to_fp8x27double217__nv_saturation_t25__nv_fp8_interpretation_t_nbst(
    shim_stream, shim_obj
):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL25__nv_cvt_double2_to_fp8x27double217__nv_saturation_t25__nv_fp8_interpretation_t_nbst(unsigned short &retval , double2* x, __nv_saturation_t* saturate, __nv_fp8_interpretation_t* fp8_interpretation) {
        retval = __nv_cvt_double2_to_fp8x2(*x, *saturate, *fp8_interpretation);
        return 0;
    }
        """

    @lower(
        cvt_double2_to_fp8x2,
        float64x2,
        IntEnumMember(saturation_t, int64),
        IntEnumMember(fp8_interpretation_t, int64),
    )
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZL25__nv_cvt_double2_to_fp8x27double217__nv_saturation_t25__nv_fp8_interpretation_t",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return callconv(builder, context, sig, args)


_lower__ZL25__nv_cvt_double2_to_fp8x27double217__nv_saturation_t25__nv_fp8_interpretation_t_nbst(
    shim_stream, shim_obj
)


def cvt_float_to_fp8():
    pass


def _lower__ZL21__nv_cvt_float_to_fp8f17__nv_saturation_t25__nv_fp8_interpretation_t_nbst(
    shim_stream, shim_obj
):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL21__nv_cvt_float_to_fp8f17__nv_saturation_t25__nv_fp8_interpretation_t_nbst(unsigned char &retval , float* x, __nv_saturation_t* saturate, __nv_fp8_interpretation_t* fp8_interpretation) {
        retval = __nv_cvt_float_to_fp8(*x, *saturate, *fp8_interpretation);
        return 0;
    }
        """

    @lower(
        cvt_float_to_fp8,
        float32,
        IntEnumMember(saturation_t, int64),
        IntEnumMember(fp8_interpretation_t, int64),
    )
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZL21__nv_cvt_float_to_fp8f17__nv_saturation_t25__nv_fp8_interpretation_t",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return callconv(builder, context, sig, args)


_lower__ZL21__nv_cvt_float_to_fp8f17__nv_saturation_t25__nv_fp8_interpretation_t_nbst(
    shim_stream, shim_obj
)


def cvt_float2_to_fp8x2():
    pass


def _lower__ZL24__nv_cvt_float2_to_fp8x26float217__nv_saturation_t25__nv_fp8_interpretation_t_nbst(
    shim_stream, shim_obj
):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL24__nv_cvt_float2_to_fp8x26float217__nv_saturation_t25__nv_fp8_interpretation_t_nbst(unsigned short &retval , float2* x, __nv_saturation_t* saturate, __nv_fp8_interpretation_t* fp8_interpretation) {
        retval = __nv_cvt_float2_to_fp8x2(*x, *saturate, *fp8_interpretation);
        return 0;
    }
        """

    @lower(
        cvt_float2_to_fp8x2,
        float32x2,
        IntEnumMember(saturation_t, int64),
        IntEnumMember(fp8_interpretation_t, int64),
    )
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZL24__nv_cvt_float2_to_fp8x26float217__nv_saturation_t25__nv_fp8_interpretation_t",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return callconv(builder, context, sig, args)


_lower__ZL24__nv_cvt_float2_to_fp8x26float217__nv_saturation_t25__nv_fp8_interpretation_t_nbst(
    shim_stream, shim_obj
)


def cvt_bfloat16raw_to_fp8():
    pass


def _lower__ZL27__nv_cvt_bfloat16raw_to_fp817__nv_bfloat16_raw17__nv_saturation_t25__nv_fp8_interpretation_t_nbst(
    shim_stream, shim_obj
):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL27__nv_cvt_bfloat16raw_to_fp817__nv_bfloat16_raw17__nv_saturation_t25__nv_fp8_interpretation_t_nbst(unsigned char &retval , __nv_bfloat16_raw* x, __nv_saturation_t* saturate, __nv_fp8_interpretation_t* fp8_interpretation) {
        retval = __nv_cvt_bfloat16raw_to_fp8(*x, *saturate, *fp8_interpretation);
        return 0;
    }
        """

    @lower(
        cvt_bfloat16raw_to_fp8,
        bfloat16_raw_type,
        IntEnumMember(saturation_t, int64),
        IntEnumMember(fp8_interpretation_t, int64),
    )
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZL27__nv_cvt_bfloat16raw_to_fp817__nv_bfloat16_raw17__nv_saturation_t25__nv_fp8_interpretation_t",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return callconv(builder, context, sig, args)


_lower__ZL27__nv_cvt_bfloat16raw_to_fp817__nv_bfloat16_raw17__nv_saturation_t25__nv_fp8_interpretation_t_nbst(
    shim_stream, shim_obj
)


def cvt_bfloat16raw_to_e8m0():
    pass


def _lower__ZL28__nv_cvt_bfloat16raw_to_e8m017__nv_bfloat16_raw17__nv_saturation_t13cudaRoundMode_nbst(
    shim_stream, shim_obj
):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL28__nv_cvt_bfloat16raw_to_e8m017__nv_bfloat16_raw17__nv_saturation_t13cudaRoundMode_nbst(unsigned char &retval , __nv_bfloat16_raw* x, __nv_saturation_t* saturate, cudaRoundMode* rounding) {
        retval = __nv_cvt_bfloat16raw_to_e8m0(*x, *saturate, *rounding);
        return 0;
    }
        """

    @lower(
        cvt_bfloat16raw_to_e8m0,
        bfloat16_raw_type,
        IntEnumMember(saturation_t, int64),
        IntEnumMember(cudaRoundMode, int64),
    )
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZL28__nv_cvt_bfloat16raw_to_e8m017__nv_bfloat16_raw17__nv_saturation_t13cudaRoundMode",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return callconv(builder, context, sig, args)


_lower__ZL28__nv_cvt_bfloat16raw_to_e8m017__nv_bfloat16_raw17__nv_saturation_t13cudaRoundMode_nbst(
    shim_stream, shim_obj
)


def cvt_float_to_e8m0():
    pass


def _lower__ZL22__nv_cvt_float_to_e8m0f17__nv_saturation_t13cudaRoundMode_nbst(
    shim_stream, shim_obj
):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL22__nv_cvt_float_to_e8m0f17__nv_saturation_t13cudaRoundMode_nbst(unsigned char &retval , float* x, __nv_saturation_t* saturate, cudaRoundMode* rounding) {
        retval = __nv_cvt_float_to_e8m0(*x, *saturate, *rounding);
        return 0;
    }
        """

    @lower(
        cvt_float_to_e8m0,
        float32,
        IntEnumMember(saturation_t, int64),
        IntEnumMember(cudaRoundMode, int64),
    )
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZL22__nv_cvt_float_to_e8m0f17__nv_saturation_t13cudaRoundMode",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return callconv(builder, context, sig, args)


_lower__ZL22__nv_cvt_float_to_e8m0f17__nv_saturation_t13cudaRoundMode_nbst(
    shim_stream, shim_obj
)


def cvt_float2_to_e8m0x2():
    pass


def _lower__ZL25__nv_cvt_float2_to_e8m0x26float217__nv_saturation_t13cudaRoundMode_nbst(
    shim_stream, shim_obj
):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL25__nv_cvt_float2_to_e8m0x26float217__nv_saturation_t13cudaRoundMode_nbst(unsigned short &retval , float2* x, __nv_saturation_t* saturate, cudaRoundMode* rounding) {
        retval = __nv_cvt_float2_to_e8m0x2(*x, *saturate, *rounding);
        return 0;
    }
        """

    @lower(
        cvt_float2_to_e8m0x2,
        float32x2,
        IntEnumMember(saturation_t, int64),
        IntEnumMember(cudaRoundMode, int64),
    )
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZL25__nv_cvt_float2_to_e8m0x26float217__nv_saturation_t13cudaRoundMode",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return callconv(builder, context, sig, args)


_lower__ZL25__nv_cvt_float2_to_e8m0x26float217__nv_saturation_t13cudaRoundMode_nbst(
    shim_stream, shim_obj
)


def cvt_double_to_e8m0():
    pass


def _lower__ZL23__nv_cvt_double_to_e8m0d17__nv_saturation_t13cudaRoundMode_nbst(
    shim_stream, shim_obj
):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL23__nv_cvt_double_to_e8m0d17__nv_saturation_t13cudaRoundMode_nbst(unsigned char &retval , double* x, __nv_saturation_t* saturate, cudaRoundMode* rounding) {
        retval = __nv_cvt_double_to_e8m0(*x, *saturate, *rounding);
        return 0;
    }
        """

    @lower(
        cvt_double_to_e8m0,
        float64,
        IntEnumMember(saturation_t, int64),
        IntEnumMember(cudaRoundMode, int64),
    )
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZL23__nv_cvt_double_to_e8m0d17__nv_saturation_t13cudaRoundMode",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return callconv(builder, context, sig, args)


_lower__ZL23__nv_cvt_double_to_e8m0d17__nv_saturation_t13cudaRoundMode_nbst(
    shim_stream, shim_obj
)


def cvt_double2_to_e8m0x2():
    pass


def _lower__ZL26__nv_cvt_double2_to_e8m0x27double217__nv_saturation_t13cudaRoundMode_nbst(
    shim_stream, shim_obj
):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL26__nv_cvt_double2_to_e8m0x27double217__nv_saturation_t13cudaRoundMode_nbst(unsigned short &retval , double2* x, __nv_saturation_t* saturate, cudaRoundMode* rounding) {
        retval = __nv_cvt_double2_to_e8m0x2(*x, *saturate, *rounding);
        return 0;
    }
        """

    @lower(
        cvt_double2_to_e8m0x2,
        float64x2,
        IntEnumMember(saturation_t, int64),
        IntEnumMember(cudaRoundMode, int64),
    )
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZL26__nv_cvt_double2_to_e8m0x27double217__nv_saturation_t13cudaRoundMode",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return callconv(builder, context, sig, args)


_lower__ZL26__nv_cvt_double2_to_e8m0x27double217__nv_saturation_t13cudaRoundMode_nbst(
    shim_stream, shim_obj
)


def cvt_e8m0_to_bf16raw():
    pass


def _lower__ZL24__nv_cvt_e8m0_to_bf16rawh_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL24__nv_cvt_e8m0_to_bf16rawh_nbst(__nv_bfloat16_raw &retval , unsigned char* x) {
        retval = __nv_cvt_e8m0_to_bf16raw(*x);
        return 0;
    }
        """

    @lower(cvt_e8m0_to_bf16raw, uint8)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        callconv = FunctionCallConv(
            itanium_mangled_name="_ZL24__nv_cvt_e8m0_to_bf16rawh",
            shim_writer=shim_writer,
            shim_code=shim_raw_str,
        )
        return callconv(builder, context, sig, args)


_lower__ZL24__nv_cvt_e8m0_to_bf16rawh_nbst(shim_stream, shim_obj)


@register
class _typing_cvt_double_to_fp8(ConcreteTemplate):
    key = globals()["cvt_double_to_fp8"]
    cases = [
        signature(
            uint8,
            float64,
            IntEnumMember(saturation_t, int64),
            IntEnumMember(fp8_interpretation_t, int64),
        )
    ]


register_global(cvt_double_to_fp8, types.Function(_typing_cvt_double_to_fp8))


@register
class _typing_cvt_double2_to_fp8x2(ConcreteTemplate):
    key = globals()["cvt_double2_to_fp8x2"]
    cases = [
        signature(
            uint16,
            float64x2,
            IntEnumMember(saturation_t, int64),
            IntEnumMember(fp8_interpretation_t, int64),
        )
    ]


register_global(
    cvt_double2_to_fp8x2, types.Function(_typing_cvt_double2_to_fp8x2)
)


@register
class _typing_cvt_float_to_fp8(ConcreteTemplate):
    key = globals()["cvt_float_to_fp8"]
    cases = [
        signature(
            uint8,
            float32,
            IntEnumMember(saturation_t, int64),
            IntEnumMember(fp8_interpretation_t, int64),
        )
    ]


register_global(cvt_float_to_fp8, types.Function(_typing_cvt_float_to_fp8))


@register
class _typing_cvt_float2_to_fp8x2(ConcreteTemplate):
    key = globals()["cvt_float2_to_fp8x2"]
    cases = [
        signature(
            uint16,
            float32x2,
            IntEnumMember(saturation_t, int64),
            IntEnumMember(fp8_interpretation_t, int64),
        )
    ]


register_global(
    cvt_float2_to_fp8x2, types.Function(_typing_cvt_float2_to_fp8x2)
)


@register
class _typing_cvt_bfloat16raw_to_fp8(ConcreteTemplate):
    key = globals()["cvt_bfloat16raw_to_fp8"]
    cases = [
        signature(
            uint8,
            bfloat16_raw_type,
            IntEnumMember(saturation_t, int64),
            IntEnumMember(fp8_interpretation_t, int64),
        )
    ]


register_global(
    cvt_bfloat16raw_to_fp8, types.Function(_typing_cvt_bfloat16raw_to_fp8)
)


@register
class _typing_cvt_bfloat16raw_to_e8m0(ConcreteTemplate):
    key = globals()["cvt_bfloat16raw_to_e8m0"]
    cases = [
        signature(
            uint8,
            bfloat16_raw_type,
            IntEnumMember(saturation_t, int64),
            IntEnumMember(cudaRoundMode, int64),
        )
    ]


register_global(
    cvt_bfloat16raw_to_e8m0, types.Function(_typing_cvt_bfloat16raw_to_e8m0)
)


@register
class _typing_cvt_float_to_e8m0(ConcreteTemplate):
    key = globals()["cvt_float_to_e8m0"]
    cases = [
        signature(
            uint8,
            float32,
            IntEnumMember(saturation_t, int64),
            IntEnumMember(cudaRoundMode, int64),
        )
    ]


register_global(cvt_float_to_e8m0, types.Function(_typing_cvt_float_to_e8m0))


@register
class _typing_cvt_float2_to_e8m0x2(ConcreteTemplate):
    key = globals()["cvt_float2_to_e8m0x2"]
    cases = [
        signature(
            uint16,
            float32x2,
            IntEnumMember(saturation_t, int64),
            IntEnumMember(cudaRoundMode, int64),
        )
    ]


register_global(
    cvt_float2_to_e8m0x2, types.Function(_typing_cvt_float2_to_e8m0x2)
)


@register
class _typing_cvt_double_to_e8m0(ConcreteTemplate):
    key = globals()["cvt_double_to_e8m0"]
    cases = [
        signature(
            uint8,
            float64,
            IntEnumMember(saturation_t, int64),
            IntEnumMember(cudaRoundMode, int64),
        )
    ]


register_global(cvt_double_to_e8m0, types.Function(_typing_cvt_double_to_e8m0))


@register
class _typing_cvt_double2_to_e8m0x2(ConcreteTemplate):
    key = globals()["cvt_double2_to_e8m0x2"]
    cases = [
        signature(
            uint16,
            float64x2,
            IntEnumMember(saturation_t, int64),
            IntEnumMember(cudaRoundMode, int64),
        )
    ]


register_global(
    cvt_double2_to_e8m0x2, types.Function(_typing_cvt_double2_to_e8m0x2)
)


@register
class _typing_cvt_e8m0_to_bf16raw(ConcreteTemplate):
    key = globals()["cvt_e8m0_to_bf16raw"]
    cases = [signature(bfloat16_raw_type, uint8)]


register_global(
    cvt_e8m0_to_bf16raw, types.Function(_typing_cvt_e8m0_to_bf16raw)
)


# Aliases:


# Symbols:


_NBTYPE_SYMBOLS = [
    "_type_fp8_e5m2",
    "_type_fp8x2_e5m2",
    "_type_fp8x4_e5m2",
    "_type_fp8_e4m3",
    "_type_fp8x2_e4m3",
    "_type_fp8x4_e4m3",
    "_type_fp8_e8m0",
    "_type_fp8x2_e8m0",
    "_type_fp8x4_e8m0",
]


_RECORD_SYMBOLS = [
    "fp8_e5m2",
    "fp8x2_e5m2",
    "fp8x4_e5m2",
    "fp8_e4m3",
    "fp8x2_e4m3",
    "fp8x4_e4m3",
    "fp8_e8m0",
    "fp8x2_e8m0",
    "fp8x4_e8m0",
]


_FUNCTION_SYMBOLS = [
    "cvt_double_to_fp8",
    "cvt_double2_to_fp8x2",
    "cvt_float_to_fp8",
    "cvt_float2_to_fp8x2",
    "cvt_bfloat16raw_to_fp8",
    "cvt_bfloat16raw_to_e8m0",
    "cvt_float_to_e8m0",
    "cvt_float2_to_e8m0x2",
    "cvt_double_to_e8m0",
    "cvt_double2_to_e8m0x2",
    "cvt_e8m0_to_bf16raw",
]


_ENUM_SYMBOLS = ["saturation_t", "fp8_interpretation_t"]

__all__ = _NBTYPE_SYMBOLS + _RECORD_SYMBOLS + _FUNCTION_SYMBOLS + _ENUM_SYMBOLS
