\name{DilateObjectMorphologyImageFilter}
\alias{DilateObjectMorphologyImageFilter}
\title{DilateObjectMorphologyImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
dilation of an object in an image
DilateObjectMorphologyImageFilter}
\details{
Dilate an image using binary morphology. Pixel values matching the
object value are considered the "foreground" and all other pixels
are "background". This is useful in processing mask images
containing only one object.
If a pixel's value is equal to the object value and the pixel is
adjacent to a non-object valued pixel, then the kernel is centered on
the object-value pixel and neighboring pixels covered by the kernel
are assigned the object value. The structuring element is assumed to
be composed of binary values (zero or one).
See:
ObjectMorphologyImageFilter , ErodeObjectMorphologyImageFilter
BinaryDilateImageFilter
DilateObjectMorphology for the procedural interface
itk::DilateObjectMorphologyImageFilter for the Doxygen on the original ITK class.
DilateObjectMorphologyImageFilter}
%C++ includes: sitkDilateObjectMorphologyImageFilter.h
\section{Methods}{
\describe{
\item{ DilateObjectMorphologyImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::vector< unsigned int > GetKernelRadius() const:}{
Get the radius of the kernel structuring element.
}
\item{KernelEnum GetKernelType() const:}{
Get the kernel or structuring element used for the morphology.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetObjectValue() const:}{}
\item{Self SetKernelRadius(std::vector< unsigned int > KernelRadius):}{
Set the radius of the kernel structuring element.
}
\item{Self SetKernelRadius(unsigned int value):}{
Set the values of the KernelRadius vector all to value
}
\item{Self SetKernelType(KernelEnum KernelType):}{
Set the kernel or structuring element used for the morphology.
}
\item{Self SetObjectValue(double ObjectValue):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~DilateObjectMorphologyImageFilter():}{
Destructor
}
}
}
