\name{UnaryMinusImageFilter}
\alias{UnaryMinusImageFilter}
\title{UnaryMinusImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Implements pixel-wise generic operation on one image.
UnaryMinusImageFilter}
\details{
This class is parameterized over the type of the input image and the
type of the output image. It is also parameterized by the operation to
be applied, using a Functor style.
UnaryFunctorImageFilter allows the output dimension of the filter to be larger than the input
dimension. Thus subclasses of the UnaryFunctorImageFilter (like the CastImageFilter ) can be used to promote a 2D image to a 3D image, etc.
See:
UnaryGeneratorImageFilter
BinaryFunctorImageFilter TernaryFunctorImageFilter
UnaryMinus for the procedural interface
itk::UnaryFunctorImageFilter for the Doxygen on the original ITK class.
UnaryMinusImageFilter}
%C++ includes: sitkUnaryMinusImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ UnaryMinusImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{ ~UnaryMinusImageFilter():}{
Destructor
}
}
}
