# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/codegen/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the Suggestion message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    #
    # A suggested fragment of code to implement an undefined step
    ##
    class Suggestion < Message
      ##
      # A unique id for this suggestion
      ##
      attr_reader :id

      ##
      # The ID of the `PickleStep` this `Suggestion` was created for.
      ##
      attr_reader :pickle_step_id

      ##
      # A collection of code snippets that could implement the undefined step
      ##
      attr_reader :snippets

      def initialize(
        id: '',
        pickle_step_id: '',
        snippets: []
      )
        @id = id
        @pickle_step_id = pickle_step_id
        @snippets = snippets
        super()
      end

      ##
      # Returns a new Suggestion from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::Suggestion.from_h(some_hash) # => #<Cucumber::Messages::Suggestion:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          id: hash[:id],
          pickle_step_id: hash[:pickleStepId],
          snippets: hash[:snippets]&.map { |item| Snippet.from_h(item) }
        )
      end
    end
  end
end
