﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agent/BedrockAgent_EXPORTS.h>
#include <aws/bedrock-agent/model/AgentSummary.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace BedrockAgent {
namespace Model {
class ListAgentsResult {
 public:
  AWS_BEDROCKAGENT_API ListAgentsResult() = default;
  AWS_BEDROCKAGENT_API ListAgentsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_BEDROCKAGENT_API ListAgentsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of objects, each of which contains information about an agent.</p>
   */
  inline const Aws::Vector<AgentSummary>& GetAgentSummaries() const { return m_agentSummaries; }
  template <typename AgentSummariesT = Aws::Vector<AgentSummary>>
  void SetAgentSummaries(AgentSummariesT&& value) {
    m_agentSummariesHasBeenSet = true;
    m_agentSummaries = std::forward<AgentSummariesT>(value);
  }
  template <typename AgentSummariesT = Aws::Vector<AgentSummary>>
  ListAgentsResult& WithAgentSummaries(AgentSummariesT&& value) {
    SetAgentSummaries(std::forward<AgentSummariesT>(value));
    return *this;
  }
  template <typename AgentSummariesT = AgentSummary>
  ListAgentsResult& AddAgentSummaries(AgentSummariesT&& value) {
    m_agentSummariesHasBeenSet = true;
    m_agentSummaries.emplace_back(std::forward<AgentSummariesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If the total number of results is greater than the <code>maxResults</code>
   * value provided in the request, use this token when making another request in the
   * <code>nextToken</code> field to return the next batch of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListAgentsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListAgentsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<AgentSummary> m_agentSummaries;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_agentSummariesHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace BedrockAgent
}  // namespace Aws
