﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codeguru-security/CodeGuruSecurity_EXPORTS.h>
#include <aws/codeguru-security/model/ErrorCode.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CodeGuruSecurity {
namespace Model {

/**
 * <p>Contains information about the error that caused a finding to fail to be
 * retrieved.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/BatchGetFindingsError">AWS
 * API Reference</a></p>
 */
class BatchGetFindingsError {
 public:
  AWS_CODEGURUSECURITY_API BatchGetFindingsError() = default;
  AWS_CODEGURUSECURITY_API BatchGetFindingsError(Aws::Utils::Json::JsonView jsonValue);
  AWS_CODEGURUSECURITY_API BatchGetFindingsError& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CODEGURUSECURITY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the scan that generated the finding.</p>
   */
  inline const Aws::String& GetScanName() const { return m_scanName; }
  inline bool ScanNameHasBeenSet() const { return m_scanNameHasBeenSet; }
  template <typename ScanNameT = Aws::String>
  void SetScanName(ScanNameT&& value) {
    m_scanNameHasBeenSet = true;
    m_scanName = std::forward<ScanNameT>(value);
  }
  template <typename ScanNameT = Aws::String>
  BatchGetFindingsError& WithScanName(ScanNameT&& value) {
    SetScanName(std::forward<ScanNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The finding ID of the finding that was not fetched.</p>
   */
  inline const Aws::String& GetFindingId() const { return m_findingId; }
  inline bool FindingIdHasBeenSet() const { return m_findingIdHasBeenSet; }
  template <typename FindingIdT = Aws::String>
  void SetFindingId(FindingIdT&& value) {
    m_findingIdHasBeenSet = true;
    m_findingId = std::forward<FindingIdT>(value);
  }
  template <typename FindingIdT = Aws::String>
  BatchGetFindingsError& WithFindingId(FindingIdT&& value) {
    SetFindingId(std::forward<FindingIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A code associated with the type of error.</p>
   */
  inline ErrorCode GetErrorCode() const { return m_errorCode; }
  inline bool ErrorCodeHasBeenSet() const { return m_errorCodeHasBeenSet; }
  inline void SetErrorCode(ErrorCode value) {
    m_errorCodeHasBeenSet = true;
    m_errorCode = value;
  }
  inline BatchGetFindingsError& WithErrorCode(ErrorCode value) {
    SetErrorCode(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Describes the error.</p>
   */
  inline const Aws::String& GetMessage() const { return m_message; }
  inline bool MessageHasBeenSet() const { return m_messageHasBeenSet; }
  template <typename MessageT = Aws::String>
  void SetMessage(MessageT&& value) {
    m_messageHasBeenSet = true;
    m_message = std::forward<MessageT>(value);
  }
  template <typename MessageT = Aws::String>
  BatchGetFindingsError& WithMessage(MessageT&& value) {
    SetMessage(std::forward<MessageT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_scanName;

  Aws::String m_findingId;

  ErrorCode m_errorCode{ErrorCode::NOT_SET};

  Aws::String m_message;
  bool m_scanNameHasBeenSet = false;
  bool m_findingIdHasBeenSet = false;
  bool m_errorCodeHasBeenSet = false;
  bool m_messageHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeGuruSecurity
}  // namespace Aws
