﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/config/ConfigService_EXPORTS.h>
#include <aws/config/model/ResourceType.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ConfigService {
namespace Model {

/**
 * <p>The details that identify a resource that is discovered by Config, including
 * the resource type, ID, and (if available) the custom resource
 * name.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ResourceIdentifier">AWS
 * API Reference</a></p>
 */
class ResourceIdentifier {
 public:
  AWS_CONFIGSERVICE_API ResourceIdentifier() = default;
  AWS_CONFIGSERVICE_API ResourceIdentifier(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONFIGSERVICE_API ResourceIdentifier& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONFIGSERVICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The type of resource.</p>
   */
  inline ResourceType GetResourceType() const { return m_resourceType; }
  inline bool ResourceTypeHasBeenSet() const { return m_resourceTypeHasBeenSet; }
  inline void SetResourceType(ResourceType value) {
    m_resourceTypeHasBeenSet = true;
    m_resourceType = value;
  }
  inline ResourceIdentifier& WithResourceType(ResourceType value) {
    SetResourceType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the resource (for example, <code>sg-xxxxxx</code>).</p>
   */
  inline const Aws::String& GetResourceId() const { return m_resourceId; }
  inline bool ResourceIdHasBeenSet() const { return m_resourceIdHasBeenSet; }
  template <typename ResourceIdT = Aws::String>
  void SetResourceId(ResourceIdT&& value) {
    m_resourceIdHasBeenSet = true;
    m_resourceId = std::forward<ResourceIdT>(value);
  }
  template <typename ResourceIdT = Aws::String>
  ResourceIdentifier& WithResourceId(ResourceIdT&& value) {
    SetResourceId(std::forward<ResourceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The custom name of the resource (if available).</p>
   */
  inline const Aws::String& GetResourceName() const { return m_resourceName; }
  inline bool ResourceNameHasBeenSet() const { return m_resourceNameHasBeenSet; }
  template <typename ResourceNameT = Aws::String>
  void SetResourceName(ResourceNameT&& value) {
    m_resourceNameHasBeenSet = true;
    m_resourceName = std::forward<ResourceNameT>(value);
  }
  template <typename ResourceNameT = Aws::String>
  ResourceIdentifier& WithResourceName(ResourceNameT&& value) {
    SetResourceName(std::forward<ResourceNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time that the resource was deleted.</p>
   */
  inline const Aws::Utils::DateTime& GetResourceDeletionTime() const { return m_resourceDeletionTime; }
  inline bool ResourceDeletionTimeHasBeenSet() const { return m_resourceDeletionTimeHasBeenSet; }
  template <typename ResourceDeletionTimeT = Aws::Utils::DateTime>
  void SetResourceDeletionTime(ResourceDeletionTimeT&& value) {
    m_resourceDeletionTimeHasBeenSet = true;
    m_resourceDeletionTime = std::forward<ResourceDeletionTimeT>(value);
  }
  template <typename ResourceDeletionTimeT = Aws::Utils::DateTime>
  ResourceIdentifier& WithResourceDeletionTime(ResourceDeletionTimeT&& value) {
    SetResourceDeletionTime(std::forward<ResourceDeletionTimeT>(value));
    return *this;
  }
  ///@}
 private:
  ResourceType m_resourceType{ResourceType::NOT_SET};

  Aws::String m_resourceId;

  Aws::String m_resourceName;

  Aws::Utils::DateTime m_resourceDeletionTime{};
  bool m_resourceTypeHasBeenSet = false;
  bool m_resourceIdHasBeenSet = false;
  bool m_resourceNameHasBeenSet = false;
  bool m_resourceDeletionTimeHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConfigService
}  // namespace Aws
