﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/GuardDutyRequest.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>

#include <utility>

namespace Aws {
namespace GuardDuty {
namespace Model {

/**
 */
class DeleteThreatIntelSetRequest : public GuardDutyRequest {
 public:
  AWS_GUARDDUTY_API DeleteThreatIntelSetRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteThreatIntelSet"; }

  AWS_GUARDDUTY_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The unique ID of the detector that is associated with the threatIntelSet.</p>
   * <p>To find the <code>detectorId</code> in the current Region, see the Settings
   * page in the GuardDuty console, or run the <a
   * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
   * API.</p>
   */
  inline const Aws::String& GetDetectorId() const { return m_detectorId; }
  inline bool DetectorIdHasBeenSet() const { return m_detectorIdHasBeenSet; }
  template <typename DetectorIdT = Aws::String>
  void SetDetectorId(DetectorIdT&& value) {
    m_detectorIdHasBeenSet = true;
    m_detectorId = std::forward<DetectorIdT>(value);
  }
  template <typename DetectorIdT = Aws::String>
  DeleteThreatIntelSetRequest& WithDetectorId(DetectorIdT&& value) {
    SetDetectorId(std::forward<DetectorIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique ID of the threatIntelSet that you want to delete.</p>
   */
  inline const Aws::String& GetThreatIntelSetId() const { return m_threatIntelSetId; }
  inline bool ThreatIntelSetIdHasBeenSet() const { return m_threatIntelSetIdHasBeenSet; }
  template <typename ThreatIntelSetIdT = Aws::String>
  void SetThreatIntelSetId(ThreatIntelSetIdT&& value) {
    m_threatIntelSetIdHasBeenSet = true;
    m_threatIntelSetId = std::forward<ThreatIntelSetIdT>(value);
  }
  template <typename ThreatIntelSetIdT = Aws::String>
  DeleteThreatIntelSetRequest& WithThreatIntelSetId(ThreatIntelSetIdT&& value) {
    SetThreatIntelSetId(std::forward<ThreatIntelSetIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_detectorId;

  Aws::String m_threatIntelSetId;
  bool m_detectorIdHasBeenSet = false;
  bool m_threatIntelSetIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
