﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/IoT_EXPORTS.h>
#include <aws/iot/model/CertificateMode.h>
#include <aws/iot/model/CertificateStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace IoT {
namespace Model {

/**
 * <p>Information about a certificate.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iot-2015-05-28/Certificate">AWS API
 * Reference</a></p>
 */
class Certificate {
 public:
  AWS_IOT_API Certificate() = default;
  AWS_IOT_API Certificate(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOT_API Certificate& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ARN of the certificate.</p>
   */
  inline const Aws::String& GetCertificateArn() const { return m_certificateArn; }
  inline bool CertificateArnHasBeenSet() const { return m_certificateArnHasBeenSet; }
  template <typename CertificateArnT = Aws::String>
  void SetCertificateArn(CertificateArnT&& value) {
    m_certificateArnHasBeenSet = true;
    m_certificateArn = std::forward<CertificateArnT>(value);
  }
  template <typename CertificateArnT = Aws::String>
  Certificate& WithCertificateArn(CertificateArnT&& value) {
    SetCertificateArn(std::forward<CertificateArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the certificate. (The last part of the certificate ARN contains the
   * certificate ID.)</p>
   */
  inline const Aws::String& GetCertificateId() const { return m_certificateId; }
  inline bool CertificateIdHasBeenSet() const { return m_certificateIdHasBeenSet; }
  template <typename CertificateIdT = Aws::String>
  void SetCertificateId(CertificateIdT&& value) {
    m_certificateIdHasBeenSet = true;
    m_certificateId = std::forward<CertificateIdT>(value);
  }
  template <typename CertificateIdT = Aws::String>
  Certificate& WithCertificateId(CertificateIdT&& value) {
    SetCertificateId(std::forward<CertificateIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the certificate.</p> <p>The status value REGISTER_INACTIVE is
   * deprecated and should not be used.</p>
   */
  inline CertificateStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(CertificateStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline Certificate& WithStatus(CertificateStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The mode of the certificate.</p> <p> <code>DEFAULT</code>: A certificate in
   * <code>DEFAULT</code> mode is either generated by Amazon Web Services IoT Core or
   * registered with an issuer certificate authority (CA) in <code>DEFAULT</code>
   * mode. Devices with certificates in <code>DEFAULT</code> mode aren't required to
   * send the Server Name Indication (SNI) extension when connecting to Amazon Web
   * Services IoT Core. However, to use features such as custom domains and VPC
   * endpoints, we recommend that you use the SNI extension when connecting to Amazon
   * Web Services IoT Core.</p> <p> <code>SNI_ONLY</code>: A certificate in
   * <code>SNI_ONLY</code> mode is registered without an issuer CA. Devices with
   * certificates in <code>SNI_ONLY</code> mode must send the SNI extension when
   * connecting to Amazon Web Services IoT Core. </p>
   */
  inline CertificateMode GetCertificateMode() const { return m_certificateMode; }
  inline bool CertificateModeHasBeenSet() const { return m_certificateModeHasBeenSet; }
  inline void SetCertificateMode(CertificateMode value) {
    m_certificateModeHasBeenSet = true;
    m_certificateMode = value;
  }
  inline Certificate& WithCertificateMode(CertificateMode value) {
    SetCertificateMode(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time the certificate was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationDate() const { return m_creationDate; }
  inline bool CreationDateHasBeenSet() const { return m_creationDateHasBeenSet; }
  template <typename CreationDateT = Aws::Utils::DateTime>
  void SetCreationDate(CreationDateT&& value) {
    m_creationDateHasBeenSet = true;
    m_creationDate = std::forward<CreationDateT>(value);
  }
  template <typename CreationDateT = Aws::Utils::DateTime>
  Certificate& WithCreationDate(CreationDateT&& value) {
    SetCreationDate(std::forward<CreationDateT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_certificateArn;

  Aws::String m_certificateId;

  CertificateStatus m_status{CertificateStatus::NOT_SET};

  CertificateMode m_certificateMode{CertificateMode::NOT_SET};

  Aws::Utils::DateTime m_creationDate{};
  bool m_certificateArnHasBeenSet = false;
  bool m_certificateIdHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_certificateModeHasBeenSet = false;
  bool m_creationDateHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
