﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/keyspacesstreams/KeyspacesStreams_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace KeyspacesStreams {
namespace Model {

/**
 * <p>Represents a change data capture stream for an Amazon Keyspaces table, which
 * enables tracking and processing of data changes.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/keyspacesstreams-2024-09-09/Stream">AWS
 * API Reference</a></p>
 */
class Stream {
 public:
  AWS_KEYSPACESSTREAMS_API Stream() = default;
  AWS_KEYSPACESSTREAMS_API Stream(Aws::Utils::Json::JsonView jsonValue);
  AWS_KEYSPACESSTREAMS_API Stream& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_KEYSPACESSTREAMS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) that uniquely identifies this stream.</p>
   */
  inline const Aws::String& GetStreamArn() const { return m_streamArn; }
  inline bool StreamArnHasBeenSet() const { return m_streamArnHasBeenSet; }
  template <typename StreamArnT = Aws::String>
  void SetStreamArn(StreamArnT&& value) {
    m_streamArnHasBeenSet = true;
    m_streamArn = std::forward<StreamArnT>(value);
  }
  template <typename StreamArnT = Aws::String>
  Stream& WithStreamArn(StreamArnT&& value) {
    SetStreamArn(std::forward<StreamArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the keyspace containing the table associated with this
   * stream.</p>
   */
  inline const Aws::String& GetKeyspaceName() const { return m_keyspaceName; }
  inline bool KeyspaceNameHasBeenSet() const { return m_keyspaceNameHasBeenSet; }
  template <typename KeyspaceNameT = Aws::String>
  void SetKeyspaceName(KeyspaceNameT&& value) {
    m_keyspaceNameHasBeenSet = true;
    m_keyspaceName = std::forward<KeyspaceNameT>(value);
  }
  template <typename KeyspaceNameT = Aws::String>
  Stream& WithKeyspaceName(KeyspaceNameT&& value) {
    SetKeyspaceName(std::forward<KeyspaceNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the table associated with this stream.</p>
   */
  inline const Aws::String& GetTableName() const { return m_tableName; }
  inline bool TableNameHasBeenSet() const { return m_tableNameHasBeenSet; }
  template <typename TableNameT = Aws::String>
  void SetTableName(TableNameT&& value) {
    m_tableNameHasBeenSet = true;
    m_tableName = std::forward<TableNameT>(value);
  }
  template <typename TableNameT = Aws::String>
  Stream& WithTableName(TableNameT&& value) {
    SetTableName(std::forward<TableNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A unique identifier for this stream that can be used in stream
   * operations.</p>
   */
  inline const Aws::String& GetStreamLabel() const { return m_streamLabel; }
  inline bool StreamLabelHasBeenSet() const { return m_streamLabelHasBeenSet; }
  template <typename StreamLabelT = Aws::String>
  void SetStreamLabel(StreamLabelT&& value) {
    m_streamLabelHasBeenSet = true;
    m_streamLabel = std::forward<StreamLabelT>(value);
  }
  template <typename StreamLabelT = Aws::String>
  Stream& WithStreamLabel(StreamLabelT&& value) {
    SetStreamLabel(std::forward<StreamLabelT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_streamArn;

  Aws::String m_keyspaceName;

  Aws::String m_tableName;

  Aws::String m_streamLabel;
  bool m_streamArnHasBeenSet = false;
  bool m_keyspaceNameHasBeenSet = false;
  bool m_tableNameHasBeenSet = false;
  bool m_streamLabelHasBeenSet = false;
};

}  // namespace Model
}  // namespace KeyspacesStreams
}  // namespace Aws
