﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/machinelearning/MachineLearningRequest.h>
#include <aws/machinelearning/MachineLearning_EXPORTS.h>

#include <utility>

namespace Aws {
namespace MachineLearning {
namespace Model {

/**
 */
class CreateRealtimeEndpointRequest : public MachineLearningRequest {
 public:
  AWS_MACHINELEARNING_API CreateRealtimeEndpointRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "CreateRealtimeEndpoint"; }

  AWS_MACHINELEARNING_API Aws::String SerializePayload() const override;

  AWS_MACHINELEARNING_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The ID assigned to the <code>MLModel</code> during creation.</p>
   */
  inline const Aws::String& GetMLModelId() const { return m_mLModelId; }
  inline bool MLModelIdHasBeenSet() const { return m_mLModelIdHasBeenSet; }
  template <typename MLModelIdT = Aws::String>
  void SetMLModelId(MLModelIdT&& value) {
    m_mLModelIdHasBeenSet = true;
    m_mLModelId = std::forward<MLModelIdT>(value);
  }
  template <typename MLModelIdT = Aws::String>
  CreateRealtimeEndpointRequest& WithMLModelId(MLModelIdT&& value) {
    SetMLModelId(std::forward<MLModelIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_mLModelId;
  bool m_mLModelIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace MachineLearning
}  // namespace Aws
