﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mgn/Mgn_EXPORTS.h>
#include <aws/mgn/model/ApplicationAggregatedStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace mgn {
namespace Model {

class Application {
 public:
  AWS_MGN_API Application() = default;
  AWS_MGN_API Application(Aws::Utils::Json::JsonView jsonValue);
  AWS_MGN_API Application& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MGN_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Application ID.</p>
   */
  inline const Aws::String& GetApplicationID() const { return m_applicationID; }
  inline bool ApplicationIDHasBeenSet() const { return m_applicationIDHasBeenSet; }
  template <typename ApplicationIDT = Aws::String>
  void SetApplicationID(ApplicationIDT&& value) {
    m_applicationIDHasBeenSet = true;
    m_applicationID = std::forward<ApplicationIDT>(value);
  }
  template <typename ApplicationIDT = Aws::String>
  Application& WithApplicationID(ApplicationIDT&& value) {
    SetApplicationID(std::forward<ApplicationIDT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Application ARN.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  Application& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Application name.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  Application& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Application description.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  Application& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Application archival status.</p>
   */
  inline bool GetIsArchived() const { return m_isArchived; }
  inline bool IsArchivedHasBeenSet() const { return m_isArchivedHasBeenSet; }
  inline void SetIsArchived(bool value) {
    m_isArchivedHasBeenSet = true;
    m_isArchived = value;
  }
  inline Application& WithIsArchived(bool value) {
    SetIsArchived(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Application aggregated status.</p>
   */
  inline const ApplicationAggregatedStatus& GetApplicationAggregatedStatus() const { return m_applicationAggregatedStatus; }
  inline bool ApplicationAggregatedStatusHasBeenSet() const { return m_applicationAggregatedStatusHasBeenSet; }
  template <typename ApplicationAggregatedStatusT = ApplicationAggregatedStatus>
  void SetApplicationAggregatedStatus(ApplicationAggregatedStatusT&& value) {
    m_applicationAggregatedStatusHasBeenSet = true;
    m_applicationAggregatedStatus = std::forward<ApplicationAggregatedStatusT>(value);
  }
  template <typename ApplicationAggregatedStatusT = ApplicationAggregatedStatus>
  Application& WithApplicationAggregatedStatus(ApplicationAggregatedStatusT&& value) {
    SetApplicationAggregatedStatus(std::forward<ApplicationAggregatedStatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Application creation dateTime.</p>
   */
  inline const Aws::String& GetCreationDateTime() const { return m_creationDateTime; }
  inline bool CreationDateTimeHasBeenSet() const { return m_creationDateTimeHasBeenSet; }
  template <typename CreationDateTimeT = Aws::String>
  void SetCreationDateTime(CreationDateTimeT&& value) {
    m_creationDateTimeHasBeenSet = true;
    m_creationDateTime = std::forward<CreationDateTimeT>(value);
  }
  template <typename CreationDateTimeT = Aws::String>
  Application& WithCreationDateTime(CreationDateTimeT&& value) {
    SetCreationDateTime(std::forward<CreationDateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Application last modified dateTime.</p>
   */
  inline const Aws::String& GetLastModifiedDateTime() const { return m_lastModifiedDateTime; }
  inline bool LastModifiedDateTimeHasBeenSet() const { return m_lastModifiedDateTimeHasBeenSet; }
  template <typename LastModifiedDateTimeT = Aws::String>
  void SetLastModifiedDateTime(LastModifiedDateTimeT&& value) {
    m_lastModifiedDateTimeHasBeenSet = true;
    m_lastModifiedDateTime = std::forward<LastModifiedDateTimeT>(value);
  }
  template <typename LastModifiedDateTimeT = Aws::String>
  Application& WithLastModifiedDateTime(LastModifiedDateTimeT&& value) {
    SetLastModifiedDateTime(std::forward<LastModifiedDateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Application tags.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  Application& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  Application& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Application wave ID.</p>
   */
  inline const Aws::String& GetWaveID() const { return m_waveID; }
  inline bool WaveIDHasBeenSet() const { return m_waveIDHasBeenSet; }
  template <typename WaveIDT = Aws::String>
  void SetWaveID(WaveIDT&& value) {
    m_waveIDHasBeenSet = true;
    m_waveID = std::forward<WaveIDT>(value);
  }
  template <typename WaveIDT = Aws::String>
  Application& WithWaveID(WaveIDT&& value) {
    SetWaveID(std::forward<WaveIDT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  inline bool RequestIdHasBeenSet() const { return m_requestIdHasBeenSet; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  Application& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_applicationID;

  Aws::String m_arn;

  Aws::String m_name;

  Aws::String m_description;

  bool m_isArchived{false};

  ApplicationAggregatedStatus m_applicationAggregatedStatus;

  Aws::String m_creationDateTime;

  Aws::String m_lastModifiedDateTime;

  Aws::Map<Aws::String, Aws::String> m_tags;

  Aws::String m_waveID;

  Aws::String m_requestId;
  bool m_applicationIDHasBeenSet = false;
  bool m_arnHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_isArchivedHasBeenSet = false;
  bool m_applicationAggregatedStatusHasBeenSet = false;
  bool m_creationDateTimeHasBeenSet = false;
  bool m_lastModifiedDateTimeHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_waveIDHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace mgn
}  // namespace Aws
