﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/payment-cryptography/PaymentCryptographyRequest.h>
#include <aws/payment-cryptography/PaymentCryptography_EXPORTS.h>

#include <utility>

namespace Aws {
namespace PaymentCryptography {
namespace Model {

/**
 */
class UpdateAliasRequest : public PaymentCryptographyRequest {
 public:
  AWS_PAYMENTCRYPTOGRAPHY_API UpdateAliasRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateAlias"; }

  AWS_PAYMENTCRYPTOGRAPHY_API Aws::String SerializePayload() const override;

  AWS_PAYMENTCRYPTOGRAPHY_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The alias whose associated key is changing.</p>
   */
  inline const Aws::String& GetAliasName() const { return m_aliasName; }
  inline bool AliasNameHasBeenSet() const { return m_aliasNameHasBeenSet; }
  template <typename AliasNameT = Aws::String>
  void SetAliasName(AliasNameT&& value) {
    m_aliasNameHasBeenSet = true;
    m_aliasName = std::forward<AliasNameT>(value);
  }
  template <typename AliasNameT = Aws::String>
  UpdateAliasRequest& WithAliasName(AliasNameT&& value) {
    SetAliasName(std::forward<AliasNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The <code>KeyARN</code> for the key that you are updating or removing from
   * the alias.</p>
   */
  inline const Aws::String& GetKeyArn() const { return m_keyArn; }
  inline bool KeyArnHasBeenSet() const { return m_keyArnHasBeenSet; }
  template <typename KeyArnT = Aws::String>
  void SetKeyArn(KeyArnT&& value) {
    m_keyArnHasBeenSet = true;
    m_keyArn = std::forward<KeyArnT>(value);
  }
  template <typename KeyArnT = Aws::String>
  UpdateAliasRequest& WithKeyArn(KeyArnT&& value) {
    SetKeyArn(std::forward<KeyArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_aliasName;

  Aws::String m_keyArn;
  bool m_aliasNameHasBeenSet = false;
  bool m_keyArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace PaymentCryptography
}  // namespace Aws
