﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/redshift-serverless/RedshiftServerless_EXPORTS.h>
#include <aws/redshift-serverless/model/Reservation.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace RedshiftServerless {
namespace Model {
class CreateReservationResult {
 public:
  AWS_REDSHIFTSERVERLESS_API CreateReservationResult() = default;
  AWS_REDSHIFTSERVERLESS_API CreateReservationResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_REDSHIFTSERVERLESS_API CreateReservationResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The reservation object that the <code>CreateReservation</code> action
   * created.</p>
   */
  inline const Reservation& GetReservation() const { return m_reservation; }
  template <typename ReservationT = Reservation>
  void SetReservation(ReservationT&& value) {
    m_reservationHasBeenSet = true;
    m_reservation = std::forward<ReservationT>(value);
  }
  template <typename ReservationT = Reservation>
  CreateReservationResult& WithReservation(ReservationT&& value) {
    SetReservation(std::forward<ReservationT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateReservationResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Reservation m_reservation;

  Aws::String m_requestId;
  bool m_reservationHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace RedshiftServerless
}  // namespace Aws
