﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/shield/Shield_EXPORTS.h>
#include <aws/shield/model/Protection.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Shield {
namespace Model {
class DescribeProtectionResult {
 public:
  AWS_SHIELD_API DescribeProtectionResult() = default;
  AWS_SHIELD_API DescribeProtectionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SHIELD_API DescribeProtectionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The <a>Protection</a> that you requested. </p>
   */
  inline const Protection& GetProtection() const { return m_protection; }
  template <typename ProtectionT = Protection>
  void SetProtection(ProtectionT&& value) {
    m_protectionHasBeenSet = true;
    m_protection = std::forward<ProtectionT>(value);
  }
  template <typename ProtectionT = Protection>
  DescribeProtectionResult& WithProtection(ProtectionT&& value) {
    SetProtection(std::forward<ProtectionT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeProtectionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Protection m_protection;

  Aws::String m_requestId;
  bool m_protectionHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Shield
}  // namespace Aws
