﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ssm/SSMRequest.h>
#include <aws/ssm/SSM_EXPORTS.h>
#include <aws/ssm/model/AssociationStatus.h>

#include <utility>

namespace Aws {
namespace SSM {
namespace Model {

/**
 */
class UpdateAssociationStatusRequest : public SSMRequest {
 public:
  AWS_SSM_API UpdateAssociationStatusRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateAssociationStatus"; }

  AWS_SSM_API Aws::String SerializePayload() const override;

  AWS_SSM_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The name of the SSM document.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  UpdateAssociationStatusRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The managed node ID.</p>
   */
  inline const Aws::String& GetInstanceId() const { return m_instanceId; }
  inline bool InstanceIdHasBeenSet() const { return m_instanceIdHasBeenSet; }
  template <typename InstanceIdT = Aws::String>
  void SetInstanceId(InstanceIdT&& value) {
    m_instanceIdHasBeenSet = true;
    m_instanceId = std::forward<InstanceIdT>(value);
  }
  template <typename InstanceIdT = Aws::String>
  UpdateAssociationStatusRequest& WithInstanceId(InstanceIdT&& value) {
    SetInstanceId(std::forward<InstanceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The association status.</p>
   */
  inline const AssociationStatus& GetAssociationStatus() const { return m_associationStatus; }
  inline bool AssociationStatusHasBeenSet() const { return m_associationStatusHasBeenSet; }
  template <typename AssociationStatusT = AssociationStatus>
  void SetAssociationStatus(AssociationStatusT&& value) {
    m_associationStatusHasBeenSet = true;
    m_associationStatus = std::forward<AssociationStatusT>(value);
  }
  template <typename AssociationStatusT = AssociationStatus>
  UpdateAssociationStatusRequest& WithAssociationStatus(AssociationStatusT&& value) {
    SetAssociationStatus(std::forward<AssociationStatusT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  Aws::String m_instanceId;

  AssociationStatus m_associationStatus;
  bool m_nameHasBeenSet = false;
  bool m_instanceIdHasBeenSet = false;
  bool m_associationStatusHasBeenSet = false;
};

}  // namespace Model
}  // namespace SSM
}  // namespace Aws
