/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.constant;

import java.io.UnsupportedEncodingException;
import proguard.classfile.Clazz;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;

public class Utf8Constant
extends Constant {
    private static final char TWO_BYTE_LIMIT = '\u0080';
    private static final int TWO_BYTE_CONSTANT1 = 192;
    private static final int TWO_BYTE_CONSTANT2 = 128;
    private static final int TWO_BYTE_SHIFT1 = 6;
    private static final int TWO_BYTE_MASK1 = 31;
    private static final int TWO_BYTE_MASK2 = 63;
    private static final char THREE_BYTE_LIMIT = '\u0800';
    private static final int THREE_BYTE_CONSTANT1 = 224;
    private static final int THREE_BYTE_CONSTANT2 = 128;
    private static final int THREE_BYTE_CONSTANT3 = 128;
    private static final int THREE_BYTE_SHIFT1 = 12;
    private static final int THREE_BYTE_SHIFT2 = 6;
    private static final int THREE_BYTE_MASK1 = 15;
    private static final int THREE_BYTE_MASK2 = 63;
    private static final int THREE_BYTE_MASK3 = 63;
    private byte[] bytes;
    private String string;

    public Utf8Constant() {
    }

    public Utf8Constant(String string) {
        this.bytes = null;
        this.string = string;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
        this.string = null;
    }

    public byte[] getBytes() {
        try {
            this.switchToByteArrayRepresentation();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return this.bytes;
    }

    public void setString(String utf8String) {
        this.bytes = null;
        this.string = utf8String;
    }

    public String getString() {
        try {
            this.switchToStringRepresentation();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return this.string;
    }

    @Override
    public int getTag() {
        return 1;
    }

    @Override
    public void accept(Clazz clazz, ConstantVisitor constantVisitor) {
        constantVisitor.visitUtf8Constant(clazz, this);
    }

    private void switchToByteArrayRepresentation() throws UnsupportedEncodingException {
        if (this.bytes == null) {
            this.bytes = this.getByteArrayRepresentation(this.string);
            this.string = null;
        }
    }

    private void switchToStringRepresentation() throws UnsupportedEncodingException {
        if (this.string == null) {
            this.string = this.getStringRepresentation(this.bytes);
            this.bytes = null;
        }
    }

    private byte[] getByteArrayRepresentation(String string) throws UnsupportedEncodingException {
        int byteLength = 0;
        int stringLength = string.length();
        for (int stringIndex = 0; stringIndex < stringLength; ++stringIndex) {
            char c = string.charAt(stringIndex);
            byteLength += c == '\u0000' ? 2 : (c < '\u0080' ? 1 : (c < '\u0800' ? 2 : 3));
        }
        byte[] bytes = new byte[byteLength];
        int byteIndex = 0;
        for (int stringIndex = 0; stringIndex < stringLength; ++stringIndex) {
            char c = string.charAt(stringIndex);
            if (c == '\u0000') {
                bytes[byteIndex++] = -64;
                bytes[byteIndex++] = -128;
                continue;
            }
            if (c < '\u0080') {
                bytes[byteIndex++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                bytes[byteIndex++] = (byte)(0xC0 | c >>> 6 & 0x1F);
                bytes[byteIndex++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            bytes[byteIndex++] = (byte)(0xE0 | c >>> 12 & 0xF);
            bytes[byteIndex++] = (byte)(0x80 | c >>> 6 & 0x3F);
            bytes[byteIndex++] = (byte)(0x80 | c & 0x3F);
        }
        return bytes;
    }

    private String getStringRepresentation(byte[] bytes) throws UnsupportedEncodingException {
        char[] chars = new char[bytes.length];
        int charIndex = 0;
        int byteIndex = 0;
        while (byteIndex < bytes.length) {
            int b = bytes[byteIndex++] & 0xFF;
            try {
                chars[charIndex++] = (char)(b < 192 ? b : (b < 224 ? (b & 0x1F) << 6 | bytes[byteIndex++] & 0x3F : (b & 0xF) << 12 | (bytes[byteIndex++] & 0x3F) << 6 | bytes[byteIndex++] & 0x3F));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new UnsupportedEncodingException("Missing UTF-8 bytes after initial byte [0x" + Integer.toHexString(b) + "] in string [" + new String(chars, 0, charIndex) + "]");
            }
        }
        return new String(chars, 0, charIndex);
    }
}

