
use strict ;
use warnings ;

use Module::Build;

my %all_modules ;
my @split_modules ;

my @pm_files = qw(
lib/App/Guiio.pm

lib/App/Guiio/Actions.pm
lib/App/Guiio/Ascii.pm
lib/App/Guiio/Connections.pm
lib/App/Guiio/Dialogs.pm
lib/App/Guiio/Elements.pm
lib/App/Guiio/Io.pm
lib/App/Guiio/Menues.pm
lib/App/Guiio/Setup.pm
lib/App/Guiio/Undo.pm
lib/App/Guiio/Options.pm

lib/App/Guiio/stripes/editable_arrow2.pm
lib/App/Guiio/stripes/editable_box2.pm
lib/App/Guiio/stripes/if_box.pm
lib/App/Guiio/stripes/process_box.pm
lib/App/Guiio/stripes/section_wirl_arrow.pm
lib/App/Guiio/stripes/single_stripe.pm
lib/App/Guiio/stripes/stripes.pm
lib/App/Guiio/stripes/wirl_arrow.pm
);

for(@pm_files)
	{
	$all_modules{$_} = $_ ;
	push @split_modules, $_ ;
	}


my @setup_lib=
qw(
setup/setup.ini

setup/actions/align.pl
setup/actions/clipboard.pl
setup/actions/debug.pl
setup/actions/elements_manipulation.pl
setup/actions/file.pl
setup/actions/mouse.pl
setup/actions/new_elements.pl
setup/actions/colors.pl
setup/actions/unsorted.pl
setup/actions/presentation.pl

setup/actions/context_menu_multi_wirl.pl
setup/actions/context_menu_box.pl
setup/actions/context_menu_rulers.pl

setup/guiio_object/basic.pl
setup/hooks/canonize_connections.pl

setup/import_export/ascii.pl
setup/import_export/guiioe.pl
setup/import_export/perl.pl
setup/import_export/png.pl

setup/stencils/guiio
setup/stencils/computer
setup/stencils/people
setup/stencils/divers
setup/stencils/guiio
) ;
my @images=
qw(
images/widget-gtk-button.png
images/widget-gtk-calendar.png
images/widget-gtk-checkbutton.png
images/widget-gtk-combo.png
images/widget-gtk-dialog.png
images/widget-gtk-entry.png
images/widget-gtk-hscale.png
images/widget-gtk-label.png
images/widget-gtk-list.png
images/widget-gtk-menubar.png
images/widget-gtk-progressbar.png
images/widget-gtk-radiobutton.png
images/widget-gtk-vscrollbar.png);

for(@images)
{
	$all_modules{$_} = "lib/App/Guiio/$_";
}

for(@setup_lib)
	{
	$all_modules{$_} = "lib/App/Guiio/$_" ;
	}

sub GetVersionAndRevisionFrom
{
my ($file) = @_ ;

my $version_from = File::Spec->catfile( split '/', $file );
my $version      = Module::Build->version_from_file($version_from);

if($ENV{'App_Guiio_USE_GIT_VERSION_FOR_DIST'})
	{
	my $number_of_commits = `git log | grep -E 'commit [0-9a-f]{40}' | wc -l` ;
	chomp $number_of_commits ;
	
	if($number_of_commits)
		{
		#print "number of git revision: $number_of_commits.\n" ;
		return("${version}.${number_of_commits}") ;
		}
	else
		{
		print "Couldn't get git revision, using version from '$file'!\n" ;
		return($version) ;
		}
	}
else
	{
	return($version) ;
	}
}

my $code = <<'EOC';
use strict ;
use warnings ;

sub GetVersionAndRevisionFrom
{
my ($file) = @_ ;

my $version_from = File::Spec->catfile( split '/', $file );
my $version      = Module::Build->version_from_file($version_from);

if($ENV{'App_Guiio_USE_GIT_VERSION_FOR_DIST'})
	{
	my $number_of_commits = `git log | grep -E 'commit [0-9a-f]{40}' | wc -l` ;
	chomp $number_of_commits ;
	
	if($number_of_commits)
		{
		#print "number of git revision: $number_of_commits.\n" ;
		return("${version}.${number_of_commits}") ;
		}
	else
		{
		print "Couldn't get git revision, using version from '$file'!\n" ;
		return($version) ;
		}
	}
else
	{
	return($version) ;
	}
}

sub ACTION_author_test
{
my $self = shift;
local $self->{properties}{test_files} = 'xt/author/*.t' ;
$self->SUPER::ACTION_test();
}

sub ACTION_build 
{
my $self = shift;

if($ENV{'App_Guiio_USE_GIT_VERSION_FOR_DIST'})
	{
	my ($version) = GetVersionAndRevisionFrom('lib/App/Guiio.pm') ;
	
	#~ print "Generating version module ($version)\n" ;
	
	open VERSION, '>', 'Version.pm' or die "can't generate Version module: $!\n" ;
	
	print VERSION <<EOV ;
	
	# version module automatically generated by the build system
	
	package Config::Version ;
	
	sub GetVersion {return '$version'} ;
	
	1 ;
	
	# end of generated version module
EOV
	
	close VERSION ;
	}
	
$self->SUPER::ACTION_build(@_);
}

sub ACTION_dist
{
my $self = shift;

if($ENV{'App_Guiio_USE_GIT_VERSION_FOR_DIST'})
	{
	my $have_git = $self->do_system('git --version');
	
	if($have_git)
		{
		print `git status -a`;
		
		if($self->do_system('git log  > git_Changes'))
			{
			use File::Copy;
			move('git_Changes', 'Changes') ;
			}
		else
			{
			print "Couldn't get git log, 'Changes' will not be generated from git log!\n" ;
			}
		}
	else
		{
		print "git not found, 'Changes' will not be generated from git log!\n" ;
		}
	}

$self->SUPER::ACTION_test() ;
#~ $self->ACTION_author_test() ;

$self->SUPER::ACTION_dist();
};


EOC

my $class = Module::Build->subclass(class => 'App::Guiio', code => $code) ;

my $build = $class->new
	(
	module_name => 'App::Guiio',
	
	dist_version => GetVersionAndRevisionFrom('lib/App/Guiio.pm'),
	
	license => 'perl',
	
	requires => 
		{
		'Readonly'         => 0,
		'Data::Compare'    => 0,
		'Sub::Exporter'     => 0,
		'Data::TreeDumper' => 0,
		'version'    => 0.50,
		
		'Compress::Bzip2' => 0,
		'Cwd' => 0,
		'Data::TreeDumper::Renderer::GTK' => 0,
		'Directory::Scratch' => 0,
		'Directory::Scratch::Structured' => 0,
		'Eval::Context' => 0,
		'File::Basename' => 0,
		'File::Spec' => 0,
		'Glib' => 0,
		'Gtk2' => 0,
		'Gtk2::Gdk::Keysyms' => 0,
		'List::MoreUtils' => 0,
		'List::Util' => 0,
		'MIME::Base64' => 0,
		'File::Copy' => 0,
		'File::Slurp' => 0,
		'Algorithm::Diff' => 0,
		'Clone' => 0,
		'Module::Util' =>0,
		
		'Test::Block' => 0,
		'Test::Exception' => 0,
		'Test::NoWarnings' => 0,
		'Test::Warn' => 0,
		'Test::Strict' => 0,
		},
		
	pm_files     => \%all_modules,
	#~ autosplit    => \@split_modules,
	
	script_files => 'script/guiio',
	dist_author  => 'James Simpson. <j2simpso at uwaterloo.ca>',
	dist_abstract => 'App::Guiio - ASCII UI Builder',
	);
	
$build->create_build_script;
  

