
BEGIN {
    if ($ENV{'PERL_CORE'}){
        chdir 't';
        @INC = '../lib';
    }
    require Config; import Config;
    if ($Config{'extensions'} !~ /\bEncode\b/) {
      print "1..0 # Skip: Encode was not built\n";
      exit 0;
    }
    if (ord("A") == 193) {
        print "1..0 # Skip: EBCDIC\n";
        exit 0;
    }
    unless (PerlIO::Layer->find('perlio')){
        print "1..0 # Skip: PerlIO required\n";
        exit 0;
    }
    if ($ENV{PERL_CORE_MINITEST}) {
        print "1..0 # Skip: no dynamic loading on miniperl, no Encode\n";
        exit 0;
    }
    $| = 1;
}

use strict;
use Test::More tests => 6;
use Encode;

use encoding 'johab';

ok(chr(0x7f) eq "\x7f");
ok(chr(0x80) eq "\x80");
ok(chr(0xff) eq "\xff");

for my $i (127, 128, 255) {
    ok(chr($i) eq pack('C', $i));
}

__END__
