/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Info;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import java.awt.Component;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import javax.swing.JLabel;

public class HelloPanel
extends IzPanel {
    private static final long serialVersionUID = 3257848774955905587L;

    public HelloPanel(InstallerFrame parent, InstallData idata) {
        this(parent, idata, new IzPanelLayout());
    }

    public HelloPanel(InstallerFrame parent, InstallData idata, LayoutManager2 layout) {
        super(parent, idata, layout);
        String str = parent.langpack.getString("HelloPanel.welcome1") + idata.info.getAppName() + " " + idata.info.getAppVersion() + parent.langpack.getString("HelloPanel.welcome2");
        JLabel welcomeLabel = LabelFactory.create(str, parent.icons.getImageIcon("host"), 10);
        this.add((Component)welcomeLabel, "nextLine");
        this.add(IzPanelLayout.createParagraphGap());
        ArrayList authors = idata.info.getAuthors();
        int size = authors.size();
        if (size > 0) {
            str = parent.langpack.getString("HelloPanel.authors");
            JLabel appAuthorsLabel = LabelFactory.create(str, parent.icons.getImageIcon("information"), 10);
            this.add((Component)appAuthorsLabel, "nextLine");
            for (int i = 0; i < size; ++i) {
                Info.Author a = (Info.Author)authors.get(i);
                String email = a.getEmail() != null && a.getEmail().length() > 0 ? " <" + a.getEmail() + ">" : "";
                JLabel label = LabelFactory.create(" - " + a.getName() + email, parent.icons.getImageIcon("empty"), 10);
                this.add((Component)label, "nextLine");
            }
            this.add(IzPanelLayout.createParagraphGap());
        }
        if (idata.info.getAppURL() != null) {
            str = parent.langpack.getString("HelloPanel.url") + idata.info.getAppURL();
            JLabel appURLLabel = LabelFactory.create(str, parent.icons.getImageIcon("bookmark"), 10);
            this.add((Component)appURLLabel, "nextLine");
        }
        this.getLayoutHelper().completeLayout();
    }

    public boolean isValidated() {
        return true;
    }
}

