 /* scan.l -- C4P Lexical Scanner Specification			-*- C -*-
    Time-stamp: "97/01/03 17:47:32 mik"

    Copyright (C) 1991, 92, 93, 94, 95, 96, 97
	Christian Schenk  <cschenk@berlin.snafu.de>

    This file is part of MiKTeX.

    MiKTeX is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, or (at your
    option) any later version.
   
    MiKTeX is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with MiKTeX; if not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

%{
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <io.h>

#include "common.h"
#include "gram.h"

extern YYSTYPE yylval;
long yylineno = 1;

static int last_tok;

static void comment (void);
static int string_or_char (void);
%}

D		[0-9]
L		[A-Za-z]
E		[Ee][+-]?{D}+

%%

{L}({L}|{D})*	{
		  symbol_t * s;

		  s = lookup (yytext);
		  if (s -> s_kind == PASCAL_KEYWORD ||
		      s -> s_kind == BUILD_IN_IDENTIFIER)
		    return (last_tok = (int) s -> s_type);

		  yylval.sym = s;
		  return (last_tok = IDENTIFIER);
		}

{D}+		{
		  sscanf (yytext, "%ld", &yylval.value);
		  return (last_tok = UNSIGNED_NUMBER);
		}

{D}+\.{D}+{E}	|
{D}+\.{D}+	|
{D}+{E}		{
	          sscanf (yytext, "%lf", &yylval.fvalue);
		  return (last_tok = REAL_CONSTANT);
		}

"<>"		{ return (last_tok = NEQ); }
"<="		{ return (last_tok = LEQ); }
">="		{ return (last_tok = GEQ); }
":="		{ return (last_tok = ASSIGN); }
".."		{ return (last_tok = DOTDOT); }

"(."		{ return (last_tok = '['); }
".)"		{ return (last_tok = ']'); }
"@"		{ return (last_tok = '^'); }

"{"		{ comment (); }

[ \t]+		{
		}

\n		{
		  yylineno++;
		}

'		{
		  return (last_tok = string_or_char ());
	        }

.		{ return (last_tok = *yytext); }

%%

static void comment (void)

{
   char c;

   while ((c = input()) != '}' && c != 0)
     if (c == '\n')
       yylineno++;
}

static char temp_buf[ 256 ];

static int string_or_char (void)

{
  unsigned len = 0;
  char c;
  char c1;

  while ((c = input()) != 0)
    {
      if (c == '\'')
	if ((c1 = input()) != '\'')
	  {
            if (c1 != 0)
	      unput (c1);
	    break;
	  }
      if (len >= sizeof(temp_buf))
	c4p_error ("internal error: string literal is too long");
      temp_buf[ len++ ] = c;
   }
   temp_buf[ len ] = 0;
   if (len == 1)
     {
       yylval.value = temp_buf[ 0 ];
       return (CHARACTER_CONSTANT);
     }
   else
     {
       yylval.value = (long) new_string (temp_buf);
       return (CHARACTER_STRING);
     }
}
