{$IFDEF WINDOWS}
{$N-,B-,V-,W-,G+}
{$ELSE}
{$N-,E-,B-,V-}
{$ENDIF}

Unit BibCache;

Interface

Uses
{$IFDEF WINDOWS}
  Wobjects, WinTypes, WinDos, wbibdisp, strings,
{$ELSE}
  DOS,Objects,bibdisp,
{$ENDIF}
  rc_strng, bibstrg, bibvars, bibstrm, bibutil, bibfile, lfnunit;

const
  MaxNumCacheCol = 10;
  MP_Size = 8192;
  CacheMagicStr: string[70] = 'BibDB cache file'; CacheVersion = 1;
  GFE_OK        = 0;
  GFE_NotOn     = 1;  GFE_WrongFile    = 2; GFE_WrongTime    = 3;
  GFE_WrongSize = 4;  GFE_WrongPattern = 5; GFE_ReadError    = 6;
  GFE_OutOfMem  = 7;  GFE_WrongVersion = 8; GFE_NotCacheFile = 9;
  GFE_NoFile    = 10;
type
  TCacheInfo = record
    Beg: longint;
    ENum,RNum: word;
    BibInd: byte;
  end;
  PCacheInfo = ^TCacheInfo;

  TCacheSaveRec = record
    Beg: longint;
    ENum,RNum: word;
  end;
  PCacheSaveRec = ^TCacheSaveRec;

  PCacheObj = ^TCacheObj;
  TCacheObj = object(TObject)
    ENum,RNum: word;
    Beg: longint;
    BibInd: integer;
    constructor init(Entry: EntryRecPtr);
    constructor ExpInit(E,R: word; I: byte; B: longint);
  end;

  PCacheCollection = ^TCacheCollection;
  TCacheCollection = object(TSortedCollection)
    function    compare(Key1,Key2: Pointer): integer; virtual;
  end;

  LinkedFilesRec = record
    Indexed,Reached,Saved: boolean;
    Nentries,Nreal: word;
    EOHeader: longint;
    IndName: string;
  end;

  PCache = ^TCache;
  TCache = object(TObject)
    MaxCacheColSize,CurrentCol,NumCols: integer;
    on,FullyIndexed,Overflow: boolean;
    Col: array[0..MaxNumCacheCol-1] of PCacheCollection;
    Last,LastSoFar: longint;
    LinkedFiles: array[1..MaxBibFiles] of LinkedFilesRec;
    constructor Init(MaxCache: longint);
    function    LookForCacheFile(bname: string;
                                 Pattern: PatRecPtr; CleanUp,ClearAll: boolean;
                                 Nentries,Nreal: Pword; EOHeader: PLongint): string;
    procedure   LoadCache(Pattern: PatRecPtr);
    procedure   SaveCache(Pattern: PatRecPtr);
    function    DoesItFit(S: PStream; Pattern: PatRecPtr;
                          bname: string): integer;
    procedure   PutInto(S: PStream; CurFile: integer; Pattern: PatRecPtr);
    function    UseCache(Pattern: PatRecPtr): boolean;
    procedure   Insert(Entry: EntryRecPtr; Pattern: PatRecPtr);
    procedure   Clear;
    function    Find(Ent: word; Pattern: PatRecPtr; UseReal: boolean;
                     Info: PCacheInfo): boolean;
    procedure   SetLast(ALast: longint; Pattern: PatRecPtr);
    destructor  Done; virtual;
  end;

var
  EntryCache: PCache;
  CacheDir: PString;
  AutoLoadCache,AutoSaveCache: boolean;

implementation

Uses bibsrtpt;

constructor TCacheObj.init(Entry: EntryRecPtr);
begin
  TObject.init;
  Beg:=Entry^.Beginning;
  ENum:=Entry^.EntryNum;
  RNum:=Entry^.RealNum;
  BibInd:=BibInRing;
end;

constructor TCacheObj.ExpInit(E,R: word; I: byte; B: longint);
begin
  TObject.init;
  Beg:=B; ENum:=E; RNum:=R; BibInd:=I;
end;

function TCacheCollection.Compare(Key1,Key2: Pointer): integer;
var
  l1,l2: longint;
begin
  l1:=PCacheObj(Key1)^.ENum; l2:=PCacheObj(Key2)^.ENum;
  if l1<l2 then Compare:=-1
  else if l1>l2 then Compare:=1
  else Compare:=0;
end;

{ ---------------------- }

constructor TCache.init(MaxCache: longint);
var
  i: integer;
begin
  TObject.init;
  for i:=0 to MaxNumCacheCol-1 do Col[i]:=Nil;
  MaxCacheColSize:=0;
  on:=false; CurrentCol:=0; NumCols:=0; Last:=-1;
  if (MaxCache=0) or (MaxAvail<MP_Size) then Exit;

  NumCols:=1;  { The minimal value }
  if MaxCollectionSize*NumCols<MaxCache then
      NumCols:=(MaxCache div MaxCollectionSize)+1;
  if NumCols>MaxNumCacheCol then NumCols:=MaxNumCacheCol;
  MaxCacheColSize:=(MaxCache div NumCols)+1;
  if MaxCacheColSize>MaxCollectionSize then MaxCacheColSize:=MaxCollectionSize;
  for i:=0 to NumCols-1 do New(Col[i],Init(0,100));
  on:=true;
  Clear;
end;                          { TCache.init }

function TCache.LookForCacheFile(bname: string; Pattern: PatRecPtr;
                                 Cleanup,ClearAll: boolean;
                                 Nentries,Nreal: Pword; EOHeader: PLongint): string;
var
  S: PBufStream;
  fname: string;
  status: integer;
  k: longint;
  ftmp: file;
{$IFDEF WINDOWS}
  fstr: array[0..255] of char;
{$ENDIF}
  Srec: TLFNSearchRec;
begin
  LookForCacheFile:='';
  S:=Nil;
  if Nentries<>Nil then Nentries^:=0;
  if Nreal<>Nil then Nreal^:=0;
  if EOHeader<>Nil then EOHeader^:=-1;
  if ContainsTags(Pattern) then Exit;
  if (CacheDir^='') or not IsDirName(CacheDir^) then Exit;
  if (bname<>'') and not LFNFileExist(bname) then Exit;

  LFNFindFirst(CacheDir^+'*.*',AnyFile and not (faDirectory or faVolumeID
               or faHidden or faSysFile),Srec);
  while (DosError=0) do
  begin
{$IFDEF WINDOWS}
    fname:=StrPas(Srec.Name);
{$ELSE}
    fname:=StrPas(PCharOf(SRec.Name));
{$ENDIF}
    if (fname<>'') and (fname<>'.') and (fname<>'..') then
    begin
      fname:=CacheDir^+fname;
{      message(fname);}
{$IFDEF WINDOWS}
      StrPCopy(fstr,LFNShortName(fname));
      New(S,Init(fstr,stOpenRead,WorkBufSize));
{$ELSE}     
      New(S,Init(LFNShortName(fname),stOpenRead,WorkBufSize));
{$ENDIF}
      if (S<>Nil) and (S^.Status=stOK) then
      begin
        Status:=DoesItFit(S,Pattern,bname);
{        message('Status = '+num2str(Status));}
        if (bname<>'') and (Status=GFE_OK) then
        begin
          k:=0;
          S^.read(k,sizeof(longint)); if Nentries<>Nil then Nentries^:=k;
          S^.read(k,sizeof(longint)); if Nreal<>Nil then Nreal^:=k;
          if S^.Status<>stOK then Status:=GFE_ReadError
          else if EOHeader<>Nil then EOHeader^:=S^.GetPos;
        end;
        if (bname<>'') and (Status=GFE_OK) then
        begin
          LookForCacheFile:=fname;
          Dispose(S,Done); S:=Nil;
          if not CleanUp then
          begin
            LFNFindClose(SRec); Exit;
          end;
        end else if (ClearAll and not (Status in [GFE_NoFile,GFE_NotCacheFile]))
          or ((not CLearAll) and
              (Status in [GFE_WrongVersion,GFE_WrongSize,GFE_WrongTime,
                      GFE_ReadError])) then
        begin
          if Status=GFE_ReadError then ErrorMessageRC(Str_CacheReadError,fname);
{          message('kill "'+fname+'"');}
          Dispose(S,Done); S:=Nil;
          LFNNew(ftmp,false); LFNAssign(ftmp,fname);
          LFNErase(ftmp); LFNDispose(ftmp);
        end;
      end;
      if S<>Nil then
      begin
        Dispose(S,Done); S:=Nil;
      end;
    end;
    LFNFindNext(Srec);
  end;
  LFNFindClose(SRec);
end;                          { TCache.LookForCacheFile }

function TCache.DoesItFit(S: PStream; Pattern: PatRecPtr;
                          bname: string): integer;
var
  k: longint;
  Patt: PatRecPtr;
  tmp: string;

procedure StrRead(S: PStream; var F: string);
begin
  F:=''; S^.read(F[0],1); if F[0]<>#0 then S^.read(F[1],ord(F[0]));
end;

procedure GetPatt(Patt: PatRecPtr);
var
  i: integer;
begin
  with Patt^ do
  begin
    S^.read(noper,sizeof(noper));
    S^.read(npatt,sizeof(npatt));
    S^.read(on,sizeof(on));
    S^.read(operation, sizeof(operation));
    S^.read(flag, sizeof(flag));
    for i:=1 to npatt do
    begin
      StrRead(S,field[i]); StrRead(S,Patrn[i]);
    end;
    for i:=npatt+1 to MaxPattCrit do
    begin
      field[i]:=''; Patrn[i]:='';
    end;
  end;
end;              { GetPatt }

begin
  { version }
  StrRead(S,tmp);
  if tmp<>CacheMagicStr then
  begin
    DoesItFit:=GFE_NotCacheFile; Exit;
  end;
  k:=0; S^.read(k,sizeof(longint));
  if k<>CacheVersion then               { wrong version }
  begin
    DoesItFit:=GFE_WrongVersion; Exit;
  end;
  { file info }
  StrRead(S,tmp); StrLwr(tmp);
  if bname='' then
  begin
    bname:=tmp; 
    if not LFNFileExist(bname) then             { File doesn't exist }
    begin
      DoesItFit:=GFE_NoFile; Exit;
    end;
  end else if tmp<>BName then                { wrong file }
  begin
    DoesItFit:=GFE_WrongFile; Exit;
  end;
  k:=-1; S^.read(k,sizeof(longint));
  if k<>GetFileTime(Bname) then   { wrong file date/time }
  begin
    DoesItFit:=GFE_WrongTime; Exit;
  end;
  k:=-1; S^.read(k,sizeof(longint));
  if k<>FileSize(bname) then     { wrong size }
  begin
    DoesItFit:=GFE_WrongSize; Exit;
  end;
  { Pattern }
  if Pattern<>Nil then
  begin
    New(Patt);
    GetPatt(Patt);
    if (not Patt^.on) or (Patt^.noper=0)
      or ContainsTags(Patt) or ContainsTags(Pattern)
      or DifferentPatt(Patt,Pattern) then
    begin
      DoesItFit:=GFE_WrongPattern;
      Dispose(Patt); Exit;                  { wrong pattern }
    end;
    Dispose(Patt);
  end;
  if S^.Status=stOK then DoesItFit:=GFE_OK
  else DoesItFit:=GFE_ReadError;
end;                           { TCache.DoesItFit }

procedure TCache.LoadCache(Pattern: PatRecPtr);
var
  i: integer;

procedure CacheFileStatus(fname: string; var IndName: string;
                          var Indexed: boolean; var Nentries,Nreal: word;
                          var EOheader: longint);
var
  ftmp: text;
begin
  Indexed:=false; IndName:=''; Nentries:=0; EOheader:=-1;
  if not ActivePattern(Pattern) then   {Index files }
  begin
    LFNNew(ftmp,true); LFNAssign(ftmp,fname);
    IndexFileStatus(ftmp,@fname,IndName,Nil,Nil,false,Indexed,
                          Nentries,EOHeader);
    LFNDispose(ftmp);
    if Indexed then Nreal:=Nentries;
  end else        { Cache files }
  begin
    IndName:=LookForCacheFile(fname,Pattern,false,false,@Nentries,@Nreal,@EOheader);
    if IndName<>'' then Indexed:=true;
  end;
end;                          { TCache.CacheFileStatus }

procedure LoadFromIndexFile;
var
  quit: boolean;
  i: integer;
  l: longint;
begin
  if ActivePattern(Pattern) and not AutoLoadCache then Exit;
  if not ActivePattern(Pattern) and not UseIndexFile then Exit;
  FullyIndexed:=true;
  for i:=1 to BibRingNum do
  begin
    with LinkedFiles[i] do
    begin
      CacheFileStatus(BibFiles^[BibRing[i]].name,IndName,Indexed,Nentries,Nreal,
                      EOheader);
      if not Indexed then FullyIndexed:=false;
      {
      if Indexed then message(BibFiles^[BibRing[i]].name+' indexed')
      else message(BibFiles^[BibRing[i]].name+' not indexed');
      }
    end;
  end;
  i:=1;
  while (i<=BibRingNum) and LinkedFiles[i].indexed do
  begin
    if i<BibRingNum then
    begin
      BibFiles^[BibRing[i+1]].EntryStart:=BibFiles^[BibRing[i]].EntryStart
                                          +LinkedFiles[i].Nentries;
      BibFiles^[BibRing[i+1]].RealStart :=BibFiles^[BibRing[i]].RealStart
                                          +LinkedFiles[i].Nreal;
    end else
    begin
      Last:=BibFiles^[BibRing[i]].EntryStart+LinkedFiles[i].Nentries;
      LastRealNum:=BibFiles^[BibRing[i]].RealStart+LinkedFiles[i].Nreal;
{      message('Last is '+num2str(Last)+','+num2str(LastRealNum));}
    end;
    LinkedFiles[i].Reached:=true;
{    message(num2str(i)+', '+num2str(BibFiles^[BibRing[i]].EntryStart)
      +', '+num2str(BibFiles^[BibRing[i]].EntryStart+LinkedFiles[i].Nentries));}
    inc(i);
  end;
end;                       { LoadFromIndexFile }

begin                      { TCache.LoadCache }
  Clear;
  for i:=1 to MaxBibFiles do with BibFiles^[i] do
  begin
    EntryStart:=0; RealStart:=0;
  end;
  {
  message('a');
  if  AutoLoadCache then message('a1');
  if  UseCache(Pattern) then message('a2');
  if (not on) then message('a3');
  if not BibFileExists then message('a4')
  else if not ActivePattern(Pattern) then
  begin
    if (MaxCacheColSize=0) and (not FullyIndexed) then message('a5');
  end else if (MaxCacheColSize=0) then message('a6');
  }
  if not (AutoLoadCache and UseCache(Pattern)) then Exit;
  LoadFromIndexFile;
  {
  if not ActivePattern(Pattern) then Exit;
  if not ((CacheDir^<>'') and IsDirName(CacheDir^)) then Exit;
  }
end;                          { TCache.LoadCache }

procedure TCache.SaveCache(Pattern: PatRecPtr);
var
  S: PSafeBufStream;
  fname: string;
  o_k: boolean;
  ftmp: file;
  CurFile: integer;
begin
  if EditOnlyStrings then Exit;
  if not (BibFileExists and ActivePattern(Pattern) and UseCache(Pattern) and
         (CacheDir^<>'') and IsDirName(CacheDir^)) then Exit;
  if (Last<>0) and not ((CurrentCol>0) or (Col[0]^.Count>0)) then Exit; { empty }

  if Last=-1 then
  begin
    ErrorMessageRC(Str_CacheNotComplete,''); Exit;
  end;
  o_k:=LFNFileExist(CacheDir^+'.');
  if o_k and (LookForCacheFile(bibname^,Pattern,false,false,Nil,Nil,Nil)<>'') then Exit;
  if not o_k then
  begin
    {$I-}
    fname:=CacheDir^; if fname[length(fname)]='\' then dec(fname[0]);
    MkDir(fname); o_k:=(IoResult=0);
    {$I+}
    if not o_k then
    begin
      ErrorMessageRC(Str_CantMdCacheDir,fname);
      AutoLoadCache:=false; Exit;
    end;
  end;

  CurFile:=1;
  while (CurFile<=BibRingNum) do
  begin
    if (not (LinkedFiles[CurFile].Indexed or LinkedFiles[CurFile].Saved)) and
       (LookForCacheFile(bibfiles^[BibRing[CurFile]].name,Pattern,
             false,false,Nil,Nil,Nil)='') then { does not yet exist }
    begin
      fname:='';
      Unique(CacheDir^,fname); if fname='' then Exit;         { Can't create }
      CanonicalFname(fname);
      New(S,Init(fname,stCreate,WorkBufSize));
      PutInto(S,CurFile,Pattern);
      o_k:=(S^.status=stOK);
      Dispose(S,Done);
      if not o_k then
      begin
        ErrorMessageRC(Str_CacheWriteError,fname);
        LFNNew(ftmp,false); LFNAssign(ftmp,fname);
        LFNErase(ftmp); LFNDispose(ftmp);
      end;
    end;
    inc(CurFile);
  end;
end;                       { TCache.SaveCache }

procedure TCache.PutInto(S: PStream; CurFile: integer; Pattern: PatRecPtr);
var
  i,j: integer;
  tmp: string;
  T: TCacheSaveRec;
  bname: string;
  k1,k2: longint;

procedure SavePattt(Patt: PatRecPtr);
var
  i: integer;
begin
  with Patt^ do
  begin
    S^.write(noper,sizeof(noper));
    S^.write(npatt,sizeof(npatt));
    S^.write(on,sizeof(on));
    S^.write(operation, sizeof(operation));
    S^.write(flag, sizeof(flag));
    for i:=1 to npatt do
    begin
      S^.write(Field[i],length(Field[i])+1);
      S^.write(Patrn[i],length(Patrn[i])+1);
    end;
  end;
end;

begin
  if LinkedFiles[CurFile].Saved or LinkedFiles[CurFile].Indexed then Exit;
  if not (BibFileExists and ActivePattern(Pattern) and UseCache(Pattern)) then Exit;
  bname:=BibFiles^[BibRing[CurFile]].name;
  { magic number and version }
  tmp:=CacheMagicStr; S^.write(tmp,length(tmp)+1);
  k1:=CacheVersion;   S^.write(k1,sizeof(longint));
  { file info }
  S^.write(bname,length(bname)+1);
  k1:=GetFileTime(Bname); S^.write(k1,sizeof(longint));
  k1:=FileSize(bname);    S^.write(k1,sizeof(longint));
  { pattern }
  SavePattt(Pattern);
  { Cache data }
  if Linked then
  begin
    if CurFile=BibRingNum then
    begin
      k1:=Last-BibFiles^[BibRing[CurFile]].EntryStart;
      k2:=LastRealNum-BibFiles^[BibRing[CurFile]].RealStart;
    end else
    begin
      k1:=BibFiles^[BibRing[CurFile+1]].EntryStart
          -BibFiles^[BibRing[CurFile]].EntryStart;
      k2:=BibFiles^[BibRing[CurFile+1]].RealStart
          -BibFiles^[BibRing[CurFile]].RealStart;
    end;
    if (k1<=0) or (k2<=0) then
    begin
      k1:=0; k2:=0;
    end;
  end else
  begin
    k1:=Last; K2:=LastRealNum;
  end;
  S^.write(k1,sizeof(longint));
  S^.write(k2,sizeof(longint));

  if Last>0 then
  for i:=0 to NumCols-1 do
    for j:=0 to Col[i]^.Count-1 do
      with PCacheObj(Col[i]^.at(j))^ do
      if (not Linked) or (BibInd=CurFile) then
      begin
        T.Beg:=Beg; T.ENum:=ENum; T.RNum:=RNum;
        if Linked then
        begin
          T.RNum:=T.RNum-BibFiles^[BibRing[CurFile]].RealStart;
          T.ENum:=T.ENum-BibFiles^[BibRing[CurFile]].EntryStart;
        end;
        S^.Write(T,sizeof(T));
      end;
  LinkedFiles[CurFile].Saved:=true;
end;                     { TCache.PutInto }

function TCache.UseCache(Pattern: PatRecPtr): boolean;
begin
  UseCache:=false;
  if (not on) or EditOnlyStrings or not BibFileExists then Exit;
  if not ActivePattern(Pattern) then
  begin
    if (MaxCacheColSize=0) and (not FullyIndexed) then Exit;
  end else if (MaxCacheColSize=0) then Exit;
  UseCache:=true;
end;                 { TCache.UseCache }

procedure TCache.Insert(Entry: EntryRecPtr; Pattern: PatRecPtr);
var
  C: PCacheObj;
  i: integer;
begin
  if (Entry=Nil) or (Entry^.EntryNum=0) or not UseCache(Pattern) then Exit;
  if LinkedFiles[BibInRing].Indexed then
  begin    { Using index or cache file, no need to store }
    if not LinkedFiles[BibInRing].Reached then
    begin
      if BibInRing<BibRingNum then
      begin
        BibFiles^[BibRing[BibInRing+1]].EntryStart:=BibFiles^[BibRing[BibInRing]].EntryStart
                                           +LinkedFiles[BibInRing].Nentries;
        BibFiles^[BibRing[BibInRing+1]].RealStart:=BibFiles^[BibRing[BibInRing]].RealStart
                                           +LinkedFiles[BibInRing].Nreal;
      end else
      begin
        Last:=BibFiles^[BibRing[BibInRing]].EntryStart+LinkedFiles[BibInRing].Nentries;
        LastRealNum:=BibFiles^[BibRing[BibInRing]].RealStart+LinkedFiles[BibInRing].Nreal;
      end;
      LinkedFiles[BibInRing].Reached:=true;
    end;
    Exit;
  end;
  if (MaxAvail<MP_Size) or Overflow then Exit;
  if (Col[CurrentCol]^.Count>=MaxCacheColSize) then
  begin
    inc(CurrentCol);
    if CurrentCol>=NumCols then
    begin
      CurrentCol:=0; Overflow:=true; Exit;
    end;
  end;
  if Entry^.EntryNum>LastSoFar then
{  if not find(Entry^.EntryNum,Pattern,false,Nil) then}
  begin
    Col[CurrentCol]^.Insert(New(PCacheObj,init(Entry)));
    LastSoFar:=Entry^.EntryNum;
{    message('Adding '+num2str(Entry^.EntryNum)+','+num2str(Entry^.RealNum));}
  end;
end;                            { TCache.Insert }

procedure TCache.Clear;
var
  i: integer;
begin
  for i:=0 to NumCols-1 do Col[i]^.FreeAll;
  CurrentCol:=0; Overflow:=false;
  Last:=-1; LastSoFar:=-1;
  for i:=1 to MaxBibFiles do
  begin
    LinkedFiles[i].Indexed:=false; LinkedFiles[i].Reached:=false;
    LinkedFiles[i].EOHeader:=-1;   LinkedFiles[i].NEntries:=0;
    LinkedFiles[i].IndName:='';    LinkedFiles[i].Saved:=false;
    LinkedFiles[i].NReal:=0;
  end;
  FullyIndexed:=false;
end;                       { TCache.Clear }

function TCache.Find(Ent: word; Pattern: PatRecPtr; UseReal: boolean;
                     Info: PCacheInfo): boolean;
var
  j,ans: integer;
  I: longint;
  C: TCacheObj;

function GetRecord(fl: integer): boolean;
var
  IndexFile: PSafeBufStream;
  SRec: SortRecPtr;
  T: TCacheSaveRec;
  i: longint;
begin
  GetRecord:=false;
  if Info=Nil then
  begin
    GetRecord:=true; Exit;
  end;
  if not LinkedFiles[fl].Indexed then Exit;
  New(IndexFile,Init(LinkedFiles[fl].IndName,stOpenRead,WorkBufSize));
  if IndexFile=Nil then
  begin
    ErrorMessageRC(Str_RWIndexError,''); Exit;
  end;
  if ActivePattern(Pattern) then   { Cache file }
  begin
    IndexFile^.seek(LinkedFiles[fl].EOHeader
                    +(Ent-Bibfiles^[BibRing[fl]].EntryStart-1)*sizeof(TCacheSaveRec));
    IndexFile^.Read(T,sizeof(TCacheSaveRec));
    if IndexFile^.status=stOK then
    begin
      Info^.ENum:=Bibfiles^[BibRing[fl]].EntryStart+T.ENum;
      Info^.RNum:=Bibfiles^[BibRing[fl]].RealStart+T.RNum;
      Info^.Beg:=T.Beg;
      Info^.BibInd:=fl;
      GetRecord:=true;
{      message(num2str(Info^.ENum)+','+num2str(Info^.RNum)+' found in Cache file.');}
    end else LinkedFiles[fl].Indexed:=false;
  end else   { Index file }
  begin
    IndexFile^.seek(LinkedFiles[fl].EOHeader);
    New(SRec);
    for i:=BibFiles^[BibRing[fl]].EntryStart+1 to Ent do
            ReadSortRec(IndexFile,Srec^);
    if IndexFile^.status<>stOK then
    begin
      ErrorMessageRC(Str_RWIndexError,'');
      Dispose(IndexFile,Done); IndexFile:=Nil;
      Dispose(Srec); Srec:=Nil;
      Exit;
    end;
    Info^.ENum:=Ent; Info^.RNum:=Ent;
    Info^.Beg:=SRec^.place;
    Info^.BibInd:=fl;
    Dispose(Srec); Srec:=Nil;
    GetRecord:=true;
{    message(num2str(Info^.ENum)+','+num2str(Info^.RNum)+' found in index file.');}
  end;
  Dispose(IndexFile,Done); IndexFile:=Nil;
end;                 { GetRecord }

begin                { TCache.Find }
  if Info<>Nil then with Info^ do
  begin
    Beg:=-1; ENum:=0; RNum:=0; BibInd:=0;
  end;
  Find:=false;
  if not UseCache(Pattern) then Exit;
  if Last=0 then Exit;
{  message('looking for '+num2str(Ent));}

  i:=1; j:=0;
  while (i<=BibRingNum) and (j=0) do
  with LinkedFiles[i] do
  begin
{    message(num2str(i)+', '+num2str(BibFiles^[BibRing[i]].EntryStart)
      +', '+num2str(BibFiles^[BibRing[i]].EntryStart+Nentries));     }
    if Reached and Indexed and (Ent>BibFiles^[BibRing[i]].EntryStart) and
       (Ent<=BibFiles^[BibRing[i]].EntryStart+Nentries) then j:=i;
{    if j=0 then message(num2str(i)+': no') else message(num2str(i)+': yes');}
    inc(i);
  end;
  if (j>0) and GetRecord(j) then   { found it in an index or cache file }
  begin
    find:=true; Exit;
  end;

  { not found, look in the memory cache }
  if Ent>LastSoFar then Exit;

  ans:=-1; i:=0;
  C.ExpInit(Ent,0,0,0);
  while (ans=-1) and (i<NumCols) do
  begin
    if Col[i]^.Count>0 then
    begin
      if UseReal then
      begin
        j:=0;
        while (j<Col[i]^.Count) and (ans=-1) do
        begin
          if PCacheObj(Col[i]^.at(j))^.RNum=Ent then ans:=j;
          inc(j);
        end;
      end else ans:=Col[i]^.IndexOf(@C);
    end;
    if ans=-1 then inc(i);
  end;
  C.Done;
  if ans<>-1 then
  begin
    if Info<>Nil then
    begin
      Info^.Beg   :=PCacheObj(Col[i]^.at(ans))^.Beg;
      Info^.ENum  :=PCacheObj(Col[i]^.at(ans))^.ENum;
      Info^.RNum  :=PCacheObj(Col[i]^.at(ans))^.RNum;
      Info^.BibInd:=PCacheObj(Col[i]^.at(ans))^.BibInd;
    end;
    Find:=true;
  end;
end;                           { TCache.Find }

procedure TCache.SetLast(ALast: longint; Pattern: PatRecPtr);
begin
  if UseCache(Pattern) and (Last=-1) and (ALast<>Last) and not Overflow then
  begin
    Last:=ALast;
    if AutoSaveCache then SaveCache(Pattern);
  end;
end;

destructor TCache.Done;
var
  i: integer;
begin
  for i:=0 to NumCols-1 do Dispose(Col[i],Done);
  TObject.Done;
end;

procedure InitCacheUnit;
begin
  EntryCache:=Nil;
  New(CacheDir);
  CacheDir^:='';
  AutoLoadCache:=false;
  AutoSaveCache:=false;
end;

begin
  InitCacheUnit;
end.
