{$IFDEF WINDOWS}
{$N-,V-,W-,G+,S+}
{$ELSE}
{$N-,E-,V-,O+,F+}
{$ENDIF}

Unit bibSrtPt;

Interface

uses
{$IFDEF WINDOWS}
  wobjects, WinDos, wbibdisp, wbibgui, wbibslct, winprocs,
{$ELSE}
  Dos, bibwindo, bibsedit, bibselct, bibCrt, bibdisp, objects,
{$ENDIF} 
  bibstrg, bibtext, bibvars, bibfile, bib8bit, bibutil, bibwild,
  bibPchec, rc_strng, bibstrm, bibtmplt, bibputbk, lfnunit;

Const
  IndexFileString='BibDB Index File, ver. 1';  { First line of index files   }
  EndIndexStr='<End of Index File>';           { Last line of index files    }
  UnFinishedTime=$FFFFFFFF;                    { "Time" for incomplete files }
  LengthOfEOL=2;                               { CR+LF for MsDOS             }

function  DifferentPatt(p1,p2: PatRecPtr): boolean;
procedure SortPattField(var field: string);
procedure GetPattCase(Pattern: PatRecPtr; Ind: integer; var CaseSen,RegExp: boolean);
procedure CleanupPattern(Pattern: PatRecPtr);
procedure OutputPattern(Pattern: PatRecPtr; width: integer;
                        ToScreen: boolean; x0,y0,height: integer;
                        Scroll: longint; var MaxLine: LongInt;
                        f: PStream; pre,post: string; Unix,MultiLine: boolean);
procedure InputPattern(var f: text; P: PStream; Pattern: PatRecPtr; line: string;
                       ReadMore: boolean; ErrorMsg: boolean);
procedure PatternLoad(Pattern: PatRecPtr; fname: string;
                      HasToExist: boolean; var ok: boolean);
procedure PatternSave(Pattern: PatRecPtr);
procedure GetSortPattern(var M: ConfigSortType; P: PatRecPtr;
                         var exists: boolean);
procedure SortWorkOut(var M: ConfigSortType; SortPattern: PatRecPtr);
procedure LoadSortMode(var cfg: text; P: PStream; var M: ConfigSortType;
                       Pattern: PatRecPtr);
procedure SaveSortMode(var fname: string;
                       var Smode: ConfigSortType; Pattern: PatRecPtr);
procedure WriteSortMode(F: PStream; var Smode: ConfigSortType;
                        Npatt: PatRecPtr; IgnoreMode,Unix: Boolean);
function  EquivSortModes(var M,SavedMode: ConfigSortType;
                        SortPattern,SavedPatt: PatRecPtr): boolean;
procedure IndexFileStatus(var bib: text; bibname: Pstring; var IndName: string;
                          M: ConfigSortPtr; SortPattern: PatRecPtr;
                          CheckSortMode: boolean; var current: boolean;
                          var Nentries: word; var EndOfHeader: longint);
procedure CheckForIndexFile(var bib: text; bibname: PString);
procedure NewDump(GetNew: Boolean; bibfile: string);
procedure NewBib(Var Bibfile: string; GetNew,MustExist,AllowAbort: Boolean;
                 Var IsRO: Boolean);

Implementation


function DifferentPatt(p1,p2: PatRecPtr): boolean;
label
  Finish;
var
  i,j,stat : integer;
  flag1,flag2: byte;
  dif : boolean;
begin
  stat:=0;
  if (p1=Nil) and (p2=Nil) then
  begin
    DifferentPatt:=false; Goto finish;
  end;
  stat:=1;
  if (p1=Nil) or (p2=Nil) then
  begin
    DifferentPatt:=true; goto finish;
  end;
  stat:=2;
  dif:=(p1^.on<>p2^.on);
  if dif then goto finish;
  stat:=3;
  dif:=(dif) or (p1^.noper<>p2^.noper) or (p1^.npatt<>p2^.npatt);
  if dif then goto finish;
  stat:=4;
  i:=0;
  while (i<p1^.noper) and (not dif) do
  begin
    inc(i);
    dif:=dif or (p1^.operation[i]<>p2^.operation[i]);
    flag1:=p1^.flag[i]; flag2:=p2^.flag[i];
    if p1^.operation[i]<0 then    { logical operation, case irrelevant }
    begin
      flag1:=flag1 and PattFlag_NOT; flag2:=flag2 and PattFlag_NOT;
    end;
    dif:=dif or (flag1<>flag2);
  end;
  if dif then goto finish;
  stat:=5;
  i:=0;
  while (i<p1^.npatt) and (not dif) do
  begin
    inc(i);
    dif:=(dif) or (p1^.patrn[i]<>p2^.patrn[i]) or (p1^.field[i]<>p2^.field[i]);
  end;
  if dif then goto finish;
  stat:=6;
Finish: ;
  DifferentPatt:=dif;
end;                                  { DifferentPatt }

{ Pattern field sorting routines }

Procedure Split(Var Info: string; First: Integer; Last: Integer; Var
                SplitPt1: Integer; Var SplitPt2: Integer);
Var
  SplitVal, Temp: char;
begin
  SplitVal:=Info[(First+Last) div 2];
  Repeat
    While Info[First] < SplitVal do
      First:=First+1;
    While Info[Last] > SplitVal do
      Last:=Last-1;
    if First <= Last then
      begin
        Temp:=Info[First];
        Info[First]:=Info[Last];
        Info[Last]:=Temp;
        First:=First+1;
        Last:=Last-1;
      end
  Until First > Last;
  SplitPt1:=First;
  SplitPt2:=Last;
end;                            { Split }

Procedure QuickSort(Var Info: string;  First,Last: Integer);
Var
  SplitPt1, SplitPt2: Integer;
begin
  if First < Last then
    begin
      Split(Info, First, Last, SplitPt1, SplitPt2);
      if SplitPt1 < Last
        then QuickSort(Info, SplitPt1, Last);
      if First < SplitPt2
        then QuickSort(Info, First, SplitPt2);
    end
end;                            { QuickSort }

procedure SortPattField(var field: string);
begin
  if length(field)>1 then QuickSort(field,1,length(field));
end;

procedure GetPattCase(Pattern: PatRecPtr; Ind: integer; var CaseSen,RegExp: boolean);
var
  i: integer;
begin
  RegExp:=false; CaseSen:=false;
  with Pattern^ do
  if noper>0 then
  begin
    if Ind>noper then Ind:=noper;
    if Ind=-1 then Ind:=noper;
    while (Ind>0) do
      if (operation[Ind]>0) and (field[operation[Ind]]<>PattField_Tagged) and
         (field[operation[Ind]]<>PattField_Type) then
      begin
        CaseSen:=(flag[Ind] and PattFlag_CaseSen)<>0;
        RegExp:= (flag[Ind] and PattFlag_Regexp) <>0;
        Ind:=0;
      end else dec(Ind);
  end;
end;                               { GetPattCase }

procedure CleanupPattern(Pattern: PatRecPtr);
var
  i,depth: integer;
begin
  if Pattern=Nil then Exit;
  with Pattern^ do
  if noper=0 then
  begin
    npatt:=0; on:=false;
  end else if operation[1]<0 then
  begin
    noper:=0; npatt:=0; on:=false;
  end else
  begin
    depth:=1; npatt:=1;
    i:=1;
    while (i<noper) do
    begin
      inc(i);
      if operation[i]>0 then
      begin
        inc(depth); if npatt<operation[i] then npatt:=operation[i];
      end else
      begin
        dec(depth); if depth<1 then noper:=i-1;
      end;
    end;
  end;
end;                           { CleanupPattern }

procedure OutputPattern(Pattern: PatRecPtr; width: integer;
                        ToScreen: boolean; x0,y0,height: integer;
                        Scroll: LongInt; var MaxLine: LongInt;
                        f: PStream; pre,post: string; Unix,MultiLine: boolean);
var
  line,tmp: string;
  indent: string[10];
  i,j,ty,strt,indlen,dep: integer;
  plus: string[4];
  CaseSen,RegExp,NewCase,NewReg: boolean;

{$IFDEF WINDOWS}
procedure DispLine;
begin
end;
{$ELSE}
procedure DispLine;
var
  mw: integer;
  tmp: string;
begin
  if line='' then Exit;
  mw:=width-length(indent);
  if ty-scroll<=Height+1 then
  begin
    TpwPrint(ty-scroll,x0,indent,PatternNorm);
    Tpwprint(ty-scroll,x0+length(indent),line,PatternNorm);
    if length(line)<mw then
      Tpwfill(ty-scroll,x0+length(indent)+length(line),1,
      mw-length(line),' ',PatternNorm);
  end;
  inc(ty);
end;
{$ENDIF}

procedure swrite(s: string);
Var
  mw: integer;
  i: byte;
  first: boolean;
  tmp: string;
begin
  if s='' then exit;
  ChrDelL(line,' ');
  if (line<>'') and (line[length(line)]=' ') then ChrDelL(s,' ');
  i:=1; while (i<length(s)) do
  if (s[i]=' ') and (s[i+1]=' ') then delete(s,i,1)
  else inc(i);
  if s='' then exit;
  mw:=width-length(indent);
  i:=1; first:=true;
  if line='' then ChrDelL(s,' ');
  repeat
    if first and (s[1]=' ') and (line<>'') and (line[length(line)]<>' ') then
    begin
      tmp:=' '; 
    end else WrdToken(tmp,s,' ',i);
    if (not first) and (length(tmp)<=255) and (tmp<>'') and (tmp[1]<>' ')
       and (line<>'') and (line[length(line)]<>' ') then
    begin
      tmp:=' '+tmp;
    end;
    if line='' then ChrDelL(tmp,' ');
    first:=false;
    if length(line)+length(tmp)<=mw then line:=line+tmp
    else begin
      if ToScreen then
      begin
        repeat
          DispLine;
          if length(tmp)<=mw then line:=tmp else line:=Copy(tmp,1,mw);
          Delete(tmp,1,length(line));
        until tmp='';
      end else
      begin
        repeat
          if MultiLine then
          begin
            StreamWrite(f,indent); StreamWriteln(f,line,Unix);
          end else
          begin
            StreamWrite(f,line); StreamWrite(f,' ');
          end;
          if length(tmp)<=255-length(line)-length(indent) then line:=tmp
            else line:=Copy(tmp,1,255-length(line)-length(indent));
          Delete(tmp,1,length(line));
        until tmp='';
      end;
    end;
  until i=0;
end;

procedure cr;
begin
  if ToScreen then DispLine
  else if MultiLine then
  begin
    StreamWrite(f,indent); StreamWriteln(f,line,Unix);
  end else
  begin
    StreamWrite(f,line); StreamWrite(f,' ');
  end;
  line:='';
end;

begin    { OutputPattern }
  if Pattern=Nil then Exit;
  CleanupPattern(Pattern);
  line:='';  indent:=''; dep:=0; ty:=0;
  CaseSen:=false; RegExp:=false;
  if ToScreen then
  begin
    ty:=y0; indlen:=0;
  end else
  begin
    indent:=pre; indlen:=length(pre);
  end;
  with pattern^ do
  begin
    for i:=1 to noper do
    begin
      if operation[i]>0 then inc(dep)
      else if (operation[i]=Patt_AND) or (operation[i]=Patt_OR) then dec(dep);
      if i>1 then
      begin
        indent:=''; j:=imax(0,indlen+(dep-1)*2);
        if j>40 then j:=40;
        FillChar(indent[1],j,' '); indent[0]:=chr(j);
      end;
      line:=''; plus:=' ';
      if operation[i]>0 then
      begin
        if field[operation[i]]=PattField_Tagged then     { Tagged entries }
          swrite(PattStr_Tagged+' ')
        else if field[operation[i]]=PattField_Type then         { Type }
        begin
          swrite(Plus+PattStr_Type); swrite(':'); swrite(' "');
          tmp:=patrn[operation[i]];
          plus:='';
          for j:=1 to length(tmp) do
          begin
            if Ord(tmp[j])<=StringTypeInd then
            begin
              swrite(plus+TypeEntry^[Ord(tmp[j])]);
              plus:=' or ';
            end;
          end;
          swrite('" ');
        end else                                                    { Fields }
        begin
          { Case and regexp } 
          NewCase:=(flag[i] and PattFlag_CaseSen)<>0;
          NewReg :=(flag[i] and PattFlag_Regexp) <>0;
          if (NewCase<>CaseSen) and (NewReg<>RegExp) then
              swrite(PattCaseStrings[NewCase]+'; '+PattRegStrings[NewReg])
          else if NewCase<>CaseSen then swrite(PattCaseStrings[NewCase])
          else if NewReg<>RegExp then swrite(PattRegStrings[NewReg]);
          if (NewCase<>CaseSen) or (NewReg<>RegExp) then CR;
          CaseSen:=NewCase; Regexp:=NewReg;
          { List of fields }
          if length(field[operation[i]])>OrigFieldLast+1 then  {!!!!!!}
              swrite(PattStr_All)
          else for j:=1 to length(field[operation[i]]) do
          begin
            if field[operation[i],j]=PattField_Name then        { Name }
                swrite(Plus+PattStr_Name)
            else if field[operation[i],j]=PattField_Undec then  { Undeclared }
                swrite(Plus+PattStr_Undec)
            else if (ord(field[operation[i],j])<=OrigFieldLast) or
                    (ord(field[operation[i],j])=StringIndex) then
                 swrite(plus+TypeField^[ord(field[operation[i],j])]);
            plus:='+';
          end;
          swrite(':'); swrite(' "');
          { search string }
          swrite(patrn[operation[i]]); swrite('" ');
        end;
      end else if operation[i]=Patt_OR     then swrite(' +')
      else if operation[i]=Patt_AND        then swrite(' *');
      if (i=noper) and (post<>'') then swrite(post);
      CR;
      if (flag[i] and PattFlag_NOT)<>0 then
      begin
        swrite(' ^'); CR;
      end;
    end;
  end;
{$IFNDEF WINDOWS}
  if ToScreen then
  begin
    strt:=ty-y0-scroll;
    if strt<0 then strt:=0;
    if (strt<height) then Tpwfill(y0+strt,x0,height-strt,width,' ',PatternNorm);
    MaxLine:=ty;
    tmp:='';
    if CaseSen     then tmp:=tmp+'[case on]'+#205#205
    else                tmp:=tmp+'[case off]'+#205;
    if RegExp      then tmp:=tmp+'[regexp on]'+#205
    else                tmp:=tmp+'[regexp off]';
    TitleWindow(6,PatternBorder,tmp)
  end;
{$ENDIF}
end;                     { OutputPattern }

procedure InputPattern(var f: text; P: PStream; Pattern: PatRecPtr; line: string;
                       ReadMore: boolean; ErrorMsg: boolean);

                      { Read a text-based pattern from a file }
var
  finish,FinishString,FinishKeys,minus,ok,CaseSen,RegExp,FromStream: boolean;
  i,j,k: byte;
  Index,depth: integer;
  tmp,tmp1: string;
  delim: char;
  nbr: integer;
  StreamEof: boolean;

function feof(var f: text): boolean;
begin
  if FromStream then
  begin
    StreamEOF:=StreamEOF or (P^.Status<>stOK) or (P^.GetPos>=P^.GetSize);
    feof:=StreamEOF;
  end else if not ReadMore then feof:=true
  else feof:=eof(f);
end;

procedure GetLine(var line: string);
var
  i: integer;
  tmp: string;
  ch: char;

begin
  if line<>'' then exit;
  if FromStream then
  begin
    while (line='') and (P^.Status=stOK) and not feof(f) do
    begin
      ch:=#1;
      repeat
        P^.Read(ch,1);
      until (P^.Status<>stOK) or feof(f) or not (ch in [#1..#20,#22..#32]);
      if ch=#0 then StreamEOF:=true;
      if (P^.Status=stOK) and not feof(f) then
      repeat
        if (ch in [#1..#20,#22..#31]) then ch:=' ';
        line:=line+ch; P^.read(ch,1);
      until (P^.Status<>stOK) or feof(f) or (ch in [#0,#10,#13]);
      if ch=#0 then StreamEOF:=true;
    end;
  end else
  while (line='') and (not feof(f)) do
  begin
    repeat
      ReadString(f,tmp,true);
      line:=line+tmp;
      ChrDelL(line,' ');
    until ReachedEol;
    SkipOneLine(f,true);
    for i:=1 to length(line) do
      if line[i] in [#0..#20,#22..#31] then line[i]:=' ';
    ChrDelR(line,' '); ChrDelL(line,' ');
  end;
  if line='' then finish:=true;
  Index:=1;
end;                 { GetLine }

begin                               { InputPattern }
  finish:=false; ok:=true; delim:=#0;
  CaseSen:=false; RegExp:=false;
  FromStream:=P<>Nil; StreamEof:=false;
  Failure:=false;
  with Pattern^ do
  begin
    noper:=0; npatt:=0; depth:=0;
    on:=false;
    Index:=1;
    if line<>'' then
    begin
      for i:=1 to length(line) do if line[i] in [#0..#20,#22..#31] then
          line[i]:=' ';
      ChrDelR(line,' '); ChrDelL(line,' ');
      StrRepl(line,'\'+lbrace,#1#1,1,255,255);
      StrRepl(line,'\'+rbrace,#2#2,1,255,255);
    end;
    repeat
      GetLine(line); tmp:='';
      if (line='') and feof(f) then line:=rbrace;
      while (line<>'') and (line[1] in [' ',';',',']) do delete(line,1,1);
      i:=1; WrdToken(tmp,line,' ;,',i); StrLwr(tmp);

      if line[1] in [';',':',','] then
        Delete(line,1,1)
      else if (tmp='.and.') or (tmp='.and') or (tmp[1] in ['*','&']) then
      begin
        if (noper<MaxPattOper) and (depth>1) then
        begin
          inc(noper); Dec(depth);
          operation[noper]:=Patt_AND;
          flag[noper]:=0;
        end;
        if (tmp[1] in ['*','&']) then Delete(line,1,pos(tmp[1],line))
        else Delete(line,1,pos(tmp,line)+length(tmp));
      end else if (tmp='.or.') or (tmp='.or') or (tmp[1] in ['+','|']) then
      begin
        if (noper<MaxPattOper) and (depth>1) then
        begin
          inc(noper); Dec(depth);
          operation[noper]:=Patt_OR;
          flag[noper]:=0;
        end;
        if (tmp[1] in ['+','|']) then Delete(line,1,pos(tmp[1],line))
        else Delete(line,1,pos(tmp,line)+length(tmp));
      end else if (tmp='.not.') or (tmp='.not') or (tmp[1] in ['^','~','~']) then { NOT }
      begin
        if depth>0 then
        begin
          if (flag[noper] and PattFlag_NOT)<>0 then
            flag[noper]:=flag[noper] and (not PattFlag_NOT)
          else flag[noper]:=flag[noper] or PattFlag_NOT;
        end;
        if tmp[1] in ['^','~','~'] then Delete(line,1,pos(tmp[1],line))
        else Delete(line,1,pos(tmp,line)+length(tmp));
      end else if (tmp='_caseon') or (Pos('_casesen',tmp)=1) then
      begin
        CaseSen:=true;
        i:=StrPosLI(line,tmp);
        if i>0 then Delete(line,1,length(tmp));
      end else if (tmp='_caseoff') or (Pos('_caseinsen',tmp)=1) then
      begin
        CaseSen:=false;
        i:=StrPosLI(line,tmp);
        if i>0 then Delete(line,1,length(tmp));
      end else if (tmp='_regexpoff') then
      begin
        Regexp:=false;
        i:=StrPosLI(line,tmp);
        if i>0 then Delete(line,1,length(tmp));
      end else if (tmp='_regexp') or (tmp='_regexpon') or (Pos('_sub',tmp)=1) then
      begin
        Regexp:=true;
        i:=StrPosLI(line,tmp);
        if i>0 then Delete(line,1,length(tmp));
      end else if line[1]=rbrace then                       { Finish }
      begin
        finish:=true; delete(line,1,1); 
      end else if (noper>=MaxPattOper) or (npatt>=MaxPattCrit) then  { overflow }
      begin
        finish:=true; line:='';
        noper:=0; npatt:=0; ok:=false;
      end else
      begin                                            { Pattern }
        Inc(npatt); Inc(noper);
        operation[noper]:=npatt; field[npatt]:=''; Patrn[npatt]:='';
        flag[noper]:=0;
        if CaseSen then flag[noper]:=flag[noper] or PattFlag_CaseSen;
        if Regexp  then flag[noper]:=flag[noper] or PattFlag_Regexp;
        Inc(depth);
        Index:=1;
        FinishKeys:=false;
        {message('Reading key list');} { ******************************** }
        repeat                    { Reading list of keys }
          tmp:='';
          minus:=false; index:=0;
          while (not ((line='') and feof(f))) and (tmp='') do
          begin
            GetLine(line);
            Index:=1; tmp:='';
            while (Index<=length(line)) and (line[index] in ['+','-',' ',',']) do
            begin
              if line[index]='-' then minus:=true;
              inc(index);
            end;
            if index>length(line) then
            begin
              line:=''; GetLine(line);
            end;
            while (Index<=length(line)) and not (line[index] in ['+','-',' ',',']) do
            begin
              tmp:=tmp+line[index];
              inc(index);
            end;
          end;
          if (tmp='') and feof(f) then FinishKeys:=true
          else if tmp[1]=':' then
          begin
            FinishKeys:=true;
            delete(line,1,1);
          end else if tmp[1] in ['"',lbrace] then FinishKeys:=true
          else begin
            i:=pos(line,':');
            if i>0 then tmp[1]:=chr(i-1);
            i:=StrPosLI(line,tmp);
            if i>0 then Delete(line,1,index-1);
            StrLwr(tmp);
            if tmp[length(tmp)]=':' then
            begin
              FinishKeys:=true; 
              delete(tmp,length(tmp),1); delete(line,1,1);
            end;
            if tmp=PattStr_All then            { !!!!!!! }
            begin
              Field[npatt]:='';
              for i:=1 to OrigFieldLast+1 do field[npatt]:=field[npatt]+Chr(i-1);
              field[npatt]:=field[npatt]+Chr(StringIndex)+PattField_Undec;
            end else if tmp=PattStr_Type then
            begin
              field[npatt]:=PattField_Type;
            end else if (length(tmp)>=PattUnique) and (Pos(tmp,PattStr_Tagged)>0) then
            begin
              field[npatt]:=PattField_Tagged;
              FinishKeys:=true;
            end else if tmp=PattStr_Name then
            begin
              field[npatt]:=field[npatt]+PattField_Name;
            end else if (length(tmp)>=PattUnique) and (Pos(tmp,PattStr_Undec)>0) then
            begin
              field[npatt]:=field[npatt]+PattField_Undec;
            end else
            begin                      { A field name }
              i:=FindInFieldList(tmp);
              if (i>0) and ((i=StringIndex) or (i<=OrigFieldLast)) then
              begin
                k:=Pos(Chr(i),field[npatt]);
                if minus and (k>0) then
                  Delete(Field[npatt],k,1)
                else if k=0 then
                  Field[npatt]:=Field[npatt]+Chr(i);
              end else
              begin
                ok:=false; FinishKeys:=true; Failure:=true;
                if ErrorMsg then ErrorMessageRC(Str_InvalidPattField,tmp);
              end;
            end;
          end;
        until FinishKeys;       { Finished with the key names }
        {message('ended key list');}  { ***************************** }
        SortPattField(field[npatt]);
        nbr:=1;
        ChrDelL(line,' '); GetLine(line);
        delim:=line[1];
        FinishString:=(delim<>'"') or (not ok) or (field[npatt]=PattField_Tagged);
        Patrn[npatt]:='';
        if (field[npatt]<>'') and (delim='"') then
        begin
          { message('searching for pattern, delimiter "'+delim+'"');}     { ******************************** }
          delete(line,1,1);
          while not FinishString do
          begin
            GetLine(line);
            if (line='') then line:='"';
            StrRepl(line,'""',#3#3,1,255,255);
            tmp:=line;
            i:=Pos(delim,line);
            if i>0 then
            begin
              tmp[0]:=Chr(i-1);
              delete(line,1,i);
              FinishString:=true;
            end else line:='';
            if tmp<>'' then
            begin
              if field[npatt]=PattField_Type then   { Type }
              begin
                StrLwr(tmp);
                i:=1; tmp1:='';
                repeat
                  WrdToken(tmp1,tmp,' ,;',i);
                  j:=FindInETypeList(tmp1);
                  if (j>0) and (Pos(chr(j),Patrn[npatt])=0) then
                    Patrn[npatt]:=Patrn[npatt]+chr(j);
                until i=0;
              end else
              begin
                if Patrn[npatt]='' then Patrn[npatt]:=tmp
                else Patrn[npatt]:=Patrn[npatt]+' '+tmp;
              end;
            end;
          end;
          if field[npatt]<>PattField_Type then
          begin
            StrRepl(Patrn[npatt],#3#3,'"',1,255,255);
            StrRepl(Patrn[npatt],#4,rbrace,1,255,255);
          end;
          { message('P: "'+Patrn[npatt]+'"');}    { ******************************** }
        end else if delim='"' then Delete(line,1,1);
        if (field[npatt]='') {or
           ((Patrn[npatt]='') and (field[npatt]<>PattField_Tagged))}
           or (not ok) then   { error }
        begin
          Dec(npatt); Dec(noper); Dec(depth);
        end;
      end;
      i:=1;
      while (i<=length(line)) and (line[i] in [' ',';',',',':']) do inc(i);
      if i>1 then Delete(line,1,i-1);
    until finish or (not ok);
    if depth>1 then ok:=false;
    if not ok then
    begin
      noper:=0; npatt:=0; depth:=0;
      on:=false;
      Failure:=true;
      if ErrorMsg then ErrorMessageRC(Str_PatternError,'');
    end else CleanupPattern(Pattern);
    if (noper>0) and (npatt>0) then on:=true;
  end;
  if FromStream and (P^.Status<>stOK) then P^.Reset;
end;                                  { InputPattern }

Procedure PatternLoad(Pattern: PatRecPtr; fname: string;
                      HasToExist: boolean; var ok: boolean);
var
  tmp1: string;
  first,Fspecified,OldPatt,accept: boolean;
  icode,i,j,OperShift: byte;
  FAttr,readsize,k: word;
{  PatFile: file;}
  TPatFile: text;
begin                               { PatternLoad }
  ok:=false; OldPatt:=false;
  first:=(fname<>''); fspecified:=first; readsize:=0;
  FileChoose(fname,PatternExt,TexInputList,
               AnyFile and (not (Directory or SysFile)),true,HasToExist,false,
               Nil,'Load from file:',PatternDesc,accept);
  if not accept then Exit;

  fname:=LFNFexpand(fname); CanonicalFname(fname);
  LFNNew(TPatFile,true);
  LFNAssign(TPatFile,fname);
  GetFAttr(TPatFile,FAttr);
  if DosError<>0 then
  begin
    if HasToExist then ErrorMessageRC(Str_FileNonExistent,fname);
    LFNDispose(TPatFile); Exit;
  end;
  if LFNReset(TPatFile,0)<>0 then
  begin
    ErrorMessageRC(Str_CantOpenFile,fname);
    LFNDispose(TPatFile); Exit;
  end;

  ok:=true;
  {
  LFNNew(TPatFile,true);
  LFNAssign(TPatFile,fname);
  LFNReset(TPatFile,0);
  }
  InputPattern(TPatFile,Nil,Pattern,'',true,true);
  LFNDispose(TPatFile);
  {$I-}
{  Close(PatFile); if IoResult<>0 then;}
  {$I+}

  if (Pattern^.noper>0) then Pattern^.on:=true
  else Pattern^.on:=false;
end;                               { PatternLoad }

procedure PatternSave(Pattern: PatRecPtr);
var
  tmp,Dir,Name,Ext: PString;
  ok,Unix,accept: boolean;
  icode,i: byte;
  FAttr,D_O: word;
  TPatFile: text;
  TPfile: PSafeBufStream;
  MaxLine: LongInt;
begin                               { PatternSave }
  if (Pattern=Nil) or (pattern^.noper=0) then
  begin
    ErrorMessageRC(Str_NothingToSave,'');  Exit;
  end;
  AllocStrings(true,@tmp,@Dir,@Name,@Ext);
  tmp^:=''; Unix:=false;
  repeat
    StrLwr(tmp^);
    FileChoose(tmp^,PatternExt,TexInputList,
                 AnyFile and (not (Directory or SysFile or ReadOnly)),
                 true,false,false,Nil,'Save to file:',PatternDesc,accept);
    if accept and (tmp^<>'') then
    begin
      ok:=true;
      if (not accept) or (Pos('*',tmp^)+Pos('?',tmp^)>0) then tmp^:=''
      else begin
        tmp^:=LFNFExpand(tmp^);
        LFNFSplit(tmp^,Dir,Name,Ext);
        if Name^='' then tmp^:=''
        else if Ext^='' then tmp^:=Dir^+Name^+PatternExt
        else tmp^:=Dir^+Name^+Ext^;
      end;
      if (tmp^<>'') and IsFileName(tmp^) then
      begin
        StrLwr(tmp^);
        LFNNew(TPatFile,true); LFNAssign(TPatFile,tmp^);
        Unix:=(Pos(tmp^[1],UnixDrives)>0);
        GetFAttr(TPatFile,FAttr); D_O:=DosError;
        if DosError=0 then
        begin
          if FAttr and ReadOnly>0 then   {ReadOnly}
          begin
            ErrorMessageRC(Str_FileIsReadonly,tmp^); ok:=false;
          end else if not AskIf(Concat(' File "',tmp^,'" exists. '),
                           '','Overwrite','Cancel') then ok:=false;
            {begin LFNErase(TPatFile); end
          else ok:=false; }
        end;
        if ok then
        begin
          if D_O=0 then New(TPfile,Init(tmp^,stOpenWrite,AuxBufSize))
          else if D_O=2 then
            New(TPfile,Init(tmp^,stCreate,AuxBufSize));
          if (TPfile=Nil) or (TPfile^.status<>stOK) then
          begin
            ErrorMessageRC(Str_CantCreateFile,tmp^);  ok:=false;
          end;
        end;
        if ok then
        begin
          OutputPattern(Pattern,78,false,0,0,0,0,MaxLine,TPFile,'','',Unix,true);
          TPfile^.Truncate;
        end;
        if TPfile<>Nil then Dispose(TPfile,Done); TPfile:=Nil;
        if not ok then LFNErase(TPatFile);
        LFNDispose(TPatFile);
      end;
    end;
  until (not accept) or (tmp^='') or ok;
  AllocStrings(false,@tmp,@Dir,@Name,@Ext);
end;                                   { PatternSave }

procedure GetSortPattern(var M: ConfigSortType; P: PatRecPtr;
                         var exists: boolean);
var
  ok: boolean;
begin                                   { GetSortPattern }
  if not M.UsePatternFile then Exit;
  with M do
  begin
    if (SortPatternFile<>'') and UsePatternFile then
    begin
      PatternLoad(P,SortPatternFile,true,ok);
      if not ok then with P^ do
      begin
        noper:=0; npatt:=0; on:=false;
      end;
      Exists:=ok;
    end else Exists:=true;
    if Exists then P^.on:=true;
  end;
end;                            { GetSortPattern }

procedure SortWorkOut(var M: ConfigSortType; SortPattern: PatRecPtr);
var
  i,j,k,l: byte;
  ok: boolean;
  D,N,E: PString;
begin                                  { SortWorkOut }
  AllocStrings(true,@D,@N,@E,Nil);
  with M do
  begin
    ChrDel(SortTypeOrder,#0);
    l:=Pos('N',SortTypeOrder);
    if l>0 then SortTypeOrder[0]:=Chr(l)
    else SortTypeOrder:=SortTypeOrder+'N';

    SortPatternExists:=false;
    if SortPattern<>Nil then
    begin
      if UsePatternFile and (SortPatternFile<>'') then
      begin
        LFNFsplit(SortPatternFile,D,N,E);
        if E^='' then SortPatternFile:=SortPatternFile+PatternExt;
        GetSortPattern(M,SortPattern,SortPatternExists);
      end else if SortPattern^.noper>0 then SortPatternExists:=true;
    end;
    if SortPatternExists and ContainsTags(SortPattern) then
    begin
      SortPatternExists:=false; SortPattern^.noper:=0;
      ErrorMessageRC(Str_SortPattHasTag,'');
    end;
  end;
  AllocStrings(false,@D,@N,@E,Nil);
end;                                    { SortWorkOut }

procedure LoadSortMode(var cfg: text; P: PStream; var M: ConfigSortType;
                       Pattern: PatRecPtr);
const
  TokenStr = ' ='+lbrace+rbrace+#9;
Type
  CriteriaType = array[1..NSortCriteria] of string;
var
  index,ind2,i,KeyIndex: byte;
  nbr,icode,j,k,nbrr: integer;
  line,trueline,tmp,tmp1,tmp2,tline: string;
  tmpp: ^CriteriaType;
  Bind,FromStream,StreamEOF,Starting: boolean;

function feof(var f: text): boolean;
begin
  if FromStream then
  begin
    StreamEOF:=StreamEOF or (P^.Status<>stOK) or (P^.GetPos>=P^.GetSize);
    feof:=StreamEOF;
  end else feof:=eof(f);
end;

procedure GetLine(var line: string);
var
  i: integer;
  tmp: string;
  ch: char;
begin
  line:='';
  repeat
    if FromStream then
    begin
{      message('into GetLine');}
      while (line='') and (P^.Status=stOK) and not feof(cfg) do
      begin
        ch:=#1;
        repeat
          P^.Read(ch,1);
        until (P^.Status<>stOK) or feof(cfg) or not (ch in [#1..#20,#22..#32]);
        if ch=#0 then StreamEOF:=true;
        if (P^.Status=stOK) and not feof(cfg) then
        repeat
          if (ch in [#1..#20,#22..#31]) then ch:=' ';
          line:=line+ch; P^.read(ch,1);
        until (P^.Status<>stOK) or feof(cfg) or (ch in [#0,#10,#13]);
        if ch=#0 then StreamEOF:=true;
      end;
    end else ReadLine(cfg,line,true);
    UnTabify(line);
    ChrDelL(line,' '); ChrDelR(line,' ');
  until (line<>'') or feof(cfg);
{  if FromStream then message('"'+line+'"');}
end;


begin                                   { LoadSortMode }
  nbr:=1;
  ZeroSortMode(M,Pattern);
  New(tmpp);
  FromStream:=P<>Nil; StreamEOF:=false;
  Starting:=true;
  with M do
  repeat
    line:=''; GetLine(line);
    Trueline:=line; ChrDel(line,' '); StrLwr(line);
    if Starting and (line='\sort'+lbrace) then
    begin
      Starting:=false;
      line:=''; GetLine(line);
      Trueline:=line; ChrDel(line,' '); StrLwr(line);
    end;
    nbr:=nbr+ChrQty(line,lbrace)-ChrQty(line,rbrace);
    if (length(line)>0) and IsAlpha(line[1]) and
       (not(line[1] in CommentSet))then
    begin
      index:=1; tmp:=''; tmp1:='';
      for i:=1 to NSortCriteria do tmpp^[i]:='';
      WrdToken(tmp,line,TokenStr,index);
      if index<>0 then
      begin
        tmp2:=line+' '; WrdToken(tmp1,tmp2,TokenStr,index);
        ChrDel(tmp1,' ');
        ind2:=1;
        for i:=1 to NSortCriteria do
          if Ind2>0 then WrdToken(tmpp^[i],tmp1,','+rbrace,Ind2);
      end;
      if (tmp='stringsort') or (tmp='stringnamesort') then
      begin
        if tmp1='off' then StringNameSort:=StrSortOff
        else if pos('ascend',tmp1)=1  then StringNameSort:=StrSortAscend
        else if pos('descend',tmp1)=1 then StringNameSort:=StrSortDescend;
      end else if tmp='mode' then
      begin
        if Pos('on',tmp1)>0 then SortingOn:=true;
        if Pos('off',tmp1)>0 then SortingOn:=false;
      end else if tmp='collation' then
      begin
        if Pos('ascii',tmp1)>0 then MixedCollation:=false;
        if Pos('mixed',tmp1)>0 then MixedCollation:=true;
      end else if tmp='nameorder' then
      begin
        NameAsc[true]:=(Pos('ascend',tmpp^[1])>0);
        if Pos('ascend',tmpp^[2])>0 then NameAsc[false]:=true
        else if Pos('descend',tmpp^[2])>0 then NameAsc[false]:=false
        else NameAsc[false]:=NameAsc[true];
      end else if Pos('keyorder',tmp)=1 then
      begin
        Delete(tmp,1,length('keyorder'));
        if tmp='' then i:=1
        else begin
          Val(tmp,i,icode); if icode<>0 then i:=1;
          if i<1 then i:=1; if i>NSortKeys then i:=NSortKeys;
        end;
        KeyAsc[i,true]:=(Pos('ascend',tmpp^[1])>0);
        NullKeyFirst[i,true]:=(Pos('last',tmpp^[2])=0);
        if Pos('ascend',tmpp^[3])>0 then KeyAsc[i,false]:=true
        else if Pos('descend',tmpp^[3])>0 then KeyAsc[i,false]:=false
        else KeyAsc[i,false]:=KeyAsc[i,true];
        if Pos('first',tmpp^[4])>0 then NullKeyFirst[i,false]:=true
        else if Pos('last',tmpp^[4])>0 then NullKeyFirst[i,false]:=false
        else NullKeyFirst[i,false]:=NullKeyFirst[i,true];
      end else if Pos('key',tmp)=1 then
      begin
        while (tmp<>'') and (Pos(tmp[1],'keyfield')>0) do delete(tmp,1,1);
        if tmp='' then i:=1
        else begin
          Val(tmp,i,icode); if icode<>0 then i:=1;
          if i<1 then i:=1; if i>NSortKeys then i:=NSortKeys;
        end;

        ChrDel(TrueLine,' ');
        j:=Pos(lbrace,trueline)+1; nbrr:=1; k:=j;
        while (k<=length(trueline)) and (nbrr>0) do
        begin
          if trueline[k]=lbrace then inc(nbrr)
          else if trueline[k]=rbrace then dec(nbrr);
          if nbrr>0 then inc(k);
        end;
        tline:=Copy(trueline,j,k-j);
        j:=0; nbrr:=0; BInd:=true;
        while (j<2) and  (tline<>'') do
        begin
          k:=1; tmp2:='';
          while (k<=length(tline)) and ((nbrr>0) or (tline[k]<>',')) do
          begin
            if tline[k]=lbrace then inc(nbrr)
            else if (tline[k]=rbrace) and (nbrr>0) then dec(nbrr);
            inc(k);
          end;
          tmp2:=Copy(tline,1,k); ChrDelR(tmp2,' '); ChrDelL(tmp2,' ');
          ChrDelR(tmp2,',');
          if k>=length(tline) then tline:=''
          else Delete(tline,1,k);
          if tmp2<>'' then
          begin
            if Pos(lbrace,tmp2)=0 then tmp2:=lbrace+tmp2+rbrace;
            Inc(j); PrepareTemplate(tmp2);
            SortKey[i,BInd]:=tmp2; BInd:=not BInd;
          end;
        end;
        if j<2 then SortKey[i,false]:=SortKey[i,true];
      end else if (tmp='patternfile') and (tmp1<>'') then
        SortPatternFile:=tmp1
      else if tmp='pattern' then
      begin
        i:=StrPosLI(Trueline,'pattern');
        if i>0 then Delete(Trueline,1,7);
        i:=1;
        while (i<=length(Trueline)) and (Trueline[i]<>lbrace) do Inc(i);
        if Trueline[i]=lbrace then inc(i);
        Delete(Trueline,1,i-1);
        InputPattern(cfg,P,Pattern,Trueline,true,true);
        nbr:=1;
      end else if tmp='patternorder' then
        PattFirst:=(Pos('last',tmp1)+Pos('descend',tmp1)=0)
      else if tmp='sorttypeorder' then
      begin
        Index:=1; KeyIndex:=0; SortTypeOrder:='';
        for i:=1 to NSortCriteria do
        begin
          if (tmpp^[i]='pattern') or (tmpp^[i]='pattfile') or
             (tmpp^[i]='patternfile') then
          begin
            SortTypeOrder:=SortTypeOrder+'P';
            UsePatternFile:=(tmpp^[i]<>'pattern');
          end else if (tmpp^[i]='key') and (KeyIndex<NSortKeys) then
          begin
            inc(KeyIndex);
            SortTypeOrder:=SortTypeOrder+Chr(KeyIndex);
          end else if tmpp^[i]='name' then SortTypeOrder:=SortTypeOrder+'N';
        end;
      end;
    end;
  until (feof(cfg)) or (nbr<1);
  if M.SortPatternFile='' then M.UsePatternFile:=false
  else if (Pattern^.npatt=0) or (Pattern^.noper=0) then M.UsePatternFile:=true;
  Dispose(tmpp); tmpp:=Nil;
  SortWorkOut(M,Pattern);
end;                                  { LoadSortMode }

procedure SaveSortMode(var fname: string;
                       var Smode: ConfigSortType; Pattern: PatRecPtr);
var
  aux: PAuxStream;
  fail,Hok,Unix,HasSortEnv: boolean;
  BibSize,SortEnvStart,SortEnvEnd,i,ToRead: LongInt;
  ercode: byte;
  f: text;
  f1: file;
  f2: PSafeBufStream;
  line: string;
  AuxSortMode: ConfigSortType;
  ReallyRead: word;

begin                               { SaveSortMode }
  aux:=Nil;
  LFNNew(f,true); LFNAssign(f,fname);
  Unix:=IsUnixFile(f,fname);
  BibSize:=FileSize(fname);
  if BibSize<=0 then
  begin
    if LFNFileExist(Fname) then New(f2,Init(fname,stOpenWrite,AuxBufSize))
    else New(f2,Init(fname,stCreate,AuxBufSize));
    WriteSortMode(f2,Smode,Pattern,false,Unix);
    Dispose(f2,Done); LFNDispose(f);
    Exit;
  end;
  New(aux,Init(WorkStreamOrder));
  if (aux=Nil) or (aux^.status<>stOK) then
  begin
    ErrorMessageRC(Str_CantCreateTemp,'');
    if aux<>Nil then Dispose(aux,Done);
    LFNDispose(f); exit;
  end;
  aux^.seek(0); aux^.truncate;
  if BibSize>-1 then   { The file exists, so write header }
  begin
    ResetBibFile(f,fname);
    HasSortEnv:=false; SortEnvStart:=-1; SortEnvEnd:=0;
    i:=0; line:='';
    while (not eof(f)) and (i<MaxLookForSort) and (not HasSortEnv) do
    begin
      ReadLine(f,line,Unix); inc(i);
      UnTabify(line); ChrDelL(line,' ');
      if StrPosLI(line,'\sort'+lbrace)=1 then
      begin
        HasSortEnv:=true;
        SortEnvStart:=TextFilePos(f)-length(line)-1;
        PushBufferStack(Pattern^,sizeof(PatRec),EnoughMem(sizeof(PatRec)),0);
        MaxMemAvail;
        LoadSortMode(f,Nil,AuxSortMode,Pattern);
        RecallBufferStack(Pattern^,0);
        SortEnvEnd:=TextFilePos(f);
      end;
    end;
    LFNDispose(f);
    LFNClose(bib);
    LFNNew(f1,false); LFNAssign(f1,fname);
    FileMode:=64; LFNReset(f1,1);
    i:=0;
    if HasSortEnv and (SortEnvStart>0) then
    begin
      repeat
        ToRead:=FileBufSize;
        if i+FileBufSize>=SortEnvStart then ToRead:=SortEnvStart-i-1;
        if ToRead>0 then
        begin
          BlockRead(f1,BibBuf^[1],ToRead,ReallyRead);
          aux^.write(BibBuf^[1],ReallyRead);
          i:=i+ReallyRead;
        end;
      until ToRead=0;
    end;
    WriteSortMode(aux,Smode,Pattern,false,Unix);
    Seek(f1,SortEnvEnd);
    repeat
      BlockRead(f1,BibBuf^[1],FileBufSize,ReallyRead);
      aux^.write(BibBuf^[1],ReallyRead);
    until ReallyRead=0;
    LFNDispose(f1);
  end else
    WriteSortMode(aux,Smode,Pattern,false,Unix);    
  Hok:=(aux^.status=0);
  aux^.Flush; aux^.seek(0);
  if Hok then
  begin
    if StrCmpI(fname,bibname^,1,1,255)=0 then AuxToBib(aux,f,fname)
    else AuxToBib(aux,f,fname);
  end else ErrorMessageRC(Str_TempStreamError,'');
  aux^.reset;
  Dispose(aux,Done);
end;                                { SaveSortMode }

procedure WriteSortMode(F: PStream; var Smode: ConfigSortType;
                        Npatt: PatRecPtr; IgnoreMode,Unix: boolean);
var
  ispattern,isname: boolean;
  i,j,Nkeys: byte;
  MaxLine: LongInt;
  comma,ad: string[1];
  tmp: string;
  Order,nullkey: array[boolean] of string[11];
  StrOrder: array[StringSortType] of string[10];

begin
  Order[true]  :='ascending';   Order[false]  :='descending';
  nullkey[true]:='nulls first'; nullkey[false]:='nulls last';
  StrOrder[StrSortOff]:='off';
  StrOrder[StrSortAscend] :='ascending';
  StrOrder[StrSortDescend]:='descending';
  StreamWriteln(f,'\Sort'+lbrace,Unix);
  ispattern:=false; isname:=false;
  with Smode do
  begin
    if not (IgnoreMode or SortingOn) then
      StreamWriteln(f,'  Mode'+lbrace+'off'+rbrace,Unix)
    else begin
      if not IgnoreMode then
        StreamWriteln(f,'  Mode'+lbrace+'on'+rbrace,Unix);
      if MixedCollation then
        StreamWriteln(f,'  Collation'+lbrace+'mixed'+rbrace,Unix)
      else
        StreamWriteln(f,'  Collation'+lbrace+'ASCII'+rbrace,Unix);
      StreamWrite(f,'  SortTypeOrder'+lbrace); comma:='';
      for i:=1 to length(SortTypeOrder) do
      begin
        case SortTypeOrder[i] of
          'N':
            if not isname then
            begin
              StreamWrite(f,comma+'name'); isname:=true; comma:=',';
            end;
          #1..Chr(NSortKeys):
            begin
              StreamWrite(f,comma+'key'); comma:=',';
            end;
          'P':
            if (not ispattern) and ((UsePatternFile and (SortPatternFile<>''))
             or ((not UsePatternFile) and (Npatt^.noper>0))) then
            begin
              StreamWrite(f,comma+'pattern'); ispattern:=true; comma:=',';
            end;
        end;
      end;
      StreamWriteln(f,rbrace,Unix);
      StreamWrite(f,'  NameOrder'+lbrace+Order[NameAsc[true]]);
      if NameAsc[true] <> NameAsc[false] then
        StreamWrite(f,','+Order[NameAsc[false]]);
      StreamWriteln(f,rbrace,Unix);
      Nkeys:=NSortKeys;
      while (Nkeys>0) and (Pos(Chr(Nkeys),SortTypeOrder)=0) do dec(Nkeys);
      for i:=1 to Nkeys do
      begin
        ad:=''; if Pos(#2,SortTypeOrder)>0 then ad:=Chr(i+Ord('0'));
        tmp:='_none';
        if SortKey[i,true]<>'' then
        begin
          DecompTemplate(tmp,SortKey[i,true]);
          EncapsulateTemplate(tmp);
        end;
        StreamWrite(f,'  Key'+ad+lbrace+tmp);
        if IsPattern and (Pos(Chr(i),SortTypeOrder)>Pos('P',SortTypeOrder))
           and (SortKey[i,true] <> SortKey[i,false]) then
        begin
          tmp:='_none';
          if SortKey[i,false]<>'' then
          begin
            DecompTemplate(tmp,SortKey[i,false]);
            EncapsulateTemplate(tmp);
          end;
          StreamWrite(f,','+tmp);
        end;
        StreamWriteln(f,rbrace,Unix);     { Finished the "Key" param }
        
        StreamWrite(f,'  KeyOrder'+ad+lbrace+Order[KeyAsc[i,true]]+','+
                          NullKey[NullKeyFirst[i,true]]);
        if IsPattern and (Pos(Chr(i),SortTypeOrder)>Pos('P',SortTypeOrder))
           and ((KeyAsc[i,true] <> KeyAsc[i,false]) or
                (NullKeyFirst[i,true]<>NullKeyFirst[i,false])) then
          StreamWrite(f,','+Order[KeyAsc[i,false]]+','+
                          NullKey[NullKeyFirst[i,false]]);
        StreamWriteln(f,rbrace,Unix);
      end;
      if ispattern then
      begin
        if UsePatternFile then
          StreamWriteln(f,'  PatternFile'+lbrace+SortPatternFile+rbrace,Unix)
        else OutputPattern(Npatt,78,false,0,0,0,0,MaxLine,f,
                           '  Pattern'+lbrace,rbrace,Unix,true);
        if PattFirst then
          StreamWriteln(f,'  PatternOrder'+lbrace+'first'+rbrace,Unix)
        else StreamWriteln(f,'  PatternOrder'+lbrace+'last'+rbrace,Unix);
      end;
    end;    
    if StringNameSort<>StrSortOff then
      StreamWriteln(f,'  StringSort'+lbrace+StrOrder[StringNameSort]+rbrace,Unix);
  end;
  StreamWriteln(f,rbrace,Unix);
end;                                { WriteSortMode }

function EquivSortModes(var M,SavedMode: ConfigSortType;
                        SortPattern,SavedPatt: PatRecPtr): boolean;
label
  FinishProcess;
var
  stat,i,j: integer;
  equiv: boolean;
begin
  equiv:=false;
  if M.SortingOn<>SavedMode.SortingOn then goto FinishProcess;
  stat:=14;
  if M.SortingOn then
  begin
    if M.SortTypeOrder<>SavedMode.SortTypeOrder then goto FinishProcess;
    stat:=15;
    if M.NameAsc[true]<>SavedMode.NameAsc[true] then goto FinishProcess;
    for i:=1 to NSortKeys do
    if Pos(chr(i),M.SortTypeOrder)>0 then
    begin
      if (M.SortKey[i,true]<>SavedMode.SortKey[i,true]) or
         (M.KeyAsc[i,true]<>SavedMode.KeyAsc[i,true]) or
         (M.NullKeyFirst[i,true]<>SavedMode.NullKeyFirst[i,true]) then
              goto FinishProcess;
      if (Pos('P',M.SortTypeOrder)>0) and
         (Pos(chr(i),M.SortTypeOrder)>Pos('P',M.SortTypeOrder)) and
       ((M.SortKey[i,false]<>SavedMode.SortKey[i,false]) or
         (M.KeyAsc[i,false]<>SavedMode.KeyAsc[i,false]) or
         (M.NullKeyFirst[i,false]<>SavedMode.NullKeyFirst[i,false]) )
              then goto FinishProcess;
    end;
    stat:=16;
    if Pos('P',M.SortTypeOrder)>0 then      { Check equivalence of patterns }
    begin
      if M.NameAsc[false]<>SavedMode.NameAsc[false] then goto FinishProcess;
      if (SortPattern=Nil) then goto FinishProcess;
      stat:=17;
      if DifferentPatt(SortPattern,SavedPatt) then goto FinishProcess;
      stat:=20;
    end;
  end;
  Equiv:=true;
FinishProcess:
  EquivSortModes:=Equiv;
end;                               { EquivSortModes }

procedure IndexFileStatus(var bib: text; bibname: Pstring; var IndName: string;
                          M: ConfigSortPtr; SortPattern: PatRecPtr;
                          CheckSortMode: boolean; var current: boolean;
                          var Nentries: word; var EndOfHeader: longint);
label
  FinishProcess;
var
  FInd: text;
  Dir,Name,Ext,line: Pstring;
  BibFileTime,BibFileSize,Bsize,Btime,i,j,EndOfData,Fsize,BibFilePos: longint;
  ok: boolean;
  SavedMode: ConfigSortPtr;
  SavedPatt: PatRecPtr;
  stat: byte;
begin
  stat:=0; SavedMode:=Nil; BibFileTime:=-1;
  Current:=false; SavedPatt:=Nil; EndOfHeader:=-1; IndName:=''; nentries:=0;
  if (M=Nil) or (SortPattern=Nil) then CheckSortMode:=false;

  if (not UseIndexFile) or (bibname^='') then Exit;
  AllocStrings(true,@Dir,@Name,@Ext,@line);

  stat:=1;
  LFNFsplit(LFNFexpand(bibname^),Dir,Name,Ext);
  IndName:=Dir^+Name^+IndexExtension^; CanonicalFname(IndName);
  if not (LFNFileExist(bibname^) and LFNFileExist(IndName)) then
  begin
    AllocStrings(false,@Dir,@Name,@Ext,@line); Exit;
  end;
  stat:=2;
  ok:=true;
  BibFilePos:=-1;
  with TextRec(bib) do
  if (Mode=fminput) or (Mode=fminout) or (Mode=fmoutput) then
    BibFilePos:=TextFilePos(bib);
  LFNClose(bib);
  BibFileSize:=FileSize(bibname^);
  {$I-}
  if LFNReset(bib,0)<>0 then ok:=false;
  if ok then GetFTime(bib,BibFileTime); if IoResult<>0 then ok:=false;
  LFNclose(bib); LFNNew(FInd,true);
  if not ok then goto FinishProcess;
  stat:=3;

  Fsize:=FileSize(IndName);
  LFNAssign(FInd,IndName);
  if LFNReset(Find,0)<>0 then goto FinishProcess; stat:=4;
  readln(Find,line^); if IoResult<>0 then goto FinishProcess; stat:=5;
  if line^<>IndexFileString then goto FinishProcess; stat:=6;
  
     { Bib file time/date, size, # entries, EndOfData }

  Readln(Find,Btime,Bsize,nentries,EndOfData);
  if IoResult<>0 then goto FinishProcess; stat:=7;
  if (Btime=UnFinishedTime) or (Btime<>BibFileTime) then
  begin
    {
    line:=bibname+': '+MakeIntoDate(BibFileTime)+',  index file: '
          +MakeIntoDate(Btime);
    message(line);
    }
    goto FinishProcess;
  end;
  stat:=8;
  if (Bsize<0) or (Bsize<>BibFileSize)              then goto FinishProcess;
  stat:=9;
  if nentries<1 then goto FinishProcess; stat:=10;
  if (EndOfData<0) or (EndOfData+length(EndIndexStr)+2*LengthOfEOL>Fsize) then
    goto FinishProcess;
  stat:=11;
  
  readln(Find,EndOfHeader); if IoResult<>0 then goto FinishProcess; { End of header }
  stat:=12;
  if EndOfHeader<0 then goto FinishProcess; 
  stat:=13;

  if CheckSortMode then
  begin
    New(SavedPatt); SavedPatt^.noper:=0; SavedPatt^.npatt:=0;
    New(SavedMode); ZeroSortMode(SavedMode^,SavedPatt);
    MaxMemAvail;
    LoadSortMode(Find,Nil,SavedMode^,SavedPatt);

    ok:=EquivSortModes(M^,SavedMode^,SortPattern,SavedPatt);
    Dispose(SavedMode); SavedMode:=Nil;
    if not ok then goto FinishProcess;
  end;
  TextSeek(Find,EndOfData+LengthOfEOL); readln(Find,line^);
  if line^<>EndIndexStr then goto FinishProcess;
  stat:=21;
  
  Current:=true;
  
FinishProcess:
  {$I+}
  LFNDispose(Find);
  if SavedPatt<>Nil then Dispose(SavedPatt); SavedPatt:=Nil;
  LFNClose(bib);
  AllocStrings(false,@Dir,@Name,@Ext,@line);
  if BibFilePos>-1 then
  begin
    LFNReset(bib,0); TextSeek(bib,BibFilePos);
  end;
  {
  if not current then message('Failed after stat='+num2str(stat));
  }
end;                               { IndexFileStatus }

procedure CheckForIndexFile(var bib: text; bibname: PString);
var
  CurrentIndex: boolean;
  f: file;
begin
  NumberOfEntries:=0; IndexFileName^:=''; EndOfIndexHeader:=-1;
  if UseIndexFile and (not linked) then
  begin
    CurrentIndex:=false;
    IndexFileStatus(bib,bibname,IndexFileName^,CurrentSortMode,
            Nil,false,CurrentIndex,NumberOfEntries,EndOfIndexHeader);
    if not CurrentIndex then
    begin
      if LFNFileExist(IndexFileName^) then
      begin
        if IndexVerbatim then MessageRC(Str_IndexFileNotCurrent,IndexFileName^);
        LFNNew(f,false); LFNAssign(f,IndexFileName^);
        LFNErase(F); LFNDispose(F);
      end else if IndexVerbatim then MessageRC(Str_IndexFileNotFound,'');
      IndexFileName^:='';
      NumberOfEntries:=0; EndOfIndexHeader:=-1;
    end else
      if IndexVerbatim then Message(' Index file "'+IndexFileName^
          +'", contains '+num2str(NumberOfEntries)+' entries. ');
  end;
end;                             { CheckForIndexFile }

procedure NewDump(GetNew: Boolean; bibfile: string);
Label
  ExitNewDump;
const
  MinDiskFree=1024;
Var
  tmp: string;
  tmp2: PString;
  DExt: PString;
  fattr: Word;
  ok,IsFile,Finish,accept,FromMacro: Boolean;
  icode: Byte;
  dump: text;
  SortPattern: PatRecPtr;
  linenum,scount: LongInt;
  Dir,Name,Ext: Pstring;
  Drive: char;
begin                                      { NewDump }
  if (not GetNew) and (DumpName^='') then Exit;
  FromMacro:=MacroCommand and GetNew;
  tmp:=DumpName^; SortPattern:=Nil;
  if DefExtension[ExportFormat]=Nil then DExt:=NewStr('.$$$')
  else DExt:=NewStr(DefExtension[ExportFormat]^);
  if BibFile<>'' then bibfile:=LFNFexpand(bibfile);
  CanonicalFname(bibfile);
  LFNNew(dump,true);
  repeat
    DumpToPrinter:=false;
    ok:=false;
    if FromMacro then tmp:=InputStr^;
    FileChoose(tmp,DExt^,TexInputList,
               AnyFile and (not (Directory or ReadOnly or SysFile)),
               GetNew and not FromMacro,false,true,Nil,'Export file:','',accept);
    if tmp<>'' then
    begin
      New(tmp2); tmp2^:=LFNFExpand(tmp);
      if (not IsFileName(tmp)) or (DriveFree(tmp2^[1])<2) then
      begin
        ErrorMessageRC(Str_CantOpenFile,tmp); tmp:='';
      end;
      Dispose(tmp2);
    end;
    if tmp='' then
    begin
      DumpName^:=''; DumpFirstTime:=true; UnixDump:=false; DumpFileExists:=false;
      goto ExitNewDump;
    end;
    GetNew:=true;
    CanonicalFname(tmp);
    if (StrCmpI(tmp,'lpt1:',1,1,255)=0) or
       (StrCmpI(tmp,'lpt2:',1,1,255)=0) or
       (StrCmpI(tmp,'lpt3:',1,1,255)=0) or
       (StrCmpI(tmp,'prn:' ,1,1,255)=0) then Delete(tmp,4,1);
    if (StrCmpI(tmp,'lpt1',1,1,255)=0)  or
       (StrCmpI(tmp,'lpt2',1,1,255)=0)  or
       (StrCmpI(tmp,'lpt3',1,1,255)=0)  or
       (StrCmpI(tmp,'prn' ,1,1,255)=0)  then
    begin
      DumpName^:=tmp; DumpToPrinter:=true; UnixDump:=false;
      DumpFileExists:=false; DumpFirstTime:=true;
      goto ExitNewDump;
    end;
    AllocStrings(true,@Dir,@Name,@Ext,Nil);
    LFNFSplit(LFNfexpand(tmp),Dir,Name,Ext);
    if Ext^='' then Ext^:=DExt^;
    tmp:=Dir^+Name^+Ext^;
    Drive:=Dir^[1];
    AllocStrings(false,@Dir,@Name,@Ext,Nil);
    CanonicalFname(tmp);
    if StrCmpI(tmp,bibfile,1,1,255)=0 then
    begin
      if MacroCommand or AskIfRC(Str_ExpEqualBib,'','Error',
                     'Clear exp. file','New exp. file') then
      begin
        tmp:=''; ok:=true;
      end;
{    end else if DiskFree(Ord(UpCase(Dir[1]))-Ord('A')+1)<MinDiskFree then}
    end else if DriveFree(Drive)<MinDiskFree then
    begin
      ErrorMessageRC(Str_DiskTooFull,Drive+':');
    end else
    begin
      LFNAssign(dump,tmp);
      DumpFileExists:=true;
      if LFNGetFAttr(dump,fattr)=2 then
      begin
        DumpFileExists:=false;
        if LFNRewrite(dump,0)<>0 then ErrorMessageRC(Str_CantOpenFile,tmp)
        else begin
          LFNErase(dump); ok:=true;
        end;
      end else
      begin
        if (DosError=0) and (Fattr and ReadOnly>0) then
          ErrorMessageRC(Str_FileIsRO,tmp)
        else ok:=true;
      end;
    end;
    if (not ok) and MacroCommand then
    begin
      tmp:=''; ok:=true; Failure:=true;
    end;
  until ok;
  DumpName^:=tmp;
  DumpFirstTime:=true;
  if DumpName^<>'' then
  begin
    DumpFileExists:=LFNFileExist(DumpName^);
    LFNAssign(dump,dumpname^);
    UnixDump:=IsUnixFile(dump,dumpname^);
    LFNClose(dump);
    if (ExportFormat=BibTeXFormat) and (SortPattPosExp>0) then
    begin
      finish:=false;
      linenum:=0; scount:=0;
      ExportSortMode^:=ConfigSortMode^;
      ExportSortMode^.SortingOn:=SortNewFiles;
      if DumpFileExists then
      begin
        ExportSortMode^.SortingOn:=SortedByDefault;
        New(SortPattern);
        RecallBufferStack(SortPattern^,SortPattPosDef);
        LFNReset(dump,0);
        while (not eof(dump)) and (not finish) and
              (linenum<=MaxLookForSort) do
        begin
          tmp:='';
          ReadLine(dump,tmp,UnixDump); ChrDel(tmp,' '); StrLwr(tmp);
          inc(linenum); scount:=1;
          if tmp='\sort'+lbrace then
          begin
            LoadSortMode(dump,Nil,ExportSortMode^,SortPattern);
            finish:=true;
          end;
        end;
        LFNClose(dump);
        SortWorkOut(ExportSortMode^,SortPattern);
        PushBufferStack(SortPattern^,sizeof(PatRec),SortPattModeExp,
                        SortPattPosExp);
        Dispose(SortPattern); SortPattern:=Nil;
      end else ExportSortMode^.SortingOn:=SortNewFiles;
    end;
  end;
  
ExitNewDump:
  DumpFileList^[ExportFormat]:=DumpName^;
  LFNDispose(dump);
  DisposeStr(DExt);
end;                                     { NewDump }

procedure NewBib(Var Bibfile: string; GetNew,MustExist,AllowAbort: Boolean;
                 Var IsRO: Boolean);
Var
  tmp: string;
  fattr: Word;
  tmpfile: Text;
  ok,IsFile,accept,IsReadOnly: Boolean;
  icode: Byte;
  choice: integer;
begin                                      { NewBib }
  tmp:=BibFile;
  LFNNew(tmpfile,true);
  repeat
    ok:=false; accept:=true;
    IsReadOnly:=ForbidEditing;
    FileChoose(tmp,DefExtension[BibTeXFormat]^,TexInputList,
               AnyFile and (not (Directory or SysFile)),
               GetNew,false,false,@IsReadOnly,'Bib File:',DatabaseDesc,accept);
    if (not accept) or (tmp='') then
    begin
      if (tmp='') or (Pos('*',tmp)+Pos('?',tmp)>0) then bibfile:='';
      LFNDispose(tmpfile); Exit;
    end;
    GetNew:=true;
    tmp:=LFNFexpand(tmp); CanonicalFname(tmp);
    LFNassign(tmpfile,tmp);
    BibFileExists:=LFNGetFAttr(tmpfile,fattr)=0;
    IsRO:=false;
    if BibFileExists then
    begin
      IsRO:=IsReadOnly or ForbidEditing or (fattr and ReadOnly>0);
      LFNReset(tmpfile,0);
      if MustExist and (DosError<>0) then ErrorMessageRC(Str_CantReadFile,tmp)
      else begin
        LFNclose(tmpfile); ok:=true;
      end;
    end else ok:=true;
  until ok;
  BibFile:=tmp;
  LFNDispose(tmpfile);
  if BibFile<>'' then
  begin
    BibFile:=LFNFexpand(BibFile); CanonicalFname(BibFile);
    if MustExist then
    begin
      NewDump(false,BibFile);
    end;
  end;
end;                                    { NewBib }

end.
